/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.storage;

import com.serverengines.helper.Helper;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.helper.StringParser;
import com.serverengines.keyboard.KeyboardMgr;
import com.serverengines.kvm.LogWriter;
import com.serverengines.mahogany.CConn;
import com.serverengines.mahogany.MessageSender;
import com.serverengines.mahoganyprotocol.StorageStatus;
import com.serverengines.nativeinterface.LUD;
import com.serverengines.storage.DriveData;
import com.serverengines.storage.RemoteDriveData;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public final class MountedDriveMgr {
    public static final String FIELD_SEPERATOR = "|";
    public static final int BUFFER_SIZE = 100;
    public static final int MAX_DEVICES_TO_SHARE = 2;
    public static final int MSS_NUM_CMD_LINE = 3;
    public static final int MSS_NUM_CMD_LINE_NO_ARGS = 1;
    public static final String CMD_LINE_INTEGRATED_STORAGE = "-integratedstorage";
    protected static MountedDriveMgr s_mountedDriveMgr = null;
    protected static LogWriter s_logger = new LogWriter((class$com$serverengines$storage$MountedDriveMgr == null ? (class$com$serverengines$storage$MountedDriveMgr = MountedDriveMgr.class$("com.serverengines.storage.MountedDriveMgr")) : class$com$serverengines$storage$MountedDriveMgr).getName());
    protected HashMap m_devicesPathHash;
    protected HashMap m_devicesSharedHash;
    protected boolean m_isSharingLocalDevices = false;
    protected boolean m_isDVDRomDeviceAllowed = false;
    protected boolean m_isMemoryDeviceAllowed = false;
    protected byte[] m_buffer = new byte[100];
    protected Process m_storageProc = null;
    static /* synthetic */ Class class$com$serverengines$storage$MountedDriveMgr;

    protected MountedDriveMgr() {
        this.m_devicesPathHash = new HashMap();
        this.m_devicesSharedHash = new HashMap();
        this.m_buffer = new byte[100];
    }

    public static synchronized MountedDriveMgr getInstance() {
        if (s_mountedDriveMgr == null) {
            s_mountedDriveMgr = new MountedDriveMgr();
        }
        return s_mountedDriveMgr;
    }

    public static void clearInstance() {
        s_mountedDriveMgr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void discoverNewDevices() {
        MountedDriveMgr mountedDriveMgr = this;
        synchronized (mountedDriveMgr) {
            block34: {
                InputStream inputStream = null;
                if (!this.isSharingDevices()) {
                    DriveData driveData;
                    String string;
                    String[] stringArray;
                    Object object;
                    CConn cConn;
                    block33: {
                        if (s_logger.isDebugLoggingEnabled()) {
                            s_logger.debug("Discovering storage devices...");
                        }
                        if ((cConn = KeyboardMgr.getInstance().getCConn()).isExeStorageSupported()) {
                            block32: {
                                object = Helper.getUserHomeDir();
                                ((StringBuffer)object).append(cConn.getStorageDirectory());
                                Helper.makeRelativePath((StringBuffer)object);
                                ((StringBuffer)object).append(Helper.getStorageServerName());
                                stringArray = new String[]{((StringBuffer)object).toString()};
                                boolean bl = false;
                                if (this.m_storageProc != null) {
                                    try {
                                        this.m_storageProc.exitValue();
                                    }
                                    catch (IllegalThreadStateException illegalThreadStateException) {
                                        bl = true;
                                    }
                                }
                                try {
                                    if (!bl) {
                                        cConn.closeStorageSupport();
                                        Runtime runtime = Runtime.getRuntime();
                                        this.m_storageProc = runtime.exec(stringArray);
                                    }
                                }
                                catch (Exception exception) {
                                    if (!s_logger.isErrorLoggingEnabled()) break block32;
                                    s_logger.error("Error starting Executable to discover devices...");
                                    s_logger.error(exception);
                                }
                            }
                            StringBufferPool.recycle((StringBuffer)object);
                        } else {
                            object = LUD.getInstance(cConn.getStorageDirectory());
                            try {
                                ((LUD)object).load();
                            }
                            catch (Throwable throwable) {
                                if (!s_logger.isErrorLoggingEnabled()) break block33;
                                s_logger.error("Exception in loading DSO:");
                                s_logger.error(throwable);
                            }
                        }
                    }
                    object = cConn.communicateWithStorageServer();
                    StringParser stringParser = StringParser.getInstance(((StringBuffer)object).toString(), "\n");
                    ((StringBuffer)object).setLength(0);
                    stringArray = new HashSet();
                    while (stringParser.hasMoreTokens()) {
                        try {
                            String string2 = stringParser.nextToken().trim();
                            if (string2.length() <= 0) continue;
                            StringParser stringParser2 = StringParser.getInstance(string2, FIELD_SEPERATOR);
                            string = stringParser2.nextToken().trim();
                            int n = Integer.parseInt(stringParser2.nextToken().trim(), 16);
                            stringParser2.recycle();
                            stringArray.add(string);
                            driveData = (DriveData)this.m_devicesPathHash.get(string);
                            if (driveData != null || !this.isMemoryDeviceAllowed() && (n == 7 || n == 8) && (this.isDVDRomDeviceAllowed() || n != 4)) continue;
                            ((StringBuffer)object).setLength(0);
                            ((StringBuffer)object).append(string);
                            driveData = DriveData.getInstance((StringBuffer)object, n, false, 0);
                            this.m_devicesPathHash.put(string, driveData);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (!s_logger.isErrorLoggingEnabled()) continue;
                            s_logger.error("Invalid number value encountered:");
                            s_logger.error(numberFormatException);
                        }
                    }
                    StringBufferPool.recycle((StringBuffer)object);
                    stringParser.recycle();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Iterator<Object> iterator = this.m_devicesPathHash.values().iterator();
                    while (iterator.hasNext()) {
                        driveData = (DriveData)iterator.next();
                        if (driveData.getMethodOfDiscovery() != 0 || stringArray.contains(string = driveData.toString())) continue;
                        arrayList.add(string);
                    }
                    iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        this.m_devicesPathHash.remove(string);
                    }
                }
                Object var16_21 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block34;
                }
                catch (Exception exception) {}
                break block34;
                {
                    catch (Throwable throwable) {
                        if (s_logger.isErrorLoggingEnabled()) {
                            s_logger.error("Exception in loading mounted drives:");
                            s_logger.error(throwable);
                        }
                        Object var16_22 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            break block34;
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var16_23 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    public boolean isSharingLocalStorage() {
        return this.m_isSharingLocalDevices;
    }

    public boolean mountDevice(DriveData driveData, DriveData driveData2) {
        Enumeration<InetAddress> enumeration;
        short s;
        Object object;
        InetAddress inetAddress = null;
        byte[] byArray = null;
        byte by = -1;
        byte by2 = -1;
        byte by3 = -1;
        byte by4 = -1;
        String string = "";
        String string2 = "";
        boolean bl = true;
        CConn cConn = KeyboardMgr.getInstance().getCConn();
        if (driveData == null) {
            return bl;
        }
        if (driveData instanceof RemoteDriveData) {
            block24: {
                this.m_isSharingLocalDevices = false;
                object = (RemoteDriveData)driveData;
                s = ((RemoteDriveData)object).getPort();
                try {
                    inetAddress = InetAddress.getByName(((DriveData)object).getPath().toString());
                    if (s_logger.isDebugLoggingEnabled()) {
                        s_logger.debug("Remote Storage Ip address= " + inetAddress.toString());
                    }
                }
                catch (Exception exception) {
                    if (!s_logger.isErrorLoggingEnabled()) break block24;
                    s_logger.error("Unknown host exception");
                    s_logger.error(exception);
                }
            }
            by = 0;
            by3 = (byte)driveData.getDriveType();
            if (driveData2 != null) {
                object = (RemoteDriveData)driveData2;
                by2 = 1;
                by4 = (byte)driveData2.getDriveType();
            }
        } else {
            block25: {
                try {
                    object = NetworkInterface.getNetworkInterfaces();
                    if (object != null && object.hasMoreElements()) {
                        boolean bl2 = false;
                        while (!bl2 && object.hasMoreElements()) {
                            NetworkInterface networkInterface = (NetworkInterface)object.nextElement();
                            enumeration = networkInterface.getInetAddresses();
                            if (enumeration == null || !enumeration.hasMoreElements()) continue;
                            while (!bl2 && enumeration.hasMoreElements()) {
                                inetAddress = enumeration.nextElement();
                                if (s_logger.isDebugLoggingEnabled()) {
                                    s_logger.debug("addr:\naddr instanceof Inet4Address=" + (inetAddress instanceof Inet4Address) + "\naddr.isAnyLocalAddress()=" + inetAddress.isAnyLocalAddress() + "\naddr.isLinkLocalAddress()=" + inetAddress.isLinkLocalAddress() + "\naddr.isLoopbackAddress()=" + inetAddress.isLoopbackAddress() + "\naddr.isMCGlobal()=" + inetAddress.isMCGlobal() + "\naddr.isMCLinkLocal()=" + inetAddress.isMCLinkLocal() + "\naddr.isMCOrgLocal()=" + inetAddress.isMCOrgLocal() + "\naddr.isMCSiteLocal()=" + inetAddress.isMCSiteLocal() + "\naddr.isMulticastAddress()=" + inetAddress.isMulticastAddress() + "\naddr.isSiteLocalAddress()=" + inetAddress.isSiteLocalAddress());
                                }
                                if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                                bl2 = true;
                            }
                        }
                        if (!bl2) {
                            inetAddress = null;
                        }
                    }
                    if (inetAddress == null) {
                        inetAddress = InetAddress.getLocalHost();
                    }
                }
                catch (Exception exception) {
                    if (!s_logger.isErrorLoggingEnabled()) break block25;
                    s_logger.error("Unknown host exception");
                    s_logger.error(exception);
                }
            }
            this.m_isSharingLocalDevices = true;
            s = (short)cConn.getViewer().mahoganyStorageServerPort.getValue();
            by = 0;
            driveData.setShareIndex(by);
            by3 = (byte)driveData.getDriveType();
            string = driveData.getPath().toString();
            if (driveData2 != null) {
                by2 = 1;
                driveData2.setShareIndex(by2);
                by4 = (byte)driveData2.getDriveType();
                string2 = driveData2.getPath().toString();
            }
        }
        this.m_devicesSharedHash.put(new Byte(driveData.getShareIndex()), driveData);
        if (driveData2 != null) {
            this.m_devicesSharedHash.put(new Byte(driveData2.getShareIndex()), driveData2);
        }
        if (this.isSharingLocalStorage() && cConn.isExeStorageSupported()) {
            block26: {
                object = Helper.getUserHomeDir();
                ((StringBuffer)object).append(cConn.getStorageDirectory());
                Helper.makeRelativePath((StringBuffer)object);
                ((StringBuffer)object).append(Helper.getStorageServerName());
                String[] stringArray = new String[]{((StringBuffer)object).toString(), CMD_LINE_INTEGRATED_STORAGE, String.valueOf(s)};
                boolean bl3 = false;
                if (this.m_storageProc != null) {
                    try {
                        this.m_storageProc.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        bl3 = true;
                    }
                }
                try {
                    if (!bl3) {
                        cConn.closeStorageSupport();
                        enumeration = Runtime.getRuntime();
                        this.m_storageProc = ((Runtime)((Object)enumeration)).exec(stringArray);
                    }
                }
                catch (Exception exception) {
                    if (!s_logger.isErrorLoggingEnabled()) break block26;
                    s_logger.error("Error starting Executable to discover devices...");
                    s_logger.error(exception);
                }
            }
            StringBufferPool.recycle((StringBuffer)object);
        }
        byArray = inetAddress.getAddress();
        byte by5 = inetAddress instanceof Inet4Address ? (byte)1 : 2;
        MessageSender.storageClientComnnect(byArray, s, by, by2, by3, by4, by5, string, string2);
        return bl;
    }

    public void unmountDevice() {
        CConn cConn = KeyboardMgr.getInstance().getCConn();
        if (cConn != null && cConn.isSocketValid()) {
            MessageSender.storageClientDisconnect();
        }
        this.stopStorage();
        this.m_devicesSharedHash.clear();
    }

    protected synchronized void stopStorage() {
        if (this.isSharingLocalStorage()) {
            if (s_logger.isDebugLoggingEnabled()) {
                s_logger.debug("Unmounting local devices");
            }
            this.m_isSharingLocalDevices = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        MountedDriveMgr mountedDriveMgr = this;
        synchronized (mountedDriveMgr) {
            Collection collection = this.isSharingDevices() ? this.m_devicesSharedHash.values() : this.m_devicesPathHash.values();
            ArrayList arrayList = new ArrayList(collection);
            Collections.sort(arrayList);
            return arrayList.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DriveData getDrive(String string) {
        MountedDriveMgr mountedDriveMgr = this;
        synchronized (mountedDriveMgr) {
            return (DriveData)this.m_devicesPathHash.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DriveData addDrive(StringBuffer stringBuffer, int n, boolean bl) {
        MountedDriveMgr mountedDriveMgr = this;
        synchronized (mountedDriveMgr) {
            DriveData driveData = DriveData.getInstance(stringBuffer, n, bl, 2);
            this.m_devicesPathHash.put(driveData.toString(), driveData);
            return driveData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DriveData addRemoteDrive(StringBuffer stringBuffer, short s, byte by, byte by2) {
        MountedDriveMgr mountedDriveMgr = this;
        synchronized (mountedDriveMgr) {
            RemoteDriveData remoteDriveData = RemoteDriveData.getInstance(stringBuffer, by2, s, by);
            this.m_devicesPathHash.put(((DriveData)remoteDriveData).toString(), remoteDriveData);
            return remoteDriveData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDrive(String string) {
        MountedDriveMgr mountedDriveMgr = this;
        synchronized (mountedDriveMgr) {
            DriveData driveData = (DriveData)this.m_devicesPathHash.remove(string);
            driveData.recycle();
        }
    }

    public void writeDrives() {
    }

    public boolean isSharingDevices() {
        return this.m_devicesSharedHash.size() > 0;
    }

    public void setDeviceShareStatus(StorageStatus storageStatus) {
        RemoteDriveData remoteDriveData = null;
        RemoteDriveData remoteDriveData2 = null;
        byte[] byArray = storageStatus.getIPAddress();
        StringBuffer stringBuffer = Helper.formatIPAddress(byArray, storageStatus.getIPType());
        short s = storageStatus.getPort();
        byte by = storageStatus.getShareIndex0();
        byte by2 = storageStatus.getShareIndex1();
        byte by3 = storageStatus.getShareType0();
        byte by4 = storageStatus.getShareType1();
        if (by != -1 && storageStatus.getShareStatus0() == 0) {
            remoteDriveData = RemoteDriveData.getInstance(stringBuffer, by3, s, by);
            remoteDriveData.setMounted(true);
        }
        if (by2 != -1 && storageStatus.getShareStatus1() == 0) {
            remoteDriveData2 = RemoteDriveData.getInstance(stringBuffer, by4, s, by2);
            remoteDriveData2.setMounted(true);
        }
        StringBufferPool.recycle(stringBuffer);
        if (this.isSharingDevices() && remoteDriveData == null && remoteDriveData2 == null) {
            this.stopStorage();
        }
        this.m_devicesSharedHash.clear();
        if (remoteDriveData != null) {
            this.m_devicesSharedHash.put(new Byte(remoteDriveData.getShareIndex()), remoteDriveData);
        }
        if (remoteDriveData2 != null) {
            this.m_devicesSharedHash.put(new Byte(remoteDriveData2.getShareIndex()), remoteDriveData2);
        }
        KeyboardMgr.getInstance().getCConn().updateMountDialog(false);
    }

    public boolean isDVDRomDeviceAllowed() {
        return this.m_isDVDRomDeviceAllowed;
    }

    public boolean isMemoryDeviceAllowed() {
        return this.m_isMemoryDeviceAllowed;
    }

    public void setDevciesAllowed(boolean bl, boolean bl2) {
        this.m_isDVDRomDeviceAllowed = bl;
        this.m_isMemoryDeviceAllowed = bl2;
        if (s_logger.isDebugLoggingEnabled()) {
            s_logger.debug("m_isMemoryDeviceAllowed = " + this.m_isMemoryDeviceAllowed);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

