/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.storage;

import com.serverengines.helper.Helper;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.keyboard.KeyboardMgr;
import com.serverengines.kvm.LogWriter;
import com.serverengines.mahogany.BaseDialog;
import com.serverengines.mahogany.CConn;
import com.serverengines.mahogany.IOKDlgCallback;
import com.serverengines.mahogany.IYesNoDlgCallback;
import com.serverengines.mahogany.ModallessOKMsgDlg;
import com.serverengines.mahogany.ModallessYesNoDlg;
import com.serverengines.mahogany.MsgBox;
import com.serverengines.resmgr.ResourceMgr;
import com.serverengines.storage.AddStorageDevicePanel;
import com.serverengines.storage.ConnectRemoteStorageDlg;
import com.serverengines.storage.DriveData;
import com.serverengines.storage.DriveImageTableRenderer;
import com.serverengines.storage.DriveStringTableRenderer;
import com.serverengines.storage.MountTableModel;
import com.serverengines.storage.MountedDriveMgr;
import com.serverengines.storage.RemoteDriveData;
import com.serverengines.storage.SelectStorageConnectionTypeDlg;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class MountDialog
extends BaseDialog
implements IYesNoDlgCallback,
IOKDlgCallback,
ActionListener,
ListSelectionListener {
    static final long serialVersionUID = -6946739068535969456L;
    protected static LogWriter s_logger = new LogWriter((class$com$serverengines$storage$MountDialog == null ? (class$com$serverengines$storage$MountDialog = MountDialog.class$("com.serverengines.storage.MountDialog")) : class$com$serverengines$storage$MountDialog).getName());
    public static final int IMG_COL_WIDTH = 50;
    public static final int ROW_HEIGHT = 30;
    public static final String DRIVE_INFO_SEPERATOR = " >> ";
    protected JTable m_storageTable;
    protected JToggleButton m_connectDisconnectButton;
    protected JButton m_addButon;
    protected JButton m_removeButon;
    protected JButton m_remoteStorageServerButton;
    protected JButton m_refreshButon;
    protected JButton m_okBtn;
    protected JProgressBar m_deviceDiscoveryProgressBar;
    protected JLabel m_infoLabel;
    protected MountTableModel m_storageModel;
    protected ModallessYesNoDlg m_confirmRemoveDlg;
    protected ModallessOKMsgDlg m_msgDlg;
    protected SelectStorageConnectionTypeDlg m_selectDlg;
    protected ConnectRemoteStorageDlg m_connectRemoteStorageDlg;
    static /* synthetic */ Class class$com$serverengines$storage$MountDialog;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$java$lang$String;

    public MountDialog(JFrame jFrame) {
        super(jFrame, ResourceMgr.getInstance().getResourceString("mount.dialog.title"), false);
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        CConn cConn = keyboardMgr.getCConn();
        if (cConn.isAlt0Text()) {
            this.setTitle(resourceMgr.getResourceString("alt.0.mount.dialog.title"));
        }
        this.m_connectRemoteStorageDlg = null;
        this.m_selectDlg = null;
        this.m_confirmRemoveDlg = null;
        this.m_msgDlg = null;
        this.m_storageModel = new MountTableModel();
        this.m_storageTable = new JTable(this.m_storageModel);
        JScrollPane jScrollPane = new JScrollPane(this.m_storageTable);
        this.m_storageTable.setSelectionMode(2);
        this.m_storageTable.setColumnSelectionAllowed(false);
        this.m_storageTable.setRowSelectionAllowed(true);
        this.m_storageTable.setRowHeight(30);
        this.m_storageTable.setDefaultRenderer(class$javax$swing$Icon == null ? (class$javax$swing$Icon = MountDialog.class$("javax.swing.Icon")) : class$javax$swing$Icon, new DriveImageTableRenderer());
        this.m_storageTable.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = MountDialog.class$("java.lang.String")) : class$java$lang$String, new DriveStringTableRenderer());
        this.m_storageTable.setShowGrid(false);
        this.m_storageTable.setBackground(this.getBackground());
        this.m_storageTable.requestFocus();
        TableColumnModel tableColumnModel = this.m_storageTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setMaxWidth(50);
        tableColumn.setResizable(false);
        this.m_storageTable.getSelectionModel().addListSelectionListener(this);
        this.getContentPane().add("Center", jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1, 0, 10));
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 20, 5));
        this.m_deviceDiscoveryProgressBar = new JProgressBar(0);
        this.m_deviceDiscoveryProgressBar.setIndeterminate(true);
        this.m_deviceDiscoveryProgressBar.setVisible(false);
        jPanel2.add(this.m_deviceDiscoveryProgressBar);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0, 20, 5));
        this.m_infoLabel = new JLabel(resourceMgr.getResourceString("empty.string"));
        jPanel2.add(this.m_infoLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(1, 20, 5));
        this.m_addButon = new JButton(resourceMgr.getResourceString("add.btn"));
        this.m_addButon.setMnemonic(resourceMgr.getResourceChar("add.btn.mnemonic"));
        this.m_addButon.addActionListener(this);
        jPanel2.add(this.m_addButon);
        this.m_remoteStorageServerButton = null;
        this.m_connectDisconnectButton = new JToggleButton(resourceMgr.getResourceString("mount.dialog.connect.btn"));
        this.m_connectDisconnectButton.setMnemonic(resourceMgr.getResourceChar("mount.dialog.connect.disconnect.btn.mnemonic"));
        this.m_connectDisconnectButton.addActionListener(this);
        jPanel2.add(this.m_connectDisconnectButton);
        this.m_removeButon = new JButton(resourceMgr.getResourceString("remove.btn"));
        this.m_removeButon.setMnemonic(resourceMgr.getResourceChar("remove.btn.mnemonic"));
        this.m_removeButon.addActionListener(this);
        jPanel2.add(this.m_removeButon);
        this.m_refreshButon = new JButton(resourceMgr.getResourceString("mount.dialog.refresh.btn"));
        this.m_refreshButon.setMnemonic(resourceMgr.getResourceChar("mount.dialog.refresh.btn.mnemonic"));
        this.m_refreshButon.addActionListener(this);
        jPanel2.add(this.m_refreshButon);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(1, 20, 5));
        this.m_okBtn = new JButton(resourceMgr.getResourceString("ok.btn"));
        this.m_okBtn.setMnemonic(resourceMgr.getResourceChar("ok.btn.mnemonic"));
        this.getRootPane().setDefaultButton(this.m_okBtn);
        this.m_okBtn.addActionListener(this);
        jPanel2.add(this.m_okBtn);
        jPanel.add(jPanel2);
        this.getContentPane().add("South", jPanel);
        this.toggleLayout();
        this.setResizable(true);
        this.pack();
        this.initPosiiton();
    }

    protected String getDriveIdFromList() {
        ListSelectionModel listSelectionModel = this.m_storageTable.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        String string = "";
        if (n > -1) {
            DriveData driveData = this.m_storageModel.getRow(n);
            string = driveData.toString();
        }
        return string;
    }

    protected void addRow(DriveData driveData) {
        this.addRow(driveData, this.m_storageModel.getRowCount());
    }

    protected void addRow(DriveData driveData, int n) {
        boolean bl = driveData.isMounted();
        this.m_storageModel.addRow(n, driveData);
        if (bl) {
            this.m_storageTable.getSelectionModel().addSelectionInterval(n, n);
        }
    }

    protected void toggleLayout() {
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        int n = this.getNumDevicesSelected();
        MountedDriveMgr mountedDriveMgr = MountedDriveMgr.getInstance();
        boolean bl = mountedDriveMgr.isSharingDevices();
        this.m_connectDisconnectButton.setSelected(bl);
        if (bl) {
            KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
            CConn cConn = keyboardMgr.getCConn();
            String string = cConn.isAlt0Text() ? resourceMgr.getResourceString("alt.0.mount.dialog.remove.devices") : resourceMgr.getResourceString("mount.dialog.remove.devices");
            this.m_connectDisconnectButton.setText(resourceMgr.getResourceString("mount.dialog.disconnect.btn"));
            this.m_connectDisconnectButton.setMnemonic(resourceMgr.getResourceChar("mount.dialog.connect.disconnect.btn.mnemonic"));
            this.m_infoLabel.setForeground(Color.RED);
            this.m_infoLabel.setText(string);
        } else {
            if (n == 2) {
                this.m_connectDisconnectButton.setText(resourceMgr.getResourceString("mount.dialog.connect.prompt.btn"));
            } else {
                this.m_connectDisconnectButton.setText(resourceMgr.getResourceString("mount.dialog.connect.btn"));
            }
            this.m_connectDisconnectButton.setMnemonic(resourceMgr.getResourceChar("mount.dialog.connect.disconnect.btn.mnemonic"));
            this.m_infoLabel.setText(resourceMgr.getResourceString("empty.string"));
        }
        this.m_storageTable.setEnabled(!bl);
        this.m_addButon.setEnabled(!bl);
        if (this.m_remoteStorageServerButton != null) {
            this.m_remoteStorageServerButton.setEnabled(!bl);
        }
        this.m_connectDisconnectButton.setEnabled(bl || n > 0 && n <= 2);
        this.m_removeButon.setEnabled(!bl && n == 1);
        this.m_refreshButon.setEnabled(!bl);
        this.pack();
    }

    public void clearSelections() {
        this.m_storageTable.getSelectionModel().clearSelection();
    }

    public void setConnectDisconnect(boolean bl) {
        this.m_connectDisconnectButton.setSelected(bl);
        this.toggleLayout();
    }

    protected void onAdd() {
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        CConn cConn = keyboardMgr.getCConn();
        String string = cConn.isAlt0Text() ? resourceMgr.getResourceString("alt.0.add.mount.dlg.title") : resourceMgr.getResourceString("add.mount.dlg.title");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(string);
        jFileChooser.setApproveButtonText(resourceMgr.getResourceString("select.btn"));
        jFileChooser.setApproveButtonMnemonic(resourceMgr.getResourceChar("select.btn.mnemonic"));
        jFileChooser.setApproveButtonToolTipText(resourceMgr.getResourceString("mount.browse.dlg.approve.tooltip"));
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(2);
        AddStorageDevicePanel addStorageDevicePanel = new AddStorageDevicePanel();
        jFileChooser.setAccessory(addStorageDevicePanel);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            Comparable comparable;
            MountedDriveMgr mountedDriveMgr = MountedDriveMgr.getInstance();
            StringBuffer stringBuffer = StringBufferPool.getInstance(jFileChooser.getSelectedFile().getPath());
            Helper.replaceString(stringBuffer, "/", File.separator);
            File file = new File(stringBuffer.toString());
            int n2 = addStorageDevicePanel.getDriveType();
            if (!file.exists()) {
                if (this.m_msgDlg == null) {
                    this.m_msgDlg = MsgBox.showModallessMsgDlg(this, resourceMgr.getResourceString("err.invalid.file.dir"), (IOKDlgCallback)this);
                    this.m_msgDlg.setVisible(true);
                } else {
                    this.m_msgDlg.setMessage(resourceMgr.getResourceString("err.invalid.file.dir"));
                    this.m_msgDlg.pack();
                    this.m_msgDlg.requestFocus();
                }
                return;
            }
            if (file.isDirectory()) {
                if (n2 == 11 || n2 == 12 || n2 == 9 || n2 == 10 || n2 == 13 || n2 == 14 || n2 == 16 || n2 == 17) {
                    if (this.m_msgDlg == null) {
                        this.m_msgDlg = MsgBox.showModallessMsgDlg(this, resourceMgr.getResourceString("err.invalid.dir.not.iso"), (IOKDlgCallback)this);
                        this.m_msgDlg.setVisible(true);
                    } else {
                        this.m_msgDlg.setMessage(resourceMgr.getResourceString("err.invalid.dir.not.iso"));
                        this.m_msgDlg.pack();
                        this.m_msgDlg.requestFocus();
                    }
                    return;
                }
                stringBuffer = Helper.makeRelativePath(stringBuffer);
            }
            if (Helper.isWindows() && n2 != 11 && n2 != 12 && n2 != 9 && n2 != 10 && n2 != 13 && n2 != 14 && n2 != 16 && n2 != 17) {
                comparable = StringBufferPool.getInstance();
                File[] fileArray = File.listRoots();
                boolean bl = false;
                int n3 = 0;
                while (!bl && n3 < fileArray.length) {
                    ((StringBuffer)comparable).setLength(0);
                    ((StringBuffer)comparable).append(fileArray[n3].getPath());
                    Helper.replaceString((StringBuffer)comparable, "/", File.separator);
                    bl = stringBuffer.indexOf(((StringBuffer)comparable).toString()) > -1;
                    if (bl) continue;
                    ++n3;
                }
                if (bl) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(((StringBuffer)comparable).toString());
                }
                StringBufferPool.recycle((StringBuffer)comparable);
            }
            if (this.m_storageModel.deviceExists(stringBuffer.toString())) {
                if (this.m_msgDlg == null) {
                    this.m_msgDlg = MsgBox.showModallessMsgDlg(this, resourceMgr.getResourceString("err.device.exists"), (IOKDlgCallback)this);
                    this.m_msgDlg.setVisible(true);
                } else {
                    this.m_msgDlg.setMessage(resourceMgr.getResourceString("err.device.exists"));
                    this.m_msgDlg.pack();
                    this.m_msgDlg.requestFocus();
                }
                return;
            }
            if (n2 == 0) {
                if (this.m_msgDlg == null) {
                    this.m_msgDlg = MsgBox.showModallessMsgDlg(this, resourceMgr.getResourceString("mount.dialog.no.device.selected"), (IOKDlgCallback)this);
                    this.m_msgDlg.setVisible(true);
                } else {
                    this.m_msgDlg.setMessage(resourceMgr.getResourceString("mount.dialog.no.device.selected"));
                    this.m_msgDlg.pack();
                    this.m_msgDlg.requestFocus();
                }
                return;
            }
            comparable = mountedDriveMgr.addDrive(stringBuffer, n2, false);
            mountedDriveMgr.writeDrives();
            this.insertDriveToTable((DriveData)comparable);
            this.toggleLayout();
            StringBufferPool.recycle(stringBuffer);
        }
    }

    protected int getNumDevicesSelected() {
        int n = 0;
        ListSelectionModel listSelectionModel = this.m_storageTable.getSelectionModel();
        for (int i = 0; i < this.m_storageModel.getRowCount(); ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            ++n;
        }
        return n;
    }

    protected Collection getDevicesSelected() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ListSelectionModel listSelectionModel = this.m_storageTable.getSelectionModel();
        for (int i = 0; i < this.m_storageModel.getRowCount(); ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            arrayList.add(new Integer(i));
        }
        return arrayList;
    }

    protected void onSelection() {
        MountedDriveMgr mountedDriveMgr = MountedDriveMgr.getInstance();
        ListSelectionModel listSelectionModel = this.m_storageTable.getSelectionModel();
        for (int i = 0; i < this.m_storageModel.getRowCount(); ++i) {
            DriveData driveData = this.m_storageModel.getRow(i);
            driveData.setMounted(listSelectionModel.isSelectedIndex(i));
            if (mountedDriveMgr.isSharingDevices() || listSelectionModel.isSelectedIndex(i)) continue;
            driveData.setShareIndex((byte)-1);
        }
        this.toggleLayout();
    }

    protected void shareDevices() {
        DriveData driveData = null;
        DriveData driveData2 = null;
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        Iterator iterator = this.getDevicesSelected().iterator();
        if (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            driveData = this.m_storageModel.getRow(n);
            driveData.setMounted(true);
            if (iterator.hasNext()) {
                n = (Integer)iterator.next();
                driveData2 = this.m_storageModel.getRow(n);
                driveData2.setMounted(true);
                if (!driveData.getClass().getName().equals(driveData2.getClass().getName())) {
                    KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
                    String string = keyboardMgr.getCConn().isAlt0Text() ? resourceMgr.getResourceString("alt.0.connect.remote.err.incompatiable.devices") : resourceMgr.getResourceString("connect.remote.err.incompatiable.devices");
                    if (this.m_msgDlg == null) {
                        this.m_msgDlg = MsgBox.showModallessMsgDlg(this, string, (IOKDlgCallback)this);
                        this.m_msgDlg.setVisible(true);
                    } else {
                        this.m_msgDlg.setMessage(string);
                        this.m_msgDlg.pack();
                        this.m_msgDlg.requestFocus();
                    }
                    this.setConnectDisconnect(false);
                    return;
                }
                if (driveData instanceof RemoteDriveData) {
                    if (this.m_msgDlg == null) {
                        this.m_msgDlg = MsgBox.showModallessMsgDlg(this, resourceMgr.getResourceString("connect.remote.err.one.remote.device"), (IOKDlgCallback)this);
                        this.m_msgDlg.setVisible(true);
                    } else {
                        this.m_msgDlg.setMessage(resourceMgr.getResourceString("connect.remote.err.one.remote.device"));
                        this.m_msgDlg.pack();
                        this.m_msgDlg.requestFocus();
                    }
                    this.setConnectDisconnect(false);
                    return;
                }
                if (this.m_selectDlg == null) {
                    this.m_selectDlg = new SelectStorageConnectionTypeDlg(this, driveData, driveData2);
                    this.m_selectDlg.setVisible(true);
                } else {
                    this.m_selectDlg.requestFocus();
                }
                return;
            }
        }
        this.shareTwoDevices(driveData, driveData2);
    }

    public void shareTwoDevices(DriveData driveData, DriveData driveData2) {
        MountedDriveMgr mountedDriveMgr = MountedDriveMgr.getInstance();
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        if (mountedDriveMgr.mountDevice(driveData, driveData2)) {
            mountedDriveMgr.writeDrives();
        } else {
            KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
            CConn cConn = keyboardMgr.getCConn();
            String string = cConn.isAlt0Text() ? resourceMgr.getResourceString("alt.0.err.storage.server.err") : resourceMgr.getResourceString("err.storage.server.err");
            if (this.m_msgDlg == null) {
                this.m_msgDlg = MsgBox.showModallessMsgDlg(this, string, (IOKDlgCallback)this);
                this.m_msgDlg.setVisible(true);
            } else {
                this.m_msgDlg.setMessage(string);
                this.m_msgDlg.pack();
                this.m_msgDlg.requestFocus();
            }
            this.setConnectDisconnect(false);
        }
    }

    protected void unshareDevices() {
        MountedDriveMgr mountedDriveMgr = MountedDriveMgr.getInstance();
        boolean bl = false;
        Iterator iterator = this.m_storageModel.getCollection().iterator();
        while (iterator.hasNext()) {
            DriveData driveData = (DriveData)iterator.next();
            if (!driveData.isMounted()) continue;
            driveData.setMounted(false);
            driveData.setShareIndex((byte)-1);
            if (bl) continue;
            mountedDriveMgr.unmountDevice();
            bl = true;
        }
        this.clearSelections();
        mountedDriveMgr.writeDrives();
    }

    protected void onConnectDisconnect() {
        if (this.m_connectDisconnectButton.isSelected()) {
            this.shareDevices();
        } else {
            this.unshareDevices();
        }
        this.toggleLayout();
    }

    protected void onRemove() {
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        CConn cConn = keyboardMgr.getCConn();
        String string = cConn.isAlt0Text() ? resourceMgr.getResourceString("alt.0.mount.dialog.confirm.remove") : resourceMgr.getResourceString("mount.dialog.confirm.remove");
        if (this.m_confirmRemoveDlg == null) {
            this.m_confirmRemoveDlg = MsgBox.showModallessYesNoDlg(this, string, (IYesNoDlgCallback)this);
            this.m_confirmRemoveDlg.setVisible(true);
        } else {
            this.m_confirmRemoveDlg.requestFocus();
        }
    }

    protected void onRefresh() {
        KeyboardMgr.getInstance().getCConn().startDeviceDiscovery();
    }

    public void discoverDevices(boolean bl) {
        CConn cConn = KeyboardMgr.getInstance().getCConn();
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        this.m_deviceDiscoveryProgressBar.setVisible(bl);
        String string = bl ? (cConn.isAlt0Text() ? "alt.0.mount.dialog.discovering.devices" : "mount.dialog.discovering.devices") : "empty.string";
        this.m_infoLabel.setForeground(Color.BLACK);
        this.m_infoLabel.setText(resourceMgr.getResourceString(string));
    }

    protected void onRemoteStorage() {
        if (this.m_connectRemoteStorageDlg == null) {
            this.m_connectRemoteStorageDlg = new ConnectRemoteStorageDlg(this);
            this.m_connectRemoteStorageDlg.setVisible(true);
        } else {
            this.m_connectRemoteStorageDlg.requestFocus();
        }
    }

    protected void insertDriveToTable(DriveData driveData) {
        List list = this.m_storageModel.getCollection();
        int n = Collections.binarySearch(list, driveData);
        if (n < 0) {
            this.addRow(driveData, -1 - n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadDrives() {
        MountDialog mountDialog = this;
        synchronized (mountDialog) {
            this.m_storageModel.clear();
            MountedDriveMgr mountedDriveMgr = MountedDriveMgr.getInstance();
            Iterator iterator = mountedDriveMgr.iterator();
            while (iterator.hasNext()) {
                DriveData driveData = (DriveData)iterator.next();
                this.insertDriveToTable(driveData);
            }
            this.toggleLayout();
        }
    }

    public void onRemoteStorageShare(String string, short s, byte by, byte by2, byte by3, byte by4) {
        DriveData driveData;
        StringBuffer stringBuffer;
        MountedDriveMgr mountedDriveMgr = MountedDriveMgr.getInstance();
        if (by != -1) {
            stringBuffer = StringBufferPool.getInstance(string);
            driveData = mountedDriveMgr.addRemoteDrive(stringBuffer, s, (byte)-1, by3);
            this.insertDriveToTable(driveData);
            StringBufferPool.recycle(stringBuffer);
        }
        if (by2 != -1) {
            stringBuffer = StringBufferPool.getInstance(string);
            driveData = mountedDriveMgr.addRemoteDrive(stringBuffer, s, (byte)-1, by4);
            this.insertDriveToTable(driveData);
            StringBufferPool.recycle(stringBuffer);
        }
        mountedDriveMgr.writeDrives();
        this.toggleLayout();
    }

    public void clearRemoteStorageDlg() {
        this.m_connectRemoteStorageDlg = null;
    }

    public void yesNoCallback(ModallessYesNoDlg modallessYesNoDlg, boolean bl) {
        if (modallessYesNoDlg.equals(this.m_confirmRemoveDlg)) {
            if (bl) {
                String string = this.getDriveIdFromList();
                ListSelectionModel listSelectionModel = this.m_storageTable.getSelectionModel();
                this.m_storageModel.removeRow(listSelectionModel.getMinSelectionIndex());
                MountedDriveMgr mountedDriveMgr = MountedDriveMgr.getInstance();
                mountedDriveMgr.removeDrive(string);
                mountedDriveMgr.writeDrives();
                this.clearSelections();
                this.toggleLayout();
            }
            this.m_confirmRemoveDlg = null;
        }
    }

    public void endDialog() {
        if (this.m_connectRemoteStorageDlg != null) {
            this.m_connectRemoteStorageDlg.endDialog();
        }
        if (this.m_selectDlg != null) {
            this.m_selectDlg.onCancel();
        }
        if (this.m_confirmRemoveDlg != null) {
            this.m_confirmRemoveDlg.dispose();
        }
        if (this.m_msgDlg != null) {
            this.m_msgDlg.dispose();
        }
        this.done = true;
        this.setVisible(false);
    }

    public void selectionMadeCallback(DriveData driveData, DriveData driveData2) {
        this.shareTwoDevices(driveData, driveData2);
        this.selectionCancelCallback();
    }

    public void selectionCancelCallback() {
        this.m_selectDlg = null;
    }

    public void okCallback(ModallessOKMsgDlg modallessOKMsgDlg) {
        if (modallessOKMsgDlg.equals(this.m_msgDlg)) {
            this.m_msgDlg = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.m_okBtn)) {
            this.onOK();
        } else if (object.equals(this.m_addButon)) {
            this.onAdd();
        } else if (object.equals(this.m_remoteStorageServerButton)) {
            this.onRemoteStorage();
        } else if (object.equals(this.m_connectDisconnectButton)) {
            this.onConnectDisconnect();
        } else if (object.equals(this.m_removeButon)) {
            this.onRemove();
        } else if (object.equals(this.m_refreshButon)) {
            this.onRefresh();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.onSelection();
    }

    protected void onCancel() {
        this.onOK();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

