/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.storage;

import com.serverengines.helper.StringBufferPool;
import com.serverengines.keyboard.KeyboardMgr;
import com.serverengines.mahogany.BaseDialog;
import com.serverengines.mahogany.CConn;
import com.serverengines.mahogany.IOKDlgCallback;
import com.serverengines.mahogany.ModallessOKMsgDlg;
import com.serverengines.mahogany.MsgBox;
import com.serverengines.resmgr.AppResMgr;
import com.serverengines.resmgr.ResourceMgr;
import com.serverengines.resmgr.SettingsResMgr;
import com.serverengines.storage.MountDialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConnectRemoteStorageDlg
extends BaseDialog
implements IOKDlgCallback,
ActionListener {
    static final long serialVersionUID = -9199809531514018747L;
    protected MountDialog m_mountDlg;
    protected DefaultComboBoxModel m_ipAddressComboModel;
    protected DefaultComboBoxModel m_portComboModel;
    protected JComboBox m_previousServerIPAddressCB;
    protected JComboBox m_previousServerPortCB;
    protected JTextField m_serverIPAddressText;
    protected JTextField m_serverPortText;
    protected ModallessOKMsgDlg m_msgDlg;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;

    public ConnectRemoteStorageDlg(MountDialog mountDialog) {
        super(mountDialog, ResourceMgr.getInstance().getResourceString("connect.remote.storage.dlg.title"), false);
        int n;
        this.m_mountDlg = mountDialog;
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        CConn cConn = keyboardMgr.getCConn();
        if (cConn.isAlt0Text()) {
            this.setTitle(resourceMgr.getResourceString("alt.0.connect.remote.storage.dlg.title"));
        }
        AppResMgr appResMgr = AppResMgr.getInstance();
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_msgDlg = null;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel(gridBagLayout);
        JLabel jLabel = new JLabel(resourceMgr.getResourceString("connect.remote.storage.dlg.ip.address"));
        jLabel.setDisplayedMnemonic(resourceMgr.getResourceChar("connect.remote.storage.dlg.ip.address.mnemonic"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.m_serverIPAddressText = new JTextField(35);
        jLabel.setLabelFor(this.m_serverIPAddressText);
        this.m_serverIPAddressText.requestFocus();
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.m_serverIPAddressText, gridBagConstraints);
        jPanel.add(this.m_serverIPAddressText);
        int n2 = appResMgr.getResourceInt("num.remote.storage.server.connections");
        String string = null;
        this.m_ipAddressComboModel = new DefaultComboBoxModel();
        for (n = 0; n < n2; ++n) {
            string = settingsResMgr.getResourceString("remote.storage." + n);
            if (string.length() <= 0) continue;
            this.m_ipAddressComboModel.addElement(string);
        }
        this.m_previousServerIPAddressCB = new JComboBox(this.m_ipAddressComboModel);
        this.m_previousServerIPAddressCB.addActionListener(this);
        if (this.m_ipAddressComboModel.getSize() > 0) {
            string = (String)this.m_ipAddressComboModel.getElementAt(0);
            this.m_serverIPAddressText.setText(string);
            this.m_serverIPAddressText.selectAll();
            this.m_previousServerIPAddressCB.setSelectedIndex(0);
            ++gridBagConstraints.gridx;
            gridBagLayout.setConstraints(this.m_previousServerIPAddressCB, gridBagConstraints);
            jPanel.add(this.m_previousServerIPAddressCB);
        }
        jLabel = new JLabel(resourceMgr.getResourceString("connect.remote.storage.dlg.port"));
        jLabel.setDisplayedMnemonic(resourceMgr.getResourceChar("connect.remote.storage.dlg.port.mnemonic"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.m_serverPortText = new JTextField();
        this.m_serverPortText.setColumns(35);
        jLabel.setLabelFor(this.m_serverPortText);
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.m_serverPortText, gridBagConstraints);
        jPanel.add(this.m_serverPortText);
        n2 = appResMgr.getResourceInt("num.remote.storage.server.ports");
        this.m_portComboModel = new DefaultComboBoxModel();
        for (n = 0; n < n2; ++n) {
            string = settingsResMgr.getResourceString("remote.storage.port." + n);
            if (string.length() <= 0) continue;
            this.m_portComboModel.addElement(string);
        }
        this.m_previousServerPortCB = new JComboBox(this.m_portComboModel);
        this.m_previousServerPortCB.addActionListener(this);
        if (this.m_portComboModel.getSize() > 0) {
            string = (String)this.m_portComboModel.getElementAt(0);
            this.m_serverPortText.setText(string);
            this.m_serverPortText.selectAll();
            this.m_previousServerPortCB.setSelectedIndex(0);
            ++gridBagConstraints.gridx;
            gridBagLayout.setConstraints(this.m_previousServerPortCB, gridBagConstraints);
            jPanel.add(this.m_previousServerPortCB);
        }
        this.getContentPane().add("Center", jPanel);
        jPanel = new JPanel(new FlowLayout(1, 20, 5));
        this.m_okBtn = new JButton(resourceMgr.getResourceString("ok.btn"));
        this.m_okBtn.setMnemonic(resourceMgr.getResourceChar("ok.btn.mnemonic"));
        this.getRootPane().setDefaultButton(this.m_okBtn);
        this.m_okBtn.addActionListener(this);
        jPanel.add(this.m_okBtn);
        this.m_cancelBtn = new JButton(resourceMgr.getResourceString("cancel.btn"));
        this.m_cancelBtn.setMnemonic(resourceMgr.getResourceChar("cancel.btn.mnemonic"));
        this.m_cancelBtn.addActionListener(this);
        jPanel.add(this.m_cancelBtn);
        this.getContentPane().add("South", jPanel);
        this.setResizable(true);
        this.pack();
        this.initPosiiton();
    }

    protected void onOK() {
        int n;
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        AppResMgr appResMgr = AppResMgr.getInstance();
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        String string = this.m_serverIPAddressText.getText();
        if ((string = string.trim()).length() == 0) {
            if (this.m_msgDlg == null) {
                this.m_msgDlg = MsgBox.showModallessMsgDlg(this, resourceMgr.getResourceString("connect.remote.err.no.ip.address"), (IOKDlgCallback)this);
                this.m_msgDlg.setVisible(true);
            } else {
                this.m_msgDlg.setMessage(resourceMgr.getResourceString("connect.remote.err.no.ip.address"));
                this.m_msgDlg.pack();
                this.m_msgDlg.requestFocus();
            }
            this.m_serverIPAddressText.requestFocus();
            this.m_serverIPAddressText.selectAll();
            return;
        }
        try {
            InetAddress.getByName(string);
        }
        catch (Exception exception) {
            if (this.m_msgDlg == null) {
                this.m_msgDlg = MsgBox.showModallessMsgDlg(this, resourceMgr.getResourceString("err.unknownhost"), (IOKDlgCallback)this);
                this.m_msgDlg.setVisible(true);
            } else {
                this.m_msgDlg.setMessage(resourceMgr.getResourceString("err.unknownhost"));
                this.m_msgDlg.pack();
                this.m_msgDlg.requestFocus();
            }
            this.m_serverIPAddressText.requestFocus();
            this.m_serverIPAddressText.selectAll();
            return;
        }
        String string2 = string;
        int n2 = appResMgr.getResourceInt("num.remote.storage.server.connections");
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        StringBuffer stringBuffer2 = StringBufferPool.getInstance();
        this.m_ipAddressComboModel.insertElementAt(string, 0);
        for (n = 0; n < n2 && n < this.m_ipAddressComboModel.getSize(); ++n) {
            string = (String)this.m_ipAddressComboModel.getElementAt(n);
            if (arrayList.contains(string)) continue;
            stringBuffer.setLength(0);
            stringBuffer2.setLength(0);
            stringBuffer.append("remote.storage.");
            stringBuffer.append(n);
            stringBuffer2.append(string);
            settingsResMgr.setResourceValue(stringBuffer.toString(), stringBuffer2);
            arrayList.add(string);
        }
        string = this.m_serverPortText.getText();
        if ((string = string.trim()).length() == 0) {
            if (this.m_msgDlg == null) {
                this.m_msgDlg = MsgBox.showModallessMsgDlg(this, resourceMgr.getResourceString("connect.remote.err.invalid.port"), (IOKDlgCallback)this);
                this.m_msgDlg.setVisible(true);
            } else {
                this.m_msgDlg.setMessage(resourceMgr.getResourceString("connect.remote.err.invalid.port"));
                this.m_msgDlg.pack();
                this.m_msgDlg.requestFocus();
            }
            this.m_serverPortText.requestFocus();
            this.m_serverPortText.selectAll();
            return;
        }
        short s = 0;
        try {
            s = Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.m_msgDlg == null) {
                this.m_msgDlg = MsgBox.showModallessMsgDlg(this, resourceMgr.getResourceString("connect.remote.err.invalid.port"), (IOKDlgCallback)this);
                this.m_msgDlg.setVisible(true);
            } else {
                this.m_msgDlg.setMessage(resourceMgr.getResourceString("connect.remote.err.invalid.port"));
                this.m_msgDlg.pack();
                this.m_msgDlg.requestFocus();
            }
            this.m_serverPortText.requestFocus();
            this.m_serverPortText.selectAll();
            return;
        }
        if (s < 0) {
            if (this.m_msgDlg == null) {
                this.m_msgDlg = MsgBox.showModallessMsgDlg(this, resourceMgr.getResourceString("connect.remote.err.invalid.port"), (IOKDlgCallback)this);
                this.m_msgDlg.setVisible(true);
            } else {
                this.m_msgDlg.setMessage(resourceMgr.getResourceString("connect.remote.err.invalid.port"));
                this.m_msgDlg.pack();
                this.m_msgDlg.requestFocus();
            }
            this.m_serverPortText.requestFocus();
            this.m_serverPortText.selectAll();
            return;
        }
        this.m_ipAddressComboModel.removeAllElements();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.m_ipAddressComboModel.addElement(iterator.next());
        }
        this.m_previousServerIPAddressCB.setSelectedIndex(0);
        n2 = appResMgr.getResourceInt("num.remote.storage.server.ports");
        arrayList.clear();
        this.m_portComboModel.insertElementAt(string, 0);
        for (n = 0; n < n2 && n < this.m_portComboModel.getSize(); ++n) {
            string = (String)this.m_portComboModel.getElementAt(n);
            if (arrayList.contains(string)) continue;
            stringBuffer.setLength(0);
            stringBuffer2.setLength(0);
            stringBuffer.append("remote.storage.port.");
            stringBuffer.append(n);
            stringBuffer2.append(string);
            settingsResMgr.setResourceValue(stringBuffer.toString(), stringBuffer2);
            arrayList.add(string);
        }
        this.m_portComboModel.removeAllElements();
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.m_portComboModel.addElement(iterator.next());
        }
        this.m_previousServerPortCB.setSelectedIndex(0);
        StringBufferPool.recycle(stringBuffer2);
        StringBufferPool.recycle(stringBuffer);
        settingsResMgr.writeResource();
        this.m_mountDlg.onRemoteStorageShare(string2, s, (byte)0, (byte)-1, (byte)11, (byte)-1);
        super.onOK();
    }

    protected void onIPItemStateChange() {
        int n = this.m_previousServerIPAddressCB.getSelectedIndex();
        if (n > -1) {
            this.m_serverIPAddressText.setText((String)this.m_ipAddressComboModel.getElementAt(n));
        }
        this.m_serverIPAddressText.requestFocus();
        this.m_serverIPAddressText.selectAll();
    }

    protected void onPortItemStateChange() {
        int n = this.m_previousServerPortCB.getSelectedIndex();
        if (n > -1) {
            this.m_serverPortText.setText((String)this.m_portComboModel.getElementAt(n));
        }
        this.m_serverPortText.requestFocus();
        this.m_serverPortText.selectAll();
    }

    public void endDialog() {
        if (this.m_mountDlg != null) {
            this.m_mountDlg.clearRemoteStorageDlg();
        }
        if (this.m_msgDlg != null) {
            this.m_msgDlg.dispose();
        }
        super.endDialog();
    }

    public void okCallback(ModallessOKMsgDlg modallessOKMsgDlg) {
        if (modallessOKMsgDlg.equals(this.m_msgDlg)) {
            this.m_msgDlg = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.m_okBtn)) {
            this.onOK();
        } else if (object.equals(this.m_cancelBtn)) {
            this.onCancel();
        } else if (object.equals(this.m_previousServerPortCB)) {
            this.onPortItemStateChange();
        } else if (object.equals(this.m_previousServerIPAddressCB)) {
            this.onIPItemStateChange();
        }
    }
}

