/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.resmgr;

import com.serverengines.helper.Helper;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.kvm.LogWriter;
import com.serverengines.mahogany.IAppletCookieCallback;
import com.serverengines.mahogany.MahoganyViewer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

public abstract class AbstractResourceMgr {
    public static final String SETTINGS_OPERATOR = "=";
    public static final char NEWLINE = "\n".charAt(0);
    protected static LogWriter s_log = new LogWriter((class$com$serverengines$resmgr$AbstractResourceMgr == null ? (class$com$serverengines$resmgr$AbstractResourceMgr = AbstractResourceMgr.class$("com.serverengines.resmgr.AbstractResourceMgr")) : class$com$serverengines$resmgr$AbstractResourceMgr).getName());
    protected Properties m_resources;
    protected String m_resourceFullPath;
    protected IAppletCookieCallback m_applet;
    static /* synthetic */ Class class$com$serverengines$resmgr$AbstractResourceMgr;

    protected AbstractResourceMgr(String string) {
        this(string, null);
    }

    protected AbstractResourceMgr(String string, IAppletCookieCallback iAppletCookieCallback) {
        block2: {
            try {
                this.m_applet = iAppletCookieCallback;
                this.loadPropertyFile(string);
            }
            catch (Exception exception) {
                if (!s_log.isErrorLoggingEnabled()) break block2;
                s_log.error(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPropertyFile(String string) throws Exception {
        InputStream inputStream = null;
        try {
            this.m_resources = new Properties();
            StringBuffer stringBuffer = StringBufferPool.getInstance(string);
            this.m_resourceFullPath = !MahoganyViewer.applet ? Helper.getResourcePath(stringBuffer).toString() : "";
            inputStream = Helper.getResourceStream(string);
            String string2 = null;
            String string3 = null;
            int n = 0;
            while (n > -1) {
                stringBuffer.setLength(0);
                n = inputStream.read();
                while (n > -1 && (char)n != NEWLINE) {
                    stringBuffer.append((char)n);
                    n = inputStream.read();
                }
                int n2 = stringBuffer.indexOf(SETTINGS_OPERATOR);
                if (n2 <= -1) continue;
                string2 = stringBuffer.substring(0, n2).trim();
                string3 = stringBuffer.substring(n2 + 1).trim();
                this.m_resources.put(string2, string3);
            }
            StringBufferPool.recycle(stringBuffer);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public IAppletCookieCallback getAppletCallback() {
        return this.m_applet;
    }

    public void setAppletCallback(IAppletCookieCallback iAppletCookieCallback) {
        this.m_applet = iAppletCookieCallback;
    }

    public String getResourceString(String string) {
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        String string2 = this.getResourceString(string, stringBuffer);
        StringBufferPool.recycle(stringBuffer);
        return string2;
    }

    public String getResourceString(String string, StringBuffer stringBuffer) {
        return this.m_resources.getProperty(string, stringBuffer.toString());
    }

    public String getResourceString(String string, ArrayList arrayList) {
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        String string2 = this.getResourceString(string, stringBuffer, arrayList);
        StringBufferPool.recycle(stringBuffer);
        return string2;
    }

    public String getResourceString(String string, StringBuffer stringBuffer, ArrayList arrayList) {
        StringBuffer stringBuffer2 = StringBufferPool.getInstance(this.getResourceString(string, stringBuffer));
        Helper.replaceWithParams(stringBuffer2, arrayList);
        String string2 = stringBuffer2.toString();
        StringBufferPool.recycle(stringBuffer2);
        return string2;
    }

    public char getResourceChar(String string) {
        return this.getResourceChar(string, '\u0000');
    }

    public char getResourceChar(String string, char c) {
        StringBuffer stringBuffer = Helper.valueOf(c);
        String string2 = this.getResourceString(string, stringBuffer);
        StringBufferPool.recycle(stringBuffer);
        char c2 = c;
        if (string2.length() > 0) {
            c2 = string2.charAt(0);
        }
        return c2;
    }

    public int getResourceInt(String string) {
        return this.getResourceInt(string, 0);
    }

    public int getResourceInt(String string, int n) {
        int n2;
        block2: {
            StringBuffer stringBuffer = Helper.valueOf(n);
            String string2 = this.getResourceString(string, stringBuffer);
            StringBufferPool.recycle(stringBuffer);
            n2 = n;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (!s_log.isErrorLoggingEnabled()) break block2;
                s_log.error(numberFormatException);
            }
        }
        return n2;
    }

    public short getResourceShort(String string) {
        return this.getResourceShort(string, (short)0);
    }

    public short getResourceShort(String string, short s) {
        short s2;
        block2: {
            StringBuffer stringBuffer = Helper.valueOf(s);
            String string2 = this.getResourceString(string, stringBuffer);
            StringBufferPool.recycle(stringBuffer);
            s2 = s;
            try {
                s2 = Short.parseShort(string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (!s_log.isErrorLoggingEnabled()) break block2;
                s_log.error(numberFormatException);
            }
        }
        return s2;
    }

    public long getResourceLong(String string) {
        return this.getResourceLong(string, 0L);
    }

    public long getResourceLong(String string, long l) {
        long l2;
        block2: {
            StringBuffer stringBuffer = Helper.valueOf(l);
            String string2 = this.getResourceString(string, stringBuffer);
            StringBufferPool.recycle(stringBuffer);
            l2 = l;
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (!s_log.isErrorLoggingEnabled()) break block2;
                s_log.error(numberFormatException);
            }
        }
        return l2;
    }

    public boolean getResourceBool(String string) {
        return this.getResourceBool(string, false);
    }

    public boolean getResourceBool(String string, boolean bl) {
        StringBuffer stringBuffer = Helper.valueOf(bl);
        String string2 = this.getResourceString(string, stringBuffer);
        StringBufferPool.recycle(stringBuffer);
        return string2.trim().equalsIgnoreCase("true");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

