/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.rdr;

import com.serverengines.buffer.Buffers;
import com.serverengines.rdr.BadException;
import com.serverengines.rdr.BadIOException;
import com.serverengines.rdr.OutStream;
import java.io.IOException;
import java.io.OutputStream;

public class JavaOutStream
extends OutStream {
    public static final int DEFAULT_BUF_SIZE = 16384;
    public static final int MIN_BULK_SIZE = 1024;
    protected OutputStream jos;
    protected int ptrOffset;
    protected int bufSize;

    public JavaOutStream(OutputStream outputStream, int n) {
        this.jos = outputStream;
        this.b = Buffers.m_socketOutBuffer;
        this.bufSize = this.b.length;
        this.ptr = 0;
        this.end = this.bufSize;
    }

    public JavaOutStream(OutputStream outputStream) {
        this(outputStream, 16384);
    }

    public void writeBytes(byte[] byArray, int n, int n2) {
        if (n2 < 1024) {
            super.writeBytes(byArray, n, n2);
            return;
        }
        this.flush();
        try {
            this.jos.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new BadIOException(iOException);
        }
        this.ptrOffset += n2;
    }

    public void flush() {
        try {
            this.jos.write(this.b, 0, this.ptr);
        }
        catch (IOException iOException) {
            throw new BadIOException(iOException);
        }
        this.ptrOffset += this.ptr;
        this.ptr = 0;
    }

    public int length() {
        return this.ptrOffset + this.ptr;
    }

    protected int overrun(int n, int n2) {
        if (n > this.bufSize) {
            throw new BadException("JavaOutStream overrun: max itemSize exceeded");
        }
        this.flush();
        if (n * n2 > this.end) {
            n2 = this.end / n;
        }
        return n2;
    }
}

