/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.nativeinterface;

import com.serverengines.keyboard.KeyboardMgr;
import com.serverengines.mahogany.CConn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;

public final class LUD {
    public static final String LIBRARY_NAME = "M2";
    public static final String EXTENSION_32_BIT = "-32";
    public static final String EXTENSION_64_BIT = "-64";
    public static final String X64 = "x64";
    public static final String AMD64 = "amd64";
    public static final String STORAGE_PORT_FILENAME = "StorageServer.Port";
    public static final int COPY_BUFFER_SZ = 8192;
    public static final long UPPER_BIT_LONG = Long.MIN_VALUE;
    public static final int BIT_MASK = 1;
    protected static LUD s_instance = null;
    protected static boolean s_storageLoadError = false;
    protected static boolean s_isNativeLoaded = false;
    protected String m_dsoFilePath;
    static /* synthetic */ Class class$com$serverengines$nativeinterface$LUD;

    protected LUD(String string) throws Throwable {
        PrintStream printStream = null;
        try {
            s_isNativeLoaded = false;
            this.m_dsoFilePath = "";
            String string2 = System.getProperty("user.home", "").trim();
            String string3 = System.getProperty("os.arch", "").trim().toLowerCase();
            int n = string2.indexOf(File.pathSeparatorChar);
            if (n > -1) {
                string2 = string2.substring(0, n).trim();
            }
            if (string2.length() > 0) {
                StringBuffer stringBuffer = new StringBuffer(string2);
                StringBuffer stringBuffer2 = new StringBuffer(LIBRARY_NAME);
                if (string3.indexOf(X64) >= 0 || string3.indexOf(AMD64) >= 0) {
                    stringBuffer2.append(EXTENSION_64_BIT);
                } else {
                    stringBuffer2.append(EXTENSION_32_BIT);
                }
                this.makeRelativePath(stringBuffer);
                stringBuffer.append(string);
                File file = new File(stringBuffer.toString());
                if (file.isDirectory() || !file.exists()) {
                    if (!file.exists()) {
                        file.mkdir();
                    }
                    this.makeRelativePath(stringBuffer);
                    StringBuffer stringBuffer3 = new StringBuffer(stringBuffer.toString());
                    this.makeRelativePath(stringBuffer3);
                    stringBuffer3.append(STORAGE_PORT_FILENAME);
                    printStream = new PrintStream(new FileOutputStream(stringBuffer3.toString()));
                    CConn cConn = KeyboardMgr.getInstance().getCConn();
                    printStream.print(cConn.getViewer().mahoganyStorageServerPort.getValue());
                    String string4 = System.mapLibraryName(stringBuffer2.toString()).toUpperCase();
                    stringBuffer.append(string4);
                    this.m_dsoFilePath = stringBuffer.toString();
                    InputStream inputStream = this.getResourceStream(string4);
                    long l = LUD.calculateChecksum(inputStream);
                    long l2 = l + 1L;
                    file = new File(this.m_dsoFilePath);
                    if (file.exists()) {
                        if (!file.isFile()) {
                            s_storageLoadError = true;
                        } else {
                            FileInputStream fileInputStream = null;
                            try {
                                fileInputStream = new FileInputStream(file);
                                l2 = LUD.calculateChecksum(fileInputStream);
                            }
                            catch (Exception exception) {
                                l2 = l + 1L;
                            }
                        }
                    } else {
                        l2 = l + 1L;
                    }
                    if (l != l2) {
                        inputStream = this.getResourceStream(string4);
                        this.copyFile(inputStream, stringBuffer);
                    }
                    s_isNativeLoaded = true;
                }
            } else {
                s_storageLoadError = true;
            }
        }
        catch (Throwable throwable) {
            s_storageLoadError = true;
            throw throwable;
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    public static synchronized LUD getInstance(String string) {
        if (s_instance == null) {
            try {
                s_instance = new LUD(string);
            }
            catch (Throwable throwable) {
                s_instance = null;
                s_storageLoadError = true;
            }
        }
        return s_instance;
    }

    public void load() {
        System.load(this.m_dsoFilePath);
    }

    public void unload() {
    }

    protected InputStream getResourceStream(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = null;
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            classLoader = (class$com$serverengines$nativeinterface$LUD == null ? (class$com$serverengines$nativeinterface$LUD = LUD.class$("com.serverengines.nativeinterface.LUD")) : class$com$serverengines$nativeinterface$LUD).getClassLoader();
            if (classLoader != null) {
                inputStream = classLoader.getResourceAsStream(string);
            }
            if (inputStream == null) {
                inputStream = (class$com$serverengines$nativeinterface$LUD == null ? (class$com$serverengines$nativeinterface$LUD = LUD.class$("com.serverengines.nativeinterface.LUD")) : class$com$serverengines$nativeinterface$LUD).getResourceAsStream(string);
            }
        }
        return inputStream;
    }

    protected boolean endsWith(StringBuffer stringBuffer, String string) {
        int n = stringBuffer.length() - string.length();
        boolean bl = false;
        if (n > -1) {
            String string2 = stringBuffer.substring(n, stringBuffer.length());
            bl = string2.equals(string);
        }
        return bl;
    }

    protected StringBuffer makeRelativePath(StringBuffer stringBuffer) {
        if (!this.endsWith(stringBuffer, "/") && !this.endsWith(stringBuffer, "\\")) {
            stringBuffer.append(File.separatorChar);
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void copyFile(InputStream inputStream, StringBuffer stringBuffer) {
        block20: {
            Exception exception2222;
            FileOutputStream fileOutputStream;
            block18: {
                fileOutputStream = null;
                byte[] byArray = new byte[8192];
                fileOutputStream = new FileOutputStream(stringBuffer.toString());
                int n = inputStream.read(byArray);
                while (n > 0) {
                    fileOutputStream.write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
                Object var7_7 = null;
                if (fileOutputStream == null) break block18;
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception2222) {}
            }
            break block20;
            {
                catch (Exception exception3) {
                    Exception exception42222;
                    Object var7_8 = null;
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception42222) {
                            // empty catch block
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception42222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception exception52222;
                Object var7_9 = null;
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception52222) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception52222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long calculateChecksum(InputStream inputStream) {
        long l = 0L;
        try {
            int n = inputStream.read();
            while (n > -1) {
                boolean bl = (l & Long.MIN_VALUE) != 0L;
                l <<= 1;
                if (bl) {
                    l |= 1L;
                }
                l ^= (long)n;
                n = inputStream.read();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return l;
    }

    public static void clearInstance() {
        s_storageLoadError = false;
    }

    public static boolean hasStorageFailedToLoad() {
        return s_storageLoadError;
    }

    public static boolean isLoaded() {
        return s_isNativeLoaded;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

