/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.mouse;

import com.serverengines.mahogany.MessageSender;
import com.serverengines.mouse.MouseButtons;
import com.serverengines.mouse.MouseDelegate;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public class MouseRelativeDelegate
extends MouseDelegate {
    protected boolean m_canSendMouseMessages = true;

    public MouseRelativeDelegate(Point point, MouseButtons mouseButtons) {
        super(point, mouseButtons);
    }

    protected short getRelativeX(MouseEvent mouseEvent) {
        short s = 0;
        if (this.m_point.x > -1) {
            s = (short)(mouseEvent.getX() - this.m_point.x);
        }
        return s;
    }

    protected short getRelativeY(MouseEvent mouseEvent) {
        short s = 0;
        if (this.m_point.y > -1) {
            s = (short)(mouseEvent.getY() - this.m_point.y);
        }
        return s;
    }

    protected void cleanupMouseMessage() {
        this.m_canSendMouseMessages = true;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.m_canSendMouseMessages) {
            MessageSender.buttonStateAtRelative(this.getRelativeX(mouseEvent), this.getRelativeY(mouseEvent), this.m_mouseButtons.mousePressed(mouseEvent));
        } else {
            this.cleanupMouseMessage();
        }
        super.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_canSendMouseMessages) {
            MessageSender.buttonStateAtRelative(this.getRelativeX(mouseEvent), this.getRelativeY(mouseEvent), this.m_mouseButtons.mouseReleased(mouseEvent));
        } else {
            this.cleanupMouseMessage();
        }
        super.mouseReleased(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.m_canSendMouseMessages) {
            MessageSender.mouseMove(this.getRelativeX(mouseEvent), this.getRelativeY(mouseEvent));
        } else {
            this.cleanupMouseMessage();
        }
        super.mouseDragged(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.m_canSendMouseMessages) {
            MessageSender.mouseMove(this.getRelativeX(mouseEvent), this.getRelativeY(mouseEvent));
        } else {
            this.cleanupMouseMessage();
        }
        super.mouseMoved(mouseEvent);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.m_canSendMouseMessages) {
            MessageSender.buttonStateAtRelative(this.getRelativeX(mouseWheelEvent), this.getRelativeY(mouseWheelEvent), this.m_mouseButtons.trackWheelMoved(mouseWheelEvent));
        } else {
            this.cleanupMouseMessage();
        }
        super.mouseWheelMoved(mouseWheelEvent);
    }

    public void centerMouse() {
        this.cleanupMouseMessage();
    }

    public byte getId() {
        return 2;
    }
}

