/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.mouse;

import com.serverengines.kvm.LogWriter;
import com.serverengines.mahogany.MessageSender;
import com.serverengines.mouse.MouseAbsoluteDelegate;
import com.serverengines.mouse.MouseButtons;
import com.serverengines.mouse.MouseDelegate;
import com.serverengines.mouse.MouseHideDelegate;
import com.serverengines.mouse.MouseRelativeDelegate;
import com.serverengines.resmgr.SettingsResMgr;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public final class MouseMgr {
    public static final byte HIDE_MOUSE = 0;
    public static final byte ABSOLUTE_MOUSE = 1;
    public static final byte RELATIVE_MOUSE = 2;
    protected static MouseMgr s_mouseMgr = null;
    protected static LogWriter s_log = new LogWriter((class$com$serverengines$mouse$MouseMgr == null ? (class$com$serverengines$mouse$MouseMgr = MouseMgr.class$("com.serverengines.mouse.MouseMgr")) : class$com$serverengines$mouse$MouseMgr).getName());
    protected Point m_point;
    protected MouseButtons m_mouseButtons;
    protected MouseRelativeDelegate m_relativeDelegate;
    protected MouseAbsoluteDelegate m_absoluteDelegate;
    protected MouseHideDelegate m_hideDelegate;
    protected MouseDelegate m_currentDelegate;
    protected boolean m_allowMouseSynchOnModeChg;
    static /* synthetic */ Class class$com$serverengines$mouse$MouseMgr;

    protected MouseMgr() {
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        this.m_point = new Point(-1, -1);
        this.m_mouseButtons = new MouseButtons();
        this.m_relativeDelegate = new MouseRelativeDelegate(this.m_point, this.m_mouseButtons);
        this.m_absoluteDelegate = new MouseAbsoluteDelegate(this.m_point, this.m_mouseButtons);
        this.m_hideDelegate = new MouseHideDelegate(this.m_point, this.m_mouseButtons, this.m_relativeDelegate);
        int n = settingsResMgr.getResourceInt("mouse.mode");
        switch (n) {
            case 0: {
                this.useHideMode();
                break;
            }
            case 1: {
                this.useAbsoluteMode();
                break;
            }
            default: {
                this.useRelativeMode();
            }
        }
        this.m_allowMouseSynchOnModeChg = settingsResMgr.getResourceInt("synch.mouse.mode.chg") != 0;
    }

    public static synchronized MouseMgr getInstance() {
        if (s_mouseMgr == null) {
            s_mouseMgr = new MouseMgr();
        }
        return s_mouseMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle() {
        Class clazz = class$com$serverengines$mouse$MouseMgr == null ? (class$com$serverengines$mouse$MouseMgr = MouseMgr.class$("com.serverengines.mouse.MouseMgr")) : class$com$serverengines$mouse$MouseMgr;
        synchronized (clazz) {
            s_mouseMgr = null;
        }
    }

    public void sendMouseState() {
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        int n = settingsResMgr.getResourceInt("mouse.mode");
        boolean bl = n == 2 || n == 0;
        boolean bl2 = n == 0;
        boolean bl3 = n == 1;
        MessageSender.clientAbsoluteMode(bl3);
        MessageSender.clientRelativeMode(bl, bl2);
    }

    public void useHideMode() {
        this.m_currentDelegate = this.m_hideDelegate;
        this.centerMouse();
    }

    public void useRelativeMode() {
        this.m_currentDelegate = this.m_relativeDelegate;
    }

    public void useAbsoluteMode() {
        this.m_currentDelegate = this.m_absoluteDelegate;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_currentDelegate.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.m_currentDelegate.mouseReleased(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.m_currentDelegate.mouseDragged(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.m_currentDelegate.mouseMoved(mouseEvent);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.m_currentDelegate.mouseWheelMoved(mouseWheelEvent);
    }

    public byte getId() {
        return this.m_currentDelegate.getId();
    }

    public Point getLocation() {
        return this.m_point;
    }

    public void centerMouse() {
        this.m_currentDelegate.centerMouse();
    }

    public MouseButtons getMouseButtons() {
        return this.m_mouseButtons;
    }

    public void setLocation(int n, int n2) {
        block2: {
            try {
                this.m_point.setLocation(n, n2);
            }
            catch (Exception exception) {
                if (!s_log.isErrorLoggingEnabled()) break block2;
                s_log.error(exception);
            }
        }
    }

    public boolean isAllowMouseSynchOnModeChg() {
        return this.m_allowMouseSynchOnModeChg;
    }

    public void setAllowMouseSynchOnModeChg(boolean bl) {
        this.m_allowMouseSynchOnModeChg = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

