/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.mahoganyprotocol;

import com.serverengines.buffer.BufferMgr;
import com.serverengines.helper.ArrayListStringBufferPool;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.mahoganyprotocol.MahoganyProtocol;
import com.serverengines.resmgr.ResourceMgr;
import java.util.ArrayList;

public class ServerHandshake
extends MahoganyProtocol {
    public static final int MAHOGANY_VERSION_BUF_SZ = 32;
    public static final int NOT_FOUND = -1;
    public static final char SEPERATOR_CHAR = ' ';
    public static final char KEYBOARD_PRIVILEGE = 'k';
    public static final char VIDEO_PRIVILEGE = 'v';
    public static final char MOUSE_PRIVILEGE = 'm';
    public static final char STORAGE_PRIVILEGE = 's';
    protected static ServerHandshake s_protocol = null;
    protected String m_data;
    protected boolean m_isKeyboardEnabled = false;
    protected boolean m_isVideoEnabled = false;
    protected boolean m_isMouseEnabled = false;
    protected boolean m_isStorageEnabled = false;
    static /* synthetic */ Class class$com$serverengines$mahoganyprotocol$ServerHandshake;

    protected ServerHandshake() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerHandshake getInstance() {
        Class clazz = class$com$serverengines$mahoganyprotocol$ServerHandshake == null ? (class$com$serverengines$mahoganyprotocol$ServerHandshake = ServerHandshake.class$("com.serverengines.mahoganyprotocol.ServerHandshake")) : class$com$serverengines$mahoganyprotocol$ServerHandshake;
        synchronized (clazz) {
            if (s_protocol == null) {
                s_protocol = new ServerHandshake();
            }
            ServerHandshake.s_protocol.m_data = "";
            return s_protocol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Class clazz = class$com$serverengines$mahoganyprotocol$ServerHandshake == null ? (class$com$serverengines$mahoganyprotocol$ServerHandshake = ServerHandshake.class$("com.serverengines.mahoganyprotocol.ServerHandshake")) : class$com$serverengines$mahoganyprotocol$ServerHandshake;
        synchronized (clazz) {
            this.m_data = null;
        }
    }

    public void readBuffer(BufferMgr bufferMgr) {
        byte[] byArray = new byte[32];
        bufferMgr.readBytes(byArray, byArray.length);
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        char c = '\u0000';
        for (int i = 0; i < byArray.length; ++i) {
            c = (char)(byArray[i] & 0xFF);
            if (Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(' ');
        }
        this.m_data = stringBuffer.toString().trim();
        StringBufferPool.recycle(stringBuffer);
        this.parseHandshake();
    }

    protected void parseHandshake() {
        int n = this.m_data.indexOf(32);
        if (n != -1) {
            String string = this.m_data.substring(n + 1).trim().toLowerCase();
            this.m_isKeyboardEnabled = string.indexOf(107) != -1;
            this.m_isVideoEnabled = string.indexOf(118) != -1;
            this.m_isMouseEnabled = string.indexOf(109) != -1;
            this.m_isStorageEnabled = string.indexOf(115) != -1;
        }
    }

    public void writeBuffer(BufferMgr bufferMgr) {
    }

    public String toString() {
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        ArrayList arrayList = ArrayListStringBufferPool.getInstance();
        StringBuffer stringBuffer = StringBufferPool.getInstance(this.m_data);
        arrayList.add(stringBuffer);
        String string = resourceMgr.getResourceString("server.handshake", arrayList);
        StringBufferPool.recycle(stringBuffer);
        ArrayListStringBufferPool.recycle(arrayList);
        return string;
    }

    public int getId() {
        return 200;
    }

    public boolean isKeyboardEnabled() {
        return this.m_isKeyboardEnabled;
    }

    public boolean isVideoEnabled() {
        return this.m_isVideoEnabled;
    }

    public boolean isMouseEnabled() {
        return this.m_isMouseEnabled;
    }

    public boolean isStorageEnabled() {
        return this.m_isStorageEnabled;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

