/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.mahogany;

import com.serverengines.helper.ArrayListStringBufferPool;
import com.serverengines.helper.Helper;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.keyboard.KeyboardMgr;
import com.serverengines.keyboard.KeyboardWindow;
import com.serverengines.kvm.LogWriter;
import com.serverengines.mahogany.CConn;
import com.serverengines.mahogany.DesktopWindow;
import com.serverengines.mahogany.ExitThread;
import com.serverengines.mahogany.IOKDlgCallback;
import com.serverengines.mahogany.IYesNoDlgCallback;
import com.serverengines.mahogany.MessageSender;
import com.serverengines.mahogany.ModallessOKMsgDlg;
import com.serverengines.mahogany.ModallessYesNoDlg;
import com.serverengines.mahogany.MsgBox;
import com.serverengines.mouse.MouseMgr;
import com.serverengines.nativeinterface.LUD;
import com.serverengines.resmgr.ResourceMgr;
import com.serverengines.resmgr.SettingsResMgr;
import com.serverengines.storage.MountDialog;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

public class ViewportFrame
extends JFrame
implements IYesNoDlgCallback,
IOKDlgCallback,
ActionListener,
WindowListener {
    static final long serialVersionUID = 6441397371129480415L;
    protected static LogWriter vlog = new LogWriter((class$com$serverengines$mahogany$ViewportFrame == null ? (class$com$serverengines$mahogany$ViewportFrame = ViewportFrame.class$("com.serverengines.mahogany.ViewportFrame")) : class$com$serverengines$mahogany$ViewportFrame).getName());
    public static int VERTICAL_SPACING = 0;
    public static int HORIZONTAL_SPACING = 0;
    protected MountDialog m_mount_dlg;
    protected JButton m_mouseSync;
    protected JToggleButton m_mouseHideBtn;
    protected JToggleButton m_leftCtrlBtn;
    protected JToggleButton m_leftWinBtn;
    protected JToggleButton m_leftAltBtn;
    protected JToggleButton m_rightAltBtn;
    protected JToggleButton m_rightWinBtn;
    protected JToggleButton m_rightCtrlBtn;
    protected JToggleButton m_contextBtn;
    protected JToggleButton m_lockBtn;
    protected JButton m_ctrlAltDelBtn;
    protected JLabel m_mouseTrapEscapeLabel;
    protected JLabel m_lmslabel;
    protected DesktopWindow m_desktop;
    protected JMenu m_kvmsMenu;
    protected JMenuItem m_menuStorage;
    protected JMenuItem m_menuVirtualKeyboard;
    protected JMenuItem m_menuTakeFullControl;
    protected JMenuItem m_menuDisconnectSession;
    protected JMenuItem m_relinquishFullControl;
    protected JMenuItem m_enabledTurnScreenOn;
    protected JMenuItem m_enabledTurnScreenOff;
    protected JMenuItem m_menuExit;
    protected JMenuItem m_menuPreferences;
    protected JMenuItem m_menuPerformance;
    protected JMenuItem m_menuHelpAbout;
    protected KeyboardWindow m_keyboardWin;
    protected HashMap m_btnMap;
    protected ModallessYesNoDlg m_conformFullControlDlg;
    protected ModallessYesNoDlg m_conformRelinquishDlg;
    protected ModallessOKMsgDlg m_msgDlg;
    protected CConn cc;
    protected JPanel m_button_panel;
    protected JMenuBar m_mb;
    protected boolean m_leftShiftBtn;
    protected boolean m_rightShiftBtn;
    JScrollPane sp;
    static /* synthetic */ Class class$com$serverengines$mahogany$ViewportFrame;

    public ViewportFrame(String string, CConn cConn) {
        super(string);
        String string2;
        this.cc = cConn;
        this.m_keyboardWin = null;
        this.m_conformFullControlDlg = null;
        this.m_conformRelinquishDlg = null;
        this.m_msgDlg = null;
        this.m_leftShiftBtn = false;
        this.m_rightShiftBtn = false;
        this.m_btnMap = new HashMap();
        StringBuffer stringBuffer = StringBufferPool.getInstance("kvms.gif");
        this.setIconImage(Helper.getIcon(stringBuffer).getImage());
        StringBufferPool.recycle(stringBuffer);
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        this.getContentPane().setLayout(new BorderLayout());
        this.m_button_panel = new JPanel(new FlowLayout(0));
        Insets insets = new Insets(VERTICAL_SPACING, HORIZONTAL_SPACING, HORIZONTAL_SPACING, VERTICAL_SPACING);
        this.m_mouseSync = new JButton(resourceMgr.getResourceString("main.window.mouse.sync"));
        this.m_button_panel.add(this.m_mouseSync);
        this.m_mouseSync.setMargin(insets);
        this.m_mouseSync.addActionListener(this);
        this.m_mouseHideBtn = new JToggleButton(resourceMgr.getResourceString("main.window.mouse.hide"));
        this.m_button_panel.add(this.m_mouseHideBtn);
        this.m_mouseHideBtn.setMargin(insets);
        this.m_mouseHideBtn.addActionListener(this);
        this.m_leftCtrlBtn = new JToggleButton(resourceMgr.getResourceString("main.window.left.ctl"));
        this.m_button_panel.add(this.m_leftCtrlBtn);
        this.m_btnMap.put(new Integer(224), this.m_leftCtrlBtn);
        this.m_leftCtrlBtn.setMargin(insets);
        this.m_leftCtrlBtn.addActionListener(this);
        this.m_leftWinBtn = new JToggleButton(resourceMgr.getResourceString("main.window.left.win"));
        this.m_button_panel.add(this.m_leftWinBtn);
        this.m_btnMap.put(new Integer(227), this.m_leftWinBtn);
        this.m_leftWinBtn.setMargin(insets);
        this.m_leftWinBtn.addActionListener(this);
        this.m_leftAltBtn = new JToggleButton(resourceMgr.getResourceString("main.window.left.alt"));
        this.m_button_panel.add(this.m_leftAltBtn);
        this.m_btnMap.put(new Integer(226), this.m_leftAltBtn);
        this.m_leftAltBtn.setMargin(insets);
        this.m_leftAltBtn.addActionListener(this);
        this.m_rightAltBtn = new JToggleButton(resourceMgr.getResourceString("main.window.right.alt"));
        this.m_button_panel.add(this.m_rightAltBtn);
        this.m_btnMap.put(new Integer(230), this.m_rightAltBtn);
        this.m_rightAltBtn.setMargin(insets);
        this.m_rightAltBtn.addActionListener(this);
        this.m_rightWinBtn = new JToggleButton(resourceMgr.getResourceString("main.window.right.win"));
        this.m_button_panel.add(this.m_rightWinBtn);
        this.m_btnMap.put(new Integer(231), this.m_rightWinBtn);
        this.m_rightWinBtn.setMargin(insets);
        this.m_rightWinBtn.addActionListener(this);
        this.m_rightCtrlBtn = new JToggleButton(resourceMgr.getResourceString("main.window.right.ctl"));
        this.m_button_panel.add(this.m_rightCtrlBtn);
        this.m_btnMap.put(new Integer(228), this.m_rightCtrlBtn);
        this.m_rightCtrlBtn.setMargin(insets);
        this.m_rightCtrlBtn.addActionListener(this);
        this.m_contextBtn = new JToggleButton(resourceMgr.getResourceString("main.window.context"));
        this.m_button_panel.add(this.m_contextBtn);
        this.m_btnMap.put(new Integer(101), this.m_contextBtn);
        this.m_contextBtn.setMargin(insets);
        this.m_contextBtn.addActionListener(this);
        this.m_lockBtn = new JToggleButton(resourceMgr.getResourceString("main.window.lock"));
        this.m_button_panel.add(this.m_lockBtn);
        this.m_lockBtn.setMargin(insets);
        this.m_lockBtn.addActionListener(this);
        this.m_ctrlAltDelBtn = new JButton(resourceMgr.getResourceString("main.window.ctl.alt.del"));
        this.m_button_panel.add(this.m_ctrlAltDelBtn);
        this.m_ctrlAltDelBtn.setMargin(insets);
        this.m_ctrlAltDelBtn.addActionListener(this);
        this.m_lmslabel = new JLabel();
        if (this.cc.isLocalScreenOn()) {
            this.m_lmslabel.setText(resourceMgr.getResourceString("lms.label.on"));
        } else {
            this.m_lmslabel.setText(resourceMgr.getResourceString("lms.label.off"));
        }
        this.m_button_panel.add(this.m_lmslabel);
        this.m_mouseTrapEscapeLabel = new JLabel();
        this.m_button_panel.add(this.m_mouseTrapEscapeLabel);
        this.toggleMouseEscape();
        this.getContentPane().add("North", this.m_button_panel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.sp = new JScrollPane(20, 30);
        gridBagLayout.setConstraints(this.sp, gridBagConstraints);
        jPanel.add(this.sp);
        this.getContentPane().add("Center", jPanel);
        this.m_mb = new JMenuBar();
        if (this.cc.isAlt0Text()) {
            this.setTitle(resourceMgr.getResourceString("alt.0.main.window.title"));
            string2 = resourceMgr.getResourceString("alt.0.menu.kvms");
        } else {
            string2 = resourceMgr.getResourceString("menu.kvms");
        }
        this.m_kvmsMenu = new JMenu(string2);
        this.m_kvmsMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        string2 = this.cc.isAlt0Text() ? resourceMgr.getResourceString("alt.0.menu.kvms.storage") : resourceMgr.getResourceString("menu.kvms.storage");
        this.m_menuStorage = new JMenuItem(string2);
        this.m_kvmsMenu.add(this.m_menuStorage);
        this.m_menuStorage.addActionListener(this);
        this.m_menuVirtualKeyboard = new JMenuItem(resourceMgr.getResourceString("menu.kvms.keyboard"));
        this.m_menuVirtualKeyboard.setEnabled(this.cc.isKeyboardEnabled());
        this.m_kvmsMenu.add(this.m_menuVirtualKeyboard);
        this.m_menuVirtualKeyboard.addActionListener(this);
        this.m_kvmsMenu.addSeparator();
        this.m_enabledTurnScreenOn = new JMenuItem(resourceMgr.getResourceString("menu.kvms.lms.turn.on"));
        this.m_kvmsMenu.add(this.m_enabledTurnScreenOn);
        this.m_enabledTurnScreenOn.setEnabled(false);
        this.m_enabledTurnScreenOn.addActionListener(this);
        this.m_enabledTurnScreenOff = new JMenuItem(resourceMgr.getResourceString("menu.kvms.lms.turn.off"));
        this.m_kvmsMenu.add(this.m_enabledTurnScreenOff);
        this.m_enabledTurnScreenOff.setEnabled(false);
        this.m_enabledTurnScreenOff.addActionListener(this);
        this.m_kvmsMenu.addSeparator();
        this.m_menuTakeFullControl = new JMenuItem(resourceMgr.getResourceString("menu.mahogany.take.full.control"));
        this.m_kvmsMenu.add(this.m_menuTakeFullControl);
        this.m_menuTakeFullControl.setEnabled(false);
        this.m_menuTakeFullControl.addActionListener(this);
        this.m_menuDisconnectSession = new JMenuItem(resourceMgr.getResourceString("menu.mahogany.disconnect.session"));
        this.m_kvmsMenu.add(this.m_menuDisconnectSession);
        this.m_menuDisconnectSession.setEnabled(false);
        this.m_menuDisconnectSession.addActionListener(this);
        this.m_relinquishFullControl = new JMenuItem(resourceMgr.getResourceString("menu.mahogany.relinquish.full.control"));
        this.m_kvmsMenu.add(this.m_relinquishFullControl);
        this.m_relinquishFullControl.setEnabled(false);
        this.m_relinquishFullControl.addActionListener(this);
        this.m_kvmsMenu.addSeparator();
        this.m_menuExit = new JMenuItem(resourceMgr.getResourceString("menu.kvms.exit"));
        this.m_kvmsMenu.add(this.m_menuExit);
        this.m_menuExit.addActionListener(this);
        this.m_mb.add(this.m_kvmsMenu);
        JMenu jMenu = new JMenu(resourceMgr.getResourceString("menu.preferences"));
        jMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.m_menuPreferences = new JMenuItem(resourceMgr.getResourceString("menu.preferencs.preferences"));
        jMenu.add(this.m_menuPreferences);
        this.m_menuPreferences.addActionListener(this);
        this.m_mb.add(jMenu);
        jMenu = new JMenu(resourceMgr.getResourceString("menu.help"));
        jMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.m_menuPerformance = new JMenuItem(resourceMgr.getResourceString("menu.help.performance"));
        jMenu.add(this.m_menuPerformance);
        this.m_menuPerformance.addActionListener(this);
        this.m_mb.add(jMenu);
        this.m_menuHelpAbout = new JMenuItem(resourceMgr.getResourceString("about.btn"));
        jMenu.add(this.m_menuHelpAbout);
        this.m_menuHelpAbout.addActionListener(this);
        this.m_mb.add(jMenu);
        this.toggleGUI();
        this.setJMenuBar(this.m_mb);
        this.addWindowListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(121, 0);
        AbstractAction abstractAction = new AbstractAction(){
            static final long serialVersionUID = -6803159439231523484L;

            public void actionPerformed(ActionEvent actionEvent) {
                ViewportFrame.this.onF10();
            }
        };
        this.getRootPane().getInputMap(1).put(keyStroke, "F10");
        this.getRootPane().getActionMap().put("F10", abstractAction);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.m_mouseSync)) {
            this.onMouseSync();
        } else if (object.equals(this.m_mouseHideBtn)) {
            this.onMouseHide();
        } else if (object.equals(this.m_leftCtrlBtn)) {
            this.onLeftControl();
        } else if (object.equals(this.m_leftWinBtn)) {
            this.onLeftWin();
        } else if (object.equals(this.m_leftAltBtn)) {
            this.onLeftAlt();
        } else if (object.equals(this.m_rightAltBtn)) {
            this.onRightAlt();
        } else if (object.equals(this.m_rightWinBtn)) {
            this.onRightWin();
        } else if (object.equals(this.m_rightCtrlBtn)) {
            this.onRightControl();
        } else if (object.equals(this.m_contextBtn)) {
            this.onContext();
        } else if (object.equals(this.m_lockBtn)) {
            this.onLock();
        } else if (object.equals(this.m_ctrlAltDelBtn)) {
            this.onCtrlAltDel();
        } else if (object.equals(this.m_menuStorage)) {
            this.onStorage();
        } else if (object.equals(this.m_menuVirtualKeyboard)) {
            this.onKeyboard();
        } else if (object.equals(this.m_menuPerformance)) {
            this.onPerformance();
        } else if (object.equals(this.m_enabledTurnScreenOn)) {
            this.onTurnLMSon();
        } else if (object.equals(this.m_enabledTurnScreenOff)) {
            this.onTurnLMSoff();
        } else if (object.equals(this.m_menuTakeFullControl)) {
            this.onTakeFullControl();
        } else if (object.equals(this.m_menuDisconnectSession)) {
            this.onDisconnectSession();
        } else if (object.equals(this.m_relinquishFullControl)) {
            this.onRelinquishFullControl();
        } else if (object.equals(this.m_menuExit)) {
            this.onClose();
        } else if (object.equals(this.m_menuPreferences)) {
            this.onOptions();
        } else if (object.equals(this.m_menuHelpAbout)) {
            this.onAbout();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.onClose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void endDialog() {
        this.setVisible(false);
    }

    public int getStartWidth() {
        return this.getInsets().left + this.sp.getInsets().left + this.m_desktop.getInsets().left;
    }

    public int getStartHeight() {
        int n = this.getInsets().top + this.m_mb.getHeight() + this.m_mb.getInsets().top + this.m_mb.getInsets().bottom + this.m_button_panel.getHeight() + this.m_button_panel.getInsets().top + this.m_button_panel.getInsets().bottom + this.sp.getInsets().top + this.m_desktop.getInsets().top;
        Integer n2 = (Integer)Helper.getToolkit().getDesktopProperty("win.frame.captionHeight");
        if (n2 != null) {
            n += n2.intValue();
        }
        return n;
    }

    protected void enableStorage() {
        if (this.cc.isStorageEnabled() && this.cc.isStorageWorking()) {
            if (this.cc.isExeStorageSupported() || LUD.isLoaded()) {
                if (this.m_mount_dlg == null) {
                    this.m_mount_dlg = new MountDialog(this);
                }
            } else {
                this.m_mount_dlg = null;
            }
        }
    }

    public void discoverDevices(boolean bl) {
        if (this.m_mount_dlg != null) {
            this.m_mount_dlg.discoverDevices(bl);
        }
    }

    public void toggleGUI() {
        boolean bl = this.cc.hasFullControl();
        boolean bl2 = this.cc.isKeyboardEnabled();
        boolean bl3 = this.cc.isMouseEnabled();
        boolean bl4 = this.cc.isLocalScreenOn();
        this.m_leftCtrlBtn.setEnabled(bl && bl2);
        this.m_leftWinBtn.setEnabled(bl && bl2);
        this.m_leftAltBtn.setEnabled(bl && bl2);
        this.m_rightAltBtn.setEnabled(bl && bl2);
        this.m_rightWinBtn.setEnabled(bl && bl2);
        this.m_rightCtrlBtn.setEnabled(bl && bl2);
        this.m_contextBtn.setEnabled(bl && bl2);
        this.m_lockBtn.setEnabled(bl && bl2);
        this.m_ctrlAltDelBtn.setEnabled(bl && bl2);
        this.m_mouseSync.setEnabled(bl && bl3);
        this.m_mouseHideBtn.setEnabled(bl && bl3);
        this.m_menuVirtualKeyboard.setEnabled(bl && bl2);
        this.setEnabledTakeControl(!bl && this.cc.canTakeFullControl());
        this.setEnabledRelinquishFullControl(bl && this.cc.canRelinquishFullControl());
        this.setEnabledTurnScreenOff(bl && this.cc.canTurnScreenOff() && bl4);
        this.setEnabledTurnScreenOn(bl && this.cc.canTurnScreenOn() && !bl4);
        this.setEnabledDisconnetSessions(bl && this.cc.canDisconnectOthers());
        this.setEnabledStorage(bl && this.cc.isStorageEnabled() && this.cc.isStorageWorking());
        this.enableStorage();
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        if (this.cc.isLocalScreenOn()) {
            this.m_lmslabel.setText(resourceMgr.getResourceString("lms.label.on"));
        } else {
            this.m_lmslabel.setText(resourceMgr.getResourceString("lms.label.off"));
        }
    }

    public void toggleMouseEscape() {
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        if (this.m_desktop != null) {
            this.m_desktop.requestFocus();
            this.m_desktop.toggleMouse();
        }
        if (settingsResMgr.getResourceInt("mouse.mode") == 0) {
            ResourceMgr resourceMgr = ResourceMgr.getInstance();
            this.m_mouseTrapEscapeLabel.setText(resourceMgr.getResourceString("main.window.mouse.escape"));
        } else {
            this.m_mouseTrapEscapeLabel.setText("");
        }
        this.m_mouseHideBtn.setSelected(settingsResMgr.getResourceInt("mouse.mode") == 0);
    }

    public MountDialog getMountDialog() {
        return this.m_mount_dlg;
    }

    public void clearAllSpecialKeys() {
        this.m_lockBtn.setSelected(false);
        if (this.m_leftShiftBtn) {
            this.m_leftShiftBtn = false;
            this.cc.writeKeyEvent(225, this.m_leftShiftBtn);
        }
        if (this.m_rightShiftBtn) {
            this.m_rightShiftBtn = false;
            this.cc.writeKeyEvent(229, this.m_rightShiftBtn);
        }
        this.clearSpecialKeys();
    }

    protected void onF10() {
        this.cc.writeKeyEvent(67, true);
        this.cc.writeKeyEvent(67, false);
    }

    protected void onClose() {
        this.m_desktop.requestFocus();
        if (this.m_keyboardWin != null) {
            this.m_keyboardWin.onOK();
            this.m_keyboardWin = null;
        }
        this.clearAllSpecialKeys();
        this.cc.setExitProperly(true);
        this.cc.setReasonForExiting(0);
        new ExitThread(this.cc);
    }

    protected void onStorage() {
        this.cc.beginStorageDlgUpdate();
    }

    public void setStorageDlgVisible() {
        if (this.m_mount_dlg != null) {
            this.m_mount_dlg.setVisible(true);
        }
    }

    protected void onKeyboard() {
        if (this.m_keyboardWin == null) {
            this.m_keyboardWin = new KeyboardWindow((Frame)this, this.m_desktop);
            this.m_keyboardWin.setVisible(true);
        } else {
            this.m_keyboardWin.requestFocus();
        }
    }

    protected void onRefresh() {
        this.m_desktop.refresh();
    }

    protected void onTakeFullControl() {
        this.cc.onTakeFullControl();
    }

    protected void onDisconnectSession() {
        this.cc.onDisconnectSession();
    }

    protected void onRelinquishFullControl() {
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        if (this.m_conformRelinquishDlg == null) {
            this.m_conformRelinquishDlg = MsgBox.showModallessYesNoDlg(this, resourceMgr.getResourceString("server.dlg.confirm.relinquish.full.control"), (IYesNoDlgCallback)this);
            this.m_conformRelinquishDlg.setVisible(true);
        } else {
            this.m_conformRelinquishDlg.requestFocus();
        }
    }

    protected void onPerformance() {
        this.cc.showPerformanceDialog(this);
    }

    protected void onAbout() {
        this.cc.showAbout(this);
    }

    protected void onOptions() {
        this.cc.showPreferencesDialog(this);
    }

    protected void onButtonAction(int n, boolean bl) {
        this.m_desktop.requestFocus();
        this.cc.writeKeyEvent(n, bl);
    }

    protected void onLeftControl() {
        this.onButtonAction(224, this.m_leftCtrlBtn.isSelected());
    }

    protected void onRightControl() {
        this.onButtonAction(228, this.m_rightCtrlBtn.isSelected());
    }

    protected void onLeftWin() {
        this.onButtonAction(227, this.m_leftWinBtn.isSelected());
    }

    protected void onRightWin() {
        this.onButtonAction(231, this.m_rightWinBtn.isSelected());
    }

    protected void onLeftAlt() {
        this.onButtonAction(226, this.m_leftAltBtn.isSelected());
    }

    protected void onRightAlt() {
        this.onButtonAction(230, this.m_rightAltBtn.isSelected());
    }

    protected void onContext() {
        this.onButtonAction(101, this.m_contextBtn.isSelected());
    }

    protected void onLock() {
        this.m_desktop.requestFocus();
    }

    protected void onCtrlAltDel() {
        this.m_desktop.requestFocus();
        this.cc.writeKeyEvent(224, true);
        this.cc.writeKeyEvent(226, true);
        this.cc.writeKeyEvent(76, true);
        this.cc.writeKeyEvent(76, false);
        this.cc.writeKeyEvent(226, false);
        this.cc.writeKeyEvent(224, false);
    }

    public void onMouseSync() {
        this.m_desktop.requestFocus();
        MouseMgr mouseMgr = MouseMgr.getInstance();
        mouseMgr.setLocation(0, 0);
        this.m_desktop.synchMouse(0, 0);
    }

    protected void onMouseHide() {
        MouseMgr mouseMgr = MouseMgr.getInstance();
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        if (this.m_mouseHideBtn.isSelected()) {
            mouseMgr.useHideMode();
        } else {
            mouseMgr.useRelativeMode();
        }
        byte by = mouseMgr.getId();
        settingsResMgr.setResourceValue("mouse.mode", (int)by);
        this.cc.toggleMouseEscape();
        this.cc.synchMouse();
    }

    public void clearSpecialKeys() {
        if (!this.m_lockBtn.isSelected()) {
            Iterator iterator = this.m_btnMap.keySet().iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                JToggleButton jToggleButton = (JToggleButton)this.m_btnMap.get(n);
                if (!jToggleButton.isSelected()) continue;
                jToggleButton.setSelected(false);
                this.cc.writeKeyEvent(n, jToggleButton.isSelected());
            }
        }
    }

    public void setSpecialKey(int n, boolean bl) {
        JToggleButton jToggleButton = (JToggleButton)this.m_btnMap.get(new Integer(n));
        if (jToggleButton != null) {
            jToggleButton.setSelected(bl);
        } else if (n == 225) {
            this.m_leftShiftBtn = bl;
        } else if (n == 229) {
            this.m_rightShiftBtn = bl;
        }
    }

    public void addChild(DesktopWindow desktopWindow) {
        this.m_desktop = desktopWindow;
        this.sp.setViewportView(this.m_desktop);
    }

    public void setGeometry(int n, int n2, int n3, int n4) {
        this.setSize(n3, n4);
        this.setLocation(n, n2);
    }

    public void changeKeyboardLayout() {
        if (this.m_keyboardWin != null) {
            this.m_keyboardWin.changeLayout();
        }
    }

    public void closeKeyboardWindow() {
        this.m_keyboardWin = null;
    }

    public void informKeyIndicators(boolean bl, boolean bl2, boolean bl3) {
    }

    public void onOfferFullControl() {
        if (!this.cc.hasFullControl()) {
            if (this.m_conformFullControlDlg == null) {
                ResourceMgr resourceMgr = ResourceMgr.getInstance();
                this.m_conformFullControlDlg = MsgBox.showModallessYesNoDlg(this, resourceMgr.getResourceString("server.dlg.inform.full.control"), (IYesNoDlgCallback)this);
                this.m_conformFullControlDlg.setVisible(true);
            } else {
                this.m_conformFullControlDlg.requestFocus();
            }
        }
    }

    public void onTurnLMSon() {
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        keyboardMgr.getCConn().setLocalScreenon(true);
        MessageSender.sendTurnLMSon();
        this.toggleGUI();
    }

    public void onTurnLMSoff() {
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        keyboardMgr.getCConn().setLocalScreenon(false);
        MessageSender.sendTurnLMSoff();
        this.toggleGUI();
    }

    public void setEnabledStorage(boolean bl) {
        if (this.m_menuStorage != null) {
            this.m_menuStorage.setEnabled(bl);
        }
    }

    public void setEnabledTurnScreenOn(boolean bl) {
        this.m_enabledTurnScreenOn.setEnabled(bl);
    }

    public void setEnabledTurnScreenOff(boolean bl) {
        this.m_enabledTurnScreenOff.setEnabled(bl);
    }

    public void setEnabledTakeControl(boolean bl) {
        this.m_menuTakeFullControl.setEnabled(bl);
    }

    public void setEnabledDisconnetSessions(boolean bl) {
        this.m_menuDisconnectSession.setEnabled(bl);
    }

    public void setEnabledRelinquishFullControl(boolean bl) {
        this.m_relinquishFullControl.setEnabled(bl);
    }

    public void yesNoCallback(ModallessYesNoDlg modallessYesNoDlg, boolean bl) {
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        if (modallessYesNoDlg.equals(this.m_conformFullControlDlg)) {
            if (!bl) {
                if (this.m_msgDlg == null) {
                    this.m_msgDlg = MsgBox.showModallessMsgDlg(this, resourceMgr.getResourceString("server.dlg.remaining.in.secondary.control"), (IOKDlgCallback)this);
                    this.m_msgDlg.setVisible(true);
                } else {
                    this.m_msgDlg.setMessage(resourceMgr.getResourceString("server.dlg.remaining.in.secondary.control"));
                    this.m_msgDlg.requestFocus();
                }
            }
            this.m_conformFullControlDlg = null;
        } else if (modallessYesNoDlg.equals(this.m_conformRelinquishDlg)) {
            if (bl) {
                this.cc.onRelinquishFullControl();
            }
            this.m_conformRelinquishDlg = null;
        }
    }

    public void okCallback(ModallessOKMsgDlg modallessOKMsgDlg) {
        if (modallessOKMsgDlg.equals(this.m_msgDlg)) {
            this.m_msgDlg = null;
        }
    }

    public void setUserNameInTitle(String string, String string2, int n, boolean bl) {
        StringBuffer stringBuffer;
        String string3;
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        StringBuffer stringBuffer2 = StringBufferPool.getInstance("user.state.");
        stringBuffer2.append(n);
        ArrayList arrayList = ArrayListStringBufferPool.getInstance();
        StringBuffer stringBuffer3 = StringBufferPool.getInstance(string);
        arrayList.add(stringBuffer3);
        StringBuffer stringBuffer4 = StringBufferPool.getInstance(string2);
        arrayList.add(stringBuffer4);
        if (this.cc.desktop.isStorageOnly()) {
            string3 = this.cc.isAlt0Text() ? "alt.0.main.window.storage.only" : "main.window.storage.only";
            stringBuffer = StringBufferPool.getInstance(resourceMgr.getResourceString(string3));
        } else {
            stringBuffer = StringBufferPool.getInstance(resourceMgr.getResourceString(stringBuffer2.toString()));
        }
        arrayList.add(stringBuffer);
        StringBuffer stringBuffer5 = bl ? StringBufferPool.getInstance(resourceMgr.getResourceString("main.window.encyption")) : StringBufferPool.getInstance(resourceMgr.getResourceString("main.window.no.encyption"));
        arrayList.add(stringBuffer5);
        if (this.cc.isStandbyPower()) {
            if (this.cc.isAlt0Text()) {
                string3 = resourceMgr.getResourceString("alt.0.main.window.title.standby.with.user.name", arrayList);
                this.m_kvmsMenu.setText(resourceMgr.getResourceString("alt.0.menu.kvms"));
                this.m_menuStorage.setText(resourceMgr.getResourceString("alt.0.menu.kvms.storage"));
            } else {
                string3 = resourceMgr.getResourceString("main.window.title.standby.with.user.name", arrayList);
            }
        } else if (this.cc.isAlt0Text()) {
            string3 = resourceMgr.getResourceString("alt.0.main.window.title.with.user.name", arrayList);
            this.m_kvmsMenu.setText(resourceMgr.getResourceString("alt.0.menu.kvms"));
            this.m_menuStorage.setText(resourceMgr.getResourceString("alt.0.menu.kvms.storage"));
        } else {
            string3 = resourceMgr.getResourceString("main.window.title.with.user.name", arrayList);
        }
        this.setTitle(string3);
        StringBufferPool.recycle(stringBuffer5);
        StringBufferPool.recycle(stringBuffer);
        StringBufferPool.recycle(stringBuffer4);
        StringBufferPool.recycle(stringBuffer3);
        StringBufferPool.recycle(stringBuffer2);
        ArrayListStringBufferPool.recycle(arrayList);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

