/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.mahogany;

import com.serverengines.graphics.GraphicsMgr;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.keyboard.KeyboardMgr;
import com.serverengines.kvm.LogWriter;
import com.serverengines.mahogany.BaseDialog;
import com.serverengines.mahogany.CConn;
import com.serverengines.mahogany.IOKDlgCallback;
import com.serverengines.mahogany.MessageSender;
import com.serverengines.mahogany.ModallessOKMsgDlg;
import com.serverengines.mahogany.MsgBox;
import com.serverengines.mouse.MouseMgr;
import com.serverengines.resmgr.AppResMgr;
import com.serverengines.resmgr.ResourceMgr;
import com.serverengines.resmgr.SettingsResMgr;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class SettingsDialog
extends BaseDialog
implements IOKDlgCallback,
ActionListener {
    static final long serialVersionUID = -3790270072148551689L;
    public static final int NONSECURE_CONNECTION = 0;
    public static final int SECURE_CONNECTION = 1;
    protected CConn m_cconn;
    protected JTabbedPane m_tabs;
    protected JComboBox m_mouseChoice;
    protected JComboBox m_languageChoice;
    protected JComboBox m_loggingChoice;
    protected JLabel m_logLabel;
    protected JTextField m_logFileText;
    protected JButton m_logFileBrowseBtn;
    protected JCheckBox m_allowTimeoutCountdownChkBx;
    protected JCheckBox m_hLevelCompressionEnabled;
    protected JLabel m_timeoutLabel;
    protected JTextField m_timeoutText;
    protected JCheckBox m_allowMouseSynchOnModeChange;
    protected JTextField m_graphicsTextField;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected ModallessOKMsgDlg m_msgDlg;

    public SettingsDialog(Dialog dialog, CConn cConn) {
        super(dialog, ResourceMgr.getInstance().getResourceString("options.dlg.titile"), false);
        this._SettingsDialog(cConn);
    }

    public SettingsDialog(Frame frame, CConn cConn) {
        super(frame, ResourceMgr.getInstance().getResourceString("options.dlg.titile"), false);
        this._SettingsDialog(cConn);
    }

    protected void _SettingsDialog(CConn cConn) {
        this.m_cconn = cConn;
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        this.m_msgDlg = null;
        this.m_tabs = new JTabbedPane();
        int n = 0;
        JPanel jPanel = this.initMousePanel();
        this.m_tabs.addTab(resourceMgr.getResourceString("options.dlg.mouse.tab"), jPanel);
        this.m_tabs.setMnemonicAt(n, 77);
        jPanel = this.initLanguagePanel();
        this.m_tabs.addTab(resourceMgr.getResourceString("options.dlg.language.tab"), jPanel);
        this.m_tabs.setMnemonicAt(++n, 65);
        jPanel = this.initLogPanel();
        this.m_tabs.addTab(resourceMgr.getResourceString("options.dlg.logging.tab"), jPanel);
        this.m_tabs.setMnemonicAt(++n, 76);
        ++n;
        this.getContentPane().add("Center", this.m_tabs);
        jPanel = new JPanel(new FlowLayout(1, 20, 5));
        this.m_okBtn = new JButton(resourceMgr.getResourceString("ok.btn"));
        this.m_okBtn.setMnemonic(resourceMgr.getResourceChar("ok.btn.mnemonic"));
        this.getRootPane().setDefaultButton(this.m_okBtn);
        this.m_okBtn.addActionListener(this);
        jPanel.add(this.m_okBtn);
        this.m_cancelBtn = new JButton(resourceMgr.getResourceString("cancel.btn"));
        this.m_cancelBtn.setMnemonic(resourceMgr.getResourceChar("cancel.btn.mnemonic"));
        this.m_cancelBtn.addActionListener(this);
        jPanel.add(this.m_cancelBtn);
        this.getContentPane().add("South", jPanel);
        this.setResizable(true);
        this.pack();
        this.initPosiiton();
    }

    protected JPanel initMousePanel() {
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        AppResMgr appResMgr = AppResMgr.getInstance();
        MouseMgr mouseMgr = MouseMgr.getInstance();
        byte by = mouseMgr.getId();
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(resourceMgr.getResourceString("options.dlg.mouse.mode"));
        jLabel.setDisplayedMnemonic(resourceMgr.getResourceChar("options.dlg.mouse.mnemonic"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        int n = appResMgr.getResourceInt("num.mouse.modes");
        String string = "options.dlg.mouse.mode.";
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (int i = 0; i < n; ++i) {
            defaultComboBoxModel.addElement(resourceMgr.getResourceString(string + i));
        }
        ++gridBagConstraints.gridx;
        this.m_mouseChoice = new JComboBox(defaultComboBoxModel);
        this.m_mouseChoice.setSelectedIndex(by);
        jLabel.setLabelFor(this.m_mouseChoice);
        gridBagLayout.setConstraints(this.m_mouseChoice, gridBagConstraints);
        jPanel.add(this.m_mouseChoice);
        this.m_allowMouseSynchOnModeChange = new JCheckBox(resourceMgr.getResourceString("options.dlg.mouse.synch.mode.change"), mouseMgr.isAllowMouseSynchOnModeChg());
        this.m_allowMouseSynchOnModeChange.setMnemonic(resourceMgr.getResourceChar("options.dlg.mouse.synch.mode.change.mnemonic"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.m_allowMouseSynchOnModeChange, gridBagConstraints);
        jPanel.add(this.m_allowMouseSynchOnModeChange);
        return jPanel;
    }

    protected JPanel initLanguagePanel() {
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        int n = keyboardMgr.getKeyboard().getKeyboardLayout();
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        AppResMgr appResMgr = AppResMgr.getInstance();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel(gridBagLayout);
        JLabel jLabel = new JLabel(resourceMgr.getResourceString("options.dlg.language.language"));
        jLabel.setDisplayedMnemonic(resourceMgr.getResourceChar("options.dlg.language.language.mnemonic"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        int n2 = appResMgr.getResourceInt("num.languages");
        String string = "language.";
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (int i = 0; i < n2; ++i) {
            defaultComboBoxModel.addElement(resourceMgr.getResourceString(string + i));
        }
        this.m_languageChoice = new JComboBox(defaultComboBoxModel);
        this.m_languageChoice.setSelectedIndex(n);
        jLabel.setLabelFor(this.m_languageChoice);
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.m_languageChoice, gridBagConstraints);
        jPanel.add(this.m_languageChoice);
        return jPanel;
    }

    protected void toggleTimeoutControls() {
        boolean bl = this.m_allowTimeoutCountdownChkBx.isSelected();
        this.m_timeoutLabel.setEnabled(bl);
        this.m_timeoutText.setEnabled(bl);
    }

    protected JPanel initLogPanel() {
        int n;
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        AppResMgr appResMgr = AppResMgr.getInstance();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(resourceMgr.getResourceString("options.dlg.logging.global.logging"));
        jLabel.setDisplayedMnemonic(resourceMgr.getResourceChar("options.dlg.logging.global.logging.mnemonic"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        int n2 = appResMgr.getResourceInt("num.log.options");
        for (n = 0; n < n2; ++n) {
            defaultComboBoxModel.addElement(resourceMgr.getResourceString("options.dlg.logging.opt." + n));
        }
        this.m_loggingChoice = new JComboBox(defaultComboBoxModel);
        this.m_loggingChoice.addActionListener(this);
        jLabel.setLabelFor(this.m_loggingChoice);
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.m_loggingChoice, gridBagConstraints);
        jPanel.add(this.m_loggingChoice);
        this.m_logLabel = new JLabel(resourceMgr.getResourceString("options.dlg.logging.console.logfile"));
        this.m_logLabel.setDisplayedMnemonic(resourceMgr.getResourceChar("options.dlg.logging.console.logfile.mnemonic"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(this.m_logLabel, gridBagConstraints);
        jPanel.add(this.m_logLabel);
        this.m_logFileText = new JTextField(35);
        this.m_logLabel.setLabelFor(this.m_logFileText);
        this.m_logFileText.setText(settingsResMgr.getResourceString("log.file"));
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.m_logFileText, gridBagConstraints);
        jPanel.add(this.m_logFileText);
        this.m_logFileBrowseBtn = new JButton(resourceMgr.getResourceString("browse.btn"));
        this.m_logFileBrowseBtn.setMnemonic(resourceMgr.getResourceChar("browse.btn.mnemonic"));
        this.m_logFileBrowseBtn.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.m_logFileBrowseBtn, gridBagConstraints);
        jPanel.add(this.m_logFileBrowseBtn);
        n = settingsResMgr.getResourceInt("initial.enable.msgs");
        this.m_loggingChoice.setSelectedIndex(n);
        this.toggleLogFileControls();
        this.m_allowTimeoutCountdownChkBx = null;
        this.m_timeoutLabel = null;
        this.m_timeoutText = null;
        if (this.m_cconn.allowTimeDown()) {
            this.m_allowTimeoutCountdownChkBx = new JCheckBox(resourceMgr.getResourceString("options.dlg.logging.timeout"), this.m_cconn.isTimingDown());
            this.m_allowTimeoutCountdownChkBx.setMnemonic(resourceMgr.getResourceChar("options.dlg.logging.timeout.mnemonic"));
            this.m_allowTimeoutCountdownChkBx.addActionListener(this);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.m_allowTimeoutCountdownChkBx, gridBagConstraints);
            jPanel.add(this.m_allowTimeoutCountdownChkBx);
            this.m_timeoutLabel = new JLabel(resourceMgr.getResourceString("options.dlg.logging.timeout.limit"));
            this.m_timeoutLabel.setDisplayedMnemonic(resourceMgr.getResourceChar("options.dlg.logging.timeout.limit.mnemonic"));
            ++gridBagConstraints.gridx;
            gridBagLayout.setConstraints(this.m_timeoutLabel, gridBagConstraints);
            jPanel.add(this.m_timeoutLabel);
            this.m_timeoutText = new JTextField(settingsResMgr.getResourceString("session.timeout"));
            this.m_timeoutLabel.setLabelFor(this.m_timeoutText);
            ++gridBagConstraints.gridx;
            gridBagLayout.setConstraints(this.m_timeoutText, gridBagConstraints);
            jPanel.add(this.m_timeoutText);
            this.toggleTimeoutControls();
        }
        this.m_hLevelCompressionEnabled = null;
        if (!this.m_cconn.isForcedHLevelState()) {
            this.m_hLevelCompressionEnabled = new JCheckBox(resourceMgr.getResourceString("options.dlg.logging.video.encyption.enabled"), this.m_cconn.isHLevelCompressionOn());
            this.m_hLevelCompressionEnabled.setMnemonic(resourceMgr.getResourceChar("options.dlg.logging.video.encyption.enabled.mnemonic"));
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            this.m_hLevelCompressionEnabled.setEnabled(!this.m_cconn.viewer.viewOnly.getValue());
            gridBagLayout.setConstraints(this.m_hLevelCompressionEnabled, gridBagConstraints);
            jPanel.add(this.m_hLevelCompressionEnabled);
        }
        return jPanel;
    }

    protected void onLogFileBrowse() {
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        JFileChooser jFileChooser = new JFileChooser(this.m_logFileText.getText());
        jFileChooser.setDialogTitle(resourceMgr.getResourceString("options.dlg.storage.log.browse.title"));
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.setApproveButtonText(resourceMgr.getResourceString("select.btn"));
        jFileChooser.setApproveButtonMnemonic(resourceMgr.getResourceChar("select.btn.mnemonic"));
        jFileChooser.setApproveButtonToolTipText(resourceMgr.getResourceString("options.dlg.approve.tooltip"));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            StringBuffer stringBuffer = StringBufferPool.getInstance(jFileChooser.getSelectedFile().getPath());
            File file = new File(stringBuffer.toString());
            if (file.isDirectory()) {
                MsgBox.showErrorMsgBox(this, resourceMgr.getResourceString("err.not.file"));
            } else {
                this.m_logFileText.setText(stringBuffer.toString());
            }
            StringBufferPool.recycle(stringBuffer);
        }
    }

    protected void onOK() {
        File file;
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        String string = this.m_logFileText.getText().trim();
        if ((this.m_loggingChoice.getSelectedIndex() & 2) != 0 && string.length() > 0 && (file = new File(string)).isDirectory()) {
            if (this.m_msgDlg == null) {
                this.m_msgDlg = MsgBox.showModallessMsgDlg(this, resourceMgr.getResourceString("err.not.file"), (IOKDlgCallback)this);
                this.m_msgDlg.setVisible(true);
            } else {
                this.m_msgDlg.setMessage(resourceMgr.getResourceString("err.not.file"));
                this.m_msgDlg.pack();
                this.m_msgDlg.requestFocus();
            }
            return;
        }
        MouseMgr mouseMgr = MouseMgr.getInstance();
        int n = this.m_mouseChoice.getSelectedIndex();
        if (n == 0) {
            mouseMgr.useHideMode();
        } else if (n == 1) {
            mouseMgr.useAbsoluteMode();
        } else {
            mouseMgr.useRelativeMode();
        }
        byte by = mouseMgr.getId();
        settingsResMgr.setResourceValue("mouse.mode", (int)by);
        mouseMgr.setAllowMouseSynchOnModeChg(this.m_allowMouseSynchOnModeChange.isSelected());
        int n2 = mouseMgr.isAllowMouseSynchOnModeChg() ? 1 : 0;
        settingsResMgr.setResourceValue("synch.mouse.mode.chg", n2);
        this.m_cconn.toggleMouseEscape();
        GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
        graphicsMgr.toggleMouse();
        int n3 = this.m_languageChoice.getSelectedIndex();
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        keyboardMgr.getKeyboard(n3, this.m_cconn);
        settingsResMgr.setResourceValue("default.language", n3);
        this.m_cconn.changeKeyboardLayout();
        settingsResMgr.setResourceValue("initial.enable.msgs", this.m_loggingChoice.getSelectedIndex());
        if (settingsResMgr.getResourceInt("initial.enable.msgs") == 0) {
            LogWriter.setGlobalLoggingLevel(0);
        } else {
            LogWriter.setGlobalLoggingLevel(110);
        }
        if (this.m_allowTimeoutCountdownChkBx != null) {
            boolean bl = this.m_allowTimeoutCountdownChkBx.isSelected();
            if (bl) {
                try {
                    int n4 = Integer.parseInt(this.m_timeoutText.getText());
                    if (n4 < 1) {
                        if (this.m_msgDlg == null) {
                            this.m_msgDlg = MsgBox.showModallessMsgDlg(this, resourceMgr.getResourceString("err.invalid.timeout"), (IOKDlgCallback)this);
                            this.m_msgDlg.setVisible(true);
                        } else {
                            this.m_msgDlg.setMessage(resourceMgr.getResourceString("err.invalid.timeout"));
                            this.m_msgDlg.pack();
                            this.m_msgDlg.requestFocus();
                        }
                        this.m_timeoutText.requestFocus();
                        return;
                    }
                    settingsResMgr.setResourceValue("session.timeout", n4);
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.m_msgDlg == null) {
                        this.m_msgDlg = MsgBox.showModallessMsgDlg(this, resourceMgr.getResourceString("err.invalid.timeout"), (IOKDlgCallback)this);
                        this.m_msgDlg.setVisible(true);
                    } else {
                        this.m_msgDlg.setMessage(resourceMgr.getResourceString("err.invalid.timeout"));
                        this.m_msgDlg.pack();
                        this.m_msgDlg.requestFocus();
                    }
                    this.m_timeoutText.requestFocus();
                    return;
                }
            }
            this.m_cconn.setTimingDown(bl);
            this.m_cconn.onTimeoutThread();
        }
        if (this.m_hLevelCompressionEnabled != null) {
            this.m_cconn.setHLevelCompressionOn(this.m_hLevelCompressionEnabled.isSelected());
            MessageSender.informHLevelCompressionOn(this.m_cconn.isHLevelCompressionOn());
        }
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        if ((settingsResMgr.getResourceInt("initial.enable.msgs") & 2) != 0) {
            stringBuffer.append(string);
            settingsResMgr.setResourceValue("log.file", stringBuffer);
            stringBuffer.setLength(0);
        }
        LogWriter.configureLogging();
        StringBufferPool.recycle(stringBuffer);
        settingsResMgr.writeResource();
        super.onOK();
    }

    public void endDialog() {
        if (this.m_msgDlg != null) {
            this.m_msgDlg.dispose();
        }
        this.m_cconn.onPreferencesComplete();
        super.endDialog();
    }

    protected void toggleLogFileControls() {
        boolean bl = (this.m_loggingChoice.getSelectedIndex() & 2) != 0;
        this.m_logLabel.setEnabled(bl);
        this.m_logFileText.setEnabled(bl);
        this.m_logFileBrowseBtn.setEnabled(bl);
    }

    protected void onLoggingCBChange() {
        this.toggleLogFileControls();
    }

    public void okCallback(ModallessOKMsgDlg modallessOKMsgDlg) {
        if (modallessOKMsgDlg.equals(this.m_msgDlg)) {
            this.m_msgDlg = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.m_okBtn)) {
            this.onOK();
        } else if (object.equals(this.m_cancelBtn)) {
            this.onCancel();
        } else if (object.equals(this.m_loggingChoice)) {
            this.onLoggingCBChange();
        } else if (object.equals(this.m_logFileBrowseBtn)) {
            this.onLogFileBrowse();
        } else if (object.equals(this.m_allowTimeoutCountdownChkBx)) {
            this.toggleTimeoutControls();
        }
    }
}

