/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.mahogany;

import com.serverengines.helper.StringBufferPool;
import com.serverengines.keyboard.KeyboardMgr;
import com.serverengines.mahogany.BaseDialog;
import com.serverengines.mahogany.CConn;
import com.serverengines.mahogany.MsgBox;
import com.serverengines.resmgr.AppResMgr;
import com.serverengines.resmgr.ResourceMgr;
import com.serverengines.resmgr.SettingsResMgr;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ServerDialog
extends BaseDialog
implements ActionListener {
    static final long serialVersionUID = -6411792110308345759L;
    public static final int COLUMN_SIZE = 35;
    protected DefaultComboBoxModel m_serverComboModel;
    protected DefaultComboBoxModel m_userComboModel;
    JTextField m_serverText;
    protected JComboBox m_serverCombo;
    protected JTextField m_userName;
    protected JComboBox m_userCombo;
    protected JPasswordField m_passwdEntry;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_aboutBtn;
    protected JButton m_preferencesBtn;
    CConn m_cconn;

    public ServerDialog(CConn cConn, String string) {
        super(ResourceMgr.getInstance().getResourceString("server.dlg.title"));
        int n;
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        AppResMgr appResMgr = AppResMgr.getInstance();
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        this.m_cconn = cConn;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel(gridBagLayout);
        JLabel jLabel = new JLabel(resourceMgr.getResourceString("server.dlg.kvms.server"));
        jLabel.setDisplayedMnemonic(resourceMgr.getResourceChar("server.dlg.kvms.server.mnemonic"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        int n2 = appResMgr.getResourceInt("num.server.connections");
        String string2 = null;
        this.m_serverComboModel = new DefaultComboBoxModel();
        for (n = 0; n < n2; ++n) {
            string2 = settingsResMgr.getResourceString("server.connection." + n);
            if (string2.length() <= 0) continue;
            this.m_serverComboModel.addElement(string2);
        }
        if (string != null && this.m_serverComboModel.getIndexOf(string) < 0) {
            this.m_serverComboModel.insertElementAt(string, 0);
        }
        this.m_serverText = new JTextField(35);
        jLabel.setLabelFor(this.m_serverText);
        if (this.m_serverComboModel.getSize() > 0) {
            string2 = (String)this.m_serverComboModel.getElementAt(0);
            this.m_serverText.setText(string2);
            this.m_serverText.selectAll();
        }
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.m_serverText, gridBagConstraints);
        jPanel.add(this.m_serverText);
        this.m_serverText.requestFocus();
        this.m_serverCombo = new JComboBox(this.m_serverComboModel);
        this.m_serverCombo.addActionListener(this);
        if (this.m_serverComboModel.getSize() > 0) {
            this.m_serverCombo.setSelectedIndex(0);
            ++gridBagConstraints.gridx;
            gridBagLayout.setConstraints(this.m_serverCombo, gridBagConstraints);
            jPanel.add(this.m_serverCombo);
        }
        jLabel = new JLabel(resourceMgr.getResourceString("passwd.dlg.username"));
        jLabel.setDisplayedMnemonic(resourceMgr.getResourceChar("passwd.dlg.username.mnemonic"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        n2 = appResMgr.getResourceInt("num.previous.users");
        this.m_userComboModel = new DefaultComboBoxModel();
        for (n = 0; n < n2; ++n) {
            string2 = settingsResMgr.getResourceString("prev.user." + n);
            if (string2.length() <= 0) continue;
            this.m_userComboModel.addElement(string2);
        }
        this.m_userName = new JTextField(35);
        jLabel.setLabelFor(this.m_userName);
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.m_userName, gridBagConstraints);
        jPanel.add(this.m_userName);
        this.m_userCombo = new JComboBox(this.m_userComboModel);
        this.m_userCombo.addActionListener(this);
        if (this.m_userComboModel.getSize() > 0) {
            this.m_userCombo.setSelectedIndex(0);
            string2 = (String)this.m_userComboModel.getElementAt(0);
            this.m_userName.setText(string2);
            ++gridBagConstraints.gridx;
            gridBagLayout.setConstraints(this.m_userCombo, gridBagConstraints);
            jPanel.add(this.m_userCombo);
        }
        jLabel = new JLabel(resourceMgr.getResourceString("passwd.dlg.password"));
        jLabel.setDisplayedMnemonic(resourceMgr.getResourceChar("passwd.dlg.password.mnemonic"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.m_passwdEntry = new JPasswordField(35);
        jLabel.setLabelFor(this.m_passwdEntry);
        this.m_passwdEntry.setEchoChar(resourceMgr.getResourceChar("passwd.dlg.password.char"));
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.m_passwdEntry, gridBagConstraints);
        jPanel.add(this.m_passwdEntry);
        this.getContentPane().add("Center", jPanel);
        jPanel = new JPanel(new FlowLayout(2));
        this.m_okBtn = new JButton(resourceMgr.getResourceString("ok.btn"));
        this.m_okBtn.setMnemonic(resourceMgr.getResourceChar("ok.btn.mnemonic"));
        this.getRootPane().setDefaultButton(this.m_okBtn);
        this.m_okBtn.addActionListener(this);
        jPanel.add(this.m_okBtn);
        this.m_cancelBtn = new JButton(resourceMgr.getResourceString("cancel.btn"));
        this.m_cancelBtn.setMnemonic(resourceMgr.getResourceChar("cancel.btn.mnemonic"));
        this.m_cancelBtn.addActionListener(this);
        jPanel.add(this.m_cancelBtn);
        this.m_aboutBtn = new JButton(resourceMgr.getResourceString("about.btn"));
        this.m_aboutBtn.setMnemonic(resourceMgr.getResourceChar("about.btn.mnemonic"));
        this.m_aboutBtn.addActionListener(this);
        jPanel.add(this.m_aboutBtn);
        this.m_preferencesBtn = new JButton(resourceMgr.getResourceString("menu.preferencs.preferences"));
        this.m_preferencesBtn.setMnemonic(resourceMgr.getResourceChar("menu.preferencs.preferences.mnemonic"));
        this.m_preferencesBtn.addActionListener(this);
        jPanel.add(this.m_preferencesBtn);
        this.getContentPane().add("South", jPanel);
        this.pack();
        this.initPosiiton();
    }

    protected void onOK() {
        int n;
        AppResMgr appResMgr = AppResMgr.getInstance();
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        String string = this.m_serverText.getText().trim();
        if (string.length() == 0) {
            MsgBox.showErrorMsgBox(this, resourceMgr.getResourceString("server.dlg.invalid.server"));
            this.m_serverText.requestFocus();
            this.m_serverText.selectAll();
            return;
        }
        try {
            InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            MsgBox.showErrorMsgBox(this, resourceMgr.getResourceString("err.unknownhost"));
            this.m_serverText.requestFocus();
            this.m_serverText.selectAll();
            return;
        }
        int n2 = appResMgr.getResourceInt("num.server.connections");
        int n3 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        StringBuffer stringBuffer = StringBufferPool.getInstance("server.connection.");
        stringBuffer.append(n3);
        StringBuffer stringBuffer2 = StringBufferPool.getInstance(string);
        settingsResMgr.setResourceValue(stringBuffer.toString(), stringBuffer2);
        hashSet.add(string);
        ++n3;
        for (n = 0; n3 < n2 && n < this.m_serverComboModel.getSize(); ++n) {
            string = (String)this.m_serverComboModel.getElementAt(n);
            if (hashSet.contains(string)) continue;
            stringBuffer.setLength(0);
            stringBuffer2.setLength(0);
            stringBuffer.append("server.connection.");
            stringBuffer.append(n3);
            stringBuffer2.append(string);
            settingsResMgr.setResourceValue(stringBuffer.toString(), stringBuffer2);
            hashSet.add(string);
            ++n3;
        }
        string = this.m_userName.getText().trim();
        n2 = appResMgr.getResourceInt("num.previous.users");
        n3 = 0;
        hashSet.clear();
        stringBuffer.setLength(0);
        stringBuffer2.setLength(0);
        stringBuffer.append("prev.user.");
        stringBuffer.append(n3);
        stringBuffer2.append(string);
        settingsResMgr.setResourceValue(stringBuffer.toString(), stringBuffer2);
        hashSet.add(string);
        ++n3;
        for (n = 0; n3 < n2 && n < this.m_userComboModel.getSize(); ++n) {
            string = (String)this.m_userComboModel.getElementAt(n);
            if (hashSet.contains(string)) continue;
            stringBuffer.setLength(0);
            stringBuffer2.setLength(0);
            stringBuffer.append("prev.user.");
            stringBuffer.append(n3);
            stringBuffer2.append(string);
            settingsResMgr.setResourceValue(stringBuffer.toString(), stringBuffer2);
            hashSet.add(string);
            ++n3;
        }
        StringBufferPool.recycle(stringBuffer2);
        StringBufferPool.recycle(stringBuffer);
        settingsResMgr.writeResource();
        super.onOK();
    }

    protected void comboChange(JComboBox jComboBox, JTextField jTextField, DefaultComboBoxModel defaultComboBoxModel) {
        int n = jComboBox.getSelectedIndex();
        if (n > -1) {
            jTextField.setText((String)defaultComboBoxModel.getElementAt(n));
        }
        jTextField.requestFocus();
        jTextField.selectAll();
    }

    public void onServerComboChange() {
        this.comboChange(this.m_serverCombo, this.m_serverText, this.m_serverComboModel);
    }

    public void onUserComboChange() {
        this.comboChange(this.m_userCombo, this.m_userName, this.m_userComboModel);
    }

    public void onAbout() {
        this.m_cconn.showAbout(this);
    }

    public void onPreferences() {
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        keyboardMgr.getKeyboard(settingsResMgr.getResourceInt("default.language"), this.m_cconn);
        this.m_cconn.showPreferencesDialog(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.m_okBtn)) {
            this.onOK();
        } else if (object.equals(this.m_cancelBtn)) {
            this.onCancel();
        } else if (object.equals(this.m_aboutBtn)) {
            this.onAbout();
        } else if (object.equals(this.m_preferencesBtn)) {
            this.onPreferences();
        } else if (object.equals(this.m_serverCombo)) {
            this.onServerComboChange();
        } else if (object.equals(this.m_userCombo)) {
            this.onUserComboChange();
        }
    }
}

