/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.mahogany;

import com.serverengines.buffer.Buffers;
import com.serverengines.graphics.GraphicMode;
import com.serverengines.graphics.GraphicsMgr;
import com.serverengines.graphics.ScreenMode;
import com.serverengines.graphics.ScreenModes;
import com.serverengines.graphics.TextMode;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.keyboard.KeyboardMgr;
import com.serverengines.kvm.LogWriter;
import com.serverengines.kvm.PixelBuffer;
import com.serverengines.mahogany.CConn;
import com.serverengines.mahoganyprotocol.Attribute;
import com.serverengines.mahoganyprotocol.Palette;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Arrays;

public class PixelBufferImage
extends PixelBuffer
implements ImageProducer {
    public static final int NUM_SNOOP_TILES = 64;
    public static final int NUM_BITS_IN_INT = 32;
    public static final int INVALID_START_VALUE = Integer.MAX_VALUE;
    public static final int INVALID_END_VALUE = Integer.MIN_VALUE;
    public static final int INT_VAL_SHIFT = 5;
    public static final int INT_VAL_MASK = 31;
    protected static LogWriter vlog = new LogWriter((class$com$serverengines$mahogany$PixelBufferImage == null ? (class$com$serverengines$mahogany$PixelBufferImage = PixelBufferImage.class$("com.serverengines.mahogany.PixelBufferImage")) : class$com$serverengines$mahogany$PixelBufferImage).getName());
    protected ImageConsumer ic;
    protected ColorModel cm;
    Image image;
    static /* synthetic */ Class class$com$serverengines$mahogany$PixelBufferImage;

    public PixelBufferImage(int n, int n2, Component component) {
        this.m_screenMode = -1;
        this.m_screenFormat = null;
        this.resize(n, n2, component);
        this.m_screenFormat = GraphicMode.getInstance(this.m_bpp, n, n2);
        this.cm = this.m_screenFormat != null ? this.m_screenFormat.getColorModel() : null;
    }

    protected int findTileShiftAmt(int n) {
        int n2 = 1;
        while (n >> n2 != 0) {
            ++n2;
        }
        return --n2;
    }

    protected int findNumOfTiles(int n, int n2) {
        int n3 = n / n2;
        if (n % n2 != 0) {
            ++n3;
        }
        return n3;
    }

    public void enhanceBitBlt(byte n, byte n2, int[] nArray, int[] nArray2, byte[] byArray) {
        int n3;
        int n4;
        GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
        int n5 = this.findTileShiftAmt(n);
        int n6 = this.findTileShiftAmt(n2);
        int n7 = this.findNumOfTiles(this.m_width_, n);
        int n8 = this.findNumOfTiles(this.m_height_, n2);
        int n9 = this.m_bpp >> 3;
        int n10 = 0;
        int n11 = 0;
        int n12 = Integer.MAX_VALUE;
        int n13 = Integer.MIN_VALUE;
        int n14 = Integer.MIN_VALUE;
        graphicsMgr.getDesktop().getCConn().setHLevelCompressionOn(false);
        n7 = Math.min(n7, 64);
        n8 = Math.min(n8, 64);
        for (int i = 0; i < n8; ++i) {
            for (int j = 0; j < n7; ++j) {
                boolean bl;
                int n15 = j;
                if (n15 < 32) {
                    bl = (nArray[i] & 1 << n15) != 0;
                } else {
                    boolean bl2 = bl = (nArray2[i] & 1 << n15 - 32) != 0;
                }
                if (!bl) continue;
                if (n14 == Integer.MIN_VALUE) {
                    n14 = i;
                }
                n11 = i;
                if (j < n12) {
                    n12 = j;
                }
                if (j > n13) {
                    n13 = j;
                }
                n4 = i << n6;
                int n16 = n4 * this.m_width_;
                n3 = j << n5;
                for (int k = 0; k < n2; ++k) {
                    if (k + n4 < this.m_height_) {
                        int n17 = k * this.m_width_ + n16 + n3;
                        for (int i2 = 0; i2 < n; ++i2) {
                            if (i2 + n3 < this.m_width_) {
                                Buffers.m_pixelScreen[n17] = 0;
                                if (this.m_bpp > 8) {
                                    if (this.m_bpp > 16) {
                                        int n18 = n17;
                                        Buffers.m_pixelScreen[n18] = Buffers.m_pixelScreen[n18] | (byArray[n10 + 2] & 0xFF) << 16;
                                    }
                                    int n19 = n17;
                                    Buffers.m_pixelScreen[n19] = Buffers.m_pixelScreen[n19] | (byArray[n10 + 1] & 0xFF) << 8;
                                    int n20 = n17;
                                    Buffers.m_pixelScreen[n20] = Buffers.m_pixelScreen[n20] | byArray[n10] & 0xFF;
                                } else {
                                    Buffers.m_paletteScreen[n17] = (byte)(byArray[n10] & 0xFF);
                                }
                                ++n17;
                            }
                            n10 += n9;
                        }
                        continue;
                    }
                    n10 += n * n9;
                }
            }
        }
        if (n12 != Integer.MAX_VALUE) {
            n3 = n12 << n5;
            n4 = n14 << n6;
            int n21 = n13 + 1 << n5;
            n21 = Math.min(n21, this.m_width_);
            int n22 = n11 + 1 << n6;
            n22 = Math.min(n22, this.m_height_);
            graphicsMgr.getDesktop().invalidate(n3, n4, n21 - n3, n22 - n4);
        }
    }

    public void enhanceBitBltHLC(byte n, byte n2, int n3, int n4, int[] nArray, int[] nArray2, byte[] byArray) {
        int n5;
        int n6;
        GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
        int n7 = this.findTileShiftAmt(n);
        int n8 = this.findTileShiftAmt(n2);
        int n9 = this.findNumOfTiles(this.m_width_, n);
        int n10 = this.findNumOfTiles(this.m_height_, n2);
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = Integer.MAX_VALUE;
        int n25 = Integer.MIN_VALUE;
        int n26 = Integer.MIN_VALUE;
        graphicsMgr.getDesktop().getCConn().setHLevelCompressionOn(true);
        n9 = Math.min(n9, 64);
        n10 = Math.min(n10, 64);
        if (this.m_bpp > 8) {
            int n27 = 0;
            n17 = (byArray[n27 + 3] & 0xFF) << 24;
            n17 |= (byArray[n27 + 2] & 0xFF) << 16;
            n17 |= (byArray[n27 + 1] & 0xFF) << 8;
            n17 |= byArray[n27] & 0xFF;
            n18 = (byArray[(n27 += 4) + 3] & 0xFF) << 24;
            n18 |= (byArray[n27 + 2] & 0xFF) << 16;
            n18 |= (byArray[n27 + 1] & 0xFF) << 8;
            n18 |= byArray[n27] & 0xFF;
            n27 += 4;
            if (this.m_bpp > 16) {
                n19 = (byArray[n27 + 3] & 0xFF) << 24;
                n19 |= (byArray[n27 + 2] & 0xFF) << 16;
                n19 |= (byArray[n27 + 1] & 0xFF) << 8;
                n19 |= byArray[n27] & 0xFF;
                n27 += 4;
            }
            n20 = n27;
            n21 = n20 + n17;
            if (this.m_bpp > 16) {
                n22 = n21 + n18;
            }
        }
        for (int i = 0; i < n10; ++i) {
            for (int j = 0; j < n9; ++j) {
                boolean bl;
                int n28 = j;
                if (n28 < 32) {
                    bl = (nArray[i] & 1 << n28) != 0;
                } else {
                    boolean bl2 = bl = (nArray2[i] & 1 << n28 - 32) != 0;
                }
                if (!bl) continue;
                if (n26 == Integer.MIN_VALUE) {
                    n26 = i;
                }
                n23 = i;
                if (j < n24) {
                    n24 = j;
                }
                if (j > n25) {
                    n25 = j;
                }
                n6 = i << n8;
                int n29 = n6 * this.m_width_;
                n5 = j << n7;
                for (int k = 0; k < n2; ++k) {
                    int n30 = k * this.m_width_ + n29 + n5;
                    for (int i2 = 0; i2 < n; ++i2) {
                        if (n14 < 1) {
                            n11 = byArray[n20] & 0xFF;
                            ++n20;
                            if (n11 == n3) {
                                n14 = 3;
                                n11 = byArray[n20] & 0xFF;
                                ++n20;
                            } else if (n11 == n4) {
                                n14 = byArray[n20] & 0xFF;
                                ++n20;
                                if (n14 == 1) {
                                    n14 = 1;
                                    n11 = n3;
                                } else if (n14 == 0) {
                                    n14 = 1;
                                    n11 = n4;
                                } else {
                                    ++n14;
                                    n11 = byArray[n20] & 0xFF;
                                    ++n20;
                                }
                            } else {
                                n14 = 1;
                            }
                        }
                        if (this.m_bpp > 8) {
                            if (n15 < 1) {
                                n12 = byArray[n21] & 0xFF;
                                ++n21;
                                if (n12 == n3) {
                                    n15 = 3;
                                    n12 = byArray[n21] & 0xFF;
                                    ++n21;
                                } else if (n12 == n4) {
                                    n15 = byArray[n21] & 0xFF;
                                    ++n21;
                                    if (n15 == 1) {
                                        n15 = 1;
                                        n12 = n3;
                                    } else if (n15 == 0) {
                                        n15 = 1;
                                        n12 = n4;
                                    } else {
                                        ++n15;
                                        n12 = byArray[n21] & 0xFF;
                                        ++n21;
                                    }
                                } else {
                                    n15 = 1;
                                }
                            }
                            if (this.m_bpp > 16 && n16 < 1) {
                                n13 = byArray[n22] & 0xFF;
                                ++n22;
                                if (n13 == n3) {
                                    n16 = 3;
                                    n13 = byArray[n22] & 0xFF;
                                    ++n22;
                                } else if (n13 == n4) {
                                    n16 = byArray[n22] & 0xFF;
                                    ++n22;
                                    if (n16 == 1) {
                                        n16 = 1;
                                        n13 = n3;
                                    } else if (n16 == 0) {
                                        n16 = 1;
                                        n13 = n4;
                                    } else {
                                        ++n16;
                                        n13 = byArray[n22] & 0xFF;
                                        ++n22;
                                    }
                                } else {
                                    n16 = 1;
                                }
                            }
                        }
                        if (k + n6 < this.m_height_ && i2 + n5 < this.m_width_) {
                            if (this.m_bpp > 8) {
                                Buffers.m_pixelScreen[n30] = n13 << 16 | n12 << 8 | n11;
                            } else {
                                Buffers.m_paletteScreen[n30] = (byte)n11;
                            }
                        }
                        if (this.m_bpp > 8) {
                            if (this.m_bpp > 16) {
                                --n16;
                            }
                            --n15;
                        }
                        --n14;
                        ++n30;
                    }
                }
            }
        }
        if (n24 != Integer.MAX_VALUE) {
            n5 = n24 << n7;
            n6 = n26 << n8;
            int n31 = n25 + 1 << n7;
            n31 = Math.min(n31, this.m_width_);
            int n32 = n23 + 1 << n8;
            n32 = Math.min(n32, this.m_height_);
            graphicsMgr.getDesktop().invalidate(n5, n6, n31 - n5, n32 - n6);
        }
    }

    public void enhanceBitBlt4bpp(byte n, byte n2, int[] nArray, int[] nArray2, byte[] byArray) {
        int n3;
        int n4;
        GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
        int n5 = this.findTileShiftAmt(n);
        int n6 = this.findTileShiftAmt(n2);
        int n7 = this.findNumOfTiles(this.m_width_, n);
        int n8 = this.findNumOfTiles(this.m_height_, n2);
        int n9 = 0;
        int n10 = 0;
        int n11 = Integer.MAX_VALUE;
        int n12 = Integer.MIN_VALUE;
        int n13 = Integer.MIN_VALUE;
        n7 = Math.min(n7, 64);
        n8 = Math.min(n8, 64);
        this.setSpecial4bppMode(true);
        for (int i = 0; i < n8; ++i) {
            for (int j = 0; j < n7; ++j) {
                boolean bl;
                int n14 = j;
                if (n14 < 32) {
                    bl = (nArray[i] & 1 << n14) != 0;
                } else {
                    boolean bl2 = bl = (nArray2[i] & 1 << n14 - 32) != 0;
                }
                if (!bl) continue;
                if (n13 == Integer.MIN_VALUE) {
                    n13 = i;
                }
                n10 = i;
                if (j < n11) {
                    n11 = j;
                }
                if (j > n12) {
                    n12 = j;
                }
                n4 = i << n6;
                int n15 = n4 * this.m_width_;
                n3 = j << n5;
                for (int k = 0; k < n2; ++k) {
                    if (k + n4 < this.m_height_) {
                        int n16 = k * this.m_width_ + n15 + n3;
                        for (int i2 = 0; i2 < n; ++i2) {
                            int n17 = byArray[n9 >> 1];
                            if ((i2 & 1) != 0) {
                                n17 >>= 4;
                            }
                            Buffers.m_attributeScreen[n16] = (byte)(n17 & 0xF);
                            ++n16;
                            ++n9;
                        }
                        continue;
                    }
                    n9 += n;
                }
            }
        }
        if (n11 != Integer.MAX_VALUE) {
            n3 = n11 << n5;
            n4 = n13 << n6;
            n12 = (n12 << n5) - n3 + n;
            n10 = (n10 << n6) - n4 + n2;
            this.convertAttributesToPalette(n3, n4, n12, n10);
            graphicsMgr.getDesktop().invalidate(n3, n4, n12, n10);
        }
    }

    public void resize(int n, int n2, Component component) {
        this.ic = null;
        this.m_width_ = n;
        this.m_height_ = n2;
        this.image = component.createImage(this);
    }

    public void put(int n, int n2, int n3, int n4, Graphics graphics) {
        if (this.ic == null) {
            return;
        }
        if (n2 + n4 > this.m_height_) {
            n4 -= n2 + n4 - this.m_height_;
        }
        if (n4 < 1) {
            return;
        }
        if (this.m_bpp > 8) {
            this.ic.setPixels(n, n2, n3, n4, this.cm, Buffers.m_pixelScreen, n2 * this.m_width_ + n, this.m_width_);
        } else if (this.m_bpp == 8) {
            this.ic.setPixels(n, n2, n3, n4, this.cm, Buffers.m_paletteScreen, n2 * this.m_width_ + n, this.m_width_);
        }
        this.ic.imageComplete(2);
        graphics.setClip(n, n2, n3, n4);
        graphics.drawImage(this.image, 0, 0, null);
    }

    public void bitBlt(int n, int n2, int n3, int n4, short s, short s2, byte[] byArray) {
        GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
        int n5 = this.m_bpp >> 3;
        int n6 = 0;
        int n7 = n2 * this.m_width_ + n;
        if (n2 + n4 > this.m_height_) {
            n4 -= n2 + n4 - this.m_height_;
        }
        if (this.m_bpp > 8) {
            for (int i = 0; i < n4; ++i) {
                int n8 = n7 + i * this.m_width_;
                for (int j = 0; j < n3; ++j) {
                    Buffers.m_pixelScreen[n8] = 0;
                    if (this.m_bpp > 16) {
                        int n9 = n8;
                        Buffers.m_pixelScreen[n9] = Buffers.m_pixelScreen[n9] | (byArray[n6 + 2] & 0xFF) << 16;
                    }
                    int n10 = n8;
                    Buffers.m_pixelScreen[n10] = Buffers.m_pixelScreen[n10] | (byArray[n6 + 1] & 0xFF) << 8;
                    int n11 = n8++;
                    Buffers.m_pixelScreen[n11] = Buffers.m_pixelScreen[n11] | byArray[n6] & 0xFF;
                    n6 += n5;
                }
            }
        } else if (this.m_bpp == 8) {
            if (this.m_screenFormat instanceof TextMode) {
                this.m_screenFormat.setFontHeight(s);
                this.m_screenFormat.setFontWidth(s2);
                this.m_screenFormat.imageRect(n, n2, n3, n4, n5, this.m_width_, byArray, 0, Buffers.m_attributeScreen);
                this.convertAttributesToPalette(n *= s2, n2 *= s, n3 *= s2, n4 *= s);
            } else if (this.m_screenFormat.getBpp() == 4) {
                for (int i = 0; i < n4; ++i) {
                    int n12 = n7 + i * this.m_width_;
                    for (int j = n3 - 1; j > -1; --j) {
                        int n13 = byArray[n6 >> 1];
                        if ((j & 1) == 0) {
                            n13 >>= 4;
                        }
                        Buffers.m_attributeScreen[n12] = (byte)(n13 & 0xF);
                        ++n12;
                        ++n6;
                    }
                }
                this.convertAttributesToPalette(n, n2, n3, n4);
            } else {
                int n14 = n7;
                for (int i = 0; i < n4; ++i) {
                    System.arraycopy(byArray, n6, Buffers.m_paletteScreen, n14, n3);
                    n14 += this.m_width_;
                    n6 += n3;
                }
            }
        }
        graphicsMgr.getDesktop().invalidate(n, n2, n3, n4);
    }

    public boolean setPalette(Palette[] paletteArray, Attribute[] attributeArray, short s, short s2) {
        boolean bl = this.m_screenFormat.setPalette(paletteArray, attributeArray, s, s2);
        this.cm = this.m_screenFormat.getColorModel();
        if (bl && this.m_screenFormat.getBpp() < 8) {
            this.convertAttributesToPalette(0, 0, this.m_width_, this.m_height_);
        }
        return bl;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        if (vlog.isDebugLoggingEnabled()) {
            StringBuffer stringBuffer = StringBufferPool.getInstance("adding consumer ");
            stringBuffer.append(imageConsumer);
            vlog.debug(stringBuffer.toString());
            StringBufferPool.recycle(stringBuffer);
        }
        this.ic = imageConsumer;
        this.ic.setDimensions(this.width(), this.height());
        this.ic.setHints(1);
        this.ic.setPixels(0, 0, this.width(), this.height(), this.cm, Buffers.m_paletteScreen, 0, this.width());
        this.ic.imageComplete(2);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        if (vlog.isInfoLoggingEnabled()) {
            vlog.info("removeConsumer " + imageConsumer);
        }
        if (this.ic == imageConsumer) {
            this.ic = null;
        }
    }

    public void setVesaMode(int n, int n2, int n3, int n4) {
        if (this.m_screenFormat == null || n != this.m_screenMode || n2 != this.m_screenFormat.getBpp() || n3 != this.m_screenFormat.getScreenWidth() || n4 != this.m_screenFormat.getScreenHeight()) {
            this.m_screenMode = n;
            this.m_isSpecial4bppMode = false;
            ScreenModes screenModes = ScreenModes.getInstance();
            ScreenMode screenMode = screenModes.getScreenMode(this.m_screenMode, n2, n3, n4);
            screenModes.recycle();
            if (this.m_screenFormat != null) {
                this.m_screenFormat.recycle();
            }
            this.m_screenFormat = screenMode;
            this.m_height_ = n4;
            this.m_width_ = n3;
            this.m_bpp = this.m_screenFormat.getBpp() < 8 ? 8 : (this.m_screenFormat.getBpp() == 15 ? 16 : n2);
            this.cm = this.m_screenFormat.getColorModel();
        }
    }

    public void setTextMode(short s) {
        this.m_screenFormat.setBlitType(s);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.ic == imageConsumer;
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        if (vlog.isInfoLoggingEnabled()) {
            vlog.info("requestTopDownLeftRightResend called");
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public void standbyPower() {
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        CConn cConn = keyboardMgr.getCConn();
        cConn.setStandbyPower(true);
        Arrays.fill(Buffers.m_pixelScreen, 0);
        GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
        graphicsMgr.getDesktop().invalidate(0, 0, this.m_width_, this.m_height_);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

