/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.mahogany;

import com.serverengines.helper.ArrayListStringBufferPool;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.mahogany.BaseDialog;
import com.serverengines.mahogany.CConn;
import com.serverengines.resmgr.ResourceMgr;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PerformanceDialog
extends BaseDialog
implements ActionListener {
    static final long serialVersionUID = 1597778718051201303L;
    public static final int NUM_CYCLES = 10;
    public static final int WORKING_INDEX = 0;
    public static final int DEFAULT_VALUE = 0;
    public static final String DEFAULT_STRING = "0";
    public static final String FOMAT_STRING = "#,###.#";
    protected CConn m_cconn;
    protected int m_currentCt;
    protected int[] m_ct;
    protected JLabel m_currentLabel;
    protected JLabel[] m_labels;
    protected JLabel m_totalLabel;
    protected DecimalFormat m_format;
    protected JButton m_okButton;

    public PerformanceDialog(Frame frame, CConn cConn) {
        super(frame, ResourceMgr.getInstance().getResourceString("performance.dlg.title"), false);
        this.m_cconn = cConn;
        this.m_currentCt = 0;
        this.m_format = new DecimalFormat(FOMAT_STRING);
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        this.m_ct = new int[10];
        this.m_labels = new JLabel[this.m_ct.length];
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ArrayList arrayList = ArrayListStringBufferPool.getInstance();
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        JLabel jLabel = new JLabel(resourceMgr.getResourceString("performance.dlg.current"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        ++gridBagConstraints.gridx;
        this.m_currentLabel = new JLabel(DEFAULT_STRING);
        gridBagLayout.setConstraints(this.m_currentLabel, gridBagConstraints);
        jPanel.add(this.m_currentLabel);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        for (int i = 0; i < this.m_ct.length; ++i) {
            arrayList.clear();
            stringBuffer.setLength(0);
            stringBuffer.append(i);
            arrayList.add(stringBuffer);
            jLabel = new JLabel(resourceMgr.getResourceString("performance.dlg.label", arrayList));
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            ++gridBagConstraints.gridx;
            this.m_ct[i] = 0;
            this.m_labels[i] = jLabel = new JLabel(DEFAULT_STRING);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
        }
        StringBufferPool.recycle(stringBuffer);
        ArrayListStringBufferPool.recycle(arrayList);
        gridBagConstraints.gridx = 0;
        jLabel = new JLabel(resourceMgr.getResourceString("performance.dlg.total"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        ++gridBagConstraints.gridx;
        this.m_totalLabel = new JLabel(DEFAULT_STRING);
        gridBagLayout.setConstraints(this.m_totalLabel, gridBagConstraints);
        jPanel.add(this.m_totalLabel);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 20, 5));
        this.m_okButton = new JButton(resourceMgr.getResourceString("ok.btn"));
        this.m_okButton.setMnemonic(resourceMgr.getResourceChar("ok.btn.mnemonic"));
        this.getRootPane().setDefaultButton(this.m_okButton);
        this.m_okButton.addActionListener(this);
        jPanel2.add(this.m_okButton);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.getContentPane().add("Center", jPanel);
        this.setResizable(true);
        this.pack();
        this.setSize(100, 400);
        this.initPosiiton();
    }

    public void endDialog() {
        this.m_cconn.onPerformanceComplete();
        super.endDialog();
    }

    public void clearValues() {
        this.m_totalLabel.setText(DEFAULT_STRING);
        this.m_currentCt = 0;
        this.m_currentLabel.setText(DEFAULT_STRING);
        for (int i = 0; i < this.m_ct.length; ++i) {
            this.m_ct[i] = 0;
            this.m_labels[i].setText(DEFAULT_STRING);
        }
    }

    public void changeCutrentCycle(int n) {
        this.m_currentCt = n;
        this.m_currentLabel.setText("" + this.m_currentCt);
    }

    public void changeCycles() {
        int n = 0;
        for (int i = this.m_ct.length - 1; i > 0; --i) {
            this.m_ct[i] = this.m_ct[i - 1];
            n += this.m_ct[i];
            this.m_labels[i].setText("" + this.m_ct[i]);
        }
        this.m_ct[0] = this.m_currentCt;
        this.m_labels[0].setText("" + this.m_ct[0]);
        String string = this.m_format.format((double)(n += this.m_ct[0]) / (double)this.m_ct.length);
        this.m_totalLabel.setText(string);
        this.m_currentCt = 0;
        this.m_currentLabel.setText(DEFAULT_STRING);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.onOK();
    }
}

