/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.mahogany;

import com.serverengines.buffer.LittleEndianBufferMgr;
import com.serverengines.helper.Helper;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.kvm.LogWriter;
import com.serverengines.mahogany.CConn;
import com.serverengines.mahoganyprotocol.ButtonState;
import com.serverengines.mahoganyprotocol.ButtonStateAtAbsolute;
import com.serverengines.mahoganyprotocol.ButtonStateAtRelative;
import com.serverengines.mahoganyprotocol.ClientAbsoluteMode;
import com.serverengines.mahoganyprotocol.ClientDisconnect;
import com.serverengines.mahoganyprotocol.ClientHandshake;
import com.serverengines.mahoganyprotocol.ClientNOP;
import com.serverengines.mahoganyprotocol.ClientRelativeMode;
import com.serverengines.mahoganyprotocol.Command;
import com.serverengines.mahoganyprotocol.DisconnectUser;
import com.serverengines.mahoganyprotocol.InformHLevelCompression;
import com.serverengines.mahoganyprotocol.Invalidate;
import com.serverengines.mahoganyprotocol.KeyStateChange;
import com.serverengines.mahoganyprotocol.KeyboardTurnScreenOff;
import com.serverengines.mahoganyprotocol.KeyboardTurnScreenOn;
import com.serverengines.mahoganyprotocol.MahoganyProtocol;
import com.serverengines.mahoganyprotocol.MouseMove;
import com.serverengines.mahoganyprotocol.Region;
import com.serverengines.mahoganyprotocol.RelinquishFullControl;
import com.serverengines.mahoganyprotocol.RequestKeyIndicators;
import com.serverengines.mahoganyprotocol.RequestPrimaryControl;
import com.serverengines.mahoganyprotocol.RequestVesaMode;
import com.serverengines.mahoganyprotocol.StorageClientConnect;
import com.serverengines.mahoganyprotocol.StorageClientDisconnect;
import com.serverengines.rdr.BadException;
import com.serverengines.rdr.OutStream;
import com.serverengines.resmgr.ResourceMgr;

public class MessageSender {
    public static final String SENDING_STRING = ResourceMgr.getInstance().getResourceString("sending.stmt") + " ";
    protected static LogWriter s_logger = new LogWriter((class$com$serverengines$mahogany$MessageSender == null ? (class$com$serverengines$mahogany$MessageSender = MessageSender.class$("com.serverengines.mahogany.MessageSender")) : class$com$serverengines$mahogany$MessageSender).getName());
    protected static CConn s_cconn = null;
    protected static OutStream s_os = null;
    static /* synthetic */ Class class$com$serverengines$mahogany$MessageSender;

    protected static void writeSendMessage(MahoganyProtocol mahoganyProtocol) {
        if (s_logger.isInfoLoggingEnabled()) {
            StringBuffer stringBuffer = StringBufferPool.getInstance(SENDING_STRING);
            stringBuffer.append(mahoganyProtocol.toString());
            s_logger.info(stringBuffer.toString());
            StringBufferPool.recycle(stringBuffer);
        }
    }

    protected static MahoganyProtocol getProtocol(int n) {
        MahoganyProtocol mahoganyProtocol = null;
        switch (n) {
            case 221: {
                mahoganyProtocol = ClientHandshake.getInstance();
                break;
            }
            case 241: {
                mahoganyProtocol = RequestVesaMode.getInstance();
                break;
            }
            case 242: {
                mahoganyProtocol = Invalidate.getInstance();
                break;
            }
            case 243: {
                mahoganyProtocol = InformHLevelCompression.getInstance();
                break;
            }
            case 177: {
                mahoganyProtocol = ClientAbsoluteMode.getInstance();
                break;
            }
            case 178: {
                mahoganyProtocol = ClientRelativeMode.getInstance();
                break;
            }
            case 179: {
                mahoganyProtocol = ButtonStateAtAbsolute.getInstance();
                break;
            }
            case 180: {
                mahoganyProtocol = ButtonStateAtRelative.getInstance();
                break;
            }
            case 181: {
                mahoganyProtocol = MouseMove.getInstance();
                break;
            }
            case 193: {
                mahoganyProtocol = RequestKeyIndicators.getInstance();
                break;
            }
            case 209: {
                mahoganyProtocol = KeyStateChange.getInstance();
                break;
            }
            case 211: {
                mahoganyProtocol = RequestPrimaryControl.getInstance();
                break;
            }
            case 214: {
                mahoganyProtocol = DisconnectUser.getInstance();
                break;
            }
            case 215: {
                mahoganyProtocol = RelinquishFullControl.getInstance();
                break;
            }
            case 216: {
                mahoganyProtocol = ClientDisconnect.getInstance();
                break;
            }
            case 153: {
                mahoganyProtocol = StorageClientConnect.getInstance();
                break;
            }
            case 154: {
                mahoganyProtocol = StorageClientDisconnect.getInstance();
                break;
            }
            case 218: {
                mahoganyProtocol = KeyboardTurnScreenOff.getInstance();
                break;
            }
            case 217: {
                mahoganyProtocol = KeyboardTurnScreenOn.getInstance();
                break;
            }
            case 210: {
                mahoganyProtocol = ClientNOP.getInstance();
                break;
            }
            default: {
                StringBuffer stringBuffer = StringBufferPool.getInstance("Cannot load invalid protocol: ");
                StringBuffer stringBuffer2 = Helper.formatToHex((byte)n);
                stringBuffer.append(n);
                stringBuffer.append(" (");
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(")");
                String string = stringBuffer.toString();
                if (s_logger.isErrorLoggingEnabled()) {
                    s_logger.error(string);
                }
                StringBufferPool.recycle(stringBuffer2);
                StringBufferPool.recycle(stringBuffer);
                throw new BadException(string);
            }
        }
        return mahoganyProtocol;
    }

    public static void sendClientHandshake(boolean bl, String string, String string2, String string3, int n, String string4) {
        ClientHandshake clientHandshake = (ClientHandshake)MessageSender.getProtocol(221);
        clientHandshake.setUserName(string);
        clientHandshake.setPassword(string2);
        clientHandshake.setPasswordFull(string3);
        clientHandshake.getConfig().setConfig(n);
        clientHandshake.setKey(string4);
        if (!bl) {
            clientHandshake.setSignature(0x12121212);
        }
        MessageSender.sendMessage(clientHandshake);
        clientHandshake.recycle();
    }

    protected static boolean isHandshakeComplete() {
        return s_cconn.isHandshakeComplete();
    }

    public static void storageClientComnnect(byte[] byArray, short s, byte by, byte by2, byte by3, byte by4, byte by5, String string, String string2) {
        if (MessageSender.isHandshakeComplete() && s_cconn.isStorageEnabled()) {
            StorageClientConnect storageClientConnect = (StorageClientConnect)MessageSender.getProtocol(153);
            storageClientConnect.setIPAddress(byArray);
            storageClientConnect.setPort(s);
            storageClientConnect.setShareIndex0(by);
            storageClientConnect.setShareIndex1(by2);
            storageClientConnect.setShareType0(by3);
            storageClientConnect.setShareType1(by4);
            storageClientConnect.seIPType(by5);
            storageClientConnect.setSharePath0(string);
            storageClientConnect.setSharePath1(string2);
            MessageSender.sendMessage(storageClientConnect);
            storageClientConnect.recycle();
        }
    }

    public static void storageClientDisconnect() {
        if (MessageSender.isHandshakeComplete() && s_cconn.isStorageEnabled()) {
            MahoganyProtocol mahoganyProtocol = MessageSender.getProtocol(154);
            MessageSender.sendMessage(mahoganyProtocol);
            mahoganyProtocol.recycle();
        }
    }

    public static void requestVesaMode() {
        if (MessageSender.isHandshakeComplete() && s_cconn.isVideoEnabled()) {
            MahoganyProtocol mahoganyProtocol = MessageSender.getProtocol(241);
            MessageSender.sendMessage(mahoganyProtocol);
            mahoganyProtocol.recycle();
        }
    }

    public static void invalidate(Region[] regionArray) {
        if (MessageSender.isHandshakeComplete() && s_cconn.isVideoEnabled()) {
            Invalidate invalidate = (Invalidate)MessageSender.getProtocol(242);
            if (regionArray == null) {
                regionArray = new Region[]{};
            }
            invalidate.setRegions(regionArray);
            MessageSender.sendMessage(invalidate);
            invalidate.recycle();
        }
    }

    public static void informHLevelCompressionOn(boolean bl) {
        if (MessageSender.isHandshakeComplete() && s_cconn.isVideoEnabled() && !MessageSender.s_cconn.viewer.viewOnly.getValue()) {
            InformHLevelCompression informHLevelCompression = (InformHLevelCompression)MessageSender.getProtocol(243);
            informHLevelCompression.setEncrypted(bl);
            MessageSender.sendMessage(informHLevelCompression);
            informHLevelCompression.recycle();
        }
    }

    public static void setConnection(CConn cConn) {
        s_cconn = cConn;
        s_os = s_cconn.getOutStream();
    }

    public static void setConn(CConn cConn) {
        s_cconn = cConn;
    }

    public static void clientAbsoluteMode(boolean bl) {
        if (MessageSender.isHandshakeComplete() && s_cconn.isMouseEnabled()) {
            ClientAbsoluteMode clientAbsoluteMode = (ClientAbsoluteMode)MessageSender.getProtocol(177);
            clientAbsoluteMode.setBoolean(bl);
            MessageSender.sendMessage(clientAbsoluteMode);
            clientAbsoluteMode.recycle();
        }
    }

    public static void clientRelativeMode(boolean bl, boolean bl2) {
        if (MessageSender.isHandshakeComplete() && s_cconn.isMouseEnabled()) {
            ClientRelativeMode clientRelativeMode = (ClientRelativeMode)MessageSender.getProtocol(178);
            clientRelativeMode.setRelativeMode(bl);
            clientRelativeMode.setMouseHide(bl2);
            MessageSender.sendMessage(clientRelativeMode);
            clientRelativeMode.recycle();
        }
    }

    public static void buttonStateAtAbsolute(short s, short s2, ButtonState[] buttonStateArray) {
        if (MessageSender.isHandshakeComplete() && s_cconn.isMouseEnabled()) {
            ButtonStateAtAbsolute buttonStateAtAbsolute = (ButtonStateAtAbsolute)MessageSender.getProtocol(179);
            buttonStateAtAbsolute.setXCoordinate(s);
            buttonStateAtAbsolute.setYCoordinate(s2);
            buttonStateAtAbsolute.setButtonStates(buttonStateArray);
            MessageSender.sendMessage(buttonStateAtAbsolute);
            buttonStateAtAbsolute.recycle();
            for (int i = 0; i < buttonStateArray.length; ++i) {
                buttonStateArray[i].recycle();
            }
        }
    }

    public static void buttonStateAtRelative(short s, short s2, ButtonState[] buttonStateArray) {
        if (MessageSender.isHandshakeComplete() && s_cconn.isMouseEnabled()) {
            ButtonStateAtRelative buttonStateAtRelative = (ButtonStateAtRelative)MessageSender.getProtocol(180);
            buttonStateAtRelative.setXCoordinate(s);
            buttonStateAtRelative.setYCoordinate(s2);
            buttonStateAtRelative.setButtonStates(buttonStateArray);
            MessageSender.sendMessage(buttonStateAtRelative);
            buttonStateAtRelative.recycle();
            for (int i = 0; i < buttonStateArray.length; ++i) {
                buttonStateArray[i].recycle();
            }
        }
    }

    public static void mouseMove(short s, short s2) {
        if (MessageSender.isHandshakeComplete() && s_cconn.isMouseEnabled()) {
            MouseMove mouseMove = (MouseMove)MessageSender.getProtocol(181);
            mouseMove.setXCoordinate(s);
            mouseMove.setYCoordinate(s2);
            MessageSender.sendMessage(mouseMove);
            mouseMove.recycle();
        }
    }

    public static void keyStateChange(short s, boolean bl, boolean bl2) {
        if (MessageSender.isHandshakeComplete() && s_cconn.isKeyboardEnabled()) {
            KeyStateChange keyStateChange = (KeyStateChange)MessageSender.getProtocol(209);
            keyStateChange.setKeyScanCode(s);
            keyStateChange.setKeyState(bl);
            keyStateChange.setPreTranslated(bl2);
            MessageSender.sendMessage(keyStateChange);
            keyStateChange.recycle();
        }
    }

    public static void requestPrimaryControl() {
        if (MessageSender.isHandshakeComplete()) {
            MahoganyProtocol mahoganyProtocol = MessageSender.getProtocol(211);
            MessageSender.sendMessage(mahoganyProtocol);
            mahoganyProtocol.recycle();
        }
    }

    public static void clientDisconnect(int n) {
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        ClientDisconnect clientDisconnect = (ClientDisconnect)MessageSender.getProtocol(216);
        clientDisconnect.setReason(n);
        clientDisconnect.setMessage(resourceMgr.getResourceString("disconnect.reason." + n));
        MessageSender.sendMessage(clientDisconnect);
        clientDisconnect.recycle();
    }

    public static void relinquishFullControl() {
        if (MessageSender.isHandshakeComplete()) {
            MahoganyProtocol mahoganyProtocol = MessageSender.getProtocol(215);
            MessageSender.sendMessage(mahoganyProtocol);
            mahoganyProtocol.recycle();
        }
    }

    public static void disconnectUser(byte by) {
        if (MessageSender.isHandshakeComplete()) {
            DisconnectUser disconnectUser = (DisconnectUser)MessageSender.getProtocol(214);
            disconnectUser.setUserId(by);
            MessageSender.sendMessage(disconnectUser);
            disconnectUser.recycle();
        }
    }

    public static void requestKeyIndicators() {
        if (MessageSender.isHandshakeComplete() && s_cconn.isKeyboardEnabled()) {
            MahoganyProtocol mahoganyProtocol = MessageSender.getProtocol(193);
            MessageSender.sendMessage(mahoganyProtocol);
            mahoganyProtocol.recycle();
        }
    }

    public static void sendTurnLMSoff() {
        if (MessageSender.isHandshakeComplete() && s_cconn.isKeyboardEnabled()) {
            MahoganyProtocol mahoganyProtocol = MessageSender.getProtocol(218);
            MessageSender.sendMessage(mahoganyProtocol);
            mahoganyProtocol.recycle();
        }
    }

    public static void sendTurnLMSon() {
        if (MessageSender.isHandshakeComplete() && s_cconn.isKeyboardEnabled()) {
            MahoganyProtocol mahoganyProtocol = MessageSender.getProtocol(217);
            MessageSender.sendMessage(mahoganyProtocol);
            mahoganyProtocol.recycle();
        }
    }

    public static void sendClientNOP() {
        MahoganyProtocol mahoganyProtocol = MessageSender.getProtocol(210);
        MessageSender.sendMessage(mahoganyProtocol);
        mahoganyProtocol.recycle();
    }

    protected static synchronized void sendMessage(MahoganyProtocol mahoganyProtocol) {
        MessageSender.writeSendMessage(mahoganyProtocol);
        Command command = Command.getInstance(mahoganyProtocol.getId());
        LittleEndianBufferMgr littleEndianBufferMgr = LittleEndianBufferMgr.getInstance();
        command.writeBuffer(littleEndianBufferMgr);
        mahoganyProtocol.writeBuffer(littleEndianBufferMgr);
        MessageSender.sendMessage(littleEndianBufferMgr.getBuffer(), littleEndianBufferMgr.getOffset());
        command.recycle();
    }

    protected static synchronized void sendMessage(byte[] byArray, int n) {
        MessageSender.sendMessage(s_os, byArray, n);
    }

    protected static synchronized void sendMessage(OutStream outStream, byte[] byArray, int n) {
        try {
            if (outStream != null) {
                outStream.writeBytes(byArray, 0, n);
                outStream.flush();
            }
        }
        catch (Throwable throwable) {
            if (s_logger.isErrorLoggingEnabled()) {
                s_logger.error("Error occured writing output to socket:");
                s_logger.error(throwable);
            }
            s_cconn.close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

