/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.mahogany;

import com.serverengines.buffer.BufferMgr;
import com.serverengines.graphics.GraphicsMgr;
import com.serverengines.helper.Helper;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.keyboard.Keyboard;
import com.serverengines.keyboard.KeyboardMgr;
import com.serverengines.kvm.LogWriter;
import com.serverengines.mahogany.CConn;
import com.serverengines.mahogany.MahoganyViewer;
import com.serverengines.mahogany.MsgBox;
import com.serverengines.mahoganyprotocol.BitBlt;
import com.serverengines.mahoganyprotocol.Command;
import com.serverengines.mahoganyprotocol.EnhanceBitBlt;
import com.serverengines.mahoganyprotocol.FirmwareVersion;
import com.serverengines.mahoganyprotocol.GraphicsRegisterValue;
import com.serverengines.mahoganyprotocol.InformKeyIndicators;
import com.serverengines.mahoganyprotocol.InformVesaMode;
import com.serverengines.mahoganyprotocol.MahoganyProtocol;
import com.serverengines.mahoganyprotocol.MatroxGraphicsCursor;
import com.serverengines.mahoganyprotocol.MultiUserState;
import com.serverengines.mahoganyprotocol.Region;
import com.serverengines.mahoganyprotocol.ServerDisconnect;
import com.serverengines.mahoganyprotocol.ServerHandshake;
import com.serverengines.mahoganyprotocol.SetPalette;
import com.serverengines.mahoganyprotocol.SetTextCursor;
import com.serverengines.mahoganyprotocol.SpecialGraphicsBit;
import com.serverengines.mahoganyprotocol.StandbyPower;
import com.serverengines.mahoganyprotocol.StorageStatus;
import com.serverengines.rdr.BadException;
import com.serverengines.rdr.InStream;

public class MessageReceiverThread
extends Thread {
    public static final long SLEEP_TIME = 1L;
    protected LogWriter s_logger = new LogWriter((class$com$serverengines$mahogany$MessageReceiverThread == null ? (class$com$serverengines$mahogany$MessageReceiverThread = MessageReceiverThread.class$("com.serverengines.mahogany.MessageReceiverThread")) : class$com$serverengines$mahogany$MessageReceiverThread).getName());
    protected CConn m_cconn = null;
    protected InStream is;
    static /* synthetic */ Class class$com$serverengines$mahogany$MessageReceiverThread;

    public MessageReceiverThread(CConn cConn) {
        this.m_cconn = cConn;
        this.is = null;
        Thread thread = this.m_cconn.getMainThread();
        int n = thread.getPriority();
        if (n > 1 && --n > 1) {
            --n;
        }
        this.setPriority(n);
    }

    public void run() {
        String string;
        block6: {
            string = null;
            this.is = this.m_cconn.getInStream();
            try {
                while (this.m_cconn.m_isRunning) {
                    this.parseCommand();
                    MessageReceiverThread.sleep(1L);
                }
            }
            catch (Throwable throwable) {
                if (this.s_logger.isInfoLoggingEnabled()) {
                    this.s_logger.info(throwable);
                }
                if (this.m_cconn.isExitingProperly()) break block6;
                string = throwable.toString();
            }
        }
        this.m_cconn.close();
        if (string != null) {
            MsgBox.showErrorMsgBox(this.m_cconn.viewer, string);
        }
        if (!MahoganyViewer.applet && --MahoganyViewer.nViewers < 1) {
            System.exit(0);
        }
    }

    protected void parseCommand() {
        Command command = Command.getInstance(this.is.readU8());
        switch (command.getDataType()) {
            case 225: {
                this.onInformVesaMode(command, this.is);
                break;
            }
            case 226: {
                this.onBitBlt(command, this.is);
                break;
            }
            case 227: {
                this.onEnhanceBitBlt(command, this.is);
                break;
            }
            case 230: {
                this.onSetPalette(command, this.is);
                break;
            }
            case 234: {
                this.onSetTextCursor(command, this.is);
                break;
            }
            case 235: {
                this.onSpecialGraphicsBit(command, this.is);
                break;
            }
            case 236: {
                this.onMatroxGraphicsCursor(command, this.is);
                break;
            }
            case 228: {
                this.onStandbyPower(command, this.is);
                break;
            }
            case 213: {
                this.onInformKeyIndicators(command, this.is);
                break;
            }
            case 197: {
                this.onMultiUserState(command, this.is);
                break;
            }
            case 198: {
                this.onServerDisconnect(command, this.is);
                break;
            }
            case 200: {
                this.onServerHandshake(command, this.is);
                break;
            }
            case 201: {
                this.onFirmwareVersion(command, this.is);
                break;
            }
            case 137: {
                this.onStorageServerStatus(command, this.is);
                break;
            }
            default: {
                this.onOtherCommand(command, this.is);
            }
        }
        command.recycle();
    }

    protected MahoganyProtocol loadCommand(Command command, BufferMgr bufferMgr) {
        return this.loadCommand(command, bufferMgr, true);
    }

    protected MahoganyProtocol loadCommand(Command command, BufferMgr bufferMgr, boolean bl) {
        MahoganyProtocol mahoganyProtocol = this.getProtocol(command.getDataType());
        if (mahoganyProtocol != null) {
            mahoganyProtocol.readBuffer(bufferMgr);
            if (this.s_logger.isInfoLoggingEnabled() && bl) {
                this.s_logger.info(mahoganyProtocol.toString());
            }
        }
        return mahoganyProtocol;
    }

    protected MahoganyProtocol getProtocol(int n) {
        MahoganyProtocol mahoganyProtocol = null;
        switch (n) {
            case 225: {
                mahoganyProtocol = InformVesaMode.getInstance();
                break;
            }
            case 238: {
                mahoganyProtocol = GraphicsRegisterValue.getInstance();
                break;
            }
            case 226: {
                mahoganyProtocol = BitBlt.getInstance();
                break;
            }
            case 227: {
                mahoganyProtocol = EnhanceBitBlt.getInstance();
                break;
            }
            case 230: {
                mahoganyProtocol = SetPalette.getInstance();
                break;
            }
            case 234: {
                mahoganyProtocol = SetTextCursor.getInstance();
                break;
            }
            case 235: {
                mahoganyProtocol = SpecialGraphicsBit.getInstance();
                break;
            }
            case 236: {
                mahoganyProtocol = MatroxGraphicsCursor.getInstance();
                break;
            }
            case 197: {
                mahoganyProtocol = MultiUserState.getInstance();
                break;
            }
            case 198: {
                mahoganyProtocol = ServerDisconnect.getInstance();
                break;
            }
            case 200: {
                mahoganyProtocol = ServerHandshake.getInstance();
                break;
            }
            case 201: {
                mahoganyProtocol = FirmwareVersion.getInstance();
                break;
            }
            case 213: {
                mahoganyProtocol = InformKeyIndicators.getInstance();
                break;
            }
            case 137: {
                mahoganyProtocol = StorageStatus.getInstance();
                break;
            }
            case 228: {
                mahoganyProtocol = StandbyPower.getInstance();
                break;
            }
            default: {
                StringBuffer stringBuffer = StringBufferPool.getInstance("Cannot load invalid protocol: ");
                StringBuffer stringBuffer2 = Helper.formatToHex((byte)n);
                stringBuffer.append(n);
                stringBuffer.append(" (");
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(")");
                String string = stringBuffer.toString();
                if (this.s_logger.isErrorLoggingEnabled()) {
                    this.s_logger.error(string);
                }
                StringBufferPool.recycle(stringBuffer2);
                StringBufferPool.recycle(stringBuffer);
                throw new BadException(string);
            }
        }
        return mahoganyProtocol;
    }

    protected void onInformKeyIndicators(Command command, BufferMgr bufferMgr) {
        InformKeyIndicators informKeyIndicators = (InformKeyIndicators)this.loadCommand(command, bufferMgr, this.m_cconn.isKeyboardEnabled());
        if (this.m_cconn.isKeyboardEnabled()) {
            Keyboard keyboard = KeyboardMgr.getInstance().getKeyboard();
            keyboard.informKeyIndicators(informKeyIndicators.getCapsLockState(), informKeyIndicators.getNumLockState(), informKeyIndicators.getScrollLockState());
        }
        informKeyIndicators.recycle();
    }

    protected void onMultiUserState(Command command, BufferMgr bufferMgr) {
        MultiUserState multiUserState = (MultiUserState)this.loadCommand(command, bufferMgr);
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        keyboardMgr.getCConn().onMultiUserState(multiUserState);
        multiUserState.recycle();
    }

    protected void onServerDisconnect(Command command, BufferMgr bufferMgr) {
        ServerDisconnect serverDisconnect = (ServerDisconnect)this.loadCommand(command, bufferMgr);
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        keyboardMgr.getCConn().onServerDisconnect(serverDisconnect.getReason(), serverDisconnect.getMessage());
        serverDisconnect.recycle();
    }

    protected void onServerHandshake(Command command, BufferMgr bufferMgr) {
        ServerHandshake serverHandshake = (ServerHandshake)this.loadCommand(command, bufferMgr);
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        keyboardMgr.getCConn().onServerHandshake(serverHandshake);
        serverHandshake.recycle();
    }

    protected void onFirmwareVersion(Command command, BufferMgr bufferMgr) {
        FirmwareVersion firmwareVersion = (FirmwareVersion)this.loadCommand(command, bufferMgr);
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        keyboardMgr.getCConn().onFirmwareVersion(firmwareVersion);
        firmwareVersion.recycle();
    }

    protected void onInformVesaMode(Command command, BufferMgr bufferMgr) {
        InformVesaMode informVesaMode = (InformVesaMode)this.loadCommand(command, bufferMgr, this.m_cconn.isVideoEnabled());
        if (this.m_cconn.isVideoEnabled()) {
            GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
            graphicsMgr.setVesaMode(informVesaMode.getModeNumber(), informVesaMode.getBpp(), informVesaMode.getWidth(), informVesaMode.getHeight());
        }
        informVesaMode.recycle();
    }

    protected void onBitBlt(Command command, BufferMgr bufferMgr) {
        BitBlt bitBlt = (BitBlt)this.loadCommand(command, bufferMgr, this.m_cconn.isVideoEnabled());
        if (this.m_cconn.isVideoEnabled()) {
            GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
            Region region = bitBlt.getDestinationRectangle();
            graphicsMgr.bitBlt(bitBlt.getBiltType(), bitBlt.getFontHeight(), bitBlt.getFontWidth(), region.getX(), region.getY(), region.getWidth(), region.getHeight(), bitBlt.getDataType(), bitBlt.getSize());
        }
        bitBlt.recycle();
    }

    protected void onEnhanceBitBlt(Command command, BufferMgr bufferMgr) {
        EnhanceBitBlt enhanceBitBlt = (EnhanceBitBlt)this.loadCommand(command, bufferMgr, this.m_cconn.isVideoEnabled());
        if (this.m_cconn.isVideoEnabled()) {
            GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
            graphicsMgr.enhanceBitBlt(enhanceBitBlt.getBiltType(), enhanceBitBlt.getTileWidth(), enhanceBitBlt.getTileHeight(), enhanceBitBlt.getTripletCode(), enhanceBitBlt.getRepeatCode(), enhanceBitBlt.getRawSize(), enhanceBitBlt.getScrunchSize(), enhanceBitBlt.getSnoopLowMap(), enhanceBitBlt.getSnoopHighMap(), enhanceBitBlt.getDataType());
        }
        enhanceBitBlt.recycle();
    }

    protected void onSetPalette(Command command, BufferMgr bufferMgr) {
        SetPalette setPalette = (SetPalette)this.loadCommand(command, bufferMgr, this.m_cconn.isVideoEnabled());
        if (this.m_cconn.isVideoEnabled()) {
            GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
            graphicsMgr.setPalette(setPalette.getPaletteSet(), setPalette.getAttributeSet(), setPalette.getPaletteSize(), setPalette.getAttributeSize());
        }
        setPalette.recycle();
    }

    protected void onSetTextCursor(Command command, BufferMgr bufferMgr) {
        SetTextCursor setTextCursor = (SetTextCursor)this.loadCommand(command, bufferMgr, this.m_cconn.isVideoEnabled());
        if (this.m_cconn.isVideoEnabled()) {
            GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
            graphicsMgr.setTextCursor(setTextCursor.getCursorX(), setTextCursor.getCursorY(), setTextCursor.getStartLine(), setTextCursor.getStopLine());
        }
        setTextCursor.recycle();
    }

    protected void onSpecialGraphicsBit(Command command, BufferMgr bufferMgr) {
        SpecialGraphicsBit specialGraphicsBit = (SpecialGraphicsBit)this.loadCommand(command, bufferMgr, this.m_cconn.isVideoEnabled());
        if (this.m_cconn.isVideoEnabled()) {
            GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
            graphicsMgr.blinkingText(specialGraphicsBit.isBlinkingText());
            graphicsMgr.dbeSwap(specialGraphicsBit.isSwapping(), specialGraphicsBit.getPrimarySelectOffset(), specialGraphicsBit.getSecondarySelectOffset());
            graphicsMgr.onSetBPP4ColorIndex(specialGraphicsBit.getBPP4ColorIndex());
        }
        specialGraphicsBit.recycle();
    }

    protected void onMatroxGraphicsCursor(Command command, BufferMgr bufferMgr) {
        MatroxGraphicsCursor matroxGraphicsCursor = (MatroxGraphicsCursor)this.loadCommand(command, bufferMgr, this.m_cconn.isVideoEnabled());
        if (this.m_cconn.isVideoEnabled()) {
            GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
            graphicsMgr.matroxGraphicsCursor(matroxGraphicsCursor.getControl(), matroxGraphicsCursor.getData(), matroxGraphicsCursor.getCursorMode());
        }
        matroxGraphicsCursor.recycle();
    }

    protected void onStandbyPower(Command command, BufferMgr bufferMgr) {
        MahoganyProtocol mahoganyProtocol = this.loadCommand(command, bufferMgr, this.m_cconn.isVideoEnabled());
        if (this.m_cconn.isVideoEnabled()) {
            GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
            graphicsMgr.standbyPower();
        }
        mahoganyProtocol.recycle();
    }

    protected void onStorageServerStatus(Command command, BufferMgr bufferMgr) {
        StorageStatus storageStatus = (StorageStatus)this.loadCommand(command, bufferMgr, this.m_cconn.isStorageEnabled());
        if (this.m_cconn.isStorageEnabled()) {
            KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
            keyboardMgr.getCConn().onStorageServerStatus(storageStatus);
        }
        storageStatus.recycle();
    }

    protected void onOtherCommand(Command command, BufferMgr bufferMgr) {
        block3: {
            try {
                MahoganyProtocol mahoganyProtocol = this.loadCommand(command, bufferMgr);
                if (mahoganyProtocol != null) {
                    mahoganyProtocol.recycle();
                }
            }
            catch (Exception exception) {
                if (!this.s_logger.isErrorLoggingEnabled()) break block3;
                StringBuffer stringBuffer = StringBufferPool.getInstance("Unknown command encountered: ");
                StringBuffer stringBuffer2 = Helper.formatToHex((byte)command.getDataType());
                stringBuffer.append(command.getDataType());
                stringBuffer.append(" (");
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(')');
                this.s_logger.error(stringBuffer.toString());
                StringBufferPool.recycle(stringBuffer);
                StringBufferPool.recycle(stringBuffer2);
                this.s_logger.error(exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

