/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.mahogany;

import com.serverengines.mahogany.CConn;
import com.serverengines.mahogany.DesktopWindow;
import com.serverengines.resmgr.SettingsResMgr;

public class MasterThread
extends Thread {
    public static final long SLEEP_TIME = 500L;
    public static final long MILI_SECONDS_PER_SECONDS = 1000L;
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final int NO_MASK = 0;
    public static final int CAPS_LOCK_MASK = 1;
    public static final int NUM_LOCK_MASK = 2;
    public static final int SCROLL_LOCK_MASK = 4;
    protected boolean m_isRunning;
    protected boolean m_isRunningTimeout;
    protected boolean m_isRunningBlinkingText;
    protected boolean m_isRunningClearLockKeys;
    protected CConn m_cconn;
    protected DesktopWindow m_desktop;
    protected long m_timeoutThreshold;
    protected int m_keysMask;

    public MasterThread(CConn cConn, DesktopWindow desktopWindow) {
        this.m_cconn = cConn;
        this.m_desktop = desktopWindow;
        this.m_isRunning = false;
        this.m_isRunningTimeout = false;
        this.m_isRunningBlinkingText = false;
        this.m_isRunningClearLockKeys = false;
        this.m_timeoutThreshold = 0L;
        this.m_keysMask = 0;
    }

    public void extendTimeout() {
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        long l = settingsResMgr.getResourceLong("session.timeout");
        this.m_timeoutThreshold = (l *= 60000L) + System.currentTimeMillis();
    }

    public boolean isRunning() {
        return this.m_isRunning;
    }

    public void setRunning(boolean bl) {
        this.m_isRunning = bl;
        if (!this.m_isRunning) {
            this.m_isRunningTimeout = false;
            this.m_isRunningBlinkingText = false;
            this.m_isRunningClearLockKeys = false;
        }
    }

    public boolean isRunningTimeout() {
        return this.m_isRunningTimeout;
    }

    public void setRunningTimeout(boolean bl) {
        this.m_isRunningTimeout = bl;
        if (this.m_isRunningTimeout) {
            this.extendTimeout();
        }
    }

    public int getKeysMask() {
        return this.m_keysMask;
    }

    public void setKeysMask(int n) {
        this.m_keysMask = n;
    }

    public boolean isRunningBlinkingText() {
        return this.m_isRunningBlinkingText;
    }

    public void setRunningBlinkingText(boolean bl) {
        this.m_isRunningBlinkingText = bl;
    }

    public boolean isRunningClearLockKeys() {
        return this.m_isRunningClearLockKeys;
    }

    public void setRunningClearLockKeys(boolean bl) {
        this.m_isRunningClearLockKeys = bl;
    }

    public void run() {
        this.m_isRunning = true;
        while (this.m_isRunning) {
            long l;
            try {
                MasterThread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_isRunningBlinkingText) {
                this.m_desktop.toggleBlinkingText();
            }
            if (this.m_isRunningClearLockKeys) {
                this.m_cconn.clearLockKeys(this.m_keysMask);
                this.m_isRunningClearLockKeys = false;
            }
            if (!this.m_isRunningTimeout || (l = System.currentTimeMillis()) <= this.m_timeoutThreshold) continue;
            this.m_cconn.closeFromTimeout();
            this.m_isRunningTimeout = false;
        }
    }
}

