/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.mahogany;

import com.serverengines.cookies.CookieException;
import com.serverengines.cookies.CookieMgr;
import com.serverengines.helper.ArrayListStringBufferPool;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.kvm.BoolParameter;
import com.serverengines.kvm.Configuration;
import com.serverengines.kvm.IntParameter;
import com.serverengines.kvm.LogWriter;
import com.serverengines.kvm.StringParameter;
import com.serverengines.mahogany.AboutDialog;
import com.serverengines.mahogany.CConn;
import com.serverengines.mahogany.IAppletCookieCallback;
import com.serverengines.mahogany.MsgBox;
import com.serverengines.resmgr.AppResMgr;
import com.serverengines.resmgr.ResourceMgr;
import com.serverengines.resmgr.SettingsResMgr;
import com.serverengines.resmgr.VersionResMgr;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JApplet;
import javax.swing.JPanel;

public class MahoganyViewer
extends JApplet
implements Runnable,
IAppletCookieCallback {
    static final long serialVersionUID = -2128257369160352334L;
    public static final String PARAM_IP_ADDRESS = "ipaddress";
    public static final String PARAM_USER_NAME = "username";
    public static final String PARAM_PASSWORD = "httpdata";
    public static final String PARAM_STORAGE_PORT = "port";
    public static final String PARAM_NONSECURE_KVM_PORT = "NonSecure_KVMPort";
    public static final String PARAM_NONSECURE_KM_PORT = "NonSecure_KMPort";
    public static final String PARAM_NONSECURE_V_PORT = "NonSecure_VPort";
    public static final String PARAM_SSL_VM_PORT = "SSL_VMPort";
    public static final String PARAM_SSL_K_PORT = "SSL_KPort";
    public static final String PARAM_SESSION_TYPE = "sessiontype";
    public static final String PARAM_LOGGING = "logging";
    public static final String NONSECURE_CONNECTION = "kvm";
    public static final String SECURE_CONNECTION = "kvmssl";
    public static final long SLEEP_TIME = 500L;
    public BoolParameter viewOnly = new BoolParameter("ViewOnly", "Don't send any mouse or keyboard events to the server", false);
    public BoolParameter alwaysShowServerDialog = new BoolParameter("AlwaysShowServerDialog", "Always show the server dialog even if a server has been specified in an applet parameter or on the command line", false);
    public BoolParameter mahoganyLogging = new BoolParameter("logging", "Turn logging messages on", false);
    public StringParameter mahoganyServerName = new StringParameter("ipaddress", "The Pilot server <host>", null);
    public StringParameter mahoganyServerPasswd = new StringParameter("httpdata", "The Mahogany User Passowrd", "");
    public StringParameter mahoganyServerUserName = new StringParameter("username", "The Mahogany User Name", "");
    public StringParameter mahoganySessionType = new StringParameter("sessiontype", "The Mahogany Session Type", "");
    public IntParameter mahoganyStorageServerPort = new IntParameter("port", "The Mahogany storage server port number", 5901);
    public IntParameter mahoganyNonSecureKVMPort = new IntParameter("NonSecure_KVMPort", "The Mahogany non secure KVM port number", 0);
    public IntParameter mahoganyNonSecureKMPort = new IntParameter("NonSecure_KMPort", "The Mahogany non secure KM port number", 0);
    public IntParameter mahoganyNonSecureVPort = new IntParameter("NonSecure_VPort", "The Mahogany non secure V port number", 0);
    public IntParameter mahoganySSLVMPort = new IntParameter("SSL_VMPort", "The Mahogany SSL VM port number", 0);
    public IntParameter mahoganySSLKPort = new IntParameter("SSL_KPort", "The Mahogany SSL K port number", 0);
    public static boolean applet = false;
    protected static boolean firstApplet = true;
    protected static int nViewers = 0;
    protected static LogWriter vlog = new LogWriter((class$com$serverengines$mahogany$MahoganyViewer == null ? (class$com$serverengines$mahogany$MahoganyViewer = MahoganyViewer.class$("com.serverengines.mahogany.MahoganyViewer")) : class$com$serverengines$mahogany$MahoganyViewer).getName());
    protected Thread thread;
    protected CConn cc;
    static /* synthetic */ Class class$com$serverengines$mahogany$MahoganyViewer;

    public static void main(String[] stringArray) {
        MahoganyViewer mahoganyViewer = new MahoganyViewer(stringArray);
        mahoganyViewer.start();
    }

    public MahoganyViewer(String[] stringArray) {
        applet = false;
        this.cc = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-log")) {
                if (++i >= stringArray.length) {
                    MahoganyViewer.usage();
                }
                if (vlog.isInfoLoggingEnabled()) {
                    StringBuffer stringBuffer = StringBufferPool.getInstance("Log setting: ");
                    stringBuffer.append(stringArray[i]);
                    vlog.info(stringBuffer.toString());
                    StringBufferPool.recycle(stringBuffer);
                }
                LogWriter.setLogParams(stringArray[i]);
                continue;
            }
            if (Configuration.setParam(stringArray[i])) continue;
            if (stringArray[i].charAt(0) == '-') {
                if (i + 1 < stringArray.length && Configuration.setParam(stringArray[i].substring(1), stringArray[i + 1])) {
                    ++i;
                    continue;
                }
                MahoganyViewer.usage();
            }
            if (this.mahoganyServerName.getValue() != null) {
                MahoganyViewer.usage();
            }
            this.mahoganyServerName.setParam(stringArray[i]);
        }
    }

    public static void usage() {
        if (vlog.isInfoLoggingEnabled()) {
            StringBuffer stringBuffer = StringBufferPool.getInstance("\nusage: MahoganyViewer [options/parameters] ");
            stringBuffer.append("[host:displayNum] [options/parameters]\n");
            stringBuffer.append('\n');
            stringBuffer.append("Options:\n");
            stringBuffer.append("  -log <level>    configure logging level\n");
            stringBuffer.append("Parameters can be turned on with -<param> or off with ");
            stringBuffer.append("-<param>=0\n");
            stringBuffer.append("Parameters which take a value can be specified as ");
            stringBuffer.append("-<param> <value>\n");
            stringBuffer.append("Other valid forms are <param>=<value> -<param>=<value> ");
            stringBuffer.append("--<param>=<value>\n");
            stringBuffer.append("Parameter names are case-insensitive.  The parameters ");
            stringBuffer.append("are:\n\n");
            stringBuffer.append(Configuration.listParams());
            vlog.info(stringBuffer.toString());
            StringBufferPool.recycle(stringBuffer);
        }
        System.exit(1);
    }

    public MahoganyViewer() {
        applet = true;
        firstApplet = true;
        this.cc = null;
    }

    public void init() {
        applet = true;
        SettingsResMgr.getInstance(this);
        this.setBackground(Color.white);
        JPanel jPanel = AboutDialog.getAboutPanel(null);
        this.getContentPane().add("Center", jPanel);
    }

    public String getAppletInfo() {
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        VersionResMgr versionResMgr = VersionResMgr.getInstance();
        StringBuffer stringBuffer = StringBufferPool.getInstance(versionResMgr.getResourceString("release.version"));
        ArrayList arrayList = ArrayListStringBufferPool.getInstance();
        arrayList.add(stringBuffer);
        StringBuffer stringBuffer2 = StringBufferPool.getInstance(versionResMgr.getResourceString("major.version"));
        arrayList.add(stringBuffer2);
        StringBuffer stringBuffer3 = StringBufferPool.getInstance(versionResMgr.getResourceString("minor.version"));
        arrayList.add(stringBuffer3);
        StringBuffer stringBuffer4 = StringBufferPool.getInstance(versionResMgr.getResourceString("build.number"));
        arrayList.add(stringBuffer4);
        String string = resourceMgr.getResourceString("about.dlg.text", arrayList);
        ArrayListStringBufferPool.recycle(arrayList);
        StringBufferPool.recycle(stringBuffer4);
        StringBufferPool.recycle(stringBuffer3);
        StringBufferPool.recycle(stringBuffer2);
        StringBufferPool.recycle(stringBuffer);
        return string;
    }

    public void start() {
        AppResMgr appResMgr = AppResMgr.getInstance();
        this.mahoganyNonSecureKVMPort.setParam(appResMgr.getResourceString("kvms.port"));
        this.mahoganyNonSecureKMPort.setParam(appResMgr.getResourceString("keyboard.port"));
        this.mahoganyNonSecureVPort.setParam(appResMgr.getResourceString("kvms.port"));
        this.mahoganySSLVMPort.setParam(appResMgr.getResourceString("kvms.port"));
        this.mahoganySSLKPort.setParam(appResMgr.getResourceString("keyboard.ssl.port"));
        if (applet) {
            String string = this.getParameter(PARAM_IP_ADDRESS);
            if (string != null) {
                this.mahoganyServerName.setParam(string);
            }
            if ((string = this.getParameter(PARAM_USER_NAME)) != null) {
                this.mahoganyServerUserName.setParam(string);
            }
            if ((string = this.getParameter(PARAM_PASSWORD)) != null) {
                this.mahoganyServerPasswd.setParam(string);
            }
            if ((string = this.getParameter(PARAM_STORAGE_PORT)) != null) {
                this.mahoganyStorageServerPort.setParam(string);
            }
            if ((string = this.getParameter(PARAM_NONSECURE_KVM_PORT)) != null) {
                this.mahoganyNonSecureKVMPort.setParam(string);
            }
            if ((string = this.getParameter(PARAM_NONSECURE_KM_PORT)) != null) {
                this.mahoganyNonSecureKMPort.setParam(string);
            }
            if ((string = this.getParameter(PARAM_NONSECURE_V_PORT)) != null) {
                this.mahoganyNonSecureVPort.setParam(string);
            }
            if ((string = this.getParameter(PARAM_SSL_VM_PORT)) != null) {
                this.mahoganySSLVMPort.setParam(string);
            }
            if ((string = this.getParameter(PARAM_SSL_K_PORT)) != null) {
                this.mahoganySSLKPort.setParam(string);
            }
            if ((string = this.getParameter(PARAM_SESSION_TYPE)) != null) {
                this.mahoganySessionType.setParam(string);
            }
            if ((string = this.getParameter(PARAM_LOGGING)) != null) {
                this.mahoganyLogging.setParam(string);
            }
        }
        ++nViewers;
        if (applet && firstApplet) {
            firstApplet = false;
            Configuration.readAppletParams(this);
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        block3: {
            try {
                if (this.cc != null) {
                    this.cc.setExitProperly(true);
                    this.cc.close();
                }
                super.stop();
            }
            catch (Throwable throwable) {
                if (!vlog.isErrorLoggingEnabled()) break block3;
                vlog.error(throwable);
            }
        }
    }

    public void run() {
        this.cc = null;
        try {
            this.cc = new CConn(this);
            this.cc.m_isRunning = true;
            if (this.cc.init(this.mahoganyServerName.getValue(), this.mahoganyServerUserName.getValue(), this.mahoganyServerPasswd.getValue(), this.alwaysShowServerDialog.getValue(), this.mahoganySessionType.getValue(), this.mahoganyStorageServerPort.getValue(), this.mahoganyNonSecureKVMPort.getValue(), this.mahoganyNonSecureKMPort.getValue(), this.mahoganyNonSecureVPort.getValue(), this.mahoganySSLVMPort.getValue(), this.mahoganySSLKPort.getValue())) {
                this.cc.startReceiverThread();
                while (this.cc.m_isRunning) {
                    Thread.sleep(500L);
                }
            }
        }
        catch (Throwable throwable) {
            if (vlog.isInfoLoggingEnabled()) {
                vlog.info(throwable);
            }
            if (this.cc != null) {
                this.cc.close();
            }
            if (this.cc == null || !this.cc.isExitingProperly()) {
                MsgBox.showErrorMsgBox(this, throwable.toString());
            }
            this.cc = null;
        }
        if (this.cc != null) {
            this.cc.close();
        }
        if (!applet && --nViewers == 0) {
            System.exit(0);
        }
    }

    public Map getCookies() {
        HashMap hashMap;
        block2: {
            hashMap = new HashMap();
            try {
                CookieMgr cookieMgr = CookieMgr.getInstance(this);
                cookieMgr.getCookies(hashMap);
                cookieMgr.recycle();
            }
            catch (CookieException cookieException) {
                if (!vlog.isErrorLoggingEnabled()) break block2;
                vlog.error("Error loading cookies:");
                vlog.error(cookieException);
            }
        }
        return hashMap;
    }

    public void writeCookies(Properties properties) {
        block2: {
            try {
                CookieMgr cookieMgr = CookieMgr.getInstance(this);
                cookieMgr.writeCookies(properties);
                cookieMgr.recycle();
            }
            catch (CookieException cookieException) {
                if (!vlog.isErrorLoggingEnabled()) break block2;
                vlog.error("Error writing for setting cookies:");
                vlog.error(cookieException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

