/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.mahogany;

import com.serverengines.buffer.Buffers;
import com.serverengines.graphics.DecodedMouseCursor;
import com.serverengines.graphics.GraphicsMgr;
import com.serverengines.helper.Helper;
import com.serverengines.helper.RectanglePool;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.kvm.LogWriter;
import com.serverengines.mahogany.CConn;
import com.serverengines.mahogany.MasterThread;
import com.serverengines.mahogany.MessageSender;
import com.serverengines.mahogany.PixelBufferImage;
import com.serverengines.mahogany.ViewportFrame;
import com.serverengines.mahoganyprotocol.Attribute;
import com.serverengines.mahoganyprotocol.ButtonState;
import com.serverengines.mahoganyprotocol.Palette;
import com.serverengines.mahoganyprotocol.Region;
import com.serverengines.mouse.MouseMgr;
import com.serverengines.resmgr.SettingsResMgr;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.JLabel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class DesktopWindow
extends JLabel
implements Scrollable,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    static final long serialVersionUID = 2716108028592125235L;
    static LogWriter vlog = new LogWriter((class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow).getName());
    public static final int SYNCH_X_VAL = 4;
    public static final int SYNCH_Y_VAL = 4;
    public static final String KEYBOARD_DIR = "keyboard/";
    public static final String HIDDEN_CURSOR = "hiddenCursor";
    public static final String HIDDEN_IMAGE = "blank_10x10.gif";
    protected MouseMgr m_mouseMgr;
    protected ViewportFrame m_viewport;
    protected MasterThread m_masterThread;
    protected CConn cc;
    protected PixelBufferImage im;
    protected boolean invalidRect;
    protected int invalidLeft;
    protected int invalidRight;
    protected int invalidTop;
    protected int invalidBottom;
    protected boolean m_isBlinking;
    protected boolean m_isCursorBlinking;
    protected int m_blinkCount;
    static /* synthetic */ Class class$com$serverengines$mahogany$DesktopWindow;

    public DesktopWindow(CConn cConn) {
        this.cc = cConn;
        if (vlog.isDebugLoggingEnabled()) {
            vlog.debug("DesktopWindow - constructor.");
        }
        this.setFocusTraversalKeysEnabled(false);
        this.setAutoscrolls(true);
        this.m_masterThread = null;
        this.m_viewport = null;
        this.invalidRect = false;
        this.m_isBlinking = false;
        this.m_isCursorBlinking = false;
        this.m_blinkCount = 0;
        this.im = new PixelBufferImage(this.cc.width, this.cc.height, this);
        this.m_mouseMgr = MouseMgr.getInstance();
        GraphicsMgr graphicsMgr = GraphicsMgr.getInstance();
        graphicsMgr.setDesktop(this, this.im, this.cc);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public void initDesktop() {
        MessageSender.requestKeyIndicators();
    }

    public CConn getCConn() {
        return this.cc;
    }

    public void setViewport(ViewportFrame viewportFrame) {
        if (this.m_viewport != null) {
            this.m_viewport = viewportFrame;
        }
    }

    public void recycle() {
        this.removeKeyListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseWheelListener(this);
    }

    public void incrementFrameCounter(int n, int n2) {
        this.cc.incrementFrameCounter(n, n2);
    }

    public void sendMouseState() {
        if (!this.cc.viewer.viewOnly.getValue()) {
            MouseMgr mouseMgr = MouseMgr.getInstance();
            mouseMgr.sendMouseState();
        }
    }

    public void toggleMouse() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DesktopWindow.this.setWinCursor();
            }
        });
    }

    protected boolean isStorageOnly() {
        return !this.cc.isKeyboardEnabled() && !this.cc.isVideoEnabled() && !this.cc.isMouseEnabled() && this.cc.isStorageEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setWinSize() {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            Graphics graphics;
            if (vlog.isDebugLoggingEnabled()) {
                vlog.debug("DesktopWindow.setWinSize() called");
            }
            int n = this.cc.width;
            int n2 = this.cc.height;
            this.setSize(n, n2);
            this.setPreferredSize(new Dimension(n, n2));
            this.revalidate();
            this.im.resize(n, n2, this);
            if (this.cc.viewport != null) {
                this.cc.viewport.pack();
            }
            if ((graphics = this.getGraphics()) != null) {
                graphics.drawImage(this.im.image, 0, 0, null);
            }
        }
    }

    protected void setVesaWinSize() {
        this.setWinSize();
        Region[] regionArray = new Region[]{Region.getInstance((short)0, (short)0, (short)this.im.getScreenFormat().getScreenWidth(), (short)this.im.getScreenFormat().getScreenHeight())};
        MessageSender.invalidate(regionArray);
        regionArray[0].recycle();
        this.blinkingText(this.m_isBlinking);
        this.cc.setSocketReadable(true);
    }

    protected void setWinCursor() {
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        int n = settingsResMgr.getResourceInt("mouse.mode");
        if (n == 0) {
            StringBuffer stringBuffer = StringBufferPool.getInstance(KEYBOARD_DIR);
            Helper.makeRelativePath(stringBuffer);
            stringBuffer.append(HIDDEN_IMAGE);
            Toolkit toolkit = Helper.getToolkit();
            Image image = Helper.getIcon(stringBuffer).getImage();
            Cursor cursor = toolkit.createCustomCursor(image, new Point(0, 0), HIDDEN_CURSOR);
            this.setCursor(cursor);
            StringBufferPool.recycle(stringBuffer);
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize() {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DesktopWindow.this.setWinSize();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vesaResize() {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            this.cc.setSocketReadable(false);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DesktopWindow.this.setVesaWinSize();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void drawInvalidRect() {
        if (!this.invalidRect) {
            return;
        }
        int n = this.invalidLeft;
        int n2 = this.invalidRight - n;
        int n3 = this.invalidTop;
        int n4 = this.invalidBottom - n3;
        this.invalidRect = false;
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            this.repaint(n, n3, n2, n4);
        }
    }

    public final void invalidate(int n, int n2, int n3, int n4) {
        if (this.invalidRect) {
            if (n < this.invalidLeft) {
                this.invalidLeft = n;
            }
            if (n + n3 > this.invalidRight) {
                this.invalidRight = n + n3;
            }
            if (n2 < this.invalidTop) {
                this.invalidTop = n2;
            }
            if (n2 + n4 > this.invalidBottom) {
                this.invalidBottom = n2 + n4;
            }
        } else {
            this.invalidLeft = n;
            this.invalidRight = n + n3;
            this.invalidTop = n2;
            this.invalidBottom = n2 + n4;
            this.invalidRect = true;
        }
        if ((this.invalidRight - this.invalidLeft) * (this.invalidBottom - this.invalidTop) > 100000) {
            this.drawInvalidRect();
        }
    }

    public void endRect() {
        this.drawInvalidRect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextMode(short s) {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            this.im.setTextMode(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            return new Dimension(this.im.width(), this.im.height());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMinimumSize() {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            return new Dimension(this.im.width(), this.im.height());
        }
    }

    public void update(Graphics graphics) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            if (this.im != null && this.im.getScreenMode() != -1) {
                Rectangle rectangle = RectanglePool.getInstance();
                graphics.getClipBounds(rectangle);
                this.im.put(rectangle.x, rectangle.y, rectangle.width, rectangle.height, graphics);
                RectanglePool.recycle(rectangle);
            } else {
                this.setBackground(Color.BLACK);
                this.setForeground(Color.WHITE);
                super.paint(graphics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent mouseEvent) {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            if (this.cc.state() != 1 || !this.cc.isMouseEnabled()) {
                return;
            }
            Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 1, 1);
            this.scrollRectToVisible(rectangle);
            this.mouseMoved(mouseEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseMoved(MouseEvent mouseEvent) {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            if (this.cc.state() != 1) {
                return;
            }
            this.cc.updateTimeoutThread();
            if (!this.cc.isMouseEnabled()) {
                return;
            }
            if (!this.cc.viewer.viewOnly.getValue()) {
                if (mouseEvent.getX() < 4 && mouseEvent.getY() < 4) {
                    this.synchMouse(mouseEvent.getX(), mouseEvent.getY());
                }
                if (mouseEvent.getID() == 503) {
                    this.m_mouseMgr.mouseMoved(mouseEvent);
                } else {
                    this.m_mouseMgr.mouseDragged(mouseEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            if (this.cc.state() != 1) {
                return;
            }
            this.cc.updateTimeoutThread();
            if (!this.cc.isMouseEnabled()) {
                return;
            }
            if (!this.cc.viewer.viewOnly.getValue()) {
                this.m_mouseMgr.mouseWheelMoved(mouseWheelEvent);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.m_viewport != null) {
            this.m_viewport.onMouseSync();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent mouseEvent) {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            if (this.cc.state() != 1) {
                return;
            }
            this.cc.updateTimeoutThread();
            if (!this.cc.isMouseEnabled()) {
                return;
            }
            if (!this.cc.viewer.viewOnly.getValue()) {
                this.m_mouseMgr.mousePressed(mouseEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            if (this.cc.state() != 1) {
                return;
            }
            this.cc.updateTimeoutThread();
            if (!this.cc.isMouseEnabled()) {
                return;
            }
            if (!this.cc.viewer.viewOnly.getValue()) {
                this.m_mouseMgr.mouseReleased(mouseEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(KeyEvent keyEvent) {
        if (vlog.isDebugLoggingEnabled()) {
            vlog.debug("keyPressed - Key pressed.");
        }
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            if (this.cc.state() != 1) {
                return;
            }
            this.cc.updateTimeoutThread();
            if (!this.cc.isKeyboardEnabled()) {
                return;
            }
            if (!this.cc.viewer.viewOnly.getValue()) {
                this.cc.onKeyPressed(keyEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyReleased(KeyEvent keyEvent) {
        if (vlog.isDebugLoggingEnabled()) {
            vlog.debug("keyReleased - Key released.");
        }
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            if (this.cc.state() != 1) {
                return;
            }
            this.cc.updateTimeoutThread();
            if (keyEvent.getKeyCode() == 48 && keyEvent.isControlDown() && keyEvent.isAltDown() && this.unsetMouseTrap()) {
                return;
            }
            if (!this.cc.isKeyboardEnabled()) {
                return;
            }
            if (!this.cc.viewer.viewOnly.getValue()) {
                this.cc.onKeyReleased(keyEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyTyped(KeyEvent keyEvent) {
        if (vlog.isDebugLoggingEnabled()) {
            vlog.debug("keyTyped - Key typed.");
        }
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            if (this.cc.state() != 1) {
                return;
            }
            this.cc.updateTimeoutThread();
            if (!this.cc.isKeyboardEnabled()) {
                return;
            }
            if (!this.cc.viewer.viewOnly.getValue()) {
                this.cc.onKeyTyped(keyEvent);
            }
        }
    }

    public boolean unsetMouseTrap() {
        MouseMgr mouseMgr = MouseMgr.getInstance();
        boolean bl = false;
        if (mouseMgr.getId() == 0) {
            if (vlog.isDebugLoggingEnabled()) {
                vlog.debug("Undoing mouse trap");
            }
            mouseMgr.useRelativeMode();
            SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
            settingsResMgr.setResourceValue("mouse.mode", mouseMgr.getId());
            settingsResMgr.writeResource();
            this.cc.toggleMouseEscape();
            this.cc.synchMouse();
            bl = true;
        }
        return bl;
    }

    public void synchMouse(int n, int n2) {
        if (this.cc.isMouseEnabled() && !this.cc.viewer.viewOnly.getValue()) {
            ButtonState[] buttonStateArray = new ButtonState[3];
            for (int i = 0; i < buttonStateArray.length; ++i) {
                buttonStateArray[i] = ButtonState.getInstance();
            }
            MessageSender.buttonStateAtAbsolute((short)n, (short)n2, buttonStateArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVesaMode(short s, short s2, short s3, short s4) {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            MouseMgr mouseMgr = MouseMgr.getInstance();
            this.cc.viewport.sp.getHorizontalScrollBar().setValue(0);
            this.cc.viewport.sp.getVerticalScrollBar().setValue(0);
            this.cc.width = s3;
            this.cc.height = s4;
            this.cc.setStandbyPower(false);
            this.im.setVesaMode(s, s2, s3, s4);
            this.vesaResize();
            if (mouseMgr.isAllowMouseSynchOnModeChg()) {
                this.cc.viewport.onMouseSync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPalette(Palette[] paletteArray, Attribute[] attributeArray, short s, short s2) {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            if (this.im.setPalette(paletteArray, attributeArray, s, s2) && this.im.getScreenFormat().getBpp() < 15) {
                this.invalidate(0, 0, this.im.getScreenFormat().getScreenWidthPixel(), this.im.getScreenFormat().getScreenHeightPixel());
                this.endRect();
            }
        }
    }

    public void loadMasterThread() {
        if (this.m_masterThread == null) {
            this.m_masterThread = this.cc.getMasterThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextCursor(int n, int n2, int n3, int n4) {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            if (n < this.im.getScreenFormat().getScreenWidth() && n2 < this.im.getScreenFormat().getScreenHeight() && (n3 == n4 || n4 < this.im.getScreenFormat().getFontHeight())) {
                if (!this.m_isCursorBlinking && n3 != n4) {
                    ++this.m_blinkCount;
                } else if (this.m_isCursorBlinking && n3 == n4) {
                    --this.m_blinkCount;
                }
                this.m_isCursorBlinking = n3 != n4;
                this.im.clearPrevTextCursor(this);
                this.im.setTextCursor(n, n2, n3, n4);
                int n5 = this.im.getScreenFormat().getFontWidth();
                int n6 = this.im.getScreenFormat().getFontHeight();
                int n7 = n * n5;
                int n8 = n2 * n6;
                this.invalidate(n7, n8, n5, n6);
                this.endRect();
                this.loadMasterThread();
                if (this.im.isInTextMode()) {
                    if (this.m_isCursorBlinking) {
                        if (!this.m_masterThread.isRunningBlinkingText()) {
                            this.m_masterThread.setRunningBlinkingText(true);
                        }
                    } else if (this.m_blinkCount < 1 && this.m_masterThread.isRunningBlinkingText()) {
                        this.m_masterThread.setRunningBlinkingText(false);
                    }
                } else if (this.m_masterThread.isRunningBlinkingText()) {
                    this.m_masterThread.setRunningBlinkingText(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blinkingText(boolean bl) {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            if (bl && !this.m_isBlinking) {
                ++this.m_blinkCount;
            } else if (!bl && this.m_isBlinking) {
                --this.m_blinkCount;
            }
            this.m_isBlinking = bl;
            this.im.setBlinking(this.m_isBlinking);
            this.loadMasterThread();
            if (this.im.isInTextMode()) {
                if (this.m_isBlinking) {
                    if (!this.m_masterThread.isRunningBlinkingText()) {
                        this.m_masterThread.setRunningBlinkingText(true);
                    }
                } else if (this.m_blinkCount < 1 && this.m_masterThread.isRunningBlinkingText()) {
                    this.m_masterThread.setRunningBlinkingText(false);
                }
            } else if (this.m_masterThread.isRunningBlinkingText()) {
                this.m_masterThread.setRunningBlinkingText(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dbeSwap(boolean bl, int n, int n2) {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            this.im.dbeSwap(bl, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSetBPP4ColorIndex(int n) {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            if (n != this.im.getColorIndex()) {
                this.im.onSetBPP4ColorIndex(n);
                this.invalidate(0, 0, this.im.getScreenFormat().getScreenWidthPixel(), this.im.getScreenFormat().getScreenHeightPixel());
                this.endRect();
            }
        }
    }

    public void matroxGraphicsCursor(byte[] byArray, byte[][] byArray2, byte by) {
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        int n = settingsResMgr.getResourceInt("mouse.mode");
        if (n == 0) {
            this.toggleMouse();
        } else if (by >= 1 && by <= 4) {
            DecodedMouseCursor decodedMouseCursor = DecodedMouseCursor.getInstance(byArray, byArray2, by);
            IndexColorModel indexColorModel = new IndexColorModel(8, 17, decodedMouseCursor.getReds(), decodedMouseCursor.getGreens(), decodedMouseCursor.getBlues(), 16);
            MemoryImageSource memoryImageSource = new MemoryImageSource(64, 64, (ColorModel)indexColorModel, decodedMouseCursor.GetColorPositionInfoArray(), 0, 64);
            decodedMouseCursor.recycle();
            Image image = this.createImage(memoryImageSource);
            Toolkit toolkit = Helper.getToolkit();
            Cursor cursor = toolkit.createCustomCursor(image, new Point(10, 10), "custom0");
            this.setCursor(cursor);
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleBlinkingText() {
        Class clazz = class$com$serverengines$mahogany$DesktopWindow == null ? (class$com$serverengines$mahogany$DesktopWindow = DesktopWindow.class$("com.serverengines.mahogany.DesktopWindow")) : class$com$serverengines$mahogany$DesktopWindow;
        synchronized (clazz) {
            this.im.toggleBlinkingText(Buffers.m_attributeScreen);
            this.im.convertAttributesToPalette(0, 0, this.im.getScreenFormat().getScreenWidthPixel(), this.im.getScreenFormat().getScreenHeightPixel());
            this.invalidate(0, 0, this.im.getScreenFormat().getScreenWidthPixel(), this.im.getScreenFormat().getScreenHeightPixel());
            this.endRect();
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 1;
    }

    public void refresh() {
        MessageSender.requestVesaMode();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

