/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.mahogany;

import com.serverengines.buffer.Buffers;
import com.serverengines.buffer.LittleEndianBufferMgr;
import com.serverengines.helper.ArrayListStringBufferPool;
import com.serverengines.helper.CalendarPool;
import com.serverengines.helper.Helper;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.keyboard.Keyboard;
import com.serverengines.keyboard.KeyboardMgr;
import com.serverengines.keyboard.LoadKeyboardImagesThread;
import com.serverengines.kvm.CConnection;
import com.serverengines.kvm.LogWriter;
import com.serverengines.mahogany.AboutDialog;
import com.serverengines.mahogany.DesktopWindow;
import com.serverengines.mahogany.DisconnectSessionDialog;
import com.serverengines.mahogany.FrameCtThread;
import com.serverengines.mahogany.IOKCancelDlgCallback;
import com.serverengines.mahogany.IOKDlgCallback;
import com.serverengines.mahogany.MahoganyViewer;
import com.serverengines.mahogany.MasterThread;
import com.serverengines.mahogany.MessageReceiverThread;
import com.serverengines.mahogany.MessageSender;
import com.serverengines.mahogany.ModallessOKCancelDlg;
import com.serverengines.mahogany.ModallessOKMsgDlg;
import com.serverengines.mahogany.MsgBox;
import com.serverengines.mahogany.PerformanceDialog;
import com.serverengines.mahogany.ServerDialog;
import com.serverengines.mahogany.ServerEgninesTrustManager;
import com.serverengines.mahogany.SettingsDialog;
import com.serverengines.mahogany.StartDeviceDiscoveryThread;
import com.serverengines.mahogany.StorageDiscoveryThread;
import com.serverengines.mahogany.ViewportFrame;
import com.serverengines.mahoganyprotocol.FirmwareVersion;
import com.serverengines.mahoganyprotocol.MultiUserState;
import com.serverengines.mahoganyprotocol.ServerHandshake;
import com.serverengines.mahoganyprotocol.StorageMsgRequest;
import com.serverengines.mahoganyprotocol.StorageStatus;
import com.serverengines.mahoganyprotocol.User;
import com.serverengines.mouse.MouseMgr;
import com.serverengines.nativeinterface.LUD;
import com.serverengines.rdr.JavaInStream;
import com.serverengines.rdr.JavaOutStream;
import com.serverengines.resmgr.AbstractResourceMgr;
import com.serverengines.resmgr.AbstractResourceWriter;
import com.serverengines.resmgr.KeyMappingResMgr;
import com.serverengines.resmgr.ResourceMgr;
import com.serverengines.resmgr.SettingsResMgr;
import com.serverengines.resmgr.VersionResMgr;
import com.serverengines.storage.MountedDriveMgr;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;

public class CConn
extends CConnection
implements IOKCancelDlgCallback,
IOKDlgCallback {
    public static final int DEFAULT_STOARGE_PORT = 5901;
    public static final int DEFAULT_DEVICE_STORAGE_PORT = 5901;
    public static final int MAX_USER_NAME_LEN = 16;
    public static final int MAX_PWD_LEN = 20;
    public static final int MAX_FULL_PWD_LEN = 128;
    public static final int SOCKET_TIME_OUT = 20;
    public static final int INVALID_THRESHOLD_VALUE = 0x40000000;
    public static final int NO_ALT_TEXT = 0;
    public static final int ALT_0_TEXT = 1;
    public static final int INITIAL_HEADER_SIZE = 19;
    public static final int HEADER_OFFSET_BYTES_TO_READ = 9;
    public static final int BYTES_TO_READ_LEN = 8;
    public static final int DEVICE_TYPE_LEN = 3;
    public static final int HEX_RADIX = 16;
    public static final int CONNECTION_RETRIES = 3;
    public static final int INIT_STORAGE_SLEEP_TIME = 250;
    public static final String LINE_DELIMINATOR = "\n";
    public static final int CHMOD_NUM_CMD_LINE = 3;
    public static final String CHMOD_EXE_NAME = "chmod";
    public static final String CHMOD_PERMSSION = "774";
    public static final int KVM_EXE_NUM_CMD_LINE = 6;
    public static final String KVM_CMD_LINE_OPTION = "-integratedkvm";
    public static final int SUCCESS_RETURN_CODE = 0;
    public static final String HTTP_HEADER = "http:/";
    public static final String HTTPS_HEADER = "https:/";
    public static final char COLON = ':';
    public static final String[] ILLEGAL_FILE_CHARS = new String[]{":", "/", "\\", "*", "?", "|", ">", "<", "&"};
    public static final String ILLEGAL_FILE_CHAR_TO_RPLACE = "_";
    public static final String LOCAL_HOST_ADDR = "127.0.0.1";
    private static LogWriter vlog = new LogWriter((class$com$serverengines$mahogany$CConn == null ? (class$com$serverengines$mahogany$CConn = CConn.class$("com.serverengines.mahogany.CConn")) : class$com$serverengines$mahogany$CConn).getName());
    protected int CurrentLocalMonitorSetting;
    protected boolean m_isLocalScreenOn;
    protected ModallessOKMsgDlg m_secondaryControlDlg;
    protected ModallessOKMsgDlg m_newConnectionDlg;
    protected ModallessOKMsgDlg m_stoargeStatusDlg;
    protected ModallessOKMsgDlg m_kvmExeFailedDlg;
    protected ModallessOKMsgDlg m_msgDlg;
    protected boolean m_exitProperly;
    protected boolean m_alraedyExited;
    protected int m_reasonForExiting;
    protected Robot m_robot;
    protected int m_currentFrameCt;
    protected int m_xFrameCtThreshold;
    protected int m_yFrameCtThreshold;
    protected String m_hostAddress;
    InetAddress serverHost;
    int serverPort;
    protected int m_requiredKeyboardPort;
    protected int m_requiredKeyboardSecurePort;
    protected boolean m_isEmbeddedApplet;
    protected String m_userName;
    protected char[] m_password;
    protected char[] m_passwordFull;
    protected User[] m_prevUsers;
    protected User[] m_curUsers;
    protected String m_hostName;
    protected String m_firmwareVersion;
    protected String m_storageBaseVersion;
    protected Socket sock;
    protected Socket m_storageDiscoverySocket;
    protected JavaInStream jis;
    protected JavaOutStream jos;
    protected JavaInStream m_storageDiscoveryJis;
    protected JavaOutStream m_storageDiscoveryJos;
    MahoganyViewer viewer;
    DesktopWindow desktop;
    ViewportFrame viewport;
    protected boolean shuttingDown;
    boolean m_isRunning;
    protected String m_sessionType;
    protected int m_permssionMode;
    protected int m_storagePort;
    protected boolean m_isHLevelCompressionOn;
    protected boolean m_isEncyptionOn;
    protected boolean m_hasFullControl;
    protected boolean m_prevHasFullControl;
    protected boolean m_canTakeFullControl;
    protected boolean m_prevCanTakeFullControl;
    protected boolean m_canDisconnectOthers;
    protected boolean m_isStorageEnabled;
    protected boolean m_isExeStorageSupported;
    protected boolean m_isExeForKVM;
    protected boolean m_isStorageWorking;
    protected boolean m_canDoRemoteStorage;
    protected boolean m_canDoStorageWrite;
    protected boolean m_canRelinquishFullControl;
    protected boolean m_justRelinquishFullControl;
    protected boolean m_canChangeLMS;
    protected boolean m_canTurnScreenOn;
    protected boolean m_canTurnScreenOff;
    protected boolean m_isDVDRomDeviceAllowed;
    protected boolean m_isMemoryDeviceAllowed;
    protected boolean m_ignoreCapsLock;
    protected boolean m_ignoreNumLock;
    protected boolean m_ignoreScrollLock;
    protected boolean m_receivedMultiUserMessage;
    protected boolean m_loadedStorageSupport;
    protected boolean m_receivedFirmwareVersion;
    protected boolean m_allowTimeoutThread;
    protected boolean m_isTimingDown;
    protected boolean m_isKeyboardEnabled;
    protected boolean m_isVideoEnabled;
    protected boolean m_isMouseEnabled;
    protected boolean m_isForcedHLevelState;
    protected boolean m_isStandbyPower;
    protected boolean m_isSSLConnection;
    protected MessageReceiverThread m_msgRecvThread;
    protected MasterThread m_masterThread;
    protected FrameCtThread m_frameCtThread;
    protected StorageDiscoveryThread m_storageDiscoveryThread;
    protected StartDeviceDiscoveryThread m_startStorageThread;
    protected Thread m_mainThread;
    protected int m_startWidthViewport;
    protected int m_startHeightViewport;
    protected int m_altText;
    protected HashSet m_keysPressedDownSet;
    protected HashSet m_keysTypedSet;
    protected HashSet m_asciiKeysSet;
    protected PerformanceDialog m_performanceDlg;
    protected AboutDialog m_aboutDlg;
    protected SettingsDialog m_settingsDlg;
    protected DisconnectSessionDialog m_DisconnectSessionDialog;
    protected ModallessOKCancelDlg m_requestDlg;
    protected ModallessOKCancelDlg m_sessionRequestDlg;
    static /* synthetic */ Class class$com$serverengines$mahogany$CConn;

    public CConn(MahoganyViewer mahoganyViewer) {
        int n;
        this.viewer = mahoganyViewer;
        this.m_permssionMode = 1;
        this.shuttingDown = false;
        this.m_alraedyExited = false;
        this.m_isHLevelCompressionOn = false;
        this.m_isEncyptionOn = false;
        this.m_hasFullControl = false;
        this.m_prevHasFullControl = false;
        this.m_canTakeFullControl = false;
        this.m_prevCanTakeFullControl = false;
        this.m_canDisconnectOthers = false;
        this.m_isStorageEnabled = false;
        this.m_isExeStorageSupported = false;
        this.m_isExeForKVM = false;
        this.m_canDoRemoteStorage = false;
        this.m_canDoStorageWrite = false;
        this.m_canRelinquishFullControl = false;
        this.m_justRelinquishFullControl = false;
        this.m_canChangeLMS = false;
        this.m_canTurnScreenOn = false;
        this.m_canTurnScreenOff = false;
        this.m_ignoreCapsLock = false;
        this.m_ignoreNumLock = false;
        this.m_ignoreScrollLock = false;
        this.m_receivedMultiUserMessage = false;
        this.m_loadedStorageSupport = false;
        this.m_receivedFirmwareVersion = false;
        this.m_exitProperly = false;
        this.m_isDVDRomDeviceAllowed = false;
        this.m_isMemoryDeviceAllowed = false;
        this.m_allowTimeoutThread = false;
        this.m_isKeyboardEnabled = false;
        this.m_isVideoEnabled = false;
        this.m_isMouseEnabled = false;
        this.m_isForcedHLevelState = false;
        this.m_isStandbyPower = false;
        this.m_isSSLConnection = false;
        this.m_isEmbeddedApplet = false;
        this.m_isRunning = true;
        this.m_isTimingDown = true;
        this.m_isStorageWorking = true;
        this.m_isLocalScreenOn = true;
        this.m_storagePort = this.viewer.mahoganyStorageServerPort.getValue();
        this.m_requiredKeyboardPort = 0;
        this.CurrentLocalMonitorSetting = 15;
        this.m_startWidthViewport = 0;
        this.m_startHeightViewport = 0;
        this.m_reasonForExiting = 2;
        this.desktop = null;
        this.m_sessionType = null;
        this.sock = null;
        this.m_storageDiscoverySocket = null;
        this.jis = null;
        this.jos = null;
        this.m_storageDiscoveryJis = null;
        this.m_storageDiscoveryJos = null;
        this.m_password = null;
        this.m_passwordFull = null;
        this.m_performanceDlg = null;
        this.m_aboutDlg = null;
        this.m_settingsDlg = null;
        this.m_requestDlg = null;
        this.m_sessionRequestDlg = null;
        this.m_DisconnectSessionDialog = null;
        this.m_masterThread = null;
        this.m_frameCtThread = null;
        this.m_storageDiscoveryThread = null;
        this.m_startStorageThread = null;
        this.m_secondaryControlDlg = null;
        this.m_newConnectionDlg = null;
        this.m_stoargeStatusDlg = null;
        this.m_kvmExeFailedDlg = null;
        this.m_msgDlg = null;
        this.m_currentFrameCt = 0;
        this.m_prevUsers = new User[2];
        this.m_altText = 0;
        this.m_userName = "";
        this.m_hostName = "";
        this.m_hostAddress = "";
        this.m_mainThread = Thread.currentThread();
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        this.m_firmwareVersion = resourceMgr.getResourceString("about.firmware.unknown");
        this.m_storageBaseVersion = "";
        for (n = 0; n < this.m_prevUsers.length; ++n) {
            this.m_prevUsers[n] = User.getInstance();
        }
        this.m_curUsers = new User[2];
        for (n = 0; n < this.m_curUsers.length; ++n) {
            this.m_curUsers[n] = User.getInstance();
        }
        this.m_keysPressedDownSet = new HashSet();
        this.m_keysTypedSet = new HashSet();
        this.m_asciiKeysSet = new HashSet();
        this.m_msgRecvThread = new MessageReceiverThread(this);
        try {
            this.m_robot = new Robot();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DesktopWindow getDesktop() {
        return this.desktop;
    }

    public void startReceiverThread() {
        this.m_msgRecvThread.start();
    }

    public void initFrameCt() {
        this.m_currentFrameCt = 0;
        this.m_xFrameCtThreshold = 0x40000000;
        this.m_yFrameCtThreshold = 0x40000000;
        if (this.m_performanceDlg != null) {
            this.m_performanceDlg.clearValues();
        }
    }

    public String getFirmwareVersion() {
        return this.m_firmwareVersion;
    }

    public String getStorageDirectory() {
        return this.m_storageBaseVersion;
    }

    public void centerMouse() {
        if (this.viewport != null) {
            int n;
            if (this.m_startWidthViewport == 0) {
                this.m_startWidthViewport = this.viewport.getStartWidth();
            }
            if (this.m_startHeightViewport == 0) {
                this.m_startHeightViewport = this.viewport.getStartHeight();
            }
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            int n2 = 0;
            int n3 = Integer.MAX_VALUE;
            if (graphicsDeviceArray != null) {
                for (n = 0; n < graphicsDeviceArray.length; ++n) {
                    Rectangle rectangle = graphicsDeviceArray[n].getDefaultConfiguration().getBounds();
                    n2 += rectangle.width;
                    if (n3 <= rectangle.height) continue;
                    n3 = rectangle.height;
                }
            }
            n = this.viewport.getX() + this.m_startWidthViewport;
            int n4 = n + (this.width >> 1);
            int n5 = this.viewport.getY() + this.m_startHeightViewport;
            int n6 = n5 + (this.height >> 1);
            if (n4 < 0) {
                n4 = this.width + this.viewport.getX() >> 1;
            }
            if (n6 < 0) {
                n6 = this.height + this.viewport.getY() >> 1;
            }
            if (n4 >= n2) {
                n4 = n2 + n >> 1;
            }
            if (n6 >= n3) {
                n6 = n3 + n5 >> 1;
            }
            this.m_robot.mouseMove(n4, n6);
        }
    }

    public void toggleMouseEscape() {
        if (this.hasFullControl()) {
            MouseMgr mouseMgr = MouseMgr.getInstance();
            mouseMgr.sendMouseState();
        }
        if (this.viewport != null) {
            this.viewport.toggleMouseEscape();
        }
    }

    public void synchMouse() {
        if (this.viewport != null) {
            this.viewport.onMouseSync();
        }
    }

    public boolean isKeyboardEnabled() {
        return this.m_isKeyboardEnabled;
    }

    public boolean isVideoEnabled() {
        return this.m_isVideoEnabled;
    }

    public boolean isMouseEnabled() {
        return this.m_isMouseEnabled;
    }

    public boolean isStorageEnabled() {
        return this.m_isStorageEnabled;
    }

    public boolean isExeStorageSupported() {
        return this.m_isExeStorageSupported;
    }

    public boolean isStorageWorking() {
        return this.m_isStorageWorking;
    }

    public void setStorageWorking(boolean bl) {
        this.m_isStorageWorking = bl;
    }

    public boolean isRemoteStorageEnabled() {
        return this.m_canDoRemoteStorage;
    }

    public boolean isForcedHLevelState() {
        return this.m_isForcedHLevelState;
    }

    public boolean isStandbyPower() {
        return this.m_isStandbyPower;
    }

    public void setStandbyPower(boolean bl) {
        this.m_isStandbyPower = bl;
        this.viewport.setUserNameInTitle(this.m_userName, this.m_hostName, this.m_permssionMode, this.m_isEncyptionOn);
    }

    public boolean canChangeLMS() {
        return this.m_canChangeLMS;
    }

    public boolean canTurnScreenOn() {
        return this.m_canTurnScreenOn;
    }

    public boolean canTurnScreenOff() {
        return this.m_canTurnScreenOff;
    }

    public boolean allowTimeDown() {
        return this.m_allowTimeoutThread;
    }

    public boolean isTimingDown() {
        return this.m_isTimingDown;
    }

    public boolean canDisconnectOthers() {
        return this.m_canDisconnectOthers;
    }

    public void setTimingDown(boolean bl) {
        this.m_isTimingDown = bl;
    }

    public synchronized void updateTimeoutThread() {
        if (this.m_masterThread != null) {
            this.m_masterThread.extendTimeout();
        }
    }

    public boolean isEmbeddedApplet() {
        return this.m_isEmbeddedApplet;
    }

    protected void installFile(String string, String string2, boolean bl) throws Exception {
        InputStream inputStream;
        File file;
        long l = 0L;
        long l2 = 1L;
        StringBuffer stringBuffer = Helper.getUserHomeDir();
        stringBuffer.append(this.m_storageBaseVersion);
        Helper.makeRelativePath(stringBuffer);
        stringBuffer.append(string);
        if (vlog.isInfoLoggingEnabled()) {
            vlog.info("Destination " + string2 + ": '" + stringBuffer.toString() + "'");
        }
        if ((file = new File(stringBuffer.toString())).exists()) {
            if (!file.isFile()) {
                if (vlog.isErrorLoggingEnabled()) {
                    vlog.error("The destination " + string2 + " is not a file. Cannot install " + string2);
                }
                this.setStorageWorking(false);
                return;
            }
            inputStream = Helper.getResourceStream(string);
            l = Helper.calculateChecksum(inputStream);
            inputStream = new FileInputStream(file);
            l2 = Helper.calculateChecksum(inputStream);
        }
        if (l != l2) {
            if (vlog.isInfoLoggingEnabled()) {
                vlog.info("Installing " + string2 + "...");
            }
            inputStream = Helper.getResourceStream(string);
            Helper.copyFile(inputStream, stringBuffer);
            if (Helper.isLinux() && bl) {
                String[] stringArray = new String[]{CHMOD_EXE_NAME, CHMOD_PERMSSION, stringBuffer.toString()};
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(stringArray);
                process.waitFor();
            }
        }
        StringBufferPool.recycle(stringBuffer);
    }

    protected void installFileFromPilot(String string, int n, String string2, String string3, boolean bl) throws Exception {
        InputStream inputStream;
        long l = 0L;
        long l2 = 1L;
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        if (this.m_isSSLConnection) {
            stringBuffer.append(HTTPS_HEADER);
        } else {
            stringBuffer.append(HTTP_HEADER);
        }
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(n);
        Helper.makeHTTPRelativePath(stringBuffer);
        stringBuffer.append(string2);
        URL uRL = new URL(stringBuffer.toString());
        StringBuffer stringBuffer2 = Helper.getUserHomeDir();
        stringBuffer2.append(this.m_storageBaseVersion);
        File file = new File(stringBuffer2.toString());
        if (!file.isDirectory()) {
            if (file.exists()) {
                if (vlog.isErrorLoggingEnabled()) {
                    vlog.error("The path is not a directory. Cannot install " + string3);
                }
                this.setStorageWorking(false);
                return;
            }
            file.mkdir();
        }
        Helper.makeRelativePath(stringBuffer2);
        stringBuffer2.append(string2);
        if (vlog.isInfoLoggingEnabled()) {
            vlog.info("Destination " + string3 + ": '" + stringBuffer2.toString() + "'");
            vlog.info("From " + string3 + ": '" + stringBuffer.toString() + "'");
            vlog.info("pilot_url: '" + string + "' port: '" + n + "' file_name: '" + string2 + "'");
        }
        if ((file = new File(stringBuffer2.toString())).exists()) {
            if (!file.isFile()) {
                if (vlog.isErrorLoggingEnabled()) {
                    vlog.error("The destination " + string3 + " is not a file. Cannot install " + string3);
                }
                this.setStorageWorking(false);
                return;
            }
            inputStream = uRL.openStream();
            l = Helper.calculateChecksum(inputStream);
            inputStream = new FileInputStream(file);
            l2 = Helper.calculateChecksum(inputStream);
        }
        if (l != l2) {
            if (vlog.isInfoLoggingEnabled()) {
                vlog.info("Installing " + string3 + "...");
            }
            inputStream = uRL.openStream();
            Helper.copyFile(inputStream, stringBuffer2);
            if (Helper.isLinux() && bl) {
                String[] stringArray = new String[]{CHMOD_EXE_NAME, CHMOD_PERMSSION, stringBuffer2.toString()};
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(stringArray);
                process.waitFor();
            }
        }
        StringBufferPool.recycle(stringBuffer);
        StringBufferPool.recycle(stringBuffer2);
    }

    protected void loadStorage() {
        if (this.m_receivedMultiUserMessage && this.m_receivedFirmwareVersion && !this.m_loadedStorageSupport) {
            String string;
            Process process = null;
            boolean bl = false;
            boolean bl2 = false;
            ResourceMgr resourceMgr = ResourceMgr.getInstance();
            this.m_loadedStorageSupport = true;
            this.installStorageSupport();
            if (this.isStorageWorking() && this.m_isExeForKVM) {
                StringBuffer stringBuffer = Helper.getUserHomeDir();
                stringBuffer.append(this.m_storageBaseVersion);
                Helper.makeRelativePath(stringBuffer);
                stringBuffer.append(Helper.getStorageServerName());
                String[] stringArray = new String[]{stringBuffer.toString(), KVM_CMD_LINE_OPTION, this.m_hostAddress, String.valueOf(this.serverPort), this.m_userName, new String(this.m_password)};
                StringBufferPool.recycle(stringBuffer);
                Runtime runtime = Runtime.getRuntime();
                try {
                    process = runtime.exec(stringArray);
                }
                catch (Exception exception) {
                    bl2 = true;
                }
                while (!bl2) {
                    try {
                        int n = process.waitFor();
                        bl2 = true;
                        if (n != 0) continue;
                        this.close();
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception exception) {
                        bl2 = true;
                    }
                }
                bl = true;
            }
            if (bl) {
                string = this.isAlt0Text() ? resourceMgr.getResourceString("alt.0.err.kvm.exe.failed") : resourceMgr.getResourceString("err.kvm.exe.failed");
                if (this.m_kvmExeFailedDlg == null) {
                    this.m_kvmExeFailedDlg = MsgBox.showModallessMsgDlg(this.viewport, string, (IOKDlgCallback)this);
                    this.m_kvmExeFailedDlg.setVisible(true);
                } else {
                    this.m_kvmExeFailedDlg.setMessage(string);
                    this.m_kvmExeFailedDlg.pack();
                    this.m_kvmExeFailedDlg.requestFocus();
                }
            }
            try {
                if (!this.isStorageWorking()) {
                    if (vlog.isDebugLoggingEnabled()) {
                        vlog.debug("Error copying storage plug-in JAR file.");
                    }
                    string = this.isAlt0Text() ? resourceMgr.getResourceString("alt.0.err.storage.failed.to.load") : resourceMgr.getResourceString("err.storage.failed.to.load");
                    if (this.m_msgDlg == null) {
                        this.m_msgDlg = MsgBox.showModallessMsgDlg(this.viewport, string, (IOKDlgCallback)this);
                        this.m_msgDlg.setVisible(true);
                    } else {
                        this.m_msgDlg.setMessage(string);
                        this.m_msgDlg.requestFocus();
                    }
                } else if (!this.isExeStorageSupported()) {
                    LUD.getInstance(this.m_storageBaseVersion);
                    if (!LUD.isLoaded()) {
                        this.setStorageWorking(false);
                        string = this.isAlt0Text() ? resourceMgr.getResourceString("alt.0.err.storage.failed.to.load") : resourceMgr.getResourceString("err.storage.failed.to.load");
                        if (LUD.hasStorageFailedToLoad()) {
                            if (this.m_msgDlg == null) {
                                this.m_msgDlg = MsgBox.showModallessMsgDlg(this.viewport, string, (IOKDlgCallback)this);
                                this.m_msgDlg.setVisible(true);
                            } else {
                                this.m_msgDlg.setMessage(string);
                                this.m_msgDlg.requestFocus();
                            }
                        }
                    }
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.setStorageWorking(false);
                if (vlog.isDebugLoggingEnabled()) {
                    vlog.debug("Error starting storage...");
                    vlog.debug(noClassDefFoundError);
                }
                string = this.isAlt0Text() ? resourceMgr.getResourceString("alt.0.err.storage.failed.to.load") : resourceMgr.getResourceString("err.storage.failed.to.load");
                if (this.m_msgDlg == null) {
                    this.m_msgDlg = MsgBox.showModallessMsgDlg(this.viewport, string, (IOKDlgCallback)this);
                    this.m_msgDlg.setVisible(true);
                }
                this.m_msgDlg.setMessage(string);
                this.m_msgDlg.requestFocus();
            }
        }
    }

    public void installStorageSupport() {
        try {
            if (this.isExeStorageSupported() || this.m_isExeForKVM) {
                this.installFileFromPilot(this.m_hostAddress, this.serverPort, Helper.getStorageServerName(), "StorageServer", true);
                this.installFileFromPilot(this.m_hostAddress, this.serverPort, "M2.R", "ResourceFile", false);
                this.setStorageWorking(true);
            }
        }
        catch (Throwable throwable) {
            if (vlog.isErrorLoggingEnabled()) {
                vlog.error("Error installing Storage:");
                vlog.error(throwable);
            }
            this.setStorageWorking(false);
        }
    }

    protected void displayInfo() {
        if (vlog.isDebugLoggingEnabled()) {
            Properties properties = System.getProperties();
            StringBuffer stringBuffer = StringBufferPool.getInstance("--- System Info ---\n");
            Object object = properties.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                String string2 = properties.getProperty(string);
                stringBuffer.append(string);
                stringBuffer.append("='");
                stringBuffer.append(string2);
                stringBuffer.append("'\n");
            }
            stringBuffer.append("---------------------\nRemote KVMS version: ");
            object = VersionResMgr.getInstance();
            stringBuffer.append(((AbstractResourceMgr)object).getResourceString("release.version"));
            stringBuffer.append('.');
            stringBuffer.append(((AbstractResourceMgr)object).getResourceString("major.version"));
            stringBuffer.append('.');
            stringBuffer.append(((AbstractResourceMgr)object).getResourceString("minor.version"));
            stringBuffer.append('.');
            stringBuffer.append(((AbstractResourceMgr)object).getResourceString("build.number"));
            stringBuffer.append("\n---------------------\nLog file time: ");
            Calendar calendar = CalendarPool.getInstance();
            stringBuffer.append(calendar.toString());
            CalendarPool.recycle(calendar);
            stringBuffer.append("\n---------------------");
            vlog.debug(stringBuffer.toString());
            StringBufferPool.recycle(stringBuffer);
        }
    }

    public boolean init(String string, String string2, String string3, boolean bl, String string4, int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        int n7;
        Object object;
        MessageSender.setConn(this);
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        this.m_userName = string2;
        this.m_password = string3.toCharArray();
        this.m_sessionType = string4;
        this.m_storagePort = n;
        if (bl || string == null) {
            object = new ServerDialog(this, string);
            ((Dialog)object).setVisible(true);
            if (!((ServerDialog)object).ok) {
                return false;
            }
            string = ((ServerDialog)object).m_serverText.getText();
            this.m_userName = ((ServerDialog)object).m_userName.getText();
            this.m_password = ((ServerDialog)object).m_passwdEntry.getPassword();
            this.m_isEmbeddedApplet = false;
        } else {
            this.m_isEmbeddedApplet = true;
        }
        this.m_passwordFull = new char[128];
        System.arraycopy(this.m_password, 0, this.m_passwordFull, 0, this.m_password.length);
        object = SettingsResMgr.getInstance();
        if (this.viewer.mahoganyLogging.getValue() && ((AbstractResourceMgr)object).getResourceInt("initial.enable.msgs") == 0) {
            ((AbstractResourceWriter)object).setResourceValue("initial.enable.msgs", 1);
        }
        if (((AbstractResourceMgr)object).getResourceInt("initial.enable.msgs") == 0) {
            LogWriter.setGlobalLoggingLevel(0);
        }
        LogWriter.configureLogging();
        if (this.m_userName.length() < 16) {
            stringBuffer.append(this.m_userName);
            for (int i = stringBuffer.length(); i < 16; ++i) {
                stringBuffer.append('\u0000');
            }
            this.m_userName = stringBuffer.toString();
        } else if (this.m_userName.length() > 16) {
            this.m_userName = this.m_userName.substring(0, 16);
        }
        if (this.m_password.length < 20) {
            char[] cArray = new char[20];
            System.arraycopy(this.m_password, 0, cArray, 0, this.m_password.length);
            for (n7 = this.m_password.length; n7 < 20; ++n7) {
                cArray[n7] = '\u0000';
            }
            this.m_password = cArray;
        } else if (this.m_password.length > 20) {
            char[] cArray = new char[20];
            System.arraycopy(this.m_password, 0, cArray, 0, cArray.length);
            this.m_password = cArray;
        }
        if (this.m_passwordFull.length < 128) {
            char[] cArray = new char[128];
            System.arraycopy(this.m_passwordFull, 0, cArray, 0, this.m_passwordFull.length);
            for (n7 = this.m_passwordFull.length; n7 < 128; ++n7) {
                cArray[n7] = '\u0000';
            }
            this.m_passwordFull = cArray;
        } else if (this.m_passwordFull.length > 128) {
            char[] cArray = new char[128];
            System.arraycopy(this.m_passwordFull, 0, cArray, 0, cArray.length);
            this.m_passwordFull = cArray;
        }
        this.displayInfo();
        if (vlog.isInfoLoggingEnabled()) {
            stringBuffer.setLength(0);
            stringBuffer.append("Storage Port: ");
            stringBuffer.append(n);
            vlog.info(stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer.append("Nonsecure KVM Port: ");
            stringBuffer.append(n2);
            vlog.info(stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer.append("Nonsecure KM Port: ");
            stringBuffer.append(n3);
            vlog.info(stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer.append("Nonsecure V Port: ");
            stringBuffer.append(n4);
            vlog.info(stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer.append("SSL VM Port: ");
            stringBuffer.append(n5);
            vlog.info(stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer.append("SSL K Port: ");
            stringBuffer.append(n6);
            vlog.info(stringBuffer.toString());
        }
        this.m_hostName = string;
        this.serverHost = InetAddress.getByName(string);
        this.m_hostAddress = this.serverHost.toString();
        int n8 = 0;
        if (this.m_sessionType.equalsIgnoreCase("kvmssl")) {
            n8 = 1;
            this.m_isSSLConnection = true;
        } else {
            n8 = 0;
        }
        ((AbstractResourceWriter)object).setResourceValue("connect.as.method", n8);
        if (n8 == 1) {
            Object object2;
            this.m_requiredKeyboardSecurePort = n6;
            SSLContext sSLContext = null;
            this.m_isEncyptionOn = true;
            try {
                sSLContext = SSLContext.getInstance("SSL");
                object2 = new TrustManager[]{new ServerEgninesTrustManager()};
                sSLContext.init(null, (TrustManager[])object2, null);
            }
            catch (Exception exception) {
                if (vlog.isErrorLoggingEnabled()) {
                    vlog.error("Error setting trust manager");
                }
                throw new RuntimeException("Error setting trust manager", exception);
            }
            this.serverPort = n2;
            if (vlog.isInfoLoggingEnabled()) {
                stringBuffer.setLength(0);
                stringBuffer.append("Connecting to host via SSL ");
                stringBuffer.append(this.m_hostAddress);
                stringBuffer.append(" port ");
                stringBuffer.append(this.serverPort);
                vlog.info(stringBuffer.toString());
            }
            object2 = sSLContext.getSocketFactory();
            SSLSocket sSLSocket = (SSLSocket)((SocketFactory)object2).createSocket(this.serverHost, this.serverPort);
            sSLSocket.startHandshake();
            this.sock = sSLSocket;
        } else {
            this.serverPort = n2;
            if (vlog.isInfoLoggingEnabled()) {
                stringBuffer.setLength(0);
                stringBuffer.append("Connecting to host ");
                stringBuffer.append(this.m_hostAddress);
                stringBuffer.append(" port ");
                stringBuffer.append(this.serverPort);
                vlog.info(stringBuffer.toString());
            }
            this.sock = new Socket(this.serverHost, this.serverPort);
        }
        StringBufferPool.recycle(stringBuffer);
        this.sock.setSoTimeout(20);
        this.jis = new JavaInStream(this.sock.getInputStream());
        this.jos = new JavaOutStream(this.sock.getOutputStream());
        this.setStreams(this.jis, this.jos);
        MessageSender.setConnection(this);
        MessageSender.sendClientNOP();
        return true;
    }

    public void startStorageSocket() throws Throwable {
        if (this.m_storageDiscoverySocket == null) {
            int n = this.getViewer().mahoganyStorageServerPort.getValue();
            if (vlog.isDebugLoggingEnabled()) {
                vlog.debug("cwd: '" + System.getProperty("user.dir", "").trim() + "'");
            }
            Thread.sleep(250L);
            this.m_storageDiscoverySocket = new Socket(LOCAL_HOST_ADDR, n);
            this.m_storageDiscoveryJis = new JavaInStream(this.m_storageDiscoverySocket.getInputStream());
            this.m_storageDiscoveryJos = new JavaOutStream(this.m_storageDiscoverySocket.getOutputStream());
        }
    }

    public void sendStorageMsg() throws Throwable {
        LittleEndianBufferMgr littleEndianBufferMgr = LittleEndianBufferMgr.getInstance();
        StorageMsgRequest storageMsgRequest = StorageMsgRequest.getInstance();
        storageMsgRequest.setPortNumber((short)this.getViewer().mahoganyStorageServerPort.getValue());
        storageMsgRequest.writeBuffer(littleEndianBufferMgr);
        this.m_storageDiscoveryJos.writeBytes(littleEndianBufferMgr.getBuffer(), 0, littleEndianBufferMgr.getOffset());
        this.m_storageDiscoveryJos.flush();
        storageMsgRequest.recycle();
    }

    public void readStorageResponse(StringBuffer stringBuffer) {
        String string = "";
        this.m_storageDiscoveryJis.readBytes(Buffers.m_buffer, 19);
        try {
            string = new String(Buffers.m_buffer, 9, 8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = string.trim();
        int n = Integer.parseInt(string, 16);
        this.m_storageDiscoveryJis.readBytes(Buffers.m_buffer, n);
        try {
            string = new String(Buffers.m_buffer, 0, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append(string);
    }

    public StringBuffer communicateWithStorageServer() throws Throwable {
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        boolean bl = false;
        int n = 0;
        while (!bl && n < 3) {
            try {
                if (vlog.isDebugLoggingEnabled()) {
                    vlog.debug("Starting stoarge socket...");
                }
                this.startStorageSocket();
                if (vlog.isDebugLoggingEnabled()) {
                    vlog.debug("Sending stoarge message...");
                }
                this.sendStorageMsg();
                if (vlog.isDebugLoggingEnabled()) {
                    vlog.debug("Reading stoarge response...");
                }
                this.readStorageResponse(stringBuffer);
                if (vlog.isDebugLoggingEnabled()) {
                    vlog.debug("Completed Storage transcation.");
                }
                bl = true;
                if (!vlog.isDebugLoggingEnabled()) continue;
                vlog.debug("Completed Device Discovery...");
            }
            catch (Throwable throwable) {
                String string;
                if (vlog.isErrorLoggingEnabled()) {
                    vlog.error("Error opening storage socket:");
                    vlog.error(throwable);
                }
                this.m_storageDiscoverySocket = null;
                if (++n < 3) continue;
                ResourceMgr resourceMgr = ResourceMgr.getInstance();
                try {
                    if (!this.isStorageWorking()) {
                        if (vlog.isDebugLoggingEnabled()) {
                            vlog.debug("Error copying storage plug-in JAR file.");
                        }
                        string = this.isAlt0Text() ? resourceMgr.getResourceString("alt.0.err.storage.failed.to.load") : resourceMgr.getResourceString("err.storage.failed.to.load");
                        if (this.m_msgDlg == null) {
                            this.m_msgDlg = MsgBox.showModallessMsgDlg(this.viewport, string, (IOKDlgCallback)this);
                            this.m_msgDlg.setVisible(true);
                            continue;
                        }
                        this.m_msgDlg.setMessage(string);
                        this.m_msgDlg.requestFocus();
                        continue;
                    }
                    if (this.isExeStorageSupported() || LUD.isLoaded()) continue;
                    this.setStorageWorking(false);
                    string = this.isAlt0Text() ? resourceMgr.getResourceString("alt.0.err.storage.failed.to.load") : resourceMgr.getResourceString("err.storage.failed.to.load");
                    if (!LUD.hasStorageFailedToLoad()) continue;
                    if (this.m_msgDlg == null) {
                        this.m_msgDlg = MsgBox.showModallessMsgDlg(this.viewport, string, (IOKDlgCallback)this);
                        this.m_msgDlg.setVisible(true);
                        continue;
                    }
                    this.m_msgDlg.setMessage(string);
                    this.m_msgDlg.requestFocus();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    this.setStorageWorking(false);
                    if (vlog.isDebugLoggingEnabled()) {
                        vlog.debug("Error starting native interface plugin...");
                        vlog.debug(noClassDefFoundError);
                    }
                    string = this.isAlt0Text() ? resourceMgr.getResourceString("alt.0.err.storage.failed.to.load") : resourceMgr.getResourceString("err.storage.failed.to.load");
                    if (this.m_msgDlg == null) {
                        this.m_msgDlg = MsgBox.showModallessMsgDlg(this.viewport, string, (IOKDlgCallback)this);
                        this.m_msgDlg.setVisible(true);
                        continue;
                    }
                    this.m_msgDlg.setMessage(string);
                    this.m_msgDlg.requestFocus();
                }
            }
        }
        return stringBuffer;
    }

    void removeWindow() {
        if (this.viewport != null) {
            this.viewport.dispose();
            this.viewport = null;
        }
    }

    public void onOfferFullControl() {
        this.viewport.onOfferFullControl();
    }

    public boolean isExitingProperly() {
        return this.m_exitProperly;
    }

    public void setExitProperly(boolean bl) {
        this.m_exitProperly = bl;
    }

    public boolean isHLevelCompressionOn() {
        return this.m_isHLevelCompressionOn;
    }

    public void setHLevelCompressionOn(boolean bl) {
        this.m_isHLevelCompressionOn = bl;
    }

    public void serverInit() {
        super.serverInit();
        this.desktop = new DesktopWindow(this);
        this.recreateViewport();
        this.m_masterThread = new MasterThread(this, this.desktop);
        this.m_masterThread.start();
    }

    void recreateViewport() {
        if (this.viewport != null) {
            this.viewport.dispose();
        }
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        this.viewport = new ViewportFrame(resourceMgr.getResourceString("main.window.title"), this);
        this.desktop.setViewport(this.viewport);
        this.viewport.addChild(this.desktop);
        this.reconfigureViewport();
        this.desktop.requestFocus();
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        Keyboard keyboard = keyboardMgr.getKeyboard(settingsResMgr.getResourceInt("default.language"), this);
        LoadKeyboardImagesThread loadKeyboardImagesThread = new LoadKeyboardImagesThread(keyboard.getImageDir());
        loadKeyboardImagesThread.start();
    }

    public void updateMountDialog(boolean bl) {
        if (this.isStorageWorking() && (this.isExeStorageSupported() || LUD.isLoaded()) && bl) {
            this.startDeviceDiscovery(bl);
        }
    }

    public void beginStorageDlgUpdate() {
        if (this.m_startStorageThread == null) {
            this.m_startStorageThread = new StartDeviceDiscoveryThread(this, this.m_mainThread);
            this.m_startStorageThread.start();
        }
    }

    public void updateStorageDialog() {
        if (this.m_startStorageThread != null) {
            this.updateMountDialog(true);
            this.viewport.setStorageDlgVisible();
            this.m_startStorageThread = null;
        }
    }

    public Thread getMainThread() {
        return this.m_mainThread;
    }

    public StorageDiscoveryThread getDeviceDiscoveryThread() {
        return this.m_storageDiscoveryThread;
    }

    public void startDeviceDiscovery() {
        this.startDeviceDiscovery(true);
    }

    public void startDeviceDiscovery(boolean bl) {
        if (this.m_storageDiscoveryThread == null) {
            this.viewport.discoverDevices(true);
            this.m_storageDiscoveryThread = new StorageDiscoveryThread(this, bl, this.m_mainThread);
            this.m_storageDiscoveryThread.start();
        }
    }

    public void onDiscoveryComplete() {
        this.m_storageDiscoveryThread = null;
        this.viewport.getMountDialog().reloadDrives();
        this.viewport.discoverDevices(false);
    }

    void reconfigureViewport() {
        if (this.viewport != null) {
            this.viewport.pack();
        }
    }

    public void close() {
        block18: {
            try {
                if (!this.m_alraedyExited) {
                    this.m_alraedyExited = true;
                    if (this.desktop != null) {
                        this.desktop.recycle();
                    }
                    this.viewer.viewOnly.setParam(true);
                    MouseMgr mouseMgr = MouseMgr.getInstance();
                    if (mouseMgr.getId() == 0) {
                        mouseMgr.useRelativeMode();
                        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
                        settingsResMgr.setResourceValue("mouse.mode", mouseMgr.getId());
                        settingsResMgr.writeResource();
                        this.viewport.toggleMouseEscape();
                    }
                    this.m_frameCtThread = null;
                    this.m_isRunning = false;
                    this.shuttingDown = true;
                    if (this.m_masterThread != null) {
                        this.m_masterThread.setRunning(false);
                        this.m_masterThread = null;
                    }
                    if (this.m_frameCtThread != null) {
                        this.m_frameCtThread.setRunning(false);
                        this.m_frameCtThread = null;
                    }
                    if (this.m_requestDlg != null) {
                        this.m_requestDlg.endDialog();
                        this.m_requestDlg = null;
                    }
                    if (this.m_sessionRequestDlg != null) {
                        this.m_sessionRequestDlg.endDialog();
                        this.m_sessionRequestDlg = null;
                    }
                    if (this.m_secondaryControlDlg != null) {
                        this.m_secondaryControlDlg.endDialog();
                        this.m_secondaryControlDlg = null;
                    }
                    if (this.m_newConnectionDlg != null) {
                        this.m_newConnectionDlg.endDialog();
                        this.m_newConnectionDlg = null;
                    }
                    if (this.m_stoargeStatusDlg != null) {
                        this.m_stoargeStatusDlg.endDialog();
                        this.m_stoargeStatusDlg = null;
                    }
                    if (this.m_kvmExeFailedDlg != null) {
                        this.m_kvmExeFailedDlg.endDialog();
                        this.m_kvmExeFailedDlg = null;
                    }
                    if (this.m_performanceDlg != null) {
                        this.m_performanceDlg.endDialog();
                        this.m_performanceDlg = null;
                    }
                    if (this.m_msgDlg != null) {
                        this.m_msgDlg.endDialog();
                        this.m_msgDlg = null;
                    }
                    this.closeAllDevices();
                    if (this.isSocketValid()) {
                        if (this.m_hasFullControl) {
                            MessageSender.relinquishFullControl();
                        }
                        MessageSender.clientDisconnect(this.m_reasonForExiting);
                    }
                    this.closeSockets();
                    KeyboardMgr.recycle();
                    this.removeWindow();
                    if (this.isStorageWorking() && !this.isExeStorageSupported()) {
                        LUD.clearInstance();
                    }
                    LogWriter.close();
                }
            }
            catch (Throwable throwable) {
                if (!vlog.isErrorLoggingEnabled()) break block18;
                vlog.error(throwable);
            }
        }
    }

    public MasterThread getMasterThread() {
        return this.m_masterThread;
    }

    public void closeFromTimeout() {
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        String string = this.isAlt0Text() ? resourceMgr.getResourceString("alt.0.err.session.timedout") : resourceMgr.getResourceString("err.session.timedout");
        this.setExitProperly(true);
        this.close();
        MsgBox.showErrorMsgBox(this.viewer, string);
    }

    public void setReasonForExiting(int n) {
        this.m_reasonForExiting = n;
    }

    public void closeSockets() {
        block3: {
            try {
                if (this.sock != null) {
                    this.sock.close();
                    this.sock = null;
                }
                this.closeStorageSupport();
            }
            catch (Exception exception) {
                if (!vlog.isErrorLoggingEnabled()) break block3;
                vlog.error(exception);
            }
        }
    }

    public void closeStorageSupport() {
        block3: {
            try {
                if (this.m_storageDiscoverySocket != null) {
                    this.m_storageDiscoverySocket.close();
                    this.m_storageDiscoverySocket = null;
                    this.m_storageDiscoveryJis = null;
                    this.m_storageDiscoveryJos = null;
                }
                LUD lUD = LUD.getInstance(this.m_storageBaseVersion);
                lUD.unload();
            }
            catch (Exception exception) {
                if (!vlog.isErrorLoggingEnabled()) break block3;
                vlog.error(exception);
            }
        }
    }

    protected void closeAllDevices() {
        MountedDriveMgr mountedDriveMgr;
        if (this.isStorageWorking() && (this.isExeStorageSupported() || LUD.isLoaded()) && (mountedDriveMgr = MountedDriveMgr.getInstance()).isSharingDevices() && mountedDriveMgr.isSharingLocalStorage()) {
            mountedDriveMgr.unmountDevice();
        }
    }

    public boolean isSocketValid() {
        return this.sock != null && !this.sock.isClosed() && this.sock.isConnected() && !this.sock.isOutputShutdown();
    }

    public void showPerformanceDialog(Frame frame) {
        if (this.m_performanceDlg == null) {
            this.m_performanceDlg = new PerformanceDialog(frame, this);
            this.initFrameCt();
            if (this.m_frameCtThread == null) {
                this.m_frameCtThread = new FrameCtThread(this);
                this.m_frameCtThread.start();
            }
            this.m_frameCtThread.setRunning(true);
        }
        this.m_performanceDlg.setVisible(true);
    }

    public void onPerformanceComplete() {
        this.m_performanceDlg = null;
        if (this.m_frameCtThread != null) {
            this.m_frameCtThread.setRunning(false);
            this.m_frameCtThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementFrameCounter(int n, int n2) {
        Class clazz = class$com$serverengines$mahogany$CConn == null ? (class$com$serverengines$mahogany$CConn = CConn.class$("com.serverengines.mahogany.CConn")) : class$com$serverengines$mahogany$CConn;
        synchronized (clazz) {
            if (n <= this.m_xFrameCtThreshold && n2 <= this.m_yFrameCtThreshold) {
                ++this.m_currentFrameCt;
                if (this.m_performanceDlg != null) {
                    this.m_performanceDlg.changeCutrentCycle(this.m_currentFrameCt);
                }
            }
            this.m_xFrameCtThreshold = n;
            this.m_yFrameCtThreshold = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeCycles() {
        Class clazz = class$com$serverengines$mahogany$CConn == null ? (class$com$serverengines$mahogany$CConn = CConn.class$("com.serverengines.mahogany.CConn")) : class$com$serverengines$mahogany$CConn;
        synchronized (clazz) {
            if (this.m_performanceDlg != null) {
                this.m_performanceDlg.changeCycles();
                this.m_currentFrameCt = 0;
            }
        }
    }

    public void showAbout(Dialog dialog) {
        if (this.m_aboutDlg != null) {
            this.m_aboutDlg.endDialog();
        }
        this.m_aboutDlg = new AboutDialog(dialog, this);
        this.m_aboutDlg.setVisible(true);
    }

    public void showAbout(Frame frame) {
        if (this.m_aboutDlg != null) {
            this.m_aboutDlg.endDialog();
        }
        this.m_aboutDlg = new AboutDialog(frame, this);
        this.m_aboutDlg.setVisible(true);
    }

    public void onAboutComplete() {
        this.m_aboutDlg = null;
    }

    public void onPreferencesComplete() {
        this.m_settingsDlg = null;
    }

    public void showPreferencesDialog(Dialog dialog) {
        if (this.m_settingsDlg != null) {
            this.m_settingsDlg.endDialog();
        }
        this.m_settingsDlg = new SettingsDialog(dialog, this);
        this.m_settingsDlg.setVisible(true);
    }

    public void showPreferencesDialog(Frame frame) {
        if (this.m_settingsDlg != null) {
            this.m_settingsDlg.endDialog();
        }
        this.m_settingsDlg = new SettingsDialog(frame, this);
        this.m_settingsDlg.setVisible(true);
    }

    public void onDisconnectSession() {
        if (this.m_DisconnectSessionDialog == null) {
            this.m_DisconnectSessionDialog = new DisconnectSessionDialog((Frame)this.viewport, this);
        }
        this.m_DisconnectSessionDialog.setVisible(true);
    }

    public synchronized void writeKeyEvent(int n, boolean bl) {
        if (this.state() != 1 || this.viewer.viewOnly.getValue()) {
            return;
        }
        MessageSender.keyStateChange((short)n, bl, false);
    }

    public synchronized void onKeyPressed(KeyEvent keyEvent) {
        boolean bl;
        if (this.state() != 1) {
            return;
        }
        if (keyEvent.getKeyCode() == 20 && this.m_ignoreCapsLock) {
            return;
        }
        if (keyEvent.getKeyCode() == 144 && this.m_ignoreNumLock) {
            return;
        }
        if (keyEvent.getKeyCode() == 145 && this.m_ignoreScrollLock) {
            return;
        }
        if (keyEvent.getKeyCode() == 121) {
            return;
        }
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        Keyboard keyboard = keyboardMgr.getKeyboard();
        KeyMappingResMgr keyMappingResMgr = keyboard.getKeyMappings();
        int n = keyEvent.getKeyCode();
        int n2 = keyMappingResMgr.getHidMapping(n, keyEvent.getKeyChar(), keyEvent.getKeyLocation());
        Integer n3 = new Integer(n2);
        Integer n4 = new Integer(230);
        boolean bl2 = bl = keyEvent.isAltGraphDown() && !this.m_keysPressedDownSet.contains(n4);
        if (n2 == -1) {
            return;
        }
        if (n == 240) {
            this.writeKeyEvent(n2, true);
            this.writeKeyEvent(n2, false);
        } else if (!this.m_keysPressedDownSet.contains(n3)) {
            Integer n5 = new Integer(224);
            if (keyEvent.isAltDown() && keyEvent.getKeyLocation() == 3 && this.m_keysPressedDownSet.contains(n5)) {
                this.writeKeyEvent(224, false);
                this.m_keysPressedDownSet.remove(n5);
                this.viewport.setSpecialKey(224, false);
            }
            if (bl) {
                this.viewport.setSpecialKey(230, true);
                this.writeKeyEvent(230, true);
            }
            this.viewport.setSpecialKey(n2, true);
            this.m_keysPressedDownSet.add(n3);
            this.writeKeyEvent(n2, true);
            this.m_asciiKeysSet.add(new Integer(keyEvent.getKeyChar()));
        }
    }

    public synchronized void onKeyReleased(KeyEvent keyEvent) {
        boolean bl;
        if (keyEvent.getKeyCode() == 20 && this.m_ignoreCapsLock) {
            this.m_ignoreCapsLock = false;
            return;
        }
        if (keyEvent.getKeyCode() == 144 && this.m_ignoreNumLock) {
            this.m_ignoreNumLock = false;
            return;
        }
        if (keyEvent.getKeyCode() == 145 && this.m_ignoreScrollLock) {
            this.m_ignoreScrollLock = false;
            return;
        }
        if (this.state() != 1) {
            return;
        }
        if (keyEvent.getKeyCode() == 121) {
            return;
        }
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        Keyboard keyboard = keyboardMgr.getKeyboard();
        KeyMappingResMgr keyMappingResMgr = keyboard.getKeyMappings();
        int n = keyMappingResMgr.getHidMapping(keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation());
        Integer n2 = new Integer(n);
        Integer n3 = new Integer(230);
        boolean bl2 = bl = keyEvent.isAltGraphDown() && !this.m_keysPressedDownSet.contains(n3);
        if (n == -1) {
            return;
        }
        if (this.m_keysTypedSet.contains(n2)) {
            this.m_keysPressedDownSet.remove(n2);
            this.m_keysTypedSet.remove(n2);
            this.viewport.clearSpecialKeys();
            return;
        }
        if (this.m_keysPressedDownSet.contains(n2)) {
            this.writeKeyEvent(n, false);
            this.m_keysPressedDownSet.remove(n2);
            this.m_asciiKeysSet.remove(new Integer(keyEvent.getKeyChar()));
            this.viewport.setSpecialKey(n, false);
            if (bl) {
                this.writeKeyEvent(230, false);
                this.viewport.setSpecialKey(230, false);
            }
        } else if (n == 224) {
            this.m_asciiKeysSet.remove(new Integer(keyEvent.getKeyChar()));
            this.viewport.setSpecialKey(n, false);
        } else {
            if (bl) {
                this.viewport.setSpecialKey(230, true);
                this.writeKeyEvent(230, true);
            }
            this.viewport.setSpecialKey(n, true);
            this.writeKeyEvent(n, true);
            this.writeKeyEvent(n, false);
            this.viewport.setSpecialKey(n, false);
            if (bl) {
                this.writeKeyEvent(230, false);
                this.viewport.setSpecialKey(230, false);
            }
        }
        this.viewport.clearSpecialKeys();
    }

    public synchronized void onKeyTyped(KeyEvent keyEvent) {
        if (this.state() != 1) {
            return;
        }
        if (keyEvent.getKeyCode() == 121) {
            return;
        }
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        Keyboard keyboard = keyboardMgr.getKeyboard();
        KeyMappingResMgr keyMappingResMgr = keyboard.getKeyMappings();
        int n = keyMappingResMgr.getHidMapping(keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation());
        Integer n2 = new Integer(n);
        if (n == -1) {
            return;
        }
        if (!this.m_keysPressedDownSet.contains(n2) && !this.m_asciiKeysSet.contains(new Integer(keyEvent.getKeyChar()))) {
            this.viewport.setSpecialKey(n, true);
            this.writeKeyEvent(n, true);
            this.writeKeyEvent(n, false);
            this.viewport.setSpecialKey(n, false);
            this.m_keysTypedSet.add(new Integer(n));
        }
    }

    public void changeKeyboardLayout() {
        if (this.viewport != null) {
            this.viewport.changeKeyboardLayout();
        }
    }

    public void closeKeyboardWindow() {
        this.viewport.closeKeyboardWindow();
    }

    public void informKeyIndicators(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = Helper.getLockingKeyState(20);
        boolean bl5 = Helper.getLockingKeyState(144);
        boolean bl6 = Helper.getLockingKeyState(145);
        int n = 0;
        if (bl4 != bl) {
            this.m_ignoreCapsLock = true;
            n |= 1;
            Helper.setLockingKeyState(20, bl);
        }
        if (bl5 != bl2) {
            this.m_ignoreNumLock = true;
            n |= 2;
            Helper.setLockingKeyState(144, bl2);
        }
        if (bl6 != bl3) {
            this.m_ignoreScrollLock = true;
            n |= 4;
            Helper.setLockingKeyState(145, bl3);
        }
        this.viewport.informKeyIndicators(bl, bl2, bl3);
        this.startClearLockKeysThread(n);
    }

    public boolean hasFullControl() {
        return this.m_hasFullControl;
    }

    public boolean canTakeFullControl() {
        return this.m_canTakeFullControl;
    }

    public boolean canPrevTakeFullControl() {
        return this.m_prevCanTakeFullControl;
    }

    public boolean canRelinquishFullControl() {
        return this.m_canRelinquishFullControl;
    }

    public User[] getUsers() {
        return this.m_curUsers;
    }

    public void startDisconnecting() {
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        this.setExitProperly(true);
        this.setReasonForExiting(1);
        this.close();
        MsgBox.showErrorMsgBox(this.viewer, resourceMgr.getResourceString("server.dlg.inform.disconnect"));
    }

    public void onServerDisconnect(int n, String string) {
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        ArrayList arrayList = ArrayListStringBufferPool.getInstance();
        StringBuffer stringBuffer = StringBufferPool.getInstance(string);
        arrayList.add(stringBuffer);
        MsgBox.showErrorMsgBox(this.viewport, resourceMgr.getResourceString("server.dlg.disconnected", arrayList));
        StringBufferPool.recycle(stringBuffer);
        ArrayListStringBufferPool.recycle(arrayList);
        this.setExitProperly(true);
        this.setReasonForExiting(1);
        this.close();
    }

    public void onServerHandshake(ServerHandshake serverHandshake) {
        if (!this.m_receivedMultiUserMessage) {
            this.m_isKeyboardEnabled = serverHandshake.isKeyboardEnabled();
            this.m_isVideoEnabled = serverHandshake.isVideoEnabled();
            this.m_isMouseEnabled = serverHandshake.isMouseEnabled();
            this.m_isStorageEnabled = serverHandshake.isStorageEnabled();
            this.viewport.toggleGUI();
            MessageSender.sendClientHandshake(this.m_isEmbeddedApplet, this.m_userName, new String(this.m_password), new String(this.m_passwordFull), 31, "");
        }
    }

    protected String fixFileSystemName(String string) {
        StringBuffer stringBuffer = StringBufferPool.getInstance(string);
        for (int i = 0; i < ILLEGAL_FILE_CHARS.length; ++i) {
            Helper.replaceString(stringBuffer, ILLEGAL_FILE_CHARS[i], ILLEGAL_FILE_CHAR_TO_RPLACE);
        }
        String string2 = stringBuffer.toString();
        StringBufferPool.recycle(stringBuffer);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFirmwareVersion(FirmwareVersion firmwareVersion) {
        this.m_firmwareVersion = firmwareVersion.getFirmwareVersion();
        this.m_storageBaseVersion = this.fixFileSystemName(this.m_firmwareVersion);
        this.m_receivedFirmwareVersion = true;
        PrintStream printStream = null;
        try {
            String string = System.getProperty("user.home", "").trim();
            int n = string.indexOf(File.pathSeparatorChar);
            if (n > -1) {
                string = string.substring(0, n).trim();
            }
            if (string.length() > 0) {
                StringBuffer stringBuffer = StringBufferPool.getInstance(string);
                Helper.makeRelativePath(stringBuffer);
                stringBuffer.append(this.m_storageBaseVersion);
                File file = new File(stringBuffer.toString());
                if (file.isDirectory() || !file.exists()) {
                    if (!file.exists()) {
                        file.mkdir();
                    }
                    Helper.makeRelativePath(stringBuffer);
                    stringBuffer.append("StorageServer.Port");
                    if (vlog.isDebugLoggingEnabled()) {
                        vlog.debug("Writing port file: '" + stringBuffer.toString() + "'");
                    }
                    printStream = new PrintStream(new FileOutputStream(stringBuffer.toString()));
                    printStream.print(this.getViewer().mahoganyStorageServerPort.getValue());
                }
                StringBufferPool.recycle(stringBuffer);
            }
        }
        catch (Exception exception) {
            if (vlog.isErrorLoggingEnabled()) {
                vlog.error("Exception creating storeserver.port file:");
                vlog.error(exception);
            }
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
        this.loadStorage();
    }

    public void onRelinquishFullControl() {
        MessageSender.relinquishFullControl();
        this.m_justRelinquishFullControl = true;
    }

    public void onRelinquishPrimaryControl() {
        this.m_hasFullControl = false;
        this.m_prevHasFullControl = false;
        this.m_justRelinquishFullControl = true;
        this.viewer.viewOnly.setParam(true);
        this.viewport.setEnabledTakeControl(!this.m_hasFullControl && this.m_canTakeFullControl);
        this.viewport.setEnabledRelinquishFullControl(false);
    }

    public boolean isHandshakeComplete() {
        return this.m_receivedMultiUserMessage;
    }

    public void onMultiUserState(MultiUserState multiUserState) {
        int n;
        boolean bl;
        boolean bl2 = bl = !this.m_receivedMultiUserMessage;
        if (bl) {
            this.m_isExeStorageSupported = multiUserState.isExeForStorage();
            this.m_isExeForKVM = multiUserState.isExeForKVM();
            this.viewport.setVisible(true);
            this.desktop.resize();
            this.viewport.toggleGUI();
        }
        MountedDriveMgr mountedDriveMgr = MountedDriveMgr.getInstance();
        this.m_receivedMultiUserMessage = true;
        User[] userArray = multiUserState.getUsers();
        boolean bl3 = this.m_requestDlg != null;
        boolean bl4 = this.m_newConnectionDlg != null;
        boolean bl5 = false;
        boolean bl6 = false;
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        this.m_altText = multiUserState.isAlt0Text() ? 1 : 0;
        for (n = 0; n < this.m_curUsers.length; ++n) {
            this.m_curUsers[n].setUserFlags(userArray[n].getUserFlags());
            if (this.m_curUsers[n].isUserValid()) {
                this.m_curUsers[n].setUserNameSize(userArray[n].getUserNameSize());
                this.m_curUsers[n].setUserName(userArray[n].getUserName());
                if (!this.m_curUsers[n].isThisUserIdentity()) continue;
                this.m_userName = this.m_curUsers[n].getUserNameStr();
                this.m_permssionMode = multiUserState.getUserStatusMask();
                this.viewport.setUserNameInTitle(this.m_userName, this.m_hostName, this.m_permssionMode, this.m_isEncyptionOn);
                continue;
            }
            this.m_curUsers[n].setUserNameSize((byte)0);
        }
        this.m_prevCanTakeFullControl = this.m_canTakeFullControl;
        this.m_prevHasFullControl = this.m_hasFullControl;
        this.m_allowTimeoutThread = multiUserState.isSessionTimeoutAllowed();
        this.m_canTakeFullControl = multiUserState.isAllowedToTakeFullControl();
        this.m_canDisconnectOthers = multiUserState.isAllowedToDisconnectOtherUsers();
        this.m_canRelinquishFullControl = multiUserState.isAllowedToRelinquishFullControl();
        this.m_canChangeLMS = multiUserState.isAllowedToChangeLMS();
        this.m_canTurnScreenOn = multiUserState.isAllowedToTurnScreenOn();
        this.m_canTurnScreenOff = multiUserState.isAllowedToTurnScreenOff();
        this.m_isStorageEnabled = multiUserState.isAllowedToDoStorage();
        this.m_canDoRemoteStorage = multiUserState.isRemoteStorageAllowed();
        this.m_canDoStorageWrite = multiUserState.isAllowedToDoWriteStorage();
        this.m_isDVDRomDeviceAllowed = multiUserState.isDVDRomDeviceAllowed();
        this.m_isMemoryDeviceAllowed = multiUserState.isMemoryDeviceAllowed();
        this.m_isForcedHLevelState = multiUserState.isForceHLevelState();
        this.m_isLocalScreenOn = multiUserState.isLocalScreenOn();
        mountedDriveMgr.setDevciesAllowed(this.m_isDVDRomDeviceAllowed, this.m_isMemoryDeviceAllowed);
        this.onTimeoutThread();
        switch (multiUserState.getUserStatusMask()) {
            case 1: {
                this.m_hasFullControl = false;
                break;
            }
            case 0: {
                this.m_hasFullControl = true;
                break;
            }
            default: {
                this.m_hasFullControl = false;
                bl6 = true;
            }
        }
        if (!this.m_hasFullControl && this.m_prevHasFullControl) {
            this.viewport.clearAllSpecialKeys();
        }
        this.viewer.viewOnly.setParam(!this.m_hasFullControl);
        this.viewport.toggleGUI();
        if (!bl6) {
            if (this.m_hasFullControl && !this.m_prevHasFullControl) {
                this.desktop.sendMouseState();
                MessageSender.requestKeyIndicators();
                this.viewport.onMouseSync();
            }
            if (!(!this.m_canTakeFullControl || this.m_justRelinquishFullControl || this.m_hasFullControl || this.m_prevCanTakeFullControl && !this.m_prevHasFullControl)) {
                bl3 = true;
            }
            for (n = 0; n < this.m_curUsers.length; ++n) {
                if (!bl4 && this.m_curUsers[n].isUserValid() && !this.m_curUsers[n].isThisUserIdentity() && !this.m_curUsers[n].equals(this.m_prevUsers[n])) {
                    bl4 = true;
                }
                if (bl5 || this.m_DisconnectSessionDialog == null || this.m_curUsers[n].isUserValid() == this.m_prevUsers[n].isUserValid() && this.m_curUsers[n].equals(this.m_prevUsers[n]) && this.m_curUsers[n].getUserFlags() == this.m_prevUsers[n].getUserFlags()) continue;
                bl5 = true;
            }
            if (bl5) {
                this.m_DisconnectSessionDialog.updateSessionDialog(this);
            }
            if (bl4 && bl3) {
                if (this.m_newConnectionDlg != null) {
                    this.m_newConnectionDlg.dispose();
                    this.m_newConnectionDlg = null;
                }
                if (this.m_requestDlg != null) {
                    this.m_requestDlg.dispose();
                    this.m_requestDlg = null;
                }
                if (this.m_sessionRequestDlg == null) {
                    this.m_sessionRequestDlg = MsgBox.showModallessOKCancelDlg(this.viewport, resourceMgr.getResourceString("server.dlg.another.con.full.control"), (IOKCancelDlgCallback)this);
                    this.m_sessionRequestDlg.setVisible(true);
                } else {
                    this.m_sessionRequestDlg.requestFocus();
                }
            } else if (bl4) {
                if (this.m_sessionRequestDlg == null) {
                    if (this.m_newConnectionDlg == null) {
                        this.m_newConnectionDlg = MsgBox.showModallessMsgDlg(this.viewport, resourceMgr.getResourceString("server.dlg.another.connected"), (IOKDlgCallback)this);
                        this.m_newConnectionDlg.setVisible(true);
                    } else {
                        this.m_newConnectionDlg.requestFocus();
                    }
                } else {
                    this.m_sessionRequestDlg.requestFocus();
                }
            } else if (bl3) {
                if (this.m_sessionRequestDlg == null) {
                    if (this.m_requestDlg == null) {
                        this.m_requestDlg = MsgBox.showModallessOKCancelDlg(this.viewport, resourceMgr.getResourceString("server.dlg.request.full.control"), (IOKCancelDlgCallback)this);
                        this.m_requestDlg.setVisible(true);
                    } else {
                        this.m_requestDlg.requestFocus();
                    }
                } else {
                    this.m_sessionRequestDlg.requestFocus();
                }
            }
            for (n = 0; n < this.m_prevUsers.length; ++n) {
                this.m_prevUsers[n].setUserFlags(this.m_curUsers[n].getUserFlags());
                if (this.m_prevUsers[n].isUserValid()) {
                    this.m_prevUsers[n].setUserNameSize(this.m_curUsers[n].getUserNameSize());
                    this.m_prevUsers[n].setUserName(this.m_curUsers[n].getUserName());
                    continue;
                }
                this.m_prevUsers[n].setUserNameSize((byte)0);
            }
        } else {
            this.startDisconnecting();
        }
        this.m_justRelinquishFullControl = false;
        this.loadStorage();
    }

    public void onTimeoutThread() {
        if (this.m_allowTimeoutThread && this.m_isTimingDown) {
            this.startTimeoutThread();
        } else {
            this.stopTimeoutThread();
        }
    }

    protected void startTimeoutThread() {
        this.m_masterThread.setRunningTimeout(true);
    }

    public void stopTimeoutThread() {
        this.m_masterThread.setRunningTimeout(false);
    }

    public void onTakeFullControl() {
        if (this.m_requestDlg == null) {
            ResourceMgr resourceMgr = ResourceMgr.getInstance();
            this.m_requestDlg = MsgBox.showModallessOKCancelDlg(this.viewport, resourceMgr.getResourceString("server.dlg.request.full.control"), (IOKCancelDlgCallback)this);
            this.m_requestDlg.setVisible(true);
        } else {
            this.m_requestDlg.requestFocus();
        }
    }

    public void onStorageServerStatus(StorageStatus storageStatus) {
        if (this.isStorageWorking() && (this.isExeStorageSupported() || LUD.isLoaded())) {
            ResourceMgr resourceMgr = ResourceMgr.getInstance();
            ArrayList arrayList = ArrayListStringBufferPool.getInstance();
            StringBuffer stringBuffer = null;
            StringBuffer stringBuffer2 = null;
            StringBuffer stringBuffer3 = null;
            StringBuffer stringBuffer4 = null;
            String string = null;
            String string2 = "";
            String string3 = "";
            MountedDriveMgr mountedDriveMgr = MountedDriveMgr.getInstance();
            mountedDriveMgr.setDeviceShareStatus(storageStatus);
            if (storageStatus.getShareIndex0() != -1 && (storageStatus.getShareStatus0() == 2 || storageStatus.getShareStatus0() == 3)) {
                stringBuffer = Helper.valueOf(storageStatus.getShareIndex0());
                arrayList.add(stringBuffer);
                stringBuffer2 = Helper.formatToHex(storageStatus.getShareStatus0());
                arrayList.add(stringBuffer2);
                stringBuffer3 = StringBufferPool.getInstance(resourceMgr.getResourceString("storage.status." + storageStatus.getShareStatus0()));
                arrayList.add(stringBuffer3);
                stringBuffer4 = StringBufferPool.getInstance(storageStatus.getSharePath0());
                arrayList.add(stringBuffer4);
                string2 = resourceMgr.getResourceString("err.status.device", arrayList);
            }
            if (storageStatus.getShareIndex1() != -1 && (storageStatus.getShareStatus1() == 2 || storageStatus.getShareStatus1() == 3)) {
                if (stringBuffer != null) {
                    StringBufferPool.recycle(stringBuffer);
                    StringBufferPool.recycle(stringBuffer2);
                    StringBufferPool.recycle(stringBuffer3);
                    StringBufferPool.recycle(stringBuffer4);
                }
                arrayList.clear();
                stringBuffer = Helper.valueOf(storageStatus.getShareIndex1());
                arrayList.add(stringBuffer);
                stringBuffer2 = Helper.formatToHex(storageStatus.getShareStatus1());
                arrayList.add(stringBuffer2);
                stringBuffer3 = StringBufferPool.getInstance(resourceMgr.getResourceString("storage.status." + storageStatus.getShareStatus1()));
                arrayList.add(stringBuffer3);
                stringBuffer4 = StringBufferPool.getInstance(storageStatus.getSharePath1());
                arrayList.add(stringBuffer4);
                string3 = resourceMgr.getResourceString("err.status.device", arrayList);
            }
            if (string2.length() > 0 || string3.length() > 0) {
                StringBufferPool.recycle(stringBuffer);
                StringBufferPool.recycle(stringBuffer2);
                StringBufferPool.recycle(stringBuffer3);
                StringBufferPool.recycle(stringBuffer4);
                arrayList.clear();
                stringBuffer = Helper.formatIPAddress(storageStatus.getIPAddress(), storageStatus.getIPType());
                arrayList.add(stringBuffer);
                stringBuffer2 = Helper.valueOf(storageStatus.getPort());
                arrayList.add(stringBuffer2);
                stringBuffer3 = StringBufferPool.getInstance(string2);
                arrayList.add(stringBuffer3);
                stringBuffer4 = StringBufferPool.getInstance(string3);
                arrayList.add(stringBuffer4);
                string = resourceMgr.getResourceString("err.status.device.msg", arrayList);
                if (this.m_stoargeStatusDlg == null) {
                    this.m_stoargeStatusDlg = MsgBox.showModallessMsgDlg(this.viewport, string, (IOKDlgCallback)this);
                    this.m_stoargeStatusDlg.setVisible(true);
                } else {
                    this.m_stoargeStatusDlg.setMessage(string);
                    this.m_stoargeStatusDlg.pack();
                    this.m_stoargeStatusDlg.requestFocus();
                }
            }
            if (stringBuffer != null) {
                StringBufferPool.recycle(stringBuffer);
                StringBufferPool.recycle(stringBuffer2);
                StringBufferPool.recycle(stringBuffer3);
                StringBufferPool.recycle(stringBuffer4);
            }
            ArrayListStringBufferPool.recycle(arrayList);
            this.viewport.getMountDialog().reloadDrives();
        }
    }

    public void onKeyboardCurrentLMS() {
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        if (this.m_isLocalScreenOn) {
            this.viewport.m_lmslabel.setText(resourceMgr.getResourceString("lms.label.on"));
        } else {
            this.viewport.m_lmslabel.setText(resourceMgr.getResourceString("lms.label.off"));
        }
    }

    public boolean isLocalScreenOn() {
        return this.m_isLocalScreenOn;
    }

    public void setLocalScreenon(boolean bl) {
        this.m_isLocalScreenOn = bl;
    }

    public int getCurrentLocalMonitorSetting() {
        return this.CurrentLocalMonitorSetting;
    }

    public void setCurrentLocalMonitorSetting(int n) {
        this.CurrentLocalMonitorSetting = n;
    }

    public MahoganyViewer getViewer() {
        return this.viewer;
    }

    public void clearLockKeys(int n) {
        if ((n & 1) != 0) {
            this.m_ignoreCapsLock = false;
        }
        if ((n & 2) != 0) {
            this.m_ignoreNumLock = false;
        }
        if ((n & 4) != 0) {
            this.m_ignoreScrollLock = false;
        }
    }

    protected void startClearLockKeysThread(int n) {
        this.m_masterThread.setKeysMask(n);
        this.m_masterThread.setRunningClearLockKeys(true);
    }

    public int getAltText() {
        return this.m_altText;
    }

    public boolean isAlt0Text() {
        return this.m_altText == 1;
    }

    public void okCancelCallback(ModallessOKCancelDlg modallessOKCancelDlg, boolean bl) {
        if (modallessOKCancelDlg.equals(this.m_requestDlg) || modallessOKCancelDlg.equals(this.m_sessionRequestDlg)) {
            if (bl) {
                MessageSender.requestPrimaryControl();
            }
            this.m_requestDlg = null;
            this.m_sessionRequestDlg = null;
        }
    }

    public void okCallback(ModallessOKMsgDlg modallessOKMsgDlg) {
        if (modallessOKMsgDlg.equals(this.m_secondaryControlDlg)) {
            this.m_secondaryControlDlg = null;
        } else if (modallessOKMsgDlg.equals(this.m_newConnectionDlg)) {
            this.m_newConnectionDlg = null;
        } else if (modallessOKMsgDlg.equals(this.m_stoargeStatusDlg)) {
            this.m_stoargeStatusDlg = null;
        } else if (modallessOKMsgDlg.equals(this.m_kvmExeFailedDlg)) {
            this.m_kvmExeFailedDlg = null;
        } else if (modallessOKMsgDlg.equals(this.m_msgDlg)) {
            this.m_msgDlg = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

