/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.kvm;

import com.serverengines.buffer.Buffers;
import com.serverengines.graphics.ScreenMode;
import com.serverengines.graphics.TextMode;
import com.serverengines.mahogany.DesktopWindow;

public class PixelBuffer {
    public static final int DEFAULT_BPP = 8;
    public static final int ATTRIBUTE_SHIFT_AMT = 4;
    public static final int USE_4BPP_LOWER_FLAG_INDEX = 16;
    public static final int USE_4BPP_FLAG_MASK = 128;
    public static final int ATTRIBUTE_INDEX = 20;
    public static final int LOWER_NIBBLE_MASK = 3;
    public static final int LOWER_NIBBLE_SHIFT = 4;
    public static final int SPECIAL_4BPP_MASK = 207;
    protected int m_width_;
    protected int m_height_;
    protected boolean m_isSpecial4bppMode = false;
    protected ScreenMode m_screenFormat;
    protected int m_screenMode;
    protected int m_bpp = 8;
    protected int m_colorIndex = 0;

    public final int width() {
        return this.m_width_;
    }

    public final int height() {
        return this.m_height_;
    }

    public int getStride() {
        return this.m_width_;
    }

    public void convertAttributesToPalette(int n, int n2, int n3, int n4) {
        int n5 = 0;
        boolean bl = false;
        byte[] byArray = this.m_screenFormat.getAttributes();
        int n6 = this.m_colorIndex << 4;
        int n7 = n2 * this.m_width_ + n;
        if (this.m_isSpecial4bppMode) {
            boolean bl2 = bl = (byArray[16] & 0x80) != 0;
            if (bl) {
                n5 = (byArray[20] & 3) << 4;
            }
        }
        if (n2 + n4 > this.m_height_) {
            n4 -= n2 + n4 - this.m_height_;
        }
        for (int i = 0; i < n4; ++i) {
            int n8 = n7 + i * this.m_width_;
            for (int j = 0; j < n3; ++j) {
                byte by = byArray[Buffers.m_attributeScreen[n8] | n6];
                if (bl) {
                    by = (byte)(by & 0xCF);
                }
                Buffers.m_paletteScreen[n8] = (byte)(by | n5);
                ++n8;
            }
        }
    }

    public void setSpecial4bppMode(boolean bl) {
        this.m_isSpecial4bppMode = bl;
    }

    public void clearPrevTextCursor(DesktopWindow desktopWindow) {
        this.m_screenFormat.clearPrevTextCursor(desktopWindow, Buffers.m_attributeScreen);
        this.convertAttributesToPalette(0, 0, this.m_screenFormat.getScreenWidthPixel(), this.m_screenFormat.getScreenHeightPixel());
    }

    public void setTextCursor(int n, int n2, int n3, int n4) {
        this.m_screenFormat.setTextCursor(n, n2, n3, n4, Buffers.m_attributeScreen);
        this.convertAttributesToPalette(0, 0, this.m_screenFormat.getScreenWidthPixel(), this.m_screenFormat.getScreenHeightPixel());
    }

    public void toggleBlinkingText(byte[] byArray) {
        this.m_screenFormat.toggleBlinkingText(byArray);
    }

    public void dbeSwap(boolean bl, int n, int n2) {
        this.m_screenFormat.dbeSwap(bl, n, n2, Buffers.m_attributeScreen);
        this.convertAttributesToPalette(0, 0, this.m_screenFormat.getScreenWidthPixel(), this.m_screenFormat.getScreenHeightPixel());
    }

    public void onSetBPP4ColorIndex(int n) {
        this.m_colorIndex = n;
    }

    public void setBlinking(boolean bl) {
        this.m_screenFormat.setBlinking(bl);
    }

    public int getScreenMode() {
        return this.m_screenMode;
    }

    public ScreenMode getScreenFormat() {
        return this.m_screenFormat;
    }

    public boolean isInTextMode() {
        return this.m_screenFormat != null && this.m_screenFormat instanceof TextMode;
    }

    public int getColorIndex() {
        return this.m_colorIndex;
    }
}

