/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.kvm;

import com.serverengines.helper.StringBufferPool;
import com.serverengines.kvm.LogFile;
import com.serverengines.resmgr.SettingsResMgr;

public class LogWriter {
    public static final String NAME_SEPERATOR = ": ";
    public static final int ERROR_LEVEL = 0;
    public static final int STATUS_LEVEL = 10;
    public static final int INFO_LEVEL = 30;
    public static final int DEBUG_LEVEL = 100;
    public static final int LOG_NOTHING = -10;
    public static final int LOG_EVERYTHING = 110;
    public static final int NO_LOG = 0;
    public static final int CONSOLE_LOG = 1;
    public static final int FILE_LOG = 2;
    public static final int CONSOLE_AND_FILE_LOG = 3;
    protected static boolean s_consoleLogging = false;
    protected static boolean s_logFileLogging = false;
    protected static LogWriter s_logWriters = null;
    protected static int s_globalLogLevel = 110;
    protected static LogFile s_logFileWriter = new LogFile();
    protected String name;
    protected int level;
    protected LogWriter next;

    public static void configureLogging() {
        SettingsResMgr settingsResMgr = SettingsResMgr.getInstance();
        int n = settingsResMgr.getResourceInt("initial.enable.msgs");
        s_consoleLogging = (n & 1) != 0;
        s_logFileLogging = (n & 2) != 0;
        s_logFileWriter.close();
        s_logFileWriter = new LogFile();
    }

    public LogWriter(String string) {
        this.name = string;
        this.level = s_globalLogLevel;
        this.next = s_logWriters;
        s_logWriters = this;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void write(int n, String string) {
        if (n <= this.level) {
            StringBuffer stringBuffer = StringBufferPool.getInstance(this.name);
            stringBuffer.append(NAME_SEPERATOR);
            stringBuffer.append(string);
            if (s_consoleLogging) {
                System.err.println(stringBuffer);
            }
            if (s_logFileLogging) {
                s_logFileWriter.write(stringBuffer.toString());
            }
            StringBufferPool.recycle(stringBuffer);
        }
    }

    public void write(int n, Throwable throwable) {
        if (n <= this.level) {
            StringBuffer stringBuffer = StringBufferPool.getInstance(this.name);
            stringBuffer.append(NAME_SEPERATOR);
            if (s_consoleLogging) {
                System.err.println(stringBuffer);
                throwable.printStackTrace(System.err);
            }
            if (s_logFileLogging) {
                s_logFileWriter.write(stringBuffer.toString());
                s_logFileWriter.write(throwable);
            }
            StringBufferPool.recycle(stringBuffer);
        }
    }

    public boolean isLoggingEnabled(int n) {
        return n <= this.level;
    }

    public boolean isDebugLoggingEnabled() {
        return 100 <= this.level;
    }

    public boolean isInfoLoggingEnabled() {
        return 30 <= this.level;
    }

    public boolean isStatusLoggingEnabled() {
        return 10 <= this.level;
    }

    public boolean isErrorLoggingEnabled() {
        return 0 <= this.level;
    }

    public void error(String string) {
        this.write(0, string);
    }

    public void status(String string) {
        this.write(10, string);
    }

    public void info(String string) {
        this.write(30, string);
    }

    public void debug(String string) {
        this.write(100, string);
    }

    public void error(Throwable throwable) {
        this.write(0, throwable);
    }

    public void status(Throwable throwable) {
        this.write(10, throwable);
    }

    public void info(Throwable throwable) {
        this.write(30, throwable);
    }

    public void debug(Throwable throwable) {
        this.write(100, throwable);
    }

    public static void close() {
        s_logFileWriter.close();
    }

    public static void setGlobalLoggingLevel(int n) {
        s_globalLogLevel = n;
        LogWriter logWriter = s_logWriters;
        while (logWriter != null) {
            logWriter.setLevel(s_globalLogLevel);
            logWriter = logWriter.next;
        }
    }

    public static boolean setLogParams(String string) {
        s_globalLogLevel = Integer.parseInt(string);
        LogWriter logWriter = s_logWriters;
        while (logWriter != null) {
            logWriter.setLevel(s_globalLogLevel);
            logWriter = logWriter.next;
        }
        return true;
    }

    static LogWriter getLogWriter(String string) {
        LogWriter logWriter = s_logWriters;
        while (logWriter != null) {
            if (string.equalsIgnoreCase(logWriter.name)) {
                return logWriter;
            }
            logWriter = logWriter.next;
        }
        return null;
    }
}

