/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.keyboard;

import com.serverengines.keyboard.Keyboard;
import com.serverengines.keyboard.KeyboardMgr;
import com.serverengines.mahogany.BaseDialog;
import com.serverengines.mahogany.CConn;
import com.serverengines.mahogany.DesktopWindow;
import com.serverengines.resmgr.ResourceMgr;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class KeyboardWindow
extends BaseDialog {
    static final long serialVersionUID = 4918636203247993498L;

    public KeyboardWindow(Frame frame, DesktopWindow desktopWindow) {
        super(frame, ResourceMgr.getInstance().getResourceString("keyboard.window.title"), false);
        this.changeLayout();
        this.initPosiiton();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(121, 0);
        AbstractAction abstractAction = new AbstractAction(){
            static final long serialVersionUID = -6803159439231523484L;

            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardWindow.this.onF10();
            }
        };
        this.getRootPane().getInputMap(1).put(keyStroke, "F10");
        this.getRootPane().getActionMap().put("F10", abstractAction);
        this.setResizable(false);
    }

    protected void onF10() {
        CConn cConn = KeyboardMgr.getInstance().getCConn();
        cConn.writeKeyEvent(67, true);
        cConn.writeKeyEvent(67, false);
    }

    protected void setEscapeKey() {
    }

    protected void initMenu() {
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        Keyboard keyboard = keyboardMgr.getKeyboard();
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        JMenuBar jMenuBar = new JMenuBar();
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu jMenu = new JMenu(resourceMgr.getResourceString("keyboard.menu.menu"));
        JMenuItem jMenuItem = new JRadioButtonMenuItem(resourceMgr.getResourceString("keyboard.menu.enhanced"), true);
        jMenu.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardWindow.this.onEnhancedKeyboard();
            }
        });
        jMenuItem = new JRadioButtonMenuItem(resourceMgr.getResourceString("keyboard.menu.standard"), false);
        buttonGroup.add(jMenuItem);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardWindow.this.onStandardKeyboard();
            }
        });
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(resourceMgr.getResourceString("menu.kvms.exit"));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardWindow.this.onOK();
            }
        });
        jMenuBar.add(jMenu);
        keyboard.setMenu(jMenuBar);
        this.setJMenuBar(jMenuBar);
    }

    protected void configureLayout(boolean bl) {
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        Keyboard keyboard = keyboardMgr.getKeyboard();
        this.getContentPane().removeAll();
        keyboard.initKeyboardLockedKeys(this);
        JPanel jPanel = keyboard.getLayout(bl);
        this.getContentPane().add("Center", jPanel);
        this.pack();
    }

    public void changeLayout() {
        this.initMenu();
        this.configureLayout(true);
    }

    public void onOK() {
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        Keyboard keyboard = keyboardMgr.getKeyboard();
        keyboard.unsetKeysDown();
        KeyboardMgr keyboardMgr2 = KeyboardMgr.getInstance();
        CConn cConn = keyboardMgr2.getCConn();
        cConn.closeKeyboardWindow();
        super.onOK();
    }

    protected void onEnhancedKeyboard() {
        this.configureLayout(true);
    }

    protected void onStandardKeyboard() {
        this.configureLayout(false);
    }

    protected void onCancel() {
        this.onOK();
    }
}

