/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.keyboard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class KeyboardState {
    protected boolean m_capsLockState;
    protected int m_numOfControlsDown;
    protected boolean m_rightControlState;
    protected boolean m_scrollLockState;
    protected int m_numOfAltsDown;
    protected boolean m_altGRState;
    protected int m_numOfWinsDown;
    protected boolean m_numLockState;
    protected boolean m_popupState;
    protected boolean m_lockKeyState;
    protected ArrayList m_specialValueArray = new ArrayList();
    protected HashMap m_shiftHash = new HashMap();

    public KeyboardState() {
        this.clear();
    }

    public boolean isCapsPressed() {
        return this.m_capsLockState;
    }

    public void setCapsPressed(boolean bl) {
        this.m_capsLockState = bl;
    }

    public boolean isShiftPressed() {
        boolean bl = false;
        Iterator iterator = this.m_shiftHash.values().iterator();
        while (!bl && iterator.hasNext()) {
            Boolean bl2 = (Boolean)iterator.next();
            bl = bl2;
        }
        return bl;
    }

    public void setShiftPressed(int n, boolean bl) {
        this.m_shiftHash.put(new Integer(n), new Boolean(bl));
    }

    public boolean isControlPressed() {
        return this.m_numOfControlsDown > 0;
    }

    public void incrementControlPressed() {
        ++this.m_numOfControlsDown;
    }

    public void decrementControlPressed() {
        --this.m_numOfControlsDown;
    }

    public boolean isRightControlPressed() {
        return this.m_rightControlState;
    }

    public void setRightControlPressed(boolean bl) {
        this.m_rightControlState = bl;
    }

    public boolean isAltPressed() {
        return this.m_numOfAltsDown > 0;
    }

    public void incrementAltPressed() {
        ++this.m_numOfAltsDown;
    }

    public void decrementAltPressed() {
        --this.m_numOfAltsDown;
    }

    public boolean isAltGRPressed() {
        return this.m_altGRState;
    }

    public void setAltGRPressed(boolean bl) {
        this.m_altGRState = bl;
    }

    public boolean isWinPressed() {
        return this.m_numOfWinsDown > 0;
    }

    public boolean isLockPressed() {
        return this.m_lockKeyState;
    }

    public void setLockPressed(boolean bl) {
        this.m_lockKeyState = bl;
    }

    public void incrementWinPressed() {
        ++this.m_numOfWinsDown;
    }

    public void decrementWinPressed() {
        --this.m_numOfWinsDown;
    }

    public boolean isNumLock() {
        return this.m_numLockState;
    }

    public void setNumLock(boolean bl) {
        this.m_numLockState = bl;
    }

    public boolean isScrollLock() {
        return this.m_scrollLockState;
    }

    public void setScrollLock(boolean bl) {
        this.m_scrollLockState = bl;
    }

    public boolean isPopup() {
        return this.m_popupState;
    }

    public void setPopup(boolean bl) {
        this.m_popupState = bl;
    }

    public int getSpecialKeyStateValue() {
        int n = 0;
        Iterator iterator = this.m_specialValueArray.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            n |= n2.intValue();
        }
        return n;
    }

    public void setSpecialKeyStateValue(int n, int n2) {
        if (n < this.m_specialValueArray.size()) {
            this.m_specialValueArray.set(n, new Integer(n2));
        } else {
            this.m_specialValueArray.add(new Integer(n2));
        }
    }

    public void clear() {
        this.m_numOfControlsDown = 0;
        this.m_numOfAltsDown = 0;
        this.m_numOfWinsDown = 0;
        this.m_shiftHash.put(new Integer(0), new Boolean(false));
        this.m_shiftHash.put(new Integer(1), new Boolean(false));
        this.m_rightControlState = false;
        this.m_altGRState = false;
        this.m_popupState = false;
        this.m_lockKeyState = false;
    }
}

