/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.keyboard;

import com.serverengines.helper.Helper;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.keyboard.Keyboard;
import com.serverengines.keyboard.KeyboardElement;
import com.serverengines.keyboard.KeyboardFace;
import com.serverengines.keyboard.KeyboardMgr;
import com.serverengines.kvm.LogWriter;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class KeyboardKey
extends KeyboardElement
implements MouseListener,
KeyListener {
    protected static LogWriter s_logger = new LogWriter((class$com$serverengines$keyboard$KeyboardKey == null ? (class$com$serverengines$keyboard$KeyboardKey = KeyboardKey.class$("com.serverengines.keyboard.KeyboardKey")) : class$com$serverengines$keyboard$KeyboardKey).getName());
    protected int m_hid;
    protected int m_width;
    protected int m_height;
    protected AbstractButton m_button;
    protected HashMap m_keyFaces;
    protected boolean m_isPressed;
    protected Keyboard m_keyboard;
    static /* synthetic */ Class class$com$serverengines$keyboard$KeyboardKey;

    public KeyboardKey(int n, Keyboard keyboard) {
        this.m_hid = n;
        this.m_width = 0;
        this.m_height = 0;
        this.createButton();
        this.m_button.addKeyListener(this);
        this.m_button.addMouseListener(this);
        this.m_button.setFocusTraversalKeysEnabled(false);
        this.m_keyFaces = new HashMap();
        this.m_isPressed = false;
        this.m_keyboard = keyboard;
    }

    protected void createButton() {
        this.m_button = new JButton();
    }

    public boolean isKeyStuck() {
        return false;
    }

    public int getHid() {
        return this.m_hid;
    }

    public Keyboard getKeyboard() {
        return this.m_keyboard;
    }

    public Component getComponent() {
        return this.m_button;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.setPressed(true);
            KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
            Keyboard keyboard = keyboardMgr.getKeyboard();
            keyboard.writeBtnPress(this);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.setPressed(false);
            KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
            Keyboard keyboard = keyboardMgr.getKeyboard();
            keyboard.writeBtnRelease(this);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (s_logger.isDebugLoggingEnabled()) {
            s_logger.debug("keyPressed - Key pressed.");
        }
        KeyboardMgr.getInstance().getCConn().getDesktop().keyPressed(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (s_logger.isDebugLoggingEnabled()) {
            s_logger.debug("keyReleased - Key released.");
        }
        KeyboardMgr.getInstance().getCConn().getDesktop().keyReleased(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (s_logger.isDebugLoggingEnabled()) {
            s_logger.debug("keyTyped - Key typed.");
        }
        KeyboardMgr.getInstance().getCConn().getDesktop().keyTyped(keyEvent);
    }

    protected void initDimensions(KeyboardFace keyboardFace) {
        if (this.m_width == 0) {
            StringBuffer stringBuffer = StringBufferPool.getInstance(this.m_keyboard.getImageDir());
            stringBuffer.append(keyboardFace.getImageName());
            stringBuffer.append(this.m_keyboard.getImageExtension());
            ImageIcon imageIcon = Helper.getIcon(stringBuffer);
            StringBufferPool.recycle(stringBuffer);
            this.m_width = imageIcon.getIconWidth();
            this.m_height = imageIcon.getIconHeight();
        }
    }

    public void writeBtnClick() {
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        Keyboard keyboard = keyboardMgr.getKeyboard();
        keyboard.writeBtnPress(this);
        keyboard.writeBtnRelease(this);
    }

    public KeyboardFace addKeyFace(int n, String string, int n2) {
        KeyboardFace keyboardFace = new KeyboardFace(string, n2);
        this.m_keyFaces.put(new Integer(n), keyboardFace);
        this.initDimensions(keyboardFace);
        return keyboardFace;
    }

    public void setKeyFace(int n) {
        Icon icon;
        KeyboardFace keyboardFace = (KeyboardFace)this.m_keyFaces.get(new Integer(n));
        if (keyboardFace == null) {
            icon = this.m_keyboard.getBlankIcon();
        } else {
            StringBuffer stringBuffer = this.m_keyboard.getImageDir();
            StringBuffer stringBuffer2 = StringBufferPool.getInstance(stringBuffer);
            stringBuffer2.append(keyboardFace.getImageName());
            stringBuffer2.append(this.m_keyboard.getImageExtension());
            icon = Helper.getIcon(stringBuffer2);
            StringBufferPool.recycle(stringBuffer2);
        }
        if (icon != null) {
            this.m_button.setIcon(icon);
        }
    }

    public void changeState() {
    }

    public void highlightButton(boolean bl) {
    }

    public boolean isPressed() {
        return this.m_isPressed;
    }

    public void setPressed(boolean bl) {
        this.m_isPressed = bl;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

