/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.keyboard;

import com.serverengines.helper.Helper;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.helper.StringParser;
import com.serverengines.keyboard.AltGRKey;
import com.serverengines.keyboard.AltKey;
import com.serverengines.keyboard.CapsLockKey;
import com.serverengines.keyboard.ControlKey;
import com.serverengines.keyboard.DualKey;
import com.serverengines.keyboard.ExtendedKeyboardLayout;
import com.serverengines.keyboard.IKeyboardLayout;
import com.serverengines.keyboard.KeyboardElement;
import com.serverengines.keyboard.KeyboardGeneralResMgr;
import com.serverengines.keyboard.KeyboardKey;
import com.serverengines.keyboard.KeyboardMenu;
import com.serverengines.keyboard.KeyboardMenuGroup;
import com.serverengines.keyboard.KeyboardMenuItem;
import com.serverengines.keyboard.KeyboardMgr;
import com.serverengines.keyboard.KeyboardRow;
import com.serverengines.keyboard.KeyboardSpace;
import com.serverengines.keyboard.KeyboardState;
import com.serverengines.keyboard.KeyboardWindow;
import com.serverengines.keyboard.LockToggleKey;
import com.serverengines.keyboard.NumKey;
import com.serverengines.keyboard.NumLockKey;
import com.serverengines.keyboard.NumpadKeyboardLayout;
import com.serverengines.keyboard.PopupKey;
import com.serverengines.keyboard.RightControlKey;
import com.serverengines.keyboard.ScrollLockKey;
import com.serverengines.keyboard.ShiftLockKey;
import com.serverengines.keyboard.StandardKeyboardLayout;
import com.serverengines.keyboard.StateKey;
import com.serverengines.keyboard.VerticalPadKeyboardLayout;
import com.serverengines.keyboard.WindowsKey;
import com.serverengines.kvm.LogWriter;
import com.serverengines.mahogany.CConn;
import com.serverengines.resmgr.AppResMgr;
import com.serverengines.resmgr.KeyMappingResMgr;
import com.serverengines.resmgr.ResourceMgr;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Keyboard {
    public static final String INCLUDE = ":include";
    public static final String BEGIN_STD = ":beginstd";
    public static final String BEGIN_EXT = ":beginext";
    public static final String BEGIN_NUM = ":beginnum";
    public static final String END_LAYOUT = ":endlayout";
    public static final String BEGIN_MENU = ":beginmenu";
    public static final String END_MENU = ":endmenu";
    public static final String BEGIN = ":begin";
    public static final String END = ":end";
    public static final String KEY = ":key";
    public static final String SPACE = ":space";
    public static final String VSPACE = ":vspace";
    public static final String MENU_GROUP = ":menugroup";
    public static final String MENU_SEP = ":menusep";
    public static final String FIELD_SEPARATOR = ",";
    public static final String MAP_SEPARATOR = ";";
    public static final int NORMAL_KEY = 0;
    public static final int NUMPAD_KEY = 1;
    public static final int LEFT_SHIFT_KEY = 2;
    public static final int CONTROL_KEY = 3;
    public static final int RIGHT_CONTROL_KEY = 4;
    public static final int ALT_KEY = 5;
    public static final int ALT_GR_KEY = 6;
    public static final int WIN_KEY = 7;
    public static final int CONTEXT_KEY = 8;
    public static final int CAPS_LOCK_KEY = 9;
    public static final int NUM_LOCK_KEY = 10;
    public static final int SCROLL_LOCK_KEY = 11;
    public static final int LOCK_KEY = 12;
    public static final int RIGHT_SHIFT_KEY = 13;
    public static final int DUAL_NORMAL_AND_CAPS_LOCK_KEY = 14;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_SHIFT = 1;
    public static final int STATE_CAPS = 2;
    public static final int STATE_NUM_LOCK = 4;
    public static final int STATE_ALT_GR = 8;
    public static final int STATE_R_CTL = 16;
    protected static LogWriter s_logger = new LogWriter((class$com$serverengines$keyboard$Keyboard == null ? (class$com$serverengines$keyboard$Keyboard = Keyboard.class$("com.serverengines.keyboard.Keyboard")) : class$com$serverengines$keyboard$Keyboard).getName());
    protected int m_keyboardLayout;
    protected KeyboardWindow m_keyboardWindow;
    protected KeyboardGeneralResMgr m_keyboardResMgr;
    protected KeyboardRow m_keyboardRow;
    protected IKeyboardLayout m_currentLayout;
    protected ArrayList m_keyboardLayoutArray;
    protected ArrayList m_customMenuArray;
    protected ArrayList m_keysArray;
    protected ArrayList m_shiftKeyArray;
    protected ArrayList m_altKeyArray;
    protected ArrayList m_controlKeyArray;
    protected ArrayList m_winKeyArray;
    protected ArrayList m_popupKeyArray;
    protected HashSet m_keyPressesHash;
    protected KeyboardState m_keyboardState;
    protected KeyboardMenu m_currentMenu;
    protected int m_horizPadding;
    protected int m_vertPadding;
    protected int m_menuPos;
    protected String m_imageExtension;
    protected String m_highlightExtension;
    protected String m_tooltipStr;
    protected Icon m_spaceIcon;
    protected Icon m_blankIcon;
    protected StringBuffer m_keyboardImageBaseDir;
    protected StringBuffer m_baseKeyMenuResource;
    protected KeyboardKey m_capsLockKey;
    protected KeyboardKey m_numLockKey;
    protected KeyboardKey m_scrollLockKey;
    protected KeyboardKey m_lockKey;
    protected KeyboardKey m_altGRKey;
    protected KeyboardKey m_rightControlKey;
    protected KeyMappingResMgr m_keymappingsResMgr;
    protected int m_lineCount;
    protected Color m_kayboardBGColor;
    static /* synthetic */ Class class$com$serverengines$keyboard$Keyboard;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Keyboard(int n) {
        block15: {
            BufferedReader bufferedReader = null;
            this.m_keyboardLayout = n;
            this.m_keyboardState = new KeyboardState();
            this.m_keyboardLayoutArray = new ArrayList();
            this.m_customMenuArray = new ArrayList();
            this.m_keysArray = new ArrayList();
            this.m_shiftKeyArray = new ArrayList();
            this.m_altKeyArray = new ArrayList();
            this.m_controlKeyArray = new ArrayList();
            this.m_winKeyArray = new ArrayList();
            this.m_popupKeyArray = new ArrayList();
            this.m_keyPressesHash = new HashSet();
            this.m_lineCount = 1;
            this.m_horizPadding = 0;
            this.m_vertPadding = 0;
            this.m_menuPos = 0;
            this.m_keyboardWindow = null;
            this.m_currentLayout = null;
            this.m_keyboardRow = null;
            this.m_imageExtension = null;
            this.m_highlightExtension = null;
            this.m_tooltipStr = null;
            this.m_baseKeyMenuResource = null;
            this.m_keyboardImageBaseDir = null;
            this.m_kayboardBGColor = null;
            this.m_capsLockKey = null;
            this.m_numLockKey = null;
            this.m_scrollLockKey = null;
            this.m_lockKey = null;
            this.m_altGRKey = null;
            this.m_rightControlKey = null;
            this.m_currentMenu = null;
            AppResMgr appResMgr = AppResMgr.getInstance();
            StringBuffer stringBuffer = StringBufferPool.getInstance("keymappings.");
            stringBuffer.append(this.m_keyboardLayout);
            String string = appResMgr.getResourceString(stringBuffer.toString());
            this.m_keymappingsResMgr = new KeyMappingResMgr(string);
            stringBuffer.setLength(0);
            stringBuffer.append("keyboard.layout.");
            stringBuffer.append(this.m_keyboardLayout);
            String string2 = appResMgr.getResourceString(stringBuffer.toString());
            StringBufferPool.recycle(stringBuffer);
            InputStream inputStream = Helper.getResourceStream(string2);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                this.parseCommand(string3);
                string3 = bufferedReader.readLine();
                ++this.m_lineCount;
            }
            Object var10_10 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block15;
            }
            catch (IOException iOException) {
                if (s_logger.isErrorLoggingEnabled()) {
                    s_logger.error(iOException);
                }
                break block15;
            }
            {
                catch (Exception exception) {
                    if (s_logger.isErrorLoggingEnabled()) {
                        s_logger.error("Error reading keyboard layout file:");
                        s_logger.error(exception);
                    }
                    Object var10_11 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {
                        if (s_logger.isErrorLoggingEnabled()) {
                            s_logger.error(iOException);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block16: {
                    Object var10_12 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!s_logger.isErrorLoggingEnabled()) break block16;
                        s_logger.error(iOException);
                    }
                }
                throw throwable;
            }
        }
    }

    protected void setKeyIndicators() {
        this.m_keyboardState.setCapsPressed(this.m_capsLockKey.isKeyStuck());
        this.m_keyboardState.setNumLock(this.m_numLockKey.isPressed());
        this.m_keyboardState.setScrollLock(this.m_scrollLockKey.isPressed());
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        CConn cConn = keyboardMgr.getCConn();
        cConn.informKeyIndicators(this.m_capsLockKey.isKeyStuck(), this.m_numLockKey.isPressed(), this.m_scrollLockKey.isPressed());
        this.m_capsLockKey.highlightButton(this.m_capsLockKey.isKeyStuck());
        this.m_numLockKey.highlightButton(this.m_numLockKey.isPressed());
        this.m_scrollLockKey.highlightButton(this.m_scrollLockKey.isPressed());
        this.updateKeyState();
    }

    public String getImageExtension() {
        return this.m_imageExtension;
    }

    public String getHighlightExtension() {
        return this.m_highlightExtension;
    }

    public StringBuffer getImageDir() {
        return this.m_keyboardImageBaseDir;
    }

    public Icon getBlankIcon() {
        return this.m_blankIcon;
    }

    public int getHorizontalPadding() {
        return this.m_horizPadding;
    }

    public int getVerticalPadding() {
        return this.m_vertPadding;
    }

    public Icon getSpaceIcon() {
        return this.m_spaceIcon;
    }

    public Color getBackgroundColor() {
        return this.m_kayboardBGColor;
    }

    protected void parseCommand(String string) {
        StringParser stringParser = StringParser.getInstance(string, FIELD_SEPARATOR);
        String string2 = stringParser.nextToken().trim().toLowerCase();
        if (string2.length() != 0) {
            if (string2.equals(KEY)) {
                this.parseKey(stringParser);
            } else if (string2.equals(SPACE)) {
                this.parseSpace(stringParser);
            } else if (string2.equals(INCLUDE)) {
                this.parseInclude(stringParser);
            } else if (string2.equals(BEGIN)) {
                this.parseBegin(stringParser);
            } else if (string2.equals(END)) {
                this.parseEnd(stringParser);
            } else if (string2.equals(BEGIN_STD)) {
                this.parseBeginStd(stringParser);
            } else if (string2.equals(BEGIN_EXT)) {
                this.parseBeginExt(stringParser);
            } else if (string2.equals(BEGIN_NUM)) {
                this.parseBeginNum(stringParser);
            } else if (string2.equals(END_LAYOUT)) {
                this.parseEndLayout(stringParser);
            } else if (string2.equals(VSPACE)) {
                this.parseVerticalSpace(stringParser);
            } else if (string2.equals(BEGIN_MENU)) {
                this.parseBeginMenu(stringParser);
            } else if (string2.equals(END_MENU)) {
                this.parseEndMenu(stringParser);
            } else if (string2.equals(MENU_GROUP)) {
                this.parseMenuGroup(stringParser);
            } else if (string2.equals(MENU_SEP)) {
                this.parseMenuSeperator(stringParser);
            } else if (s_logger.isErrorLoggingEnabled()) {
                StringBuffer stringBuffer = StringBufferPool.getInstance("L: ");
                stringBuffer.append(this.m_lineCount);
                stringBuffer.append(": Unknown command token: '");
                stringBuffer.append(string2);
                stringBuffer.append('\'');
                s_logger.error(stringBuffer.toString());
                StringBufferPool.recycle(stringBuffer);
            }
        }
        stringParser.recycle();
    }

    protected void parseKey(StringParser stringParser) {
        block44: {
            try {
                KeyboardKey keyboardKey;
                StringBuffer stringBuffer;
                StringBuffer stringBuffer2;
                String string;
                StringParser stringParser2;
                int n;
                int n2;
                block43: {
                    block42: {
                        if (stringParser.countTokens() < 4) {
                            return;
                        }
                        n2 = 0;
                        n = 0;
                        stringParser2 = StringParser.getInstance();
                        string = stringParser.nextToken().trim();
                        try {
                            if (string.length() > 0) {
                                n2 = Integer.parseInt(string);
                                if (n2 < 0 && s_logger.isErrorLoggingEnabled()) {
                                    stringBuffer2 = StringBufferPool.getInstance("L: ");
                                    stringBuffer2.append(this.m_lineCount);
                                    stringBuffer2.append(": Hid value: ");
                                    stringBuffer2.append(n2);
                                    stringBuffer2.append(" needs to be 0 or greater");
                                    s_logger.error(stringBuffer2.toString());
                                    StringBufferPool.recycle(stringBuffer2);
                                }
                            } else if (s_logger.isErrorLoggingEnabled()) {
                                stringBuffer2 = StringBufferPool.getInstance("L: ");
                                stringBuffer2.append(this.m_lineCount);
                                stringBuffer2.append(": Hid value is not specified");
                                s_logger.error(stringBuffer2.toString());
                                StringBufferPool.recycle(stringBuffer2);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (!s_logger.isErrorLoggingEnabled()) break block42;
                            stringBuffer = StringBufferPool.getInstance("L: ");
                            stringBuffer.append(this.m_lineCount);
                            stringBuffer.append(": Hid value: '");
                            stringBuffer.append(string);
                            stringBuffer.append("' needs to be a numeric value");
                            s_logger.error(stringBuffer.toString());
                            StringBufferPool.recycle(stringBuffer);
                            s_logger.error(numberFormatException);
                        }
                    }
                    string = stringParser.nextToken().trim();
                    try {
                        if (string.length() > 0) {
                            n = Integer.parseInt(string);
                        } else if (s_logger.isErrorLoggingEnabled()) {
                            stringBuffer2 = StringBufferPool.getInstance("L: ");
                            stringBuffer2.append(this.m_lineCount);
                            stringBuffer2.append(": Key type is not specified");
                            s_logger.error(stringBuffer2.toString());
                            StringBufferPool.recycle(stringBuffer2);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!s_logger.isErrorLoggingEnabled()) break block43;
                        stringBuffer = StringBufferPool.getInstance("L: ");
                        stringBuffer.append(this.m_lineCount);
                        stringBuffer.append(": Key type: '");
                        stringBuffer.append(string);
                        stringBuffer.append("' needs to be a numeric value");
                        s_logger.error(stringBuffer.toString());
                        StringBufferPool.recycle(stringBuffer);
                        s_logger.error(numberFormatException);
                    }
                }
                switch (n) {
                    case 9: {
                        keyboardKey = this.initCapsLock(n2);
                        break;
                    }
                    case 14: {
                        keyboardKey = this.initDualCapsLock(n2);
                        break;
                    }
                    case 1: {
                        keyboardKey = this.initNumKey(n2);
                        break;
                    }
                    case 2: {
                        keyboardKey = this.initShift(n2, 0);
                        break;
                    }
                    case 13: {
                        keyboardKey = this.initShift(n2, 1);
                        break;
                    }
                    case 3: {
                        keyboardKey = this.initControl(n2);
                        break;
                    }
                    case 4: {
                        keyboardKey = this.initRightControl(n2);
                        break;
                    }
                    case 7: {
                        keyboardKey = this.initWindow(n2);
                        break;
                    }
                    case 5: {
                        keyboardKey = this.initAlt(n2);
                        break;
                    }
                    case 6: {
                        keyboardKey = this.initAltGR(n2);
                        break;
                    }
                    case 11: {
                        keyboardKey = this.initScrollLock(n2);
                        break;
                    }
                    case 10: {
                        keyboardKey = this.initNumLock(n2);
                        break;
                    }
                    case 8: {
                        keyboardKey = this.initPopup(n2);
                        break;
                    }
                    case 12: {
                        keyboardKey = this.initLockKey();
                        break;
                    }
                    default: {
                        keyboardKey = this.initNomalKey(n2);
                    }
                }
                this.m_keysArray.add(keyboardKey);
                this.m_keyboardRow.add(keyboardKey);
                while (stringParser.countTokens() > 2) {
                    string = stringParser.nextToken().trim();
                    stringParser2.setCriteria(string, MAP_SEPARATOR);
                    int n3 = -1;
                    String string2 = stringParser.nextToken().trim();
                    if (string2.length() == 0 && s_logger.isErrorLoggingEnabled()) {
                        stringBuffer2 = StringBufferPool.getInstance("L: ");
                        stringBuffer2.append(this.m_lineCount);
                        stringBuffer2.append(": Image name is not specified");
                        s_logger.error(stringBuffer2.toString());
                        StringBufferPool.recycle(stringBuffer2);
                    }
                    string = stringParser.nextToken().trim();
                    try {
                        if (string.length() > 0) {
                            n3 = Integer.parseInt(string);
                        } else if (s_logger.isErrorLoggingEnabled()) {
                            stringBuffer2 = StringBufferPool.getInstance("L: ");
                            stringBuffer2.append(this.m_lineCount);
                            stringBuffer2.append(": Resource id is not specified");
                            s_logger.error(stringBuffer2.toString());
                            StringBufferPool.recycle(stringBuffer2);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (s_logger.isErrorLoggingEnabled()) {
                            stringBuffer = StringBufferPool.getInstance("L: ");
                            stringBuffer.append(this.m_lineCount);
                            stringBuffer.append(": Resource id: '");
                            stringBuffer.append(string);
                            stringBuffer.append("' needs to be a numeric value");
                            s_logger.error(stringBuffer.toString());
                            StringBufferPool.recycle(stringBuffer);
                            s_logger.error(numberFormatException);
                        }
                        string2 = "";
                    }
                    if (string2.length() <= 0) continue;
                    while (stringParser2.hasMoreTokens()) {
                        string = stringParser2.nextToken().trim();
                        try {
                            if (string.length() > 0) {
                                int n4 = Integer.parseInt(string);
                                keyboardKey.addKeyFace(n4, string2, n3);
                                continue;
                            }
                            if (!s_logger.isErrorLoggingEnabled()) continue;
                            stringBuffer2 = StringBufferPool.getInstance("L: ");
                            stringBuffer2.append(this.m_lineCount);
                            stringBuffer2.append(": Map id is not specified");
                            s_logger.error(stringBuffer2.toString());
                            StringBufferPool.recycle(stringBuffer2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (!s_logger.isErrorLoggingEnabled()) continue;
                            stringBuffer = StringBufferPool.getInstance("L: ");
                            stringBuffer.append(this.m_lineCount);
                            stringBuffer.append(": Map id: '");
                            stringBuffer.append(string);
                            stringBuffer.append("' needs to be a numeric value");
                            s_logger.error(stringBuffer.toString());
                            StringBufferPool.recycle(stringBuffer);
                            s_logger.error(numberFormatException);
                        }
                    }
                }
                stringParser2.recycle();
            }
            catch (Exception exception) {
                if (!s_logger.isErrorLoggingEnabled()) break block44;
                StringBuffer stringBuffer = StringBufferPool.getInstance("L: ");
                stringBuffer.append(this.m_lineCount);
                stringBuffer.append(": Exception occurred while parsing key:");
                s_logger.error(stringBuffer.toString());
                StringBufferPool.recycle(stringBuffer);
                s_logger.error(exception);
            }
        }
    }

    protected void parseSpace(StringParser stringParser) {
        Object object;
        int n = 1;
        String string = stringParser.nextToken().trim();
        if (string.length() > 0) {
            try {
                n = Integer.parseInt(string);
                if (n < 1) {
                    if (s_logger.isErrorLoggingEnabled()) {
                        StringBuffer stringBuffer = StringBufferPool.getInstance("L: ");
                        stringBuffer.append(this.m_lineCount);
                        stringBuffer.append(": Space value is invalid: '");
                        stringBuffer.append(n);
                        stringBuffer.append("' needs to be greater than 0");
                        s_logger.error(stringBuffer.toString());
                        StringBufferPool.recycle(stringBuffer);
                    }
                    n = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (s_logger.isErrorLoggingEnabled()) {
                    object = StringBufferPool.getInstance("L: ");
                    ((StringBuffer)object).append(this.m_lineCount);
                    ((StringBuffer)object).append(": Space value is invalid: '");
                    ((StringBuffer)object).append(string);
                    ((StringBuffer)object).append("' needs to be a numeric value");
                    s_logger.error(((StringBuffer)object).toString());
                    StringBufferPool.recycle((StringBuffer)object);
                    s_logger.error(numberFormatException);
                }
                n = 1;
            }
        }
        for (int i = 0; i < n; ++i) {
            object = new KeyboardSpace(this.m_spaceIcon);
            this.m_keyboardRow.add((KeyboardElement)object);
        }
    }

    protected void parseVerticalSpace(StringParser stringParser) {
        Object object;
        int n = 1;
        String string = stringParser.nextToken().trim();
        if (string.length() > 0) {
            try {
                n = Integer.parseInt(string);
                if (n < 1) {
                    if (s_logger.isErrorLoggingEnabled()) {
                        object = StringBufferPool.getInstance("L: ");
                        ((StringBuffer)object).append(this.m_lineCount);
                        ((StringBuffer)object).append(": Vertical space value is invalid: '");
                        ((StringBuffer)object).append(n);
                        ((StringBuffer)object).append("' needs to be greater than 0");
                        s_logger.error(((StringBuffer)object).toString());
                        StringBufferPool.recycle((StringBuffer)object);
                    }
                    n = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (s_logger.isErrorLoggingEnabled()) {
                    StringBuffer stringBuffer = StringBufferPool.getInstance("L: ");
                    stringBuffer.append(this.m_lineCount);
                    stringBuffer.append(": Vertical space is invalid: '");
                    stringBuffer.append(string);
                    stringBuffer.append("' needs to be a numeric value");
                    s_logger.error(stringBuffer.toString());
                    StringBufferPool.recycle(stringBuffer);
                    s_logger.error(numberFormatException);
                }
                n = 1;
            }
        }
        object = new VerticalPadKeyboardLayout(this, n);
        this.m_keyboardLayoutArray.add(object);
    }

    protected void parseBeginMenu(StringParser stringParser) {
        String string = stringParser.nextToken().trim();
        if (string.length() > 0) {
            StringBuffer stringBuffer = StringBufferPool.getInstance(this.m_baseKeyMenuResource);
            stringBuffer.append(string);
            ResourceMgr resourceMgr = ResourceMgr.getInstance();
            string = resourceMgr.getResourceString(stringBuffer.toString());
            this.m_currentMenu = new KeyboardMenu(string);
            StringBufferPool.recycle(stringBuffer);
            this.m_customMenuArray.add(this.m_currentMenu);
        } else if (s_logger.isErrorLoggingEnabled()) {
            StringBuffer stringBuffer = StringBufferPool.getInstance("L: ");
            stringBuffer.append(this.m_lineCount);
            stringBuffer.append(": Menu name is required.");
            s_logger.error(stringBuffer.toString());
            StringBufferPool.recycle(stringBuffer);
        }
    }

    protected void parseEndMenu(StringParser stringParser) {
        this.m_currentMenu = null;
    }

    protected void parseMenuGroup(StringParser stringParser) {
        KeyboardMenuGroup keyboardMenuGroup = new KeyboardMenuGroup();
        this.m_currentMenu.addMenuGroup(keyboardMenuGroup);
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        ResourceMgr resourceMgr = ResourceMgr.getInstance();
        while (stringParser.countTokens() > 2) {
            Object object;
            String string = stringParser.nextToken().trim();
            if (string.length() > 0) {
                stringBuffer.setLength(0);
                stringBuffer.append(this.m_baseKeyMenuResource);
                stringBuffer.append(string);
                string = stringParser.nextToken().trim();
                if (string.length() > 0) {
                    try {
                        int n = Integer.parseInt(string);
                        string = stringParser.nextToken().trim();
                        boolean bl = Helper.getBoolean(string);
                        string = resourceMgr.getResourceString(stringBuffer.toString());
                        object = new KeyboardMenuItem(string, this.m_menuPos, bl, n);
                        keyboardMenuGroup.addMenuItem((KeyboardMenuItem)object);
                        if (!bl) continue;
                        this.m_keyboardState.setSpecialKeyStateValue(this.m_menuPos, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!s_logger.isErrorLoggingEnabled()) continue;
                        StringBuffer stringBuffer2 = StringBufferPool.getInstance("L: ");
                        stringBuffer2.append(this.m_lineCount);
                        stringBuffer2.append(": Menu item value is invalid: '");
                        stringBuffer2.append(string);
                        stringBuffer2.append("' needs to be a numeric value");
                        s_logger.error(stringBuffer2.toString());
                        StringBufferPool.recycle(stringBuffer2);
                        s_logger.error(numberFormatException);
                    }
                    continue;
                }
                if (!s_logger.isErrorLoggingEnabled()) continue;
                object = StringBufferPool.getInstance("L: ");
                ((StringBuffer)object).append(this.m_lineCount);
                ((StringBuffer)object).append(": Menu item value is required.");
                s_logger.error(((StringBuffer)object).toString());
                StringBufferPool.recycle((StringBuffer)object);
                continue;
            }
            if (!s_logger.isErrorLoggingEnabled()) continue;
            object = StringBufferPool.getInstance("L: ");
            ((StringBuffer)object).append(this.m_lineCount);
            ((StringBuffer)object).append(": Menu item name is required.");
            s_logger.error(((StringBuffer)object).toString());
            StringBufferPool.recycle((StringBuffer)object);
        }
        StringBufferPool.recycle(stringBuffer);
        ++this.m_menuPos;
    }

    protected void parseMenuSeperator(StringParser stringParser) {
        this.m_currentMenu.addMenuSeperator();
    }

    protected KeyboardKey initNomalKey(int n) {
        return new KeyboardKey(n, this);
    }

    protected KeyboardKey initNumKey(int n) {
        return new NumKey(n, this);
    }

    protected KeyboardKey initCapsLock(int n) {
        this.m_capsLockKey = new CapsLockKey(n, this, this.m_keyboardState);
        return this.m_capsLockKey;
    }

    protected KeyboardKey initDualCapsLock(int n) {
        this.m_capsLockKey = new DualKey(n, this, this.m_keyboardState);
        return this.m_capsLockKey;
    }

    protected KeyboardKey initShift(int n, int n2) {
        ShiftLockKey shiftLockKey = new ShiftLockKey(n, this, this.m_keyboardState, n2);
        this.m_shiftKeyArray.add(shiftLockKey);
        return shiftLockKey;
    }

    protected KeyboardKey initControl(int n) {
        ControlKey controlKey = new ControlKey(n, this, this.m_keyboardState);
        this.m_controlKeyArray.add(controlKey);
        return controlKey;
    }

    protected KeyboardKey initRightControl(int n) {
        this.m_rightControlKey = new RightControlKey(n, this, this.m_keyboardState);
        this.m_controlKeyArray.add(this.m_rightControlKey);
        return this.m_rightControlKey;
    }

    protected KeyboardKey initWindow(int n) {
        WindowsKey windowsKey = new WindowsKey(n, this, this.m_keyboardState);
        this.m_winKeyArray.add(windowsKey);
        return windowsKey;
    }

    protected KeyboardKey initAlt(int n) {
        AltKey altKey = new AltKey(n, this, this.m_keyboardState);
        this.m_altKeyArray.add(altKey);
        return altKey;
    }

    protected KeyboardKey initAltGR(int n) {
        this.m_altGRKey = new AltGRKey(n, this, this.m_keyboardState);
        this.m_altKeyArray.add(this.m_altGRKey);
        return this.m_altGRKey;
    }

    protected KeyboardKey initScrollLock(int n) {
        this.m_scrollLockKey = new ScrollLockKey(n, this, this.m_keyboardState);
        return this.m_scrollLockKey;
    }

    protected KeyboardKey initNumLock(int n) {
        this.m_numLockKey = new NumLockKey(n, this, this.m_keyboardState);
        return this.m_numLockKey;
    }

    protected KeyboardKey initPopup(int n) {
        PopupKey popupKey = new PopupKey(n, this, this.m_keyboardState);
        this.m_popupKeyArray.add(popupKey);
        return popupKey;
    }

    protected KeyboardKey initLockKey() {
        this.m_lockKey = new LockToggleKey(0, this, this.m_keyboardState);
        return this.m_lockKey;
    }

    protected void parseInclude(StringParser stringParser) {
        if (!stringParser.hasMoreTokens()) {
            return;
        }
        String string = stringParser.nextToken();
        this.m_keyboardResMgr = new KeyboardGeneralResMgr(string);
        if (this.m_keyboardImageBaseDir != null) {
            StringBufferPool.recycle(this.m_keyboardImageBaseDir);
        }
        this.m_keyboardImageBaseDir = StringBufferPool.getInstance(this.m_keyboardResMgr.getResourceString("image.dir"));
        Helper.makeRelativePath(this.m_keyboardImageBaseDir);
        this.m_horizPadding = this.m_keyboardResMgr.getResourceInt("btn.horizon.padding");
        this.m_vertPadding = this.m_keyboardResMgr.getResourceInt("btn.vertical.padding");
        String string2 = this.m_keyboardResMgr.getResourceString("space.img");
        String string3 = this.m_keyboardResMgr.getResourceString("blank.img");
        this.m_imageExtension = this.m_keyboardResMgr.getResourceString("image.extension");
        this.m_highlightExtension = this.m_keyboardResMgr.getResourceString("highlight.name.extension");
        this.m_tooltipStr = this.m_keyboardResMgr.getResourceString("keyboard.tooltop");
        this.m_kayboardBGColor = new Color(this.m_keyboardResMgr.getResourceInt("keyboard.bg.color"));
        StringBuffer stringBuffer = StringBufferPool.getInstance(this.m_keyboardImageBaseDir);
        stringBuffer.append(string2);
        stringBuffer.append(this.m_imageExtension);
        this.m_spaceIcon = Helper.getIcon(stringBuffer);
        stringBuffer.setLength(0);
        stringBuffer.append(this.m_keyboardImageBaseDir);
        stringBuffer.append(string3);
        stringBuffer.append(this.m_imageExtension);
        this.m_blankIcon = Helper.getIcon(stringBuffer);
        StringBufferPool.recycle(stringBuffer);
        this.m_baseKeyMenuResource = new StringBuffer(this.m_keyboardResMgr.getResourceString("keyboard.menu"));
        this.m_baseKeyMenuResource.append(this.m_keyboardResMgr.getResourceString("keyboard.language"));
    }

    protected void addLayout(IKeyboardLayout iKeyboardLayout) {
        this.m_currentLayout = iKeyboardLayout;
        this.m_keyboardLayoutArray.add(this.m_currentLayout);
    }

    protected void parseBegin(StringParser stringParser) {
        this.m_keyboardRow = new KeyboardRow();
        this.m_currentLayout.add(this.m_keyboardRow);
    }

    protected void parseEnd(StringParser stringParser) {
        this.m_keyboardRow = null;
    }

    protected void parseBeginStd(StringParser stringParser) {
        this.addLayout(new StandardKeyboardLayout(this));
    }

    protected void parseBeginExt(StringParser stringParser) {
        this.addLayout(new ExtendedKeyboardLayout(this));
    }

    protected void parseBeginNum(StringParser stringParser) {
        this.addLayout(new NumpadKeyboardLayout(this));
    }

    protected void parseEndLayout(StringParser stringParser) {
        this.m_currentLayout = null;
    }

    public void setMenu(JMenuBar jMenuBar) {
        KeyboardMenu keyboardMenu = null;
        Iterator iterator = this.m_customMenuArray.iterator();
        while (iterator.hasNext()) {
            keyboardMenu = (KeyboardMenu)iterator.next();
            keyboardMenu.configureMenuElement(this, jMenuBar);
        }
    }

    public void processValue(int n, int n2) {
        this.m_keyboardState.setSpecialKeyStateValue(n, n2);
        this.updateKeyState();
    }

    public JPanel getLayout(boolean bl) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBackground(this.m_kayboardBGColor);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(this.m_vertPadding, this.m_horizPadding, this.m_horizPadding, this.m_vertPadding);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Iterator iterator = this.m_keyboardLayoutArray.iterator();
        while (iterator.hasNext()) {
            IKeyboardLayout iKeyboardLayout = (IKeyboardLayout)iterator.next();
            if (!bl && !(iKeyboardLayout instanceof StandardKeyboardLayout)) continue;
            JPanel jPanel2 = iKeyboardLayout.getLayout();
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
            ++gridBagConstraints.gridx;
        }
        return jPanel;
    }

    public KeyMappingResMgr getKeyMappings() {
        return this.m_keymappingsResMgr;
    }

    public int getKeyboardLayout() {
        return this.m_keyboardLayout;
    }

    public void highlightShiftKeys(boolean bl) {
        Iterator iterator = this.m_shiftKeyArray.iterator();
        while (iterator.hasNext()) {
            KeyboardKey keyboardKey = (KeyboardKey)iterator.next();
            keyboardKey.highlightButton(bl);
            keyboardKey.setPressed(bl);
        }
    }

    public void highlightAltKeys(boolean bl) {
        Iterator iterator = this.m_altKeyArray.iterator();
        while (iterator.hasNext()) {
            KeyboardKey keyboardKey = (KeyboardKey)iterator.next();
            keyboardKey.highlightButton(bl);
            keyboardKey.setPressed(bl);
        }
    }

    public void highlightControlKeys(boolean bl) {
        Iterator iterator = this.m_controlKeyArray.iterator();
        while (iterator.hasNext()) {
            KeyboardKey keyboardKey = (KeyboardKey)iterator.next();
            keyboardKey.highlightButton(bl);
            keyboardKey.setPressed(bl);
        }
    }

    public void highlightWinKeys(boolean bl) {
        Iterator iterator = this.m_winKeyArray.iterator();
        while (iterator.hasNext()) {
            KeyboardKey keyboardKey = (KeyboardKey)iterator.next();
            keyboardKey.highlightButton(bl);
            keyboardKey.setPressed(bl);
        }
    }

    public void highlightPopupKeys(boolean bl) {
        Iterator iterator = this.m_popupKeyArray.iterator();
        while (iterator.hasNext()) {
            KeyboardKey keyboardKey = (KeyboardKey)iterator.next();
            keyboardKey.highlightButton(bl);
            keyboardKey.setPressed(bl);
        }
    }

    protected int getKeyStates() {
        int n = this.m_keyboardState.getSpecialKeyStateValue();
        if (this.m_keyboardState.isShiftPressed()) {
            n |= 1;
        }
        if (this.m_keyboardState.isCapsPressed()) {
            n |= 2;
        }
        if (this.m_keyboardState.isNumLock()) {
            n |= 4;
        }
        if (this.m_keyboardState.isAltGRPressed()) {
            n |= 8;
        }
        if (this.m_keyboardState.isRightControlPressed()) {
            n |= 0x10;
        }
        return n;
    }

    public void updateKeyState() {
        int n = this.getKeyStates();
        Iterator iterator = this.m_keysArray.iterator();
        while (iterator.hasNext()) {
            KeyboardKey keyboardKey = (KeyboardKey)iterator.next();
            keyboardKey.setKeyFace(n);
        }
        if (this.m_keyboardWindow != null) {
            this.m_keyboardWindow.pack();
        }
    }

    public void writeBtnPress(KeyboardKey keyboardKey) {
        int n = keyboardKey.getHid();
        this.m_keyPressesHash.add(new Integer(n));
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        CConn cConn = keyboardMgr.getCConn();
        cConn.writeKeyEvent(n, true);
    }

    public void writeBtnRelease(KeyboardKey keyboardKey) {
        int n = keyboardKey.getHid();
        this.m_keyPressesHash.remove(new Integer(n));
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        CConn cConn = keyboardMgr.getCConn();
        cConn.writeKeyEvent(n, false);
        if (!(keyboardKey instanceof StateKey) && !this.m_keyboardState.isLockPressed()) {
            KeyboardKey keyboardKey2;
            Iterator iterator = this.m_shiftKeyArray.iterator();
            while (iterator.hasNext()) {
                keyboardKey2 = (KeyboardKey)iterator.next();
                if (!keyboardKey2.isKeyStuck()) continue;
                keyboardKey2.setPressed(false);
                keyboardKey2.writeBtnClick();
            }
            iterator = this.m_altKeyArray.iterator();
            while (iterator.hasNext()) {
                keyboardKey2 = (KeyboardKey)iterator.next();
                if (!keyboardKey2.isKeyStuck()) continue;
                keyboardKey2.setPressed(false);
                keyboardKey2.writeBtnClick();
            }
            iterator = this.m_controlKeyArray.iterator();
            while (iterator.hasNext()) {
                keyboardKey2 = (KeyboardKey)iterator.next();
                if (!keyboardKey2.isKeyStuck()) continue;
                keyboardKey2.setPressed(false);
                keyboardKey2.writeBtnClick();
            }
            iterator = this.m_winKeyArray.iterator();
            while (iterator.hasNext()) {
                keyboardKey2 = (KeyboardKey)iterator.next();
                if (!keyboardKey2.isKeyStuck()) continue;
                keyboardKey2.setPressed(false);
                keyboardKey2.writeBtnClick();
            }
            iterator = this.m_popupKeyArray.iterator();
            while (iterator.hasNext()) {
                keyboardKey2 = (KeyboardKey)iterator.next();
                if (!keyboardKey2.isKeyStuck()) continue;
                keyboardKey2.setPressed(false);
                keyboardKey2.writeBtnClick();
            }
            this.m_keyboardState.clear();
            this.updateKeyState();
        }
    }

    public void unsetKeysDown() {
        KeyboardMgr keyboardMgr = KeyboardMgr.getInstance();
        CConn cConn = keyboardMgr.getCConn();
        Iterator iterator = this.m_keyPressesHash.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            cConn.writeKeyEvent(n, false);
        }
    }

    public void initKeyboardLockedKeys(KeyboardWindow keyboardWindow) {
        this.m_keyboardWindow = keyboardWindow;
        this.m_keyboardState.clear();
        this.highlightShiftKeys(false);
        this.highlightAltKeys(false);
        this.highlightControlKeys(false);
        this.highlightWinKeys(false);
        this.highlightPopupKeys(false);
        this.m_lockKey.setPressed(false);
        this.m_capsLockKey.setPressed(this.m_keyboardState.isCapsPressed());
        this.m_numLockKey.setPressed(this.m_keyboardState.isNumLock());
        this.m_scrollLockKey.setPressed(this.m_keyboardState.isScrollLock());
        this.m_lockKey.changeState();
        this.updateKeyState();
        this.m_keyboardWindow.pack();
    }

    public Iterator getKeys() {
        return this.m_keysArray.iterator();
    }

    public KeyboardState getKeyboardState() {
        return this.m_keyboardState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informKeyIndicators(boolean bl, boolean bl2, boolean bl3) {
        Class clazz = class$com$serverengines$keyboard$Keyboard == null ? (class$com$serverengines$keyboard$Keyboard = Keyboard.class$("com.serverengines.keyboard.Keyboard")) : class$com$serverengines$keyboard$Keyboard;
        synchronized (clazz) {
            this.m_capsLockKey.setPressed(bl);
            this.m_numLockKey.setPressed(bl2);
            this.m_scrollLockKey.setPressed(bl3);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Keyboard.this.setKeyIndicators();
                }
            });
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

