/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.keyboard;

import com.serverengines.helper.Helper;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.keyboard.Keyboard;
import com.serverengines.keyboard.KeyboardFace;
import com.serverengines.keyboard.KeyboardKey;
import com.serverengines.keyboard.KeyboardState;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DualKey
extends KeyboardKey {
    protected KeyboardState m_keyboardState;
    protected KeyboardFace m_imageFace;
    protected boolean m_isKeyStuck;

    public DualKey(int n, Keyboard keyboard, KeyboardState keyboardState) {
        super(n, keyboard);
        this.m_keyboardState = keyboardState;
        this.m_imageFace = null;
        this.m_isKeyStuck = false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            super.mouseClicked(mouseEvent);
            this.writeBtnClick();
            this.m_keyboard.updateKeyState();
        }
    }

    public boolean isKeyStuck() {
        return this.m_isKeyStuck;
    }

    public void setPressed(boolean bl) {
        super.setPressed(bl);
        this.m_isKeyStuck = bl;
        this.changeState();
    }

    public void changeState() {
        this.highlightButton(this.isKeyStuck());
    }

    public void highlightButton(boolean bl) {
        StringBuffer stringBuffer = StringBufferPool.getInstance(this.m_keyboard.getImageDir());
        stringBuffer.append(this.m_imageFace.getImageName());
        if (bl) {
            stringBuffer.append(this.m_keyboard.getHighlightExtension());
        }
        stringBuffer.append(this.m_keyboard.getImageExtension());
        ImageIcon imageIcon = Helper.getIcon(stringBuffer);
        this.m_button.setIcon(imageIcon);
        StringBufferPool.recycle(stringBuffer);
    }

    public KeyboardFace addKeyFace(int n, String string, int n2) {
        KeyboardFace keyboardFace = super.addKeyFace(n, string, n2);
        if (this.m_imageFace == null) {
            this.m_imageFace = keyboardFace;
        }
        return keyboardFace;
    }

    public void setKeyFace(int n) {
        Icon icon;
        this.m_imageFace = (KeyboardFace)this.m_keyFaces.get(new Integer(n));
        if (this.m_imageFace == null) {
            icon = this.m_keyboard.getBlankIcon();
        } else {
            StringBuffer stringBuffer = this.m_keyboard.getImageDir();
            StringBuffer stringBuffer2 = StringBufferPool.getInstance(stringBuffer);
            stringBuffer2.append(this.m_imageFace.getImageName());
            if (this.isKeyStuck()) {
                stringBuffer2.append(this.m_keyboard.getHighlightExtension());
            }
            stringBuffer2.append(this.m_keyboard.getImageExtension());
            icon = Helper.getIcon(stringBuffer2);
            StringBufferPool.recycle(stringBuffer2);
        }
        if (icon != null) {
            this.m_button.setIcon(icon);
        }
    }
}

