/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.helper;

import com.serverengines.buffer.Buffers;
import com.serverengines.helper.ImageCache;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.helper.StringParser;
import com.serverengines.kvm.LogWriter;
import com.serverengines.resmgr.AppResMgr;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ImageIcon;

public class Helper {
    protected static Toolkit s_toolkit = null;
    public static final int CHAR_SIZE = 1;
    public static final int BYTE_SIZE = 1;
    public static final int BOOLEAN_SIZE = 1;
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int FLOAT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int DOUBLE_SIZE = 8;
    public static final int MAX_IP_PARTS = 4;
    public static final int IPV4_OFFSET = 12;
    public static final int COPY_BUFFER_SZ = 8192;
    public static final int CHAR_NIBBLE_SIZE = 2;
    public static final int BYTE_NIBBLE_SIZE = 2;
    public static final int BOOLEAN_NIBBLE_SIZE = 2;
    public static final int SHORT_NIBBLE_SIZE = 4;
    public static final int INT_NIBBLE_SIZE = 8;
    public static final int FLOAT_NIBBLE_SIZE = 8;
    public static final int LONG_NIBBLE_SIZE = 16;
    public static final int DOUBLE_NIBBLE_SIZE = 16;
    public static final String NEWLINE = "\n";
    public static final String RESOURCE_NEWLINE = "\\n";
    public static final String HTML_BREAK = "<br>";
    public static final String UTF16LE_STRING_ENCODING_TYPE = "UTF-16LE";
    public static final int OS_NOT_DETERMINED = 0;
    public static final int OS_WINDOWS = 1;
    public static final int OS_LINUX = 2;
    public static final int OS_UNKNOWN = 3;
    public static final String OS_WIN_NAME = "win";
    public static final String OS_LIN_NAME = "linux";
    public static final char PARAM_MARKER = '%';
    public static final String HEX_LEAD = "0x";
    public static final char IP_ADDR_SEPERATOR = '.';
    public static final char IPV6_IP_ADDR_SEPERATOR = ':';
    public static final int NIBBLE_MASK = 15;
    public static final int NIBBLE_SHIFT = 4;
    public static final int MAX_PATH_LEN = 512;
    public static final long UPPER_BIT_LONG = Long.MIN_VALUE;
    public static final String WIN_MSS_NAME = "M2.EXE";
    public static final String LIN_MSS_NAME = "M2.E";
    public static final String RESOURCE_FILE = "M2.R";
    public static final String PRINTABLE_MSS_NAME = "StorageServer";
    public static final String PRINTABLE_RESOURCE_FILE = "ResourceFile";
    protected static int s_OSType = 0;
    protected static String s_MSSName = null;
    protected static LogWriter s_log = new LogWriter((class$com$serverengines$helper$Helper == null ? (class$com$serverengines$helper$Helper = Helper.class$("com.serverengines.helper.Helper")) : class$com$serverengines$helper$Helper).getName());
    static /* synthetic */ Class class$com$serverengines$helper$Helper;

    public static StringBuffer formatToHex(String string, int n) {
        StringBuffer stringBuffer = StringBufferPool.getInstance(string);
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, '0');
        }
        stringBuffer.insert(0, HEX_LEAD);
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Toolkit getToolkit() {
        Class clazz = class$com$serverengines$helper$Helper == null ? (class$com$serverengines$helper$Helper = Helper.class$("com.serverengines.helper.Helper")) : class$com$serverengines$helper$Helper;
        synchronized (clazz) {
            if (s_toolkit == null) {
                s_toolkit = Toolkit.getDefaultToolkit();
            }
            return s_toolkit;
        }
    }

    public static int GetOsType() {
        if (s_OSType == 0) {
            String string = System.getProperty("os.name", "").toLowerCase();
            s_OSType = string.indexOf(OS_WIN_NAME) > -1 ? 1 : (string.indexOf(OS_LIN_NAME) > -1 ? 2 : 3);
        }
        return s_OSType;
    }

    public static boolean isWindows() {
        return Helper.GetOsType() == 1;
    }

    public static boolean isLinux() {
        return Helper.GetOsType() == 2;
    }

    public static String getStorageServerName() {
        if (s_MSSName == null) {
            s_MSSName = Helper.isWindows() ? WIN_MSS_NAME : LIN_MSS_NAME;
        }
        return s_MSSName;
    }

    public static StringBuffer getUserHomeDir() {
        String string = System.getProperty("user.home", "").trim();
        int n = string.indexOf(File.pathSeparatorChar);
        if (n > -1) {
            string = string.substring(0, n).trim();
        }
        StringBuffer stringBuffer = StringBufferPool.getInstance(string);
        Helper.makeRelativePath(stringBuffer);
        return stringBuffer;
    }

    public static byte[] formatUnicodeString(String string) {
        byte[] byArray;
        block2: {
            byArray = new byte[]{};
            try {
                byArray = string.getBytes(UTF16LE_STRING_ENCODING_TYPE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!s_log.isErrorLoggingEnabled()) break block2;
                s_log.error(unsupportedEncodingException);
            }
        }
        return byArray;
    }

    public static String formatUnicodeString(byte[] byArray) {
        String string;
        block2: {
            string = "";
            try {
                string = new String(byArray, UTF16LE_STRING_ENCODING_TYPE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!s_log.isErrorLoggingEnabled()) break block2;
                s_log.error(unsupportedEncodingException);
            }
        }
        return string;
    }

    public static byte[] addPadding(byte[] byArray, int n) {
        if (n < byArray.length) {
            n = byArray.length;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        Arrays.fill(byArray2, byArray.length, byArray2.length, (byte)0);
        return byArray2;
    }

    public static StringBuffer formatToHex(char c) {
        return Helper.formatToHex(Integer.toHexString(c & 0xFF), 2);
    }

    public static StringBuffer formatToHex(byte by) {
        return Helper.formatToHex(Integer.toHexString(by & 0xFF), 2);
    }

    public static StringBuffer formatToHex(byte[] byArray) {
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        for (int i = 0; i < byArray.length; ++i) {
            byte by;
            if ((i & 3) == 0) {
                stringBuffer.append(' ');
            }
            if (((by = byArray[i]) & 0xF0) == 0) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(by & 0xFF));
        }
        return stringBuffer;
    }

    public static StringBuffer formatToHex(short s) {
        return Helper.formatToHex(Integer.toHexString(s & 0xFFFF), 4);
    }

    public static StringBuffer formatToHex(int n) {
        return Helper.formatToHex(Integer.toHexString(n), 8);
    }

    public static StringBuffer formatToHex(long l) {
        return Helper.formatToHex(Long.toHexString(l), 16);
    }

    public static StringBuffer valueOf(byte by) {
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        stringBuffer.append(by & 0xFF);
        return stringBuffer;
    }

    public static StringBuffer valueOf(char c) {
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        stringBuffer.append(c);
        return stringBuffer;
    }

    public static StringBuffer valueOf(boolean bl) {
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        stringBuffer.append(bl);
        return stringBuffer;
    }

    public static StringBuffer valueOf(short s) {
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        stringBuffer.append(s);
        return stringBuffer;
    }

    public static StringBuffer valueOf(int n) {
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        stringBuffer.append(n);
        return stringBuffer;
    }

    public static StringBuffer valueOf(long l) {
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        stringBuffer.append(l);
        return stringBuffer;
    }

    public static StringBuffer formatIPAddress(byte[] byArray, byte by) {
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        try {
            byte[] byArray2;
            if (by == 1) {
                byArray2 = new byte[4];
                System.arraycopy(byArray, 12, byArray2, 0, byArray2.length);
            } else {
                byArray2 = byArray;
            }
            InetAddress inetAddress = InetAddress.getByAddress(byArray2);
            stringBuffer.append(inetAddress.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer;
    }

    public static StringBuffer replaceWithParams(StringBuffer stringBuffer, ArrayList arrayList) {
        StringBuffer stringBuffer2 = StringBufferPool.getInstance();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer2.setLength(0);
            stringBuffer2.append('%');
            stringBuffer2.append(i);
            stringBuffer2.append('%');
            StringBuffer stringBuffer3 = (StringBuffer)arrayList.get(i);
            if (stringBuffer3 == null) continue;
            String string = stringBuffer3.toString();
            int n = stringBuffer3.length();
            String string2 = stringBuffer2.toString();
            int n2 = stringBuffer.indexOf(string2);
            int n3 = stringBuffer2.length();
            while (n2 > -1) {
                stringBuffer.replace(n2, n2 + n3, string);
                n2 = stringBuffer.indexOf(string2, n2 + n);
            }
        }
        StringBufferPool.recycle(stringBuffer2);
        return stringBuffer;
    }

    public static StringBuffer replaceString(StringBuffer stringBuffer, String string, String string2) {
        int n = stringBuffer.indexOf(string);
        while (n > -1) {
            stringBuffer.replace(n, n + string.length(), string2);
            n = stringBuffer.indexOf(string, n + string2.length());
        }
        return stringBuffer;
    }

    public static StringBuffer formatToHTML(StringBuffer stringBuffer) {
        return Helper.replaceString(stringBuffer, NEWLINE, HTML_BREAK);
    }

    public static StringBuffer formatNewline(StringBuffer stringBuffer) {
        return Helper.replaceString(stringBuffer, RESOURCE_NEWLINE, NEWLINE);
    }

    public static URL getResourceURL(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = null;
        if (classLoader != null) {
            uRL = classLoader.getResource(string);
        }
        if (uRL == null) {
            classLoader = (class$com$serverengines$helper$Helper == null ? (class$com$serverengines$helper$Helper = Helper.class$("com.serverengines.helper.Helper")) : class$com$serverengines$helper$Helper).getClassLoader();
            if (classLoader != null) {
                uRL = classLoader.getResource(string);
            }
            if (uRL == null) {
                uRL = (class$com$serverengines$helper$Helper == null ? (class$com$serverengines$helper$Helper = Helper.class$("com.serverengines.helper.Helper")) : class$com$serverengines$helper$Helper).getResource(string);
            }
        }
        return uRL;
    }

    public static InputStream getResourceStream(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = null;
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            classLoader = (class$com$serverengines$helper$Helper == null ? (class$com$serverengines$helper$Helper = Helper.class$("com.serverengines.helper.Helper")) : class$com$serverengines$helper$Helper).getClassLoader();
            if (classLoader != null) {
                inputStream = classLoader.getResourceAsStream(string);
            }
            if (inputStream == null) {
                inputStream = (class$com$serverengines$helper$Helper == null ? (class$com$serverengines$helper$Helper = Helper.class$("com.serverengines.helper.Helper")) : class$com$serverengines$helper$Helper).getResourceAsStream(string);
            }
        }
        return inputStream;
    }

    public static boolean getBoolean(String string) {
        boolean bl = false;
        if (string != null) {
            String string2 = string.toLowerCase();
            bl = string2.equals("true") || string2.equals("1") || string2.equals("on");
        }
        return bl;
    }

    public static StringBuffer getResourceDirectory(StringBuffer stringBuffer) {
        boolean bl = false;
        StringBuffer stringBuffer2 = StringBufferPool.getInstance();
        StringBuffer stringBuffer3 = StringBufferPool.getInstance();
        StringBuffer stringBuffer4 = StringBufferPool.getInstance();
        StringParser stringParser = StringParser.getInstance(System.getProperty("java.class.path"), File.pathSeparator);
        while (!bl && stringParser.hasMoreTokens()) {
            stringBuffer2.setLength(0);
            stringBuffer4.setLength(0);
            stringBuffer4.append(stringParser.nextToken());
            stringBuffer2.append(Helper.makeRelativePath(stringBuffer4));
            stringBuffer3.setLength(0);
            stringBuffer3.append(stringBuffer2);
            stringBuffer3.append(stringBuffer);
            File file = new File(stringBuffer3.toString());
            if (!file.isFile()) continue;
            bl = true;
        }
        StringBufferPool.recycle(stringBuffer4);
        stringParser.recycle();
        StringBufferPool.recycle(stringBuffer3);
        if (!bl) {
            stringBuffer2.setLength(0);
        }
        return stringBuffer2;
    }

    public static StringBuffer getResourcePath(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = Helper.getResourceDirectory(stringBuffer);
        if (stringBuffer2.length() > 0) {
            stringBuffer2.append(stringBuffer);
        }
        return stringBuffer2;
    }

    public static boolean endsWith(StringBuffer stringBuffer, String string) {
        int n = stringBuffer.length() - string.length();
        boolean bl = false;
        if (n > -1) {
            String string2 = stringBuffer.substring(n, stringBuffer.length());
            bl = string2.equals(string);
        }
        return bl;
    }

    public static StringBuffer makeRelativePath(StringBuffer stringBuffer) {
        if (!Helper.endsWith(stringBuffer, "/") && !Helper.endsWith(stringBuffer, "\\")) {
            stringBuffer.append(File.separatorChar);
        }
        return stringBuffer;
    }

    public static StringBuffer makeHTTPRelativePath(StringBuffer stringBuffer) {
        if (!Helper.endsWith(stringBuffer, "/")) {
            stringBuffer.append('/');
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getIcon(StringBuffer stringBuffer) {
        Class clazz = class$com$serverengines$helper$Helper == null ? (class$com$serverengines$helper$Helper = Helper.class$("com.serverengines.helper.Helper")) : class$com$serverengines$helper$Helper;
        synchronized (clazz) {
            URL uRL;
            AppResMgr appResMgr = AppResMgr.getInstance();
            StringBuffer stringBuffer2 = StringBufferPool.getInstance(appResMgr.getResourceString("image.dir"));
            Helper.makeRelativePath(stringBuffer2);
            stringBuffer2.append(stringBuffer);
            ImageCache imageCache = ImageCache.getInstance();
            ImageIcon imageIcon = imageCache.getImage(stringBuffer2.toString());
            if (imageIcon == null && (uRL = Helper.getResourceURL(stringBuffer2.toString())) != null) {
                imageIcon = new ImageIcon(uRL);
                imageCache.addImage(stringBuffer2.toString(), imageIcon);
            }
            StringBufferPool.recycle(stringBuffer2);
            return imageIcon;
        }
    }

    public static boolean getLockingKeyState(int n) {
        boolean bl;
        block2: {
            bl = false;
            try {
                Toolkit toolkit = Helper.getToolkit();
                bl = toolkit.getLockingKeyState(n);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (!s_log.isErrorLoggingEnabled()) break block2;
                s_log.error(unsupportedOperationException);
            }
        }
        return bl;
    }

    public static void setLockingKeyState(int n, boolean bl) {
        block2: {
            try {
                Toolkit toolkit = Helper.getToolkit();
                toolkit.setLockingKeyState(n, bl);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (!s_log.isErrorLoggingEnabled()) break block2;
                s_log.error(unsupportedOperationException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void copyFile(InputStream inputStream, StringBuffer stringBuffer) {
        block17: {
            Exception exception2222;
            FileOutputStream fileOutputStream;
            block16: {
                fileOutputStream = null;
                fileOutputStream = new FileOutputStream(stringBuffer.toString());
                int n = inputStream.read(Buffers.m_buffer);
                while (n > 0) {
                    fileOutputStream.write(Buffers.m_buffer, 0, n);
                    n = inputStream.read(Buffers.m_buffer);
                }
                Object var5_5 = null;
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception2222) {
                    if (!s_log.isErrorLoggingEnabled()) break block16;
                    s_log.error("Error closing file:");
                    s_log.error(exception2222);
                }
            }
            try {
                inputStream.close();
            }
            catch (Exception exception2222) {
                if (s_log.isErrorLoggingEnabled()) {
                    s_log.error("Error closing file:");
                    s_log.error(exception2222);
                }
                break block17;
            }
            {
                catch (Exception exception3) {
                    Exception exception42222;
                    block18: {
                        if (s_log.isErrorLoggingEnabled()) {
                            s_log.error("Error copying file:");
                            s_log.error(exception3);
                        }
                        Object var5_6 = null;
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception42222) {
                            if (!s_log.isErrorLoggingEnabled()) break block18;
                            s_log.error("Error closing file:");
                            s_log.error(exception42222);
                        }
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception42222) {
                        if (s_log.isErrorLoggingEnabled()) {
                            s_log.error("Error closing file:");
                            s_log.error(exception42222);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block20: {
                    Exception exception52222;
                    block19: {
                        Object var5_7 = null;
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception52222) {
                            if (!s_log.isErrorLoggingEnabled()) break block19;
                            s_log.error("Error closing file:");
                            s_log.error(exception52222);
                        }
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception52222) {
                        if (!s_log.isErrorLoggingEnabled()) break block20;
                        s_log.error("Error closing file:");
                        s_log.error(exception52222);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long calculateChecksum(InputStream inputStream) {
        long l;
        block13: {
            l = 0L;
            int n = inputStream.read();
            while (n > -1) {
                boolean bl = (l & Long.MIN_VALUE) != 0L;
                l <<= 1;
                if (bl) {
                    l |= 1L;
                }
                l ^= (long)n;
                n = inputStream.read();
            }
            Object var6_5 = null;
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                if (s_log.isErrorLoggingEnabled()) {
                    s_log.error("Error closing file:");
                    s_log.error(exception);
                }
                break block13;
            }
            {
                catch (Exception exception) {
                    if (s_log.isErrorLoggingEnabled()) {
                        s_log.error("Error checking the sum of the file:");
                        s_log.error(exception);
                    }
                    Object var6_6 = null;
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception2) {
                        if (s_log.isErrorLoggingEnabled()) {
                            s_log.error("Error closing file:");
                            s_log.error(exception2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block14: {
                    Object var6_7 = null;
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        if (!s_log.isErrorLoggingEnabled()) break block14;
                        s_log.error("Error closing file:");
                        s_log.error(exception);
                    }
                }
                throw throwable;
            }
        }
        return l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

