/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.graphics;

import com.serverengines.buffer.Buffers;
import com.serverengines.graphics.ScreenMode;
import com.serverengines.mahogany.DesktopWindow;
import java.awt.Color;

public class TextMode
extends ScreenMode {
    public static final int POOL_SIZE = 5;
    public static final byte STANDARD_FG_MASK = 15;
    public static final byte DBE_FG_MASK = 7;
    public static final byte FG_SHIFT = 0;
    public static final byte STANDARD_BG_MASK = 15;
    public static final byte BLINKING_BG_MASK = 7;
    public static final byte BG_SHIFT = 4;
    public static final byte BLINKING_TEXT_MASK = -128;
    public static final byte DBE_MASK = 8;
    public static final short ASCII_BIT_BLT = 1;
    public static final short ATTRIBUTE_BIT_BLT = 2;
    public static final short FONT_BIT_BLT = 4;
    protected static TextMode[] s_pool = new TextMode[5];
    protected static int s_poolCount = 0;
    protected byte[] m_asciiTable = Buffers.m_asciiTable;
    protected byte[] m_attributeTable = Buffers.m_attributeTable;
    protected byte[] m_fontTable = Buffers.m_fontTable;
    protected int m_fontWidth;
    protected int m_fontHeight;
    protected short m_blitType;
    protected boolean m_attributeTableValid;
    protected int m_cursorX;
    protected int m_cursorY;
    protected int m_startLine;
    protected int m_stopLine;
    protected boolean m_isBlinkOn;
    protected boolean m_isBlinking;
    protected boolean m_isDBESwap;
    protected int m_primaryOffset;
    protected int m_secondaryOffset;
    static /* synthetic */ Class class$com$serverengines$graphics$TextMode;

    protected TextMode(int n, int n2) {
        super(4, n, n2);
        byte[] byArray = s_paletteMgr.getReds();
        byte[] byArray2 = s_paletteMgr.getGreens();
        byte[] byArray3 = s_paletteMgr.getBlues();
        s_paletteMgr.setPaletteSize(2);
        byArray[0] = (byte)Color.BLACK.getRed();
        byArray2[0] = (byte)Color.BLACK.getGreen();
        byArray3[0] = (byte)Color.BLACK.getBlue();
        byArray[1] = (byte)Color.WHITE.getRed();
        byArray2[1] = (byte)Color.WHITE.getGreen();
        byArray3[1] = (byte)Color.WHITE.getBlue();
        byte[] byArray4 = s_attributeMgr.getAttributes();
        s_attributeMgr.setAttributeSize(2);
        for (int n3 = 0; n3 < 2; n3 = (int)((byte)(n3 + 1))) {
            byArray4[n3] = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextMode getInstance(int n, int n2, int n3, int n4) {
        Class clazz = class$com$serverengines$graphics$TextMode == null ? (class$com$serverengines$graphics$TextMode = TextMode.class$("com.serverengines.graphics.TextMode")) : class$com$serverengines$graphics$TextMode;
        synchronized (clazz) {
            TextMode textMode;
            if (s_poolCount == 0) {
                textMode = new TextMode(n, n2);
            } else {
                textMode = s_pool[--s_poolCount];
                TextMode.s_pool[TextMode.s_poolCount] = null;
            }
            textMode.m_screenWidth = n;
            textMode.m_screenHeight = n2;
            textMode.m_fontWidth = n3;
            textMode.m_fontHeight = n4;
            textMode.m_cursorX = -1;
            textMode.m_cursorY = -1;
            textMode.m_bpp = 0;
            textMode.m_startLine = 0;
            textMode.m_stopLine = 0;
            textMode.m_primaryOffset = 0;
            textMode.m_secondaryOffset = 0;
            textMode.m_isBlinkOn = false;
            textMode.m_isBlinking = false;
            textMode.m_isDBESwap = false;
            textMode.m_attributeTableValid = false;
            return textMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Class clazz = class$com$serverengines$graphics$TextMode == null ? (class$com$serverengines$graphics$TextMode = TextMode.class$("com.serverengines.graphics.TextMode")) : class$com$serverengines$graphics$TextMode;
        synchronized (clazz) {
            if (s_poolCount < 5) {
                TextMode.s_pool[TextMode.s_poolCount] = this;
                ++s_poolCount;
            }
        }
    }

    public void setScreenWidth(int n) {
        super.setScreenWidth(n /= this.m_fontWidth);
    }

    public void setScreenHeight(int n) {
        super.setScreenHeight(n /= this.m_fontHeight);
    }

    public int getFontWidth() {
        return this.m_fontWidth;
    }

    public void setFontWidth(int n) {
        int n2 = this.getScreenWidthPixel();
        this.m_fontWidth = n;
        this.setScreenWidth(n2);
    }

    public int getFontHeight() {
        return this.m_fontHeight;
    }

    public void setBlitType(short s) {
        this.m_blitType = s;
    }

    public void setFontHeight(int n) {
        int n2 = this.getScreenHeightPixel();
        this.m_fontHeight = n;
        this.setScreenHeight(n2);
    }

    public void imageRect(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray, int n7, byte[] byArray2) {
        int n8;
        int n9;
        byte by = 1;
        byte by2 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = n2 * this.m_fontHeight * n6 + n * this.m_fontWidth;
        if (this.m_blitType != 264) {
            if ((this.m_blitType & 1) != 0) {
                n9 = Math.min(this.m_asciiTable.length, n3 * n4);
                System.arraycopy(byArray, n7, this.m_asciiTable, 0, n9);
                n7 += n9;
            }
            if ((this.m_blitType & 2) != 0) {
                this.m_attributeTableValid = true;
                n9 = Math.min(this.m_attributeTable.length, n3 * n4);
                System.arraycopy(byArray, n7, this.m_attributeTable, 0, n9);
                n7 += n9;
            }
            if ((this.m_blitType & 4) != 0) {
                n9 = Math.min(byArray.length - n7, this.m_fontTable.length);
                System.arraycopy(byArray, n7, this.m_fontTable, 0, n9);
                n7 += n9;
            }
        } else {
            this.m_attributeTableValid = true;
            n9 = this.m_screenHeight * this.m_screenWidth << 1;
            n8 = 0;
            while (n11 < n9) {
                this.m_asciiTable[n8] = byArray[n11];
                this.m_attributeTable[n8] = byArray[++n11];
                ++n11;
                ++n8;
            }
        }
        for (int i = 0; i < n4; ++i) {
            int n13 = n2 + i;
            int n14 = i * n3;
            for (int j = 0; j < this.m_fontHeight; ++j) {
                int n15 = 0;
                int n16 = n12 + n10 * n6;
                for (int k = 0; k < n3; ++k) {
                    boolean bl;
                    int n17 = n + k;
                    n8 = n14 + k;
                    int n18 = this.m_asciiTable[n8] & 0xFF;
                    boolean bl2 = bl = this.m_cursorY == n13 && this.m_cursorX == n17 && j >= this.m_startLine && j <= this.m_stopLine;
                    if (this.m_attributeTableValid) {
                        byte by3 = this.m_attributeTable[n8];
                        by = (byte)(by3 >> 0);
                        by2 = (byte)(by3 >> 4);
                        if (this.m_isDBESwap) {
                            by = (byte)(by & 7);
                            n18 = (by3 & 8) != 0 ? (n18 += this.m_primaryOffset) : (n18 += this.m_secondaryOffset);
                        } else {
                            by = (byte)(by & 0xF);
                        }
                        by2 = this.m_isBlinking ? (byte)(by2 & 7) : (byte)(by2 & 0xF);
                        if (this.m_isBlinking && (by3 & 0xFFFFFF80) != 0) {
                            by = by2;
                        }
                    }
                    byte by4 = this.m_fontTable[n18 * 32 + j];
                    for (int i2 = this.m_fontWidth - 1; i2 > -1; --i2) {
                        byArray2[n16 + n15] = bl || (by4 >> i2 & 1) != 0 ? by : by2;
                        ++n15;
                    }
                }
                ++n10;
            }
        }
    }

    public void clearPrevTextCursor(DesktopWindow desktopWindow, byte[] byArray) {
        if (this.m_cursorX != -1) {
            int n;
            int n2;
            byte by = 0;
            byte by2 = 0;
            int n3 = this.m_cursorY * this.m_screenWidth + this.m_cursorX;
            int n4 = this.m_asciiTable[n3] & 0xFF;
            int n5 = this.m_screenWidth * this.m_fontWidth;
            int n6 = this.m_cursorY * this.m_fontHeight * n5 + this.m_cursorX * this.m_fontWidth;
            if (this.m_attributeTableValid) {
                n2 = this.m_attributeTable[n3];
                byte by3 = (byte)(n2 >> 0);
                byte by4 = (byte)(n2 >> 4);
                if (this.m_isDBESwap) {
                    by3 = (byte)(by3 & 7);
                    n4 = (n2 & 8) != 0 ? (n4 += this.m_primaryOffset) : (n4 += this.m_secondaryOffset);
                } else {
                    by3 = (byte)(by3 & 0xF);
                }
                by4 = this.m_isBlinking ? (byte)(by4 & 7) : (byte)(by4 & 0xF);
                by2 = by3;
                by = by4;
                if (this.m_isBlinking && (n2 & 0xFFFFFF80) != 0) {
                    by2 = by4;
                }
            }
            n2 = n4 * 32;
            for (n = 0; n < this.m_fontHeight; ++n) {
                int n7 = 0;
                int n8 = n6 + n * n5;
                byte by5 = this.m_fontTable[n2 + n];
                for (int i = this.m_fontWidth - 1; i > -1; --i) {
                    byArray[n8 + n7] = (by5 >> i & 1) != 0 ? by2 : by;
                    ++n7;
                }
            }
            n = this.getFontWidth();
            int n9 = this.getFontHeight();
            int n10 = this.m_cursorX * n;
            int n11 = this.m_cursorY * n9;
            desktopWindow.invalidate(n10, n11, n, n9);
            desktopWindow.endRect();
        }
    }

    protected void setCursor(byte[] byArray) {
        int n;
        byte by = 1;
        int n2 = this.m_screenWidth * this.m_fontWidth;
        int n3 = this.m_cursorX * this.m_fontWidth;
        int n4 = this.m_cursorY * this.m_fontHeight * n2 + n3;
        if (this.m_attributeTableValid) {
            n = this.m_cursorY * this.m_screenWidth + this.m_cursorX;
            byte by2 = this.m_attributeTable[n];
            by = (byte)(by2 >> 0);
            byte by3 = (byte)(by2 >> 4);
            by = this.m_isDBESwap ? (byte)(by & 7) : (byte)(by & 0xF);
            by3 = this.m_isBlinking ? (byte)(by3 & 7) : (byte)(by3 & 0xF);
            if ((by2 & 0xFFFFFF80) != 0 && this.m_isBlinking) {
                by = by3;
            }
        }
        for (n = this.m_startLine; n <= this.m_stopLine; ++n) {
            int n5 = n * n2 + n4;
            for (int i = 0; i < this.m_fontWidth; ++i) {
                byArray[n5 + i] = by;
            }
        }
    }

    public void setTextCursor(int n, int n2, int n3, int n4, byte[] byArray) {
        this.m_startLine = n3;
        this.m_stopLine = n4;
        if (this.m_startLine == this.m_stopLine) {
            this.m_cursorX = -1;
            this.m_cursorY = -1;
        } else {
            this.m_cursorX = n;
            this.m_cursorY = n2;
            this.setCursor(byArray);
        }
    }

    protected void blinkOn(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte by = 0;
        byte by2 = 1;
        int n4 = this.m_screenWidth;
        int n5 = this.m_screenHeight;
        int n6 = n4 * this.m_fontWidth;
        int n7 = n2 * this.m_fontHeight * n6 + n * this.m_fontWidth;
        for (int i = 0; i < n5; ++i) {
            int n8 = n2 + i;
            int n9 = i * n4;
            for (int j = 0; j < this.m_fontHeight; ++j) {
                int n10 = 0;
                int n11 = n7 + n3 * n6;
                for (int k = 0; k < n4; ++k) {
                    boolean bl;
                    int n12 = n + k;
                    int n13 = n9 + k;
                    int n14 = this.m_asciiTable[n13] & 0xFF;
                    boolean bl2 = bl = this.m_cursorY == n8 && this.m_cursorX == n12 && j >= this.m_startLine && j <= this.m_stopLine;
                    if (this.m_attributeTableValid) {
                        byte by3 = this.m_attributeTable[n13];
                        by2 = (byte)(by3 >> 0);
                        by = (byte)(by3 >> 4);
                        if (this.m_isDBESwap) {
                            by2 = (byte)(by2 & 7);
                            n14 = (by3 & 8) != 0 ? (n14 += this.m_primaryOffset) : (n14 += this.m_secondaryOffset);
                        } else {
                            by2 = (byte)(by2 & 0xF);
                        }
                        by = this.m_isBlinking ? (byte)(by & 7) : (byte)(by & 0xF);
                        if (this.m_isBlinking && (by3 & 0xFFFFFF80) != 0) {
                            by2 = by;
                        }
                    }
                    byte by4 = this.m_fontTable[n14 * 32 + j];
                    for (int i2 = this.m_fontWidth - 1; i2 > -1; --i2) {
                        byArray[n11 + n10] = bl || (by4 >> i2 & 1) != 0 ? by2 : by;
                        ++n10;
                    }
                }
                ++n3;
            }
        }
    }

    protected void blinkOff(byte[] byArray) {
        int n = 0;
        byte by = 0;
        byte by2 = 1;
        int n2 = this.m_screenWidth;
        int n3 = this.m_screenHeight;
        int n4 = n2 * this.m_fontWidth;
        for (int i = 0; i < n3; ++i) {
            int n5 = i * n2;
            for (int j = 0; j < this.m_fontHeight; ++j) {
                int n6 = 0;
                int n7 = n * n4;
                for (int k = 0; k < n2; ++k) {
                    int n8 = n5 + k;
                    int n9 = this.m_asciiTable[n8] & 0xFF;
                    if (this.m_attributeTableValid) {
                        byte by3 = this.m_attributeTable[n8];
                        by2 = (byte)(by3 >> 0);
                        by = (byte)(by3 >> 4);
                        if (this.m_isDBESwap) {
                            by2 = (byte)(by2 & 7);
                            n9 = (by3 & 8) != 0 ? (n9 += this.m_primaryOffset) : (n9 += this.m_secondaryOffset);
                        } else {
                            by2 = (byte)(by2 & 0xF);
                        }
                        by = this.m_isBlinking ? (byte)(by & 7) : (byte)(by & 0xF);
                    }
                    byte by4 = this.m_fontTable[n9 * 32 + j];
                    for (int i2 = this.m_fontWidth - 1; i2 > -1; --i2) {
                        byArray[n7 + n6] = (by4 >> i2 & 1) != 0 ? by2 : by;
                        ++n6;
                    }
                }
                ++n;
            }
        }
    }

    public void setBlinking(boolean bl) {
        this.m_isBlinking = bl;
    }

    public int getScreenWidthPixel() {
        return this.getScreenWidth() * this.getFontWidth();
    }

    public int getScreenHeightPixel() {
        return this.getScreenHeight() * this.getFontHeight();
    }

    public void toggleBlinkingText(byte[] byArray) {
        if (this.m_isBlinkOn) {
            this.blinkOn(byArray);
        } else {
            this.blinkOff(byArray);
        }
        this.m_isBlinkOn = !this.m_isBlinkOn;
    }

    public void dbeSwap(boolean bl, int n, int n2, byte[] byArray) {
        this.m_isDBESwap = bl;
        this.m_primaryOffset = n;
        this.m_secondaryOffset = n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.m_screenWidth;
        int n6 = this.m_screenHeight;
        int n7 = n5 * this.m_fontWidth;
        int n8 = 0;
        int n9 = n4 * this.m_fontHeight * n7 + n3 * this.m_fontWidth;
        byte by = 0;
        byte by2 = 1;
        for (int i = 0; i < n6; ++i) {
            int n10 = n4 + i;
            int n11 = i * n5;
            for (int j = 0; j < this.m_fontHeight; ++j) {
                int n12 = 0;
                int n13 = n9 + n8 * n7;
                for (int k = 0; k < n5; ++k) {
                    boolean bl2;
                    int n14 = n3 + k;
                    int n15 = n11 + k;
                    int n16 = this.m_asciiTable[n15] & 0xFF;
                    boolean bl3 = bl2 = this.m_cursorY == n10 && this.m_cursorX == n14 && j >= this.m_startLine && j <= this.m_stopLine;
                    if (this.m_attributeTableValid) {
                        byte by3 = this.m_attributeTable[n15];
                        by2 = (byte)(by3 >> 0);
                        by = (byte)(by3 >> 4);
                        if (this.m_isDBESwap) {
                            by2 = (byte)(by2 & 7);
                            n16 = (by3 & 8) != 0 ? (n16 += this.m_primaryOffset) : (n16 += this.m_secondaryOffset);
                        } else {
                            by2 = (byte)(by2 & 0xF);
                        }
                        by = this.m_isBlinking ? (byte)(by & 7) : (byte)(by & 0xF);
                        if (this.m_isBlinking && (by3 & 0xFFFFFF80) != 0) {
                            by2 = by;
                        }
                    }
                    byte by4 = this.m_fontTable[n16 * 32 + j];
                    for (int i2 = this.m_fontWidth - 1; i2 > -1; --i2) {
                        byArray[n13 + n12] = bl2 || (by4 >> i2 & 1) != 0 ? by2 : by;
                        ++n12;
                    }
                }
                ++n8;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

