/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.graphics;

import com.serverengines.helper.StringBufferPool;
import com.serverengines.kvm.LogWriter;
import com.serverengines.mahoganyprotocol.Palette;

public class PaletteMgr {
    protected static LogWriter s_log = new LogWriter((class$com$serverengines$graphics$PaletteMgr == null ? (class$com$serverengines$graphics$PaletteMgr = PaletteMgr.class$("com.serverengines.graphics.PaletteMgr")) : class$com$serverengines$graphics$PaletteMgr).getName());
    protected byte[] m_reds = new byte[this.m_palleteSize];
    protected byte[] m_greens = new byte[this.m_palleteSize];
    protected byte[] m_blues = new byte[this.m_palleteSize];
    protected int m_palleteSize = 256;
    static /* synthetic */ Class class$com$serverengines$graphics$PaletteMgr;

    public PaletteMgr() {
        for (int i = 0; i < this.m_palleteSize; ++i) {
            this.m_reds[i] = (byte)(((i & 7) * 255 + 3) / 7);
            this.m_greens[i] = (byte)(((i >> 3 & 7) * 255 + 3) / 7);
            this.m_blues[i] = (byte)(((i >> 6 & 3) * 255 + 1) / 3);
        }
    }

    public boolean setPalette(Palette[] paletteArray, short s) {
        boolean bl = false;
        if (paletteArray != null) {
            bl = this.m_palleteSize != s;
            this.m_palleteSize = s;
        }
        this.m_palleteSize = Math.min(this.m_palleteSize, this.m_reds.length);
        if (s_log.isInfoLoggingEnabled()) {
            StringBuffer stringBuffer = StringBufferPool.getInstance("Palette size=");
            stringBuffer.append(this.m_palleteSize);
            s_log.info(stringBuffer.toString());
            StringBufferPool.recycle(stringBuffer);
        }
        for (int i = 0; i < this.m_palleteSize; ++i) {
            int n = paletteArray[i].getOffset() & 0xFF;
            if (!bl) {
                bl = this.m_reds[n] != paletteArray[i].getHiValue() || this.m_greens[n] != paletteArray[i].getMidValue() || this.m_blues[n] != paletteArray[i].getLoValue();
            }
            this.m_reds[n] = paletteArray[i].getHiValue();
            this.m_greens[n] = paletteArray[i].getMidValue();
            this.m_blues[n] = paletteArray[i].getLoValue();
        }
        return bl;
    }

    public int getPaletteSize() {
        return this.m_palleteSize;
    }

    public void setPaletteSize(int n) {
        this.m_palleteSize = n;
    }

    public byte[] getReds() {
        return this.m_reds;
    }

    public byte[] getGreens() {
        return this.m_greens;
    }

    public byte[] getBlues() {
        return this.m_blues;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

