/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.graphics;

import com.serverengines.helper.Helper;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.kvm.LogWriter;
import com.serverengines.mahogany.CConn;
import com.serverengines.mahogany.DesktopWindow;
import com.serverengines.mahogany.PixelBufferImage;
import com.serverengines.mahoganyprotocol.Attribute;
import com.serverengines.mahoganyprotocol.Palette;

public final class GraphicsMgr {
    protected static LogWriter s_log = new LogWriter((class$com$serverengines$graphics$GraphicsMgr == null ? (class$com$serverengines$graphics$GraphicsMgr = GraphicsMgr.class$("com.serverengines.graphics.GraphicsMgr")) : class$com$serverengines$graphics$GraphicsMgr).getName());
    public static final short BPP_4 = 4;
    public static final short BPP_8 = 8;
    public static final short BPP_15 = 15;
    public static final short BPP_16 = 16;
    public static final short BPP_24 = 24;
    public static final short BPP_32 = 32;
    public static final int RED_MASK = 0xFF0000;
    public static final int GREEN_MASK = 65280;
    public static final int BLUE_MASK = 255;
    public static final int DEFAULT_PALETTE_SIZE = 256;
    public static final int MAX_ATTRIBUTE_SIZE = 64;
    public static final int RGB565_RED_MASK = 63488;
    public static final int RGB565_GREEN_MASK = 2016;
    public static final int RGB565_BLUE_MASK = 31;
    public static final int RGB555_RED_MASK = 31744;
    public static final int RGB555_GREEN_MASK = 992;
    public static final int RGB555_BLUE_MASK = 31;
    public static final int SINGLE_TRIPLET = 1;
    public static final int SINGLE_REPEATER = 0;
    public static final int TRIPLET_REPEAT_AMT = 3;
    public static final int SINGLE_REPEAT_AMT = 1;
    public static final int BYTE_SHIFT = 3;
    protected static GraphicsMgr s_graphicsMgr = null;
    protected DesktopWindow m_desktop = null;
    protected PixelBufferImage m_imageRender = null;
    protected CConn m_cconn = null;
    static /* synthetic */ Class class$com$serverengines$graphics$GraphicsMgr;

    protected GraphicsMgr() {
    }

    public static synchronized GraphicsMgr getInstance() {
        if (s_graphicsMgr == null) {
            s_graphicsMgr = new GraphicsMgr();
        }
        return s_graphicsMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle() {
        Class clazz = class$com$serverengines$graphics$GraphicsMgr == null ? (class$com$serverengines$graphics$GraphicsMgr = GraphicsMgr.class$("com.serverengines.graphics.GraphicsMgr")) : class$com$serverengines$graphics$GraphicsMgr;
        synchronized (clazz) {
            s_graphicsMgr = null;
        }
    }

    public DesktopWindow getDesktop() {
        return this.m_desktop;
    }

    public PixelBufferImage getImageRender() {
        return this.m_imageRender;
    }

    public void setDesktop(DesktopWindow desktopWindow, PixelBufferImage pixelBufferImage, CConn cConn) {
        this.m_desktop = desktopWindow;
        this.m_imageRender = pixelBufferImage;
        this.m_cconn = cConn;
    }

    public void setVesaMode(short s, short s2, short s3, short s4) {
        this.m_desktop.setVesaMode(s, s2, s3, s4);
    }

    public void standbyPower() {
        this.m_desktop.setVesaMode((short)-1, (short)16, (short)640, (short)480);
        this.m_imageRender.standbyPower();
    }

    public void setPalette(Palette[] paletteArray, Attribute[] attributeArray, short s, short s2) {
        this.m_desktop.setPalette(paletteArray, attributeArray, s, s2);
    }

    public void bitBlt(short s, short s2, short s3, int n, int n2, int n3, int n4, byte[] byArray, int n5) {
        this.m_desktop.incrementFrameCounter(n, n2);
        switch (s) {
            case 256: {
                this.m_imageRender.bitBlt(n, n2, n3, n4, s2, s3, byArray);
                break;
            }
            case 499: {
                this.m_imageRender.setSpecial4bppMode(true);
                this.m_imageRender.bitBlt(n, n2, n3, n4, s2, s3, byArray);
                break;
            }
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: 
            case 264: {
                this.m_imageRender.setSpecial4bppMode(false);
                this.m_desktop.setTextMode(s);
                this.m_imageRender.bitBlt(n, n2, n3, n4, s2, s3, byArray);
                break;
            }
            default: {
                if (!s_log.isInfoLoggingEnabled()) break;
                StringBuffer stringBuffer = Helper.formatToHex(s);
                s_log.info("Unknown bit blt type = " + stringBuffer.toString());
                StringBufferPool.recycle(stringBuffer);
            }
        }
        this.m_desktop.endRect();
    }

    public void enhanceBitBlt(short s, byte by, byte by2, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, byte[] byArray) {
        if (s == -32272 || s == -32270 || s == -32269) {
            this.m_desktop.incrementFrameCounter(0, 0);
        }
        switch (s) {
            case -32272: 
            case 496: {
                this.m_imageRender.enhanceBitBlt(by, by2, nArray, nArray2, byArray);
                break;
            }
            case -32270: 
            case 498: {
                this.m_imageRender.enhanceBitBltHLC(by, by2, n, n2, nArray, nArray2, byArray);
                break;
            }
            case -32269: 
            case 499: {
                this.m_imageRender.enhanceBitBlt4bpp(by, by2, nArray, nArray2, byArray);
                break;
            }
            default: {
                StringBuffer stringBuffer = Helper.formatToHex(s);
                if (s_log.isInfoLoggingEnabled()) {
                    s_log.info("Unknown enhance bit blt type = " + stringBuffer.toString());
                }
                StringBufferPool.recycle(stringBuffer);
            }
        }
        this.m_desktop.endRect();
    }

    public void setTextCursor(int n, int n2, int n3, int n4) {
        this.m_desktop.setTextCursor(n, n2, n3, n4);
    }

    public void blinkingText(boolean bl) {
        this.m_desktop.blinkingText(bl);
    }

    public void dbeSwap(boolean bl, int n, int n2) {
        this.m_desktop.dbeSwap(bl, n, n2);
    }

    public void onSetBPP4ColorIndex(int n) {
        this.m_desktop.onSetBPP4ColorIndex(n);
    }

    public void matroxGraphicsCursor(byte[] byArray, byte[][] byArray2, byte by) {
        this.m_desktop.matroxGraphicsCursor(byArray, byArray2, by);
    }

    public void toggleMouse() {
        if (this.m_desktop != null) {
            this.m_desktop.toggleMouse();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

