/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.graphics;

import com.serverengines.graphics.ScreenMode;
import com.serverengines.kvm.LogWriter;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;

public class GraphicMode
extends ScreenMode {
    public static final int POOL_SIZE = 5;
    protected static GraphicMode[] s_pool = new GraphicMode[5];
    protected static int s_poolCount = 0;
    protected static LogWriter vlog = new LogWriter((class$com$serverengines$graphics$GraphicMode == null ? (class$com$serverengines$graphics$GraphicMode = GraphicMode.class$("com.serverengines.graphics.GraphicMode")) : class$com$serverengines$graphics$GraphicMode).getName());
    static /* synthetic */ Class class$com$serverengines$graphics$GraphicMode;

    protected GraphicMode(int n, int n2, int n3) {
        super(n, n2, n3);
        if (this.m_bpp < 15 && !s_isValidPalette) {
            int n4;
            int n5;
            int n6;
            byte[] byArray = s_paletteMgr.getReds();
            byte[] byArray2 = s_paletteMgr.getGreens();
            byte[] byArray3 = s_paletteMgr.getBlues();
            byte[] byArray4 = s_attributeMgr.getAttributes();
            if (this.m_bpp == 8) {
                n6 = 256;
                n5 = 0;
            } else {
                n6 = 16;
                n5 = 16;
            }
            s_paletteMgr.setPaletteSize(n6);
            s_attributeMgr.setAttributeSize(n5);
            for (n4 = 0; n4 < n6; ++n4) {
                byArray[n4] = (byte)(((n4 & 7) * 255 + 3) / 7);
                byArray2[n4] = (byte)(((n4 >> 3 & 7) * 255 + 3) / 7);
                byArray3[n4] = (byte)(((n4 >> 6 & 3) * 255 + 1) / 3);
            }
            for (n4 = 0; n4 < n5; ++n4) {
                byArray4[n4] = (byte)n4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphicMode getInstance(int n, int n2, int n3) {
        Class clazz = class$com$serverengines$graphics$GraphicMode == null ? (class$com$serverengines$graphics$GraphicMode = GraphicMode.class$("com.serverengines.graphics.GraphicMode")) : class$com$serverengines$graphics$GraphicMode;
        synchronized (clazz) {
            GraphicMode graphicMode;
            if (s_poolCount == 0) {
                graphicMode = new GraphicMode(n, n2, n3);
            } else {
                graphicMode = s_pool[--s_poolCount];
                GraphicMode.s_pool[GraphicMode.s_poolCount] = null;
                graphicMode.m_bpp = n;
                graphicMode.m_screenWidth = n2;
                graphicMode.m_screenHeight = n3;
            }
            return graphicMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Class clazz = class$com$serverengines$graphics$GraphicMode == null ? (class$com$serverengines$graphics$GraphicMode = GraphicMode.class$("com.serverengines.graphics.GraphicMode")) : class$com$serverengines$graphics$GraphicMode;
        synchronized (clazz) {
            if (s_poolCount < 5) {
                GraphicMode.s_pool[GraphicMode.s_poolCount] = this;
                ++s_poolCount;
            }
        }
    }

    public ColorModel getColorModel() {
        ColorModel colorModel = null;
        switch (this.m_bpp) {
            case 4: 
            case 8: {
                colorModel = super.getColorModel();
                break;
            }
            case 15: {
                colorModel = new DirectColorModel(this.m_bpp, 31744, 992, 31);
                break;
            }
            case 16: {
                colorModel = new DirectColorModel(this.m_bpp, 63488, 2016, 31);
                break;
            }
            case 24: 
            case 32: {
                colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255);
                break;
            }
            default: {
                if (!vlog.isErrorLoggingEnabled()) break;
                vlog.error("Unknown bits per pixel: " + this.m_bpp);
            }
        }
        return colorModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

