/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.graphics;

import com.serverengines.kvm.LogWriter;
import java.util.Random;

public class DecodedMouseCursor {
    public static final int POOL_SIZE = 5;
    protected static DecodedMouseCursor[] s_pool = new DecodedMouseCursor[5];
    protected static int s_poolCount = 0;
    protected static LogWriter vlog = new LogWriter((class$com$serverengines$graphics$DecodedMouseCursor == null ? (class$com$serverengines$graphics$DecodedMouseCursor = DecodedMouseCursor.class$("com.serverengines.graphics.DecodedMouseCursor")) : class$com$serverengines$graphics$DecodedMouseCursor).getName());
    public static final int CONTROL_SIZE = 256;
    public static final int NUM_CURSOR_ROWS = 64;
    public static final int NUM_BYTES_IN_EACH_ROW = 48;
    public static final int LOW = 0;
    public static final int HIGH = 1;
    public static final int CURSOR_COLOR_0 = 0;
    public static final int CURSOR_COLOR_1 = 1;
    public static final int CURSOR_COLOR_2 = 2;
    public static final int CURSOR_TRANSPARENT = 3;
    public static final int CURSOR_COMPLEMENT = 4;
    public static final int INDEX_RED = 0;
    public static final int INDEX_GREEN = 1;
    public static final int INDEX_BLUE = 2;
    public static final int CURSOR_PALETTE_SIZE = 16;
    public static final int TOTAL_CURSOR_PALETTE_SIZE = 17;
    public static final int TRANSPARENT_INDEX = 16;
    public static final int MAX_COLOR_RANGE = 0x1000000;
    public static final int CURSOR_MODE_3_COLOR = 1;
    public static final int CURSOR_MODE_XGA = 2;
    public static final int CURSOR_MODE_XWINDOW = 3;
    public static final int CURSOR_MODE_DIRECT = 4;
    public static final int IMAGE_WIDTH = 64;
    public static final int IMAGE_HEIGHT = 64;
    public static final int NUM_MODES = 4;
    public static final int DEFAULT_X_HOTSPOT_POS = 10;
    public static final int DEFAULT_Y_HOTSPOT_POS = 10;
    public static final String DEFAULT_CURSOR_NAME = "custom0";
    public static final int[][] CONTROL_INDEXES = new int[][]{{8, 12, 16, 96, 99, 102, 105, 108, 111, 114, 117, 120, 123, 126, 129, 132}, {9, 13, 17, 97, 100, 103, 106, 109, 112, 115, 118, 121, 124, 127, 130, 133}, {10, 14, 18, 98, 101, 104, 107, 110, 113, 116, 119, 122, 125, 128, 131, 134}};
    public static final int[][] DECODED_PIXEL_DATA_MAP = new int[][]{{3, 0, 1, 2}, {0, 1, 3, 4}, {3, 3, 0, 1}};
    protected byte[] m_cursor_control = new byte[256];
    protected byte[][] m_cursor_data = new byte[64][48];
    protected byte m_cursor_mode;
    protected int m_index;
    protected int[] m_modeValues = new int[4];
    protected byte[] m_colorPositionInfo = new byte[4096];
    protected int m_transparentColor;
    static /* synthetic */ Class class$com$serverengines$graphics$DecodedMouseCursor;

    protected DecodedMouseCursor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DecodedMouseCursor getInstance(byte[] byArray, byte[][] byArray2, byte by) {
        Class clazz = class$com$serverengines$graphics$DecodedMouseCursor == null ? (class$com$serverengines$graphics$DecodedMouseCursor = DecodedMouseCursor.class$("com.serverengines.graphics.DecodedMouseCursor")) : class$com$serverengines$graphics$DecodedMouseCursor;
        synchronized (clazz) {
            DecodedMouseCursor decodedMouseCursor;
            if (s_poolCount == 0) {
                decodedMouseCursor = new DecodedMouseCursor();
            } else {
                decodedMouseCursor = s_pool[--s_poolCount];
                DecodedMouseCursor.s_pool[DecodedMouseCursor.s_poolCount] = null;
            }
            decodedMouseCursor.m_index = 0;
            System.arraycopy(byArray, 0, decodedMouseCursor.m_cursor_control, 0, decodedMouseCursor.m_cursor_control.length);
            for (int i = 0; i < 64; ++i) {
                System.arraycopy(byArray2[i], 0, decodedMouseCursor.m_cursor_data[i], 0, decodedMouseCursor.m_cursor_data[i].length);
            }
            decodedMouseCursor.m_cursor_mode = by;
            decodedMouseCursor.InitializeColorPositionInfoArray();
            return decodedMouseCursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Class clazz = class$com$serverengines$graphics$DecodedMouseCursor == null ? (class$com$serverengines$graphics$DecodedMouseCursor = DecodedMouseCursor.class$("com.serverengines.graphics.DecodedMouseCursor")) : class$com$serverengines$graphics$DecodedMouseCursor;
        synchronized (clazz) {
            if (s_poolCount < 5) {
                DecodedMouseCursor.s_pool[DecodedMouseCursor.s_poolCount] = this;
                ++s_poolCount;
            }
        }
    }

    public byte GetRedOfTransparent() {
        return (byte)((this.m_transparentColor & 0xFF0000) >> 16);
    }

    public byte GetGreenOfTransparent() {
        return (byte)((this.m_transparentColor & 0xFF00) >> 8);
    }

    public byte GetBlueOfTransparent() {
        return (byte)(this.m_transparentColor & 0xFF);
    }

    public byte[] getReds() {
        byte[] byArray = new byte[17];
        for (int i = 0; i < 16; ++i) {
            byArray[i] = this.m_cursor_control[CONTROL_INDEXES[0][i]];
        }
        byArray[16] = this.GetRedOfTransparent();
        return byArray;
    }

    public byte[] getGreens() {
        byte[] byArray = new byte[17];
        for (int i = 0; i < 16; ++i) {
            byArray[i] = this.m_cursor_control[CONTROL_INDEXES[1][i]];
        }
        byArray[16] = this.GetGreenOfTransparent();
        return byArray;
    }

    public byte[] getBlues() {
        byte[] byArray = new byte[17];
        for (int i = 0; i < 16; ++i) {
            byArray[i] = this.m_cursor_control[CONTROL_INDEXES[2][i]];
        }
        byArray[16] = this.GetBlueOfTransparent();
        return byArray;
    }

    protected void GetCursorModeColors(byte by) {
        if (by == 1 || by == 2 || by == 3) {
            System.arraycopy(DECODED_PIXEL_DATA_MAP[by - 1], 0, this.m_modeValues, 0, this.m_modeValues.length);
        }
    }

    protected int GenerateTransparentColor() {
        boolean bl = true;
        int[] nArray = new int[16];
        Random random = new Random();
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.m_cursor_control[CONTROL_INDEXES[0][i]] & 0xFF;
            int n2 = this.m_cursor_control[CONTROL_INDEXES[1][i]] & 0xFF;
            int n3 = this.m_cursor_control[CONTROL_INDEXES[2][i]] & 0xFF;
            nArray[i] = n << 16 | n2 << 8 | n3;
        }
        while (bl) {
            this.m_transparentColor = random.nextInt(0x1000000);
            bl = this.ColorExits(this.m_transparentColor, nArray);
        }
        if (vlog.isInfoLoggingEnabled()) {
            vlog.info("m_transparentColor = " + this.m_transparentColor);
        }
        return this.m_transparentColor;
    }

    protected boolean ColorExits(int n, int[] nArray) {
        boolean bl = false;
        for (int i = 0; !bl && i < 16; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
        }
        return bl;
    }

    protected byte getCursorMode() {
        return this.m_cursor_mode;
    }

    protected void InsertCursorColor(int n) {
        switch (n) {
            case 3: {
                this.m_colorPositionInfo[this.m_index] = 16;
                break;
            }
            case 4: {
                this.m_colorPositionInfo[this.m_index] = 16;
                break;
            }
            case 0: {
                this.m_colorPositionInfo[this.m_index] = 0;
                break;
            }
            case 1: {
                this.m_colorPositionInfo[this.m_index] = 1;
                break;
            }
            default: {
                this.m_colorPositionInfo[this.m_index] = 2;
            }
        }
        ++this.m_index;
    }

    protected void GetPlane0123Value(int n, int n2) {
        byte by = (byte)(this.m_cursor_data[0][n] >> n2 & 1);
        byte by2 = (byte)(this.m_cursor_data[1][n] >> n2 & 1);
        byte by3 = (byte)(this.m_cursor_data[2][n] >> n2 & 1);
        byte by4 = (byte)(this.m_cursor_data[3][n] >> n2 & 1);
        this.m_colorPositionInfo[this.m_index] = (byte)(by4 << 3 | by3 << 2 | by2 << 1 | by);
        ++this.m_index;
    }

    protected void UpdateColorPositionInfo(byte by) {
        this.m_colorPositionInfo[this.m_index] = by;
        ++this.m_index;
    }

    protected void InitializeColorPositionInfoArray() {
        block17: {
            byte by;
            byte[] byArray;
            block16: {
                byArray = new byte[2];
                this.GenerateTransparentColor();
                by = this.getCursorMode();
                if (by != 1 && by != 2 && by != 3) break block16;
                this.GetCursorModeColors(by);
                block0: for (int i = 0; i < 22; ++i) {
                    int n = 11;
                    int n2 = n - 4;
                    for (int j = 3; j != 51; j += 16) {
                        for (int k = 0; k < 2; ++k) {
                            while (n != n2) {
                                byte by2 = this.m_cursor_data[i][j];
                                byte by3 = this.m_cursor_data[i][n];
                                for (int i2 = 7; i2 >= 0; --i2) {
                                    byte by4 = (byte)(by2 >> i2 & 1);
                                    byte by5 = (byte)(by3 >> i2 & 1);
                                    if (by5 == 0 && by4 == 0) {
                                        this.InsertCursorColor(this.m_modeValues[0]);
                                        continue;
                                    }
                                    if (by5 == 0 && by4 == 1) {
                                        this.InsertCursorColor(this.m_modeValues[1]);
                                        continue;
                                    }
                                    if (by5 == 1 && by4 == 0) {
                                        this.InsertCursorColor(this.m_modeValues[2]);
                                        continue;
                                    }
                                    this.InsertCursorColor(this.m_modeValues[3]);
                                }
                                --j;
                                --n;
                            }
                            if (k != 0 || n != n2) continue;
                            j += 8;
                            n2 = (n += 8) - 4;
                        }
                        if (i == 21) continue block0;
                        n2 = (n += 16) - 4;
                    }
                }
                break block17;
            }
            if (by != 4) break block17;
            for (int i = 0; i < 64; ++i) {
                int n = 36;
                int n3 = n + 4;
                int n4 = 7;
                int n5 = 4;
                int n6 = n5 + 4;
                while (n5 != 36) {
                    for (int j = 0; j < 2; ++j) {
                        while (n5 != n6) {
                            byArray[1] = (byte)((this.m_cursor_data[i][n5] & 0xF0) >> 4);
                            byArray[0] = (byte)(this.m_cursor_data[i][n5] & 0xF);
                            for (int k = 1; k >= 0; --k) {
                                byte by6 = (byte)(this.m_cursor_data[i][n] >> n4 & 1);
                                byte by7 = (byte)(this.m_cursor_data[i][n + 8] >> n4 & 1);
                                if (n4 == 0) {
                                    n4 = 8;
                                    n = (byte)(n + 1);
                                }
                                if (n == n3) {
                                    n = 32;
                                }
                                n4 = (byte)(n4 - 1);
                                if (by6 == 0 && by7 == 0) {
                                    this.UpdateColorPositionInfo(byArray[j]);
                                    continue;
                                }
                                this.m_colorPositionInfo[this.m_index] = 16;
                                ++this.m_index;
                            }
                            ++n5;
                        }
                        if (j != 0) continue;
                        n6 = (n5 -= 8) + 4;
                    }
                    n6 = (n5 += 8) + 4;
                }
            }
        }
    }

    public byte[] GetColorPositionInfoArray() {
        return this.m_colorPositionInfo;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

