/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.cookies;

import com.serverengines.cookies.CookieException;
import com.serverengines.helper.CalendarPool;
import com.serverengines.helper.StringBufferPool;
import com.serverengines.helper.StringParser;
import com.serverengines.kvm.LogWriter;
import com.serverengines.resmgr.AppResMgr;
import java.applet.Applet;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;

public final class CookieMgr {
    public static final int POOL_SIZE = 5;
    public static final String DOCUMENT = "document";
    public static final String COOKIE = "cookie";
    public static final String EXPIRES = "expires";
    public static final String COOKIE_NAME_PREFIX = "cookie";
    public static final String SEMI_COLON = ";";
    public static final String COMMA = ",";
    public static final char[] ILLEGAL_CHARS = new char[]{";".charAt(0), "=".charAt(0)};
    protected static LogWriter s_logger = new LogWriter((class$com$serverengines$cookies$CookieMgr == null ? (class$com$serverengines$cookies$CookieMgr = CookieMgr.class$("com.serverengines.cookies.CookieMgr")) : class$com$serverengines$cookies$CookieMgr).getName());
    protected static CookieMgr[] s_pool = new CookieMgr[5];
    protected static int s_poolCount = 0;
    protected Applet m_applet;
    static /* synthetic */ Class class$com$serverengines$cookies$CookieMgr;

    protected CookieMgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CookieMgr getInstance(Applet applet) {
        Class clazz = class$com$serverengines$cookies$CookieMgr == null ? (class$com$serverengines$cookies$CookieMgr = CookieMgr.class$("com.serverengines.cookies.CookieMgr")) : class$com$serverengines$cookies$CookieMgr;
        synchronized (clazz) {
            CookieMgr cookieMgr = null;
            if (s_poolCount == 0) {
                cookieMgr = new CookieMgr();
            } else {
                cookieMgr = s_pool[--s_poolCount];
                CookieMgr.s_pool[CookieMgr.s_poolCount] = null;
            }
            cookieMgr.m_applet = applet;
            return cookieMgr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Class clazz = class$com$serverengines$cookies$CookieMgr == null ? (class$com$serverengines$cookies$CookieMgr = CookieMgr.class$("com.serverengines.cookies.CookieMgr")) : class$com$serverengines$cookies$CookieMgr;
        synchronized (clazz) {
            this.m_applet = null;
            if (s_poolCount < 5) {
                CookieMgr.s_pool[CookieMgr.s_poolCount] = this;
                ++s_poolCount;
            }
        }
    }

    protected String getUTCString() throws JSException {
        Calendar calendar = CalendarPool.getInstance();
        AppResMgr appResMgr = AppResMgr.getInstance();
        calendar.add(5, appResMgr.getResourceInt("applet.cookie.expire.time"));
        String string = calendar.getTime().toString();
        CalendarPool.recycle(calendar);
        return string;
    }

    protected boolean isValidString(String string) {
        boolean bl = true;
        int n = 0;
        while (n < ILLEGAL_CHARS.length && bl) {
            if (string.indexOf(ILLEGAL_CHARS[n]) > -1) {
                bl = false;
                continue;
            }
            ++n;
        }
        return bl;
    }

    public void getCookies(Map map) throws CookieException {
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this.m_applet);
            JSObject jSObject2 = (JSObject)jSObject.getMember(DOCUMENT);
            StringParser stringParser = StringParser.getInstance(jSObject2.getMember("cookie").toString(), SEMI_COLON);
            while (stringParser.hasMoreTokens()) {
                String string = stringParser.nextToken().toString().trim();
                int n = string.indexOf("=");
                if (n <= 0) continue;
                int n2 = string.startsWith("cookie") ? "cookie".length() : 0;
                String string2 = string.substring(n2, n).trim();
                String string3 = string.substring(n + 1).trim();
                map.put(string2, string3);
            }
            stringParser.recycle();
        }
        catch (JSException jSException) {
            throw new CookieException("Failed to get cookies", jSException);
        }
    }

    public void writeCookies(Properties properties) throws CookieException {
        JSObject jSObject;
        Object object;
        StringBuffer stringBuffer = StringBufferPool.getInstance();
        try {
            object = JSObject.getWindow((Applet)this.m_applet);
            jSObject = (JSObject)((JSObject)object).getMember(DOCUMENT);
        }
        catch (Exception exception) {
            s_logger.error(exception);
            throw new CookieException("Failed to write cookies", exception);
        }
        object = properties.propertyNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            stringBuffer.setLength(0);
            stringBuffer.append("cookie");
            stringBuffer.append(string);
            stringBuffer.append("=");
            String string2 = properties.getProperty(string);
            if (!this.isValidString(string) || !this.isValidString(string2)) {
                throw new CookieException(string);
            }
            stringBuffer.append(string2);
            stringBuffer.append(SEMI_COLON);
            stringBuffer.append(EXPIRES);
            stringBuffer.append("=");
            stringBuffer.append(this.getUTCString());
            try {
                jSObject.setMember("cookie", stringBuffer.toString());
            }
            catch (Exception exception) {
                throw new CookieException("Failed to write cookies", exception);
            }
        }
        StringBufferPool.recycle(stringBuffer);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

