/*
 * Decompiled with CFR 0.152.
 */
package com.serverengines.buffer;

import com.serverengines.buffer.BufferMgr;
import com.serverengines.buffer.Buffers;

public abstract class EndianBufferMgr
extends BufferMgr {
    public static final int ALIGNMENT_MASK = 7;
    protected byte[] m_buffer = Buffers.m_bufMgrBuffer;
    protected int m_offset = 0;

    public byte[] getBuffer() {
        return this.m_buffer;
    }

    public int getOffset() {
        return this.m_offset;
    }

    public void setOffset(int n) {
        this.m_offset = n;
    }

    public void clear() {
        this.m_offset = 0;
    }

    public byte readByte() {
        byte by = this.m_buffer[this.m_offset];
        ++this.m_offset;
        return by;
    }

    public void write(byte by) {
        this.m_buffer[this.m_offset] = by;
        ++this.m_offset;
    }

    public boolean readBoolean() {
        boolean bl = this.m_buffer[this.m_offset] != 0;
        ++this.m_offset;
        return bl;
    }

    public void write(boolean bl) {
        this.m_buffer[this.m_offset] = bl ? (byte)1 : 0;
        ++this.m_offset;
    }

    public void readBytes(byte[] byArray, int n) {
        System.arraycopy(this.m_buffer, this.m_offset, byArray, 0, n);
        this.m_offset += n;
    }

    public void write(byte[] byArray, int n) {
        System.arraycopy(byArray, 0, this.m_buffer, this.m_offset, n);
        this.m_offset += n;
    }

    public String readString(short s) {
        String string = new String(this.m_buffer, this.m_offset, (int)s);
        this.m_offset += s;
        return string;
    }

    public void write(String string) {
        byte[] byArray = string.getBytes();
        System.arraycopy(byArray, 0, this.m_buffer, this.m_offset, byArray.length);
        this.m_offset += byArray.length;
    }
}

