/*
 * Decompiled with CFR 0.152.
 */
package com.hp.ilo2.virtdevs;

import com.hp.ilo2.virtdevs.D;
import com.hp.ilo2.virtdevs.SCSI;
import com.hp.ilo2.virtdevs.VErrorDialog;
import com.hp.ilo2.virtdevs.virtdevs;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class SCSIcdrom
extends SCSI {
    public static final int SCSI_IOCTL_DATA_OUT = 0;
    public static final int SCSI_IOCTL_DATA_IN = 1;
    public static final int SCSI_IOCTL_DATA_UNSPECIFIED = 2;
    public static final int CONST = 0;
    static final int WRITE = 0;
    static final int READ = 0x1000000;
    static final int NONE = 0x2000000;
    public static final int BLKS = 0x800000;
    static final int B32 = 262144;
    static final int B24 = 196608;
    static final int B16 = 131072;
    static final int B08 = 65536;
    static final int[] commands = new int[]{30, 0x2000000, 37, 0x1000008, 29, 0x2000000, 0, 0x2000000, 40, 25296903, 168, 25427974, 27, 0x2000000, 190, 25362438, 185, 0x1000000, 68, 0x1000008, 66, 16908295, 67, 16908295, 78, 0x2000000, 189, 16908296, 90, 16908295, 74, 16908295};
    byte[] sense = new byte[3];
    int retrycount;
    VErrorDialog dlg;
    boolean do_split_reads = false;
    virtdevs v;

    void media_err(byte[] byArray, byte[] byArray2) {
        String string = "The CDROM drive reports a media error:\nCommand: " + D.hex(byArray[0], 2) + " " + D.hex(byArray[1], 2) + " " + D.hex(byArray[2], 2) + " " + D.hex(byArray[3], 2) + " " + D.hex(byArray[4], 2) + " " + D.hex(byArray[5], 2) + " " + D.hex(byArray[6], 2) + " " + D.hex(byArray[7], 2) + " " + D.hex(byArray[8], 2) + " " + D.hex(byArray[9], 2) + " " + D.hex(byArray[10], 2) + " " + D.hex(byArray[11], 2) + "\n" + "Sense Code: " + D.hex(byArray2[0], 2) + "/" + D.hex(byArray2[1], 2) + "/" + D.hex(byArray2[2], 2) + "\n\n";
        this.dlg = new VErrorDialog(string, false);
    }

    public SCSIcdrom(Socket socket, InputStream inputStream, BufferedOutputStream bufferedOutputStream, String string, int n, virtdevs virtdevs2) throws IOException {
        super(socket, inputStream, bufferedOutputStream, string, n);
        D.println(1, "Media opening " + string + "(" + (n | 2) + ")");
        int n2 = this.media.open(string, n);
        D.println(1, "Media open returns " + n2);
        this.retrycount = Integer.valueOf(virtdevs.prop.getProperty("com.hp.ilo2.virtdevs.retrycount", "10"));
        this.v = virtdevs2;
    }

    public void close() throws IOException {
        this.req[0] = 30;
        this.req[11] = 0;
        this.req[10] = 0;
        this.req[9] = 0;
        this.req[8] = 0;
        this.req[7] = 0;
        this.req[7] = 0;
        this.req[5] = 0;
        this.req[4] = 0;
        this.req[3] = 0;
        this.req[2] = 0;
        this.req[1] = 0;
        this.media.scsi(this.req, 2, 0, this.buffer, null);
        super.close();
    }

    int scsi_length(int n, byte[] byArray) {
        int n2 = 0;
        switch (commands[++n] & 0x7F0000) {
            case 0: {
                n2 = commands[n] & 0xFFFF;
                break;
            }
            case 262144: {
                n2 = SCSI.mk_int32(byArray, commands[n] & 0xFFFF);
                break;
            }
            case 196608: {
                n2 = SCSI.mk_int24(byArray, commands[n] & 0xFFFF);
                break;
            }
            case 131072: {
                n2 = SCSI.mk_int16(byArray, commands[n] & 0xFFFF);
                break;
            }
            case 65536: {
                n2 = byArray[commands[n] & 0xFFFF] & 0xFF;
                break;
            }
            default: {
                D.println(0, "Unknown Size!");
            }
        }
        if ((commands[n] & 0x800000) == 0x800000) {
            n2 *= 2048;
        }
        return n2;
    }

    void start_stop_unit() {
        byte[] byArray = new byte[]{27, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray2 = new byte[3];
        int n = this.media.scsi(byArray, 2, 0, this.buffer, byArray2);
        D.println(3, "Start/Stop unit = " + n + " " + byArray2[0] + "/" + byArray2[1] + "/" + byArray2[2]);
    }

    boolean within_75(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[]{37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        boolean bl = byArray[0] == 168;
        int n = SCSI.mk_int32(byArray, 2);
        int n2 = bl ? SCSI.mk_int32(byArray, 6) : SCSI.mk_int16(byArray, 7);
        this.media.scsi(byArray3, 1, 8, byArray2, null);
        int n3 = SCSI.mk_int32(byArray2, 0);
        return n > n3 - 75 || n + n2 > n3 - 75;
    }

    int split_read() {
        boolean bl = this.req[0] == 168;
        int n = SCSI.mk_int32(this.req, 2);
        int n2 = bl ? SCSI.mk_int32(this.req, 6) : SCSI.mk_int16(this.req, 7);
        int n3 = n2 > 32 ? 32 : n2;
        int n4 = 1;
        this.req[2] = (byte)(n >> 24);
        this.req[3] = (byte)(n >> 16);
        this.req[4] = (byte)(n >> 8);
        this.req[5] = (byte)n;
        if (bl) {
            this.req[6] = (byte)(n3 >> 24);
            this.req[7] = (byte)(n3 >> 16);
            this.req[8] = (byte)(n3 >> 8);
            this.req[9] = (byte)n3;
        } else {
            this.req[7] = (byte)(n3 >> 8);
            this.req[8] = (byte)n3;
        }
        int n5 = this.media.scsi(this.req, n4, n3 * 2048, this.buffer, this.sense);
        if (n5 < 0) {
            return n5;
        }
        if ((n2 -= n3) <= 0) {
            return n5;
        }
        this.req[2] = (byte)((n += n3) >> 24);
        this.req[3] = (byte)(n >> 16);
        this.req[4] = (byte)(n >> 8);
        this.req[5] = (byte)n;
        if (bl) {
            this.req[6] = (byte)(n2 >> 24);
            this.req[7] = (byte)(n2 >> 16);
            this.req[8] = (byte)(n2 >> 8);
            this.req[9] = (byte)n2;
        } else {
            this.req[7] = (byte)(n2 >> 8);
            this.req[8] = (byte)n2;
        }
        int n6 = this.media.scsi(this.req, n4, n2 * 2048, this.buffer, this.sense, 65536);
        if (n6 < 0) {
            return n6;
        }
        return n5 + n6;
    }

    public boolean process() throws IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        this.read_command(this.req, 12);
        D.println(1, "SCSI Request:");
        D.hexdump(1, this.req, 12);
        this.v.ParentApp.remconsObj.setvmAct(1);
        if (this.media.dio.filehandle == -1 && (n = this.media.open(this.selectedDevice, this.targetIsDevice)) < 0) {
            new VErrorDialog("Could not open CDROM (" + this.media.dio.sysError(-n) + ")", false);
            throw new IOException("Couldn't open cdrom " + n);
        }
        int n4 = 0;
        while (n4 < commands.length) {
            if (this.req[0] == (byte)commands[n4]) break;
            n4 += 2;
        }
        if (n4 != commands.length) {
            n2 = this.scsi_length(n4, this.req);
            n3 = commands[n4 + 1] >> 24;
            n4 = this.req[0] & 0xFF;
            if (n3 == 0) {
                this.read_complete(this.buffer, n2);
            }
            D.println(1, "SCSI dir=" + n3 + " len=" + n2);
            int n5 = 0;
            do {
                long l = System.currentTimeMillis();
                n = (n4 == 40 || n4 == 168) && this.do_split_reads ? this.split_read() : this.media.scsi(this.req, n3, n2, this.buffer, this.sense);
                long l2 = System.currentTimeMillis();
                D.println(1, "ret=" + n + " sense=" + D.hex(this.sense[0], 2) + " " + D.hex(this.sense[1], 2) + " " + D.hex(this.sense[2], 2) + " Time=" + (l2 - l));
                if (n4 == 90) {
                    D.println(1, "media type: " + D.hex(this.buffer[3], 2));
                    this.reply.setmedia(this.buffer[3]);
                }
                if (n4 == 67) {
                    D.hexdump(3, this.buffer, n2);
                }
                if (n4 == 27) {
                    n = 0;
                }
                if (n4 == 40 || n4 == 168) {
                    if (this.sense[1] == 41) {
                        n = -1;
                    } else if (n < 0 && this.within_75(this.req)) {
                        this.sense[0] = 5;
                        this.sense[1] = 33;
                        this.sense[2] = 0;
                        n = 0;
                    } else if (n < 0) {
                        this.do_split_reads = true;
                    }
                }
                if (this.sense[0] != 3 && this.sense[0] != 4) continue;
                this.media_err(this.req, this.sense);
                n = -1;
            } while (n < 0 && n5++ < this.retrycount);
            n2 = n;
            if (n2 < 0 || n2 > 131072) {
                D.println(0, "AIEE! len out of bounds: " + n2 + ", cmd: " + D.hex(n4, 2) + "\n");
                n2 = 0;
                this.reply.set(5, 32, 0, 0);
            } else {
                this.reply.set(this.sense[0], this.sense[1], this.sense[2], n2);
            }
        } else {
            D.println(0, "AIEE! Unhandled command" + D.hex(this.req[0], 2) + "\n");
            this.reply.set(5, 32, 0, 0);
            n2 = 0;
        }
        this.reply.send(this.out);
        if (n2 != 0) {
            this.out.write(this.buffer, 0, n2);
        }
        this.out.flush();
        return true;
    }
}

