/*
 * Decompiled with CFR 0.152.
 */
package com.hp.ilo2.virtdevs;

import com.hp.ilo2.virtdevs.D;
import com.hp.ilo2.virtdevs.SCSI;
import com.hp.ilo2.virtdevs.virtdevs;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class SCSIcdimage
extends SCSI {
    int fdd_state = 0;
    int event_state = 0;
    long media_sz;
    virtdevs v;

    public void setWriteProt(boolean bl) {
        this.writeprot = bl;
    }

    public SCSIcdimage(Socket socket, InputStream inputStream, BufferedOutputStream bufferedOutputStream, String string, int n, virtdevs virtdevs2) throws IOException {
        super(socket, inputStream, bufferedOutputStream, string, n);
        int n2 = this.media.open(string, 0);
        D.println(1, "Media open returns " + n2 + " / " + this.media.size() + " bytes");
        this.v = virtdevs2;
    }

    public boolean process() throws IOException {
        boolean bl = true;
        D.println(1, "Device: " + this.selectedDevice + " (" + this.targetIsDevice + ")");
        this.read_command(this.req, 12);
        D.print(1, "SCSI Request: ");
        D.hexdump(1, this.req, 12);
        this.v.ParentApp.remconsObj.setvmAct(1);
        this.media_sz = this.media.size();
        if (this.media_sz == 0L) {
            this.reply.setmedia(0);
            this.fdd_state = 0;
            this.event_state = 4;
        } else {
            this.reply.setmedia(1);
            ++this.fdd_state;
            if (this.fdd_state > 2) {
                this.fdd_state = 2;
            }
            if (this.event_state == 4) {
                this.event_state = 0;
            }
            ++this.event_state;
            if (this.event_state > 2) {
                this.event_state = 2;
            }
        }
        switch (this.req[0] & 0xFF) {
            case 30: {
                this.client_pa_media_removal(this.req);
                break;
            }
            case 37: {
                this.client_read_capacity();
                break;
            }
            case 29: {
                this.client_send_diagnostic();
                break;
            }
            case 0: {
                this.client_test_unit_ready();
                break;
            }
            case 40: 
            case 168: {
                this.client_read(this.req);
                break;
            }
            case 27: {
                bl = this.client_start_stop_unit(this.req);
                break;
            }
            case 67: {
                this.client_read_toc(this.req);
                break;
            }
            case 90: {
                this.client_mode_sense(this.req);
                break;
            }
            case 74: {
                this.client_get_event_status(this.req);
                break;
            }
            default: {
                D.println(0, "Unknown request:cmd = " + Integer.toHexString(this.req[0]));
                this.reply.set(5, 36, 0, 0);
                this.reply.send(this.out);
                this.out.flush();
            }
        }
        return bl;
    }

    void client_send_diagnostic() throws IOException {
    }

    void client_read(byte[] byArray) throws IOException {
        boolean bl = byArray[0] == 168;
        long l = (long)SCSI.mk_int32(byArray, 2) * 2048L;
        int n = bl ? SCSI.mk_int32(byArray, 6) : SCSI.mk_int16(byArray, 7);
        D.println(3, "CDImage :Client read " + l + ", len=" + (n *= 2048));
        if (this.fdd_state == 0) {
            D.println(3, "media not present");
            this.reply.set(2, 58, 0, 0);
            n = 0;
        } else if (this.fdd_state == 1) {
            D.println(3, "media changed");
            this.reply.set(6, 40, 0, 0);
            n = 0;
            this.fdd_state = 2;
        } else if (l >= 0L && l < this.media_sz) {
            this.media.read(l, n, this.buffer);
            this.reply.set(0, 0, 0, n);
        } else {
            this.reply.set(5, 33, 0, 0);
            n = 0;
        }
        this.reply.send(this.out);
        if (n != 0) {
            this.out.write(this.buffer, 0, n);
        }
        this.out.flush();
    }

    void client_pa_media_removal(byte[] byArray) throws IOException {
        if ((byArray[4] & 1) != 0) {
            D.println(3, "Media removal prevented");
        } else {
            D.println(3, "Media removal allowed");
        }
        this.reply.set(0, 0, 0, 0);
        this.reply.send(this.out);
        this.out.flush();
    }

    boolean client_start_stop_unit(byte[] byArray) throws IOException {
        this.reply.set(0, 0, 0, 0);
        this.reply.send(this.out);
        this.out.flush();
        if ((byArray[4] & 3) == 2) {
            this.fdd_state = 0;
            this.event_state = 4;
            D.println(3, "Media eject");
            return false;
        }
        return true;
    }

    void client_test_unit_ready() throws IOException {
        if (this.fdd_state == 0) {
            D.println(3, "media not present");
            this.reply.set(2, 58, 0, 0);
        } else if (this.fdd_state == 1) {
            D.println(3, "media changed");
            this.reply.set(6, 40, 0, 0);
            this.fdd_state = 2;
        } else {
            D.println(3, "device ready");
            this.reply.set(0, 0, 0, 0);
        }
        this.reply.send(this.out);
        this.out.flush();
    }

    void client_read_capacity() throws IOException {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        this.reply.set(0, 0, 0, byArray.length);
        if (this.fdd_state == 0) {
            this.reply.set(2, 58, 0, 0);
        } else if (this.fdd_state == 1) {
            this.reply.set(6, 40, 0, 0);
        } else {
            int n = (int)(this.media.size() / 2048L - 1L);
            byArray[0] = (byte)(n >> 24 & 0xFF);
            byArray[1] = (byte)(n >> 16 & 0xFF);
            byArray[2] = (byte)(n >> 8 & 0xFF);
            byArray[3] = (byte)(n >> 0 & 0xFF);
            byArray[6] = 8;
        }
        this.reply.send(this.out);
        if (this.fdd_state == 2) {
            this.out.write(byArray, 0, byArray.length);
        }
        this.out.flush();
        D.print(3, "client_read_capacity: ");
        D.hexdump(3, byArray, 8);
    }

    void client_read_toc(byte[] byArray) throws IOException {
        boolean bl = (byArray[1] & 2) != 0;
        int n = (byArray[9] & 0xC0) >> 6;
        int n2 = (int)(this.media.size() / 2048L);
        double d = (double)n2 / 75.0 + 2.0;
        int n3 = (int)d / 60;
        int n4 = (int)d % 60;
        int n5 = (int)((d - (double)((int)d)) * 75.0);
        int n6 = SCSI.mk_int16(byArray, 7);
        int n7 = 0;
        while (n7 < n6) {
            this.buffer[n7] = 0;
            ++n7;
        }
        if (n == 0) {
            this.buffer[0] = 0;
            this.buffer[1] = 18;
            this.buffer[2] = 1;
            this.buffer[3] = 1;
            this.buffer[4] = 0;
            this.buffer[5] = 20;
            this.buffer[6] = 1;
            this.buffer[7] = 0;
            this.buffer[8] = 0;
            this.buffer[9] = 0;
            this.buffer[10] = bl ? 2 : 0;
            this.buffer[11] = 0;
            this.buffer[12] = 0;
            this.buffer[13] = 20;
            this.buffer[14] = -86;
            this.buffer[15] = 0;
            this.buffer[16] = 0;
            this.buffer[17] = bl ? (byte)n3 : (byte)(n2 >> 16 & 0xFF);
            this.buffer[18] = bl ? (byte)n4 : (byte)(n2 >> 8 & 0xFF);
            byte by = this.buffer[19] = bl ? (byte)n5 : (byte)(n2 & 0xFF);
        }
        if (n == 1) {
            this.buffer[0] = 0;
            this.buffer[1] = 10;
            this.buffer[2] = 1;
            this.buffer[3] = 1;
            this.buffer[4] = 0;
            this.buffer[5] = 20;
            this.buffer[6] = 1;
            this.buffer[7] = 0;
            this.buffer[8] = 0;
            this.buffer[9] = 0;
            this.buffer[10] = bl ? 2 : 0;
            this.buffer[11] = 0;
        }
        if (n6 < (n2 = 412)) {
            n2 = n6;
        }
        D.hexdump(3, this.buffer, n2);
        this.reply.set(0, 0, 0, n2);
        this.reply.send(this.out);
        this.out.write(this.buffer, 0, n2);
        this.out.flush();
    }

    void client_mode_sense(byte[] byArray) throws IOException {
        this.buffer[0] = 0;
        this.buffer[1] = 8;
        this.buffer[2] = 1;
        this.buffer[3] = 0;
        this.buffer[4] = 0;
        this.buffer[5] = 0;
        this.buffer[6] = 0;
        this.buffer[7] = 0;
        this.reply.set(0, 0, 0, 8);
        D.hexdump(3, this.buffer, 8);
        this.reply.setmedia(this.buffer[2]);
        this.reply.send(this.out);
        this.out.write(this.buffer, 0, 8);
        this.out.flush();
    }

    void client_get_event_status(byte[] byArray) throws IOException {
        byte by = byArray[4];
        int n = SCSI.mk_int16(byArray, 7);
        int n2 = 0;
        while (n2 < n) {
            this.buffer[n2] = 0;
            ++n2;
        }
        if ((byArray[1] & 1) == 0) {
            this.reply.set(5, 36, 0, 0);
            this.reply.send(this.out);
            this.out.flush();
        }
        if ((by & 0x10) != 0) {
            this.buffer[0] = 0;
            this.buffer[1] = 6;
            this.buffer[2] = 4;
            this.buffer[3] = 16;
            if (this.event_state == 0) {
                this.buffer[4] = 0;
                this.buffer[5] = 0;
            } else if (this.event_state == 1) {
                this.buffer[4] = 4;
                this.buffer[5] = 2;
                if (n > 4) {
                    this.event_state = 2;
                }
            } else if (this.event_state == 4) {
                this.buffer[4] = 3;
                this.buffer[5] = 0;
                if (n > 4) {
                    this.event_state = 0;
                }
            } else {
                this.buffer[4] = 0;
                this.buffer[5] = 2;
            }
            D.hexdump(3, this.buffer, 8);
            this.reply.set(0, 0, 0, n < 8 ? n : 8);
            this.reply.send(this.out);
            this.out.write(this.buffer, 0, n < 8 ? n : 8);
            this.out.flush();
        } else {
            this.buffer[0] = 0;
            this.buffer[1] = 2;
            this.buffer[2] = -128;
            this.buffer[3] = 16;
            D.hexdump(3, this.buffer, 4);
            this.reply.set(0, 0, 0, n < 4 ? n : 4);
            this.reply.send(this.out);
            this.out.write(this.buffer, 0, n < 4 ? n : 4);
            this.out.flush();
        }
    }
}

