/*
 * Decompiled with CFR 0.152.
 */
package com.hp.ilo2.virtdevs;

import com.hp.ilo2.virtdevs.D;
import com.hp.ilo2.virtdevs.SCSI;
import com.hp.ilo2.virtdevs.VErrorDialog;
import com.hp.ilo2.virtdevs.virtdevs;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Date;

public class SCSIFloppy
extends SCSI {
    int fdd_state = 0;
    long media_sz;
    Date date = new Date();
    byte[] rcs_resp = new byte[]{0, 0, 0, 16, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 11, 64, 0, 0, 2, 0};
    virtdevs v;
    VErrorDialog dlg;

    public void setWriteProt(boolean bl) {
        this.writeprot = bl;
        if (this.fdd_state == 2) {
            this.fdd_state = 0;
        }
    }

    public SCSIFloppy(Socket socket, InputStream inputStream, BufferedOutputStream bufferedOutputStream, String string, int n, virtdevs virtdevs2) throws IOException {
        super(socket, inputStream, bufferedOutputStream, string, n);
        int n2 = this.media.open(string, n);
        D.print(1, "open returns " + n2);
        this.v = virtdevs2;
    }

    public boolean process() throws IOException {
        this.date.setTime(System.currentTimeMillis());
        D.println(1, "Date = " + this.date);
        D.println(1, "Device: " + this.selectedDevice + " (" + this.targetIsDevice + ")");
        this.read_command(this.req, 12);
        D.print(1, "SCSI Request: ");
        D.hexdump(1, this.req, 12);
        this.media_sz = this.media.size();
        this.v.ParentApp.remconsObj.setvmAct(1);
        if (this.media_sz < 0L || this.media.dio != null && this.media.dio.filehandle == -1) {
            D.println(1, "Disk change detected\n");
            this.media.close();
            this.media.open(this.selectedDevice, this.targetIsDevice);
            this.media_sz = this.media.size();
            this.fdd_state = 0;
        }
        D.println(1, "retval=" + this.media_sz + " type=" + this.media.type() + " physdrive=" + (this.media.dio != null ? this.media.dio.PhysicalDevice : -1));
        if (this.media_sz == -6L) {
            new VErrorDialog(this.v.ParentApp.dispFrame, this.selectedDevice + " " + this.v.ParentApp.remconsObj.getLocalString(8288) + "\n\n" + this.v.ParentApp.remconsObj.getLocalString(8239));
            return false;
        }
        if (this.media_sz <= 0L) {
            this.reply.setmedia(0);
            this.fdd_state = 0;
        } else {
            this.reply.setmedia(36);
            ++this.fdd_state;
            if (this.fdd_state > 2) {
                this.fdd_state = 2;
            }
        }
        if (!this.writeprot && this.media.wp()) {
            this.writeprot = true;
        }
        switch (this.req[0] & 0xFF) {
            case 4: {
                this.client_format_unit(this.req);
                break;
            }
            case 30: {
                this.client_pa_media_removal(this.req);
                break;
            }
            case 37: {
                this.client_read_capacity();
                break;
            }
            case 29: {
                this.client_send_diagnostic();
                break;
            }
            case 0: {
                this.client_test_unit_ready();
                break;
            }
            case 40: 
            case 168: {
                this.client_read(this.req);
                break;
            }
            case 42: 
            case 46: 
            case 170: {
                this.client_write(this.req);
                break;
            }
            case 35: {
                this.client_read_capacities();
                break;
            }
            case 27: {
                this.client_start_stop_unit(this.req);
                break;
            }
            default: {
                D.println(0, "Unknown request:cmd = " + Integer.toHexString(this.req[0]));
            }
        }
        return true;
    }

    void client_read_capacities() throws IOException {
        if (this.fdd_state != 1) {
            this.reply.set(0, 0, 0, this.rcs_resp.length);
        } else {
            this.reply.set(6, 40, 0, this.rcs_resp.length);
            this.fdd_state = 2;
        }
        if (this.media.type() == 0) {
            this.rcs_resp[11] = 0;
            this.rcs_resp[10] = 0;
            this.rcs_resp[7] = 0;
            this.rcs_resp[6] = 0;
            this.rcs_resp[5] = 0;
            this.rcs_resp[4] = 0;
        } else if (this.media.type() == 100) {
            long l = this.media.size() / 512L;
            this.rcs_resp[4] = (byte)(l >> 24 & 0xFFL);
            this.rcs_resp[5] = (byte)(l >> 16 & 0xFFL);
            this.rcs_resp[6] = (byte)(l >> 8 & 0xFFL);
            this.rcs_resp[7] = (byte)(l >> 0 & 0xFFL);
            this.rcs_resp[10] = 2;
            this.rcs_resp[11] = 0;
        } else {
            long l = this.media.size() / (long)this.media.dio.BytesPerSec;
            this.rcs_resp[4] = (byte)(l >> 24 & 0xFFL);
            this.rcs_resp[5] = (byte)(l >> 16 & 0xFFL);
            this.rcs_resp[6] = (byte)(l >> 8 & 0xFFL);
            this.rcs_resp[7] = (byte)(l >> 0 & 0xFFL);
            this.rcs_resp[10] = (byte)(this.media.dio.BytesPerSec >> 8 & 0xFF);
            this.rcs_resp[11] = (byte)(this.media.dio.BytesPerSec & 0xFF);
        }
        this.reply.setflags(this.writeprot);
        this.reply.send(this.out);
        this.out.write(this.rcs_resp, 0, this.rcs_resp.length);
        this.out.flush();
    }

    void client_send_diagnostic() throws IOException {
        this.fdd_state = 1;
    }

    void client_read(byte[] byArray) throws IOException {
        boolean bl = byArray[0] == 168;
        long l = (long)SCSI.mk_int32(byArray, 2) * 512L;
        int n = bl ? SCSI.mk_int32(byArray, 6) : SCSI.mk_int16(byArray, 7);
        D.println(3, "FDIO.client_read:Client read " + l + ", len=" + (n *= 512));
        if (l >= 0L && l < this.media_sz) {
            try {
                this.media.read(l, n, this.buffer);
                this.reply.set(0, 0, 0, n);
            }
            catch (IOException iOException) {
                D.println(0, "Exception during read: " + iOException);
                this.reply.set(3, 16, 0, 0);
                n = 0;
            }
        } else {
            this.reply.set(5, 33, 0, 0);
            n = 0;
        }
        this.reply.setflags(this.writeprot);
        this.reply.send(this.out);
        if (n != 0) {
            this.out.write(this.buffer, 0, n);
        }
        this.out.flush();
    }

    void client_write(byte[] byArray) throws IOException {
        boolean bl = byArray[0] == 170;
        long l = (long)SCSI.mk_int32(byArray, 2) * 512L;
        int n = bl ? SCSI.mk_int32(byArray, 6) : SCSI.mk_int16(byArray, 7);
        D.println(3, "FDIO.client_write:lba = " + l + ", length = " + (n *= 512));
        this.read_complete(this.buffer, n);
        if (!this.writeprot) {
            if (l >= 0L && l < this.media_sz) {
                try {
                    this.media.write(l, n, this.buffer);
                    this.reply.set(0, 0, 0, 0);
                }
                catch (IOException iOException) {
                    D.println(0, "Exception during write: " + iOException);
                    this.reply.set(3, 16, 0, 0);
                }
            } else {
                this.reply.set(5, 33, 0, 0);
            }
        } else {
            this.reply.set(7, 39, 0, 0);
        }
        this.reply.setflags(this.writeprot);
        this.reply.send(this.out);
        this.out.flush();
    }

    void client_pa_media_removal(byte[] byArray) throws IOException {
        if ((byArray[4] & 1) != 0) {
            this.reply.set(5, 36, 0, 0);
        } else {
            this.reply.set(0, 0, 0, 0);
        }
        this.reply.setflags(this.writeprot);
        this.reply.send(this.out);
        this.out.flush();
    }

    void client_start_stop_unit(byte[] byArray) throws IOException {
        if ((byArray[4] & 2) != 0) {
            this.reply.set(5, 36, 0, 0);
        } else {
            this.reply.set(0, 0, 0, 0);
        }
        this.reply.setflags(this.writeprot);
        this.reply.send(this.out);
        this.out.flush();
    }

    void client_test_unit_ready() throws IOException {
        if (this.fdd_state == 0) {
            D.println(3, "media not present");
            this.reply.set(2, 58, 0, 0);
        } else if (this.fdd_state == 1) {
            D.println(3, "media changed");
            this.reply.set(6, 40, 0, 0);
            this.fdd_state = 2;
        } else {
            D.println(3, "device ready");
            this.reply.set(0, 0, 0, 0);
        }
        this.reply.setflags(this.writeprot);
        this.reply.send(this.out);
        this.out.flush();
    }

    void client_format_unit(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[100];
        int n = SCSI.mk_int16(byArray, 7);
        this.read_complete(byArray2, n);
        D.print(3, "Format params: ");
        D.hexdump(3, byArray2, n);
        int n2 = byArray2[1] & 1;
        int n3 = SCSI.mk_int32(byArray2, 4) == 2880 && SCSI.mk_int24(byArray2, 9) == 512 ? 2 : (SCSI.mk_int32(byArray2, 4) == 1440 && SCSI.mk_int24(byArray2, 9) == 512 ? 5 : 0);
        if (this.writeprot) {
            this.reply.set(7, 39, 0, 0);
        } else if (n3 != 0) {
            int n4 = byArray[2] & 0xFF;
            this.media.format(n3, n4, n4, n2, n2);
            D.println(3, "format");
            this.reply.set(0, 0, 0, 0);
        } else {
            this.reply.set(5, 38, 0, 0);
        }
        this.reply.setflags(this.writeprot);
        this.reply.send(this.out);
        this.out.flush();
    }

    void client_read_capacity() throws IOException {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        this.reply.set(0, 0, 0, byArray.length);
        if (this.fdd_state == 0) {
            this.reply.set(2, 58, 0, 0);
        } else if (this.fdd_state == 1) {
            this.reply.set(6, 40, 0, 0);
        } else if (this.media.type() != 0) {
            if (this.media.type() == 100) {
                long l = this.media.size() / 512L - 1L;
                byArray[0] = (byte)(l >> 24 & 0xFFL);
                byArray[1] = (byte)(l >> 16 & 0xFFL);
                byArray[2] = (byte)(l >> 8 & 0xFFL);
                byArray[3] = (byte)(l >> 0 & 0xFFL);
                byArray[6] = 2;
            } else {
                long l = this.media.size() / (long)this.media.dio.BytesPerSec - 1L;
                byArray[0] = (byte)(l >> 24 & 0xFFL);
                byArray[1] = (byte)(l >> 16 & 0xFFL);
                byArray[2] = (byte)(l >> 8 & 0xFFL);
                byArray[3] = (byte)(l >> 0 & 0xFFL);
                byArray[6] = (byte)(this.media.dio.BytesPerSec >> 8 & 0xFF);
                byArray[7] = (byte)(this.media.dio.BytesPerSec & 0xFF);
            }
        }
        this.reply.setflags(this.writeprot);
        this.reply.send(this.out);
        if (this.fdd_state == 2) {
            this.out.write(byArray, 0, byArray.length);
        }
        this.out.flush();
        D.print(3, "FDIO.client_read_capacity: ");
        D.hexdump(3, byArray, 8);
    }
}

