/*
 * Decompiled with CFR 0.152.
 */
package com.hp.ilo2.virtdevs;

import com.hp.ilo2.virtdevs.D;
import com.hp.ilo2.virtdevs.MediaAccess;
import com.hp.ilo2.virtdevs.ReplyHeader;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;

public abstract class SCSI {
    public static final int SCSI_FORMAT_UNIT = 4;
    public static final int SCSI_INQUIRY = 18;
    public static final int SCSI_MODE_SELECT_6 = 21;
    public static final int SCSI_MODE_SELECT = 85;
    public static final int SCSI_MODE_SENSE_6 = 26;
    public static final int SCSI_MODE_SENSE = 90;
    public static final int SCSI_PA_MEDIA_REMOVAL = 30;
    public static final int SCSI_READ_10 = 40;
    public static final int SCSI_READ_12 = 168;
    public static final int SCSI_READ_CAPACITY = 37;
    public static final int SCSI_READ_CAPACITIES = 35;
    public static final int SCSI_REQUEST_SENSE = 3;
    public static final int SCSI_REZERO_UNIT = 1;
    public static final int SCSI_SEEK = 43;
    public static final int SCSI_SEND_DIAGNOSTIC = 29;
    public static final int SCSI_START_STOP_UNIT = 27;
    public static final int SCSI_TEST_UNIT_READY = 0;
    public static final int SCSI_VERIFY = 47;
    public static final int SCSI_WRITE_10 = 42;
    public static final int SCSI_WRITE_12 = 170;
    public static final int SCSI_WRITE_VERIFY = 46;
    public static final int SCSI_READ_CD = 190;
    public static final int SCSI_READ_CD_MSF = 185;
    public static final int SCSI_READ_HEADER = 68;
    public static final int SCSI_READ_SUBCHANNEL = 66;
    public static final int SCSI_READ_TOC = 67;
    public static final int SCSI_STOP_PLAY_SCAN = 78;
    public static final int SCSI_MECHANISM_STATUS = 189;
    public static final int SCSI_GET_EVENT_STATUS = 74;
    MediaAccess media = new MediaAccess();
    ReplyHeader reply = new ReplyHeader();
    String selectedDevice;
    protected InputStream in;
    protected BufferedOutputStream out;
    protected Socket sock;
    boolean writeprot = false;
    boolean please_exit = false;
    int targetIsDevice = 0;
    byte[] buffer = new byte[131072];
    byte[] req = new byte[12];

    public void setWriteProt(boolean bl) {
        this.writeprot = bl;
    }

    public boolean getWriteProt() {
        D.println(3, "media.wp = " + this.media.wp());
        return this.media.wp();
    }

    public SCSI(Socket socket, InputStream inputStream, BufferedOutputStream bufferedOutputStream, String string, int n) {
        this.sock = socket;
        this.in = inputStream;
        this.out = bufferedOutputStream;
        this.selectedDevice = string;
        this.targetIsDevice = n;
    }

    public void close() throws IOException {
        this.media.close();
    }

    public static int mk_int32(byte[] byArray, int n) {
        byte by = byArray[n + 0];
        byte by2 = byArray[n + 1];
        byte by3 = byArray[n + 2];
        byte by4 = byArray[n + 3];
        int n2 = (by & 0xFF) << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | by4 & 0xFF;
        return n2;
    }

    public static int mk_int24(byte[] byArray, int n) {
        byte by = byArray[n + 0];
        byte by2 = byArray[n + 1];
        byte by3 = byArray[n + 2];
        int n2 = (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
        return n2;
    }

    public static int mk_int16(byte[] byArray, int n) {
        byte by = byArray[n + 0];
        byte by2 = byArray[n + 1];
        int n2 = (by & 0xFF) << 8 | by2 & 0xFF;
        return n2;
    }

    protected int read_complete(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        while (n > 0) {
            try {
                this.sock.setSoTimeout(1000);
                n3 = this.in.read(byArray, n2, n);
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            if (n3 < 0) break;
            n -= n3;
            n2 += n3;
        }
        return n2;
    }

    protected int read_command(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        while (true) {
            try {
                this.sock.setSoTimeout(1000);
                n2 = this.in.read(byArray, 0, n);
            }
            catch (InterruptedIOException interruptedIOException) {
                this.reply.keepalive(true);
                D.println(3, "Sending keepalive");
                this.reply.send(this.out);
                this.out.flush();
                this.reply.keepalive(false);
                if (!this.please_exit) continue;
                break;
            }
            if ((byArray[0] & 0xFF) != 254) break;
            this.reply.sendsynch(this.out, byArray);
            this.out.flush();
        }
        if (this.please_exit) {
            throw new IOException("Asked to exit");
        }
        if (n2 < 0) {
            throw new IOException("Socket Closed");
        }
        return n2;
    }

    public void send_disconnect() {
        try {
            this.reply.disconnect(true);
            this.reply.send(this.out);
            this.out.flush();
            this.reply.disconnect(false);
        }
        catch (Exception exception) {
            D.println(1, "Exception in send_disconnect" + exception);
            exception.printStackTrace();
        }
    }

    public abstract boolean process() throws IOException;

    public void change_disk() {
        this.please_exit = true;
    }
}

