/*
 * Decompiled with CFR 0.152.
 */
package com.hp.ilo2.virtdevs;

import com.hp.ilo2.virtdevs.D;
import com.hp.ilo2.virtdevs.DirectIO;
import com.hp.ilo2.virtdevs.virtdevs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class MediaAccess {
    public static final int Unknown = 0;
    public static final int F5_1Pt2_512 = 1;
    public static final int F3_1Pt44_512 = 2;
    public static final int F3_2Pt88_512 = 3;
    public static final int F3_20Pt88_512 = 4;
    public static final int F3_720_512 = 5;
    public static final int F5_360_512 = 6;
    public static final int F5_320_512 = 7;
    public static final int F5_320_1024 = 8;
    public static final int F5_180_512 = 9;
    public static final int F5_160_512 = 10;
    public static final int RemovableMedia = 11;
    public static final int FixedMedia = 12;
    public static final int F3_120M_512 = 13;
    public static final int ImageFile = 100;
    public static final int NoRootDir = 1;
    public static final int Removable = 2;
    public static final int Fixed = 3;
    public static final int Remote = 4;
    public static final int CDROM = 5;
    public static final int Ramdisk = 6;
    public static String dllext = "";
    static int dio_setup = -1;
    DirectIO dio;
    File file;
    RandomAccessFile raf;
    boolean dev = false;
    boolean readonly = false;
    int zero_offset = 0;

    public int open(String string, int n) throws IOException {
        this.dev = (n & 1) == 1;
        boolean bl = (n & 2) == 2;
        this.zero_offset = 0;
        if (this.dev) {
            if (dio_setup != 0) {
                throw new IOException("DirectIO not possible (" + dio_setup + ")");
            }
            if (this.dio == null) {
                this.dio = new DirectIO();
            }
            return this.dio.open(string);
        }
        this.readonly = false;
        this.file = new File(string);
        if (!this.file.exists() && !bl) {
            throw new IOException("File " + string + " does not exist");
        }
        if (this.file.isDirectory()) {
            throw new IOException("File " + string + " is a directory");
        }
        try {
            this.raf = new RandomAccessFile(string, "rw");
        }
        catch (IOException iOException) {
            if (!bl) {
                this.raf = new RandomAccessFile(string, "r");
                this.readonly = true;
            }
            throw iOException;
        }
        byte[] byArray = new byte[512];
        this.read(0L, 512, byArray);
        if (byArray[0] == 67 && byArray[1] == 80 && byArray[2] == 81 && byArray[3] == 82 && byArray[4] == 70 && byArray[5] == 66 && byArray[6] == 76 && byArray[7] == 79) {
            this.zero_offset = byArray[14] | byArray[15] << 8;
        }
        byArray = null;
        return 0;
    }

    public int close() throws IOException {
        if (this.dev) {
            return this.dio.close();
        }
        this.raf.close();
        return 0;
    }

    public void read(long l, int n, byte[] byArray) throws IOException {
        l += (long)this.zero_offset;
        if (this.dev) {
            int n2 = this.dio.read(l, n, byArray);
            if (n2 != 0) {
                throw new IOException("DirectIO read error (" + this.dio.sysError(-n2) + ")");
            }
        } else {
            this.raf.seek(l);
            this.raf.read(byArray, 0, n);
        }
    }

    public void write(long l, int n, byte[] byArray) throws IOException {
        l += (long)this.zero_offset;
        if (this.dev) {
            int n2 = this.dio.write(l, n, byArray);
            if (n2 != 0) {
                throw new IOException("DirectIO write error (" + this.dio.sysError(-n2) + ")");
            }
        } else {
            this.raf.seek(l);
            this.raf.write(byArray, 0, n);
        }
    }

    public long size() throws IOException {
        long l = this.dev ? this.dio.size() : this.raf.length() - (long)this.zero_offset;
        return l;
    }

    public int format(int n, int n2, int n3, int n4, int n5) throws IOException {
        if (this.dev) {
            this.dio.media_type = n;
            this.dio.StartCylinder = n2;
            this.dio.EndCylinder = n3;
            this.dio.StartHead = n4;
            this.dio.EndHead = n5;
            return this.dio.format();
        }
        return 0;
    }

    public String[] devices() {
        if (dio_setup != 0) {
            return null;
        }
        if (this.dio == null) {
            this.dio = new DirectIO();
        }
        return this.dio.devices();
    }

    public int devtype(String string) {
        if (dio_setup != 0) {
            return 0;
        }
        if (this.dio == null) {
            this.dio = new DirectIO();
        }
        return this.dio.devtype(string);
    }

    public int scsi(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3) {
        return this.scsi(byArray, n, n2, byArray2, byArray3, 0);
    }

    public int scsi(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3, int n3) {
        int n4 = this.dev ? this.dio.scsi(byArray, n, n2, byArray2, byArray3, n3) : -1;
        return n4;
    }

    public boolean wp() {
        boolean bl = this.dev ? this.dio.wp == 1 : this.readonly;
        return bl;
    }

    public int type() {
        if (this.dev && this.dio != null) {
            return this.dio.media_type;
        }
        if (this.raf != null) {
            return 100;
        }
        return 0;
    }

    public int dllExtract(String string, String string2) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        byte[] byArray = new byte[4096];
        D.println(1, "dllExtract trying " + string);
        if (classLoader.getResource(string) == null) {
            return -1;
        }
        D.println(1, "Extracting " + classLoader.getResource(string).toExternalForm() + " to " + string2);
        try {
            int n;
            InputStream inputStream = classLoader.getResourceAsStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            while ((n = inputStream.read(byArray, 0, 4096)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            D.println(0, "dllExtract: " + iOException);
            return -2;
        }
        return 0;
    }

    public int setup_DirectIO() {
        int n = 0;
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("java.io.tmpdir");
        String string3 = System.getProperty("os.name").toLowerCase();
        String string4 = System.getProperty("java.vm.name");
        String string5 = "unknown";
        if (string2 == null) {
            String string6 = string2 = string3.startsWith("windows") ? "C:\\TEMP" : "/tmp";
        }
        if (string3.startsWith("windows")) {
            if (string4.indexOf("64") != -1) {
                System.out.println("virt: Detected win 64bit jvm");
                string5 = "x86-win64";
            } else {
                System.out.println("virt: Detected win 32bit jvm");
                string5 = "x86-win32";
            }
            dllext = ".dll";
        } else if (string3.startsWith("linux")) {
            if (string4.indexOf("64") != -1) {
                System.out.println("virt: Detected 64bit linux jvm");
                string5 = "x86-linux-64";
            } else {
                System.out.println("virt: Detected 32bit linux jvm");
                string5 = "x86-linux-32";
            }
        }
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!string2.endsWith(string)) {
            string2 = string2 + string;
        }
        string2 = string2 + "cpqma-" + Integer.toHexString(virtdevs.UID) + dllext;
        System.out.println("Checking for " + string2);
        File file2 = new File(string2);
        if (file2.exists()) {
            System.out.println("DLL present");
            dio_setup = 0;
            return 0;
        }
        System.out.println("DLL not present");
        dio_setup = n = this.dllExtract("com/hp/ilo2/virtdevs/cpqma-" + string5, string2);
        return n;
    }

    public static void cleanup(virtdevs virtdevs2) {
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("java.io.tmpdir");
        String string3 = System.getProperty("os.name").toLowerCase();
        if (string2 == null) {
            string2 = string3.startsWith("windows") ? "C:\\TEMP" : "/tmp";
        }
        File file = new File(string2);
        String[] stringArray = file.list();
        String string4 = "";
        if (!string2.endsWith(string)) {
            string2 = string2 + string;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("cpqma-") && stringArray[n].endsWith(dllext)) {
                File file2 = new File(string2 + stringArray[n]);
                file2.delete();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].startsWith("HpqKbHook-") && stringArray[n2].endsWith(dllext)) {
                File file3 = new File(string2 + stringArray[n2]);
                file3.delete();
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].startsWith("jirc_strings") && stringArray[n3].endsWith("xml")) {
                File file4 = new File(string2 + stringArray[n3]);
                file4.delete();
            }
            ++n3;
        }
    }
}

