/*
 * Decompiled with CFR 0.152.
 */
package com.hp.ilo2.remcons;

import com.hp.ilo2.remcons.remcons;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.JPanel;

public class dvcwin
extends JPanel
implements Runnable {
    protected Image offscreen_image = null;
    protected Image first_image = null;
    protected Graphics offscreen_gc = null;
    protected MemoryImageSource image_source;
    protected int screen_x;
    protected int screen_y;
    protected int block_y;
    protected int block_x;
    protected ColorModel cm;
    protected Image clearScreenImage = null;
    protected Graphics clearScreenGc;
    public int[] pixel_buffer;
    public remcons remconsObj;
    protected Thread screen_updater = null;
    protected static final int REFRESH_RATE = 15;
    private int refresh_count = 0;
    private int need_to_refresh = 1;
    private int need_to_refresh_r = 1;
    private int need_to_refresh_w = 1;
    public boolean mirror = false;
    private int frametime = 0;
    private int paint_count = 0;
    protected boolean updater_running = false;
    private boolean abs_dimen_initialized = false;
    private boolean clear_screen = false;
    private boolean firstResize = true;

    public dvcwin(int n, int n2, remcons remcons2) {
        this.screen_x = n;
        this.screen_y = n2;
        this.cm = new DirectColorModel(32, 0xFF0000, 65280, 255, 0);
        this.set_framerate(0);
        this.remconsObj = remcons2;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void addNotify() {
        super.addNotify();
        if (this.offscreen_image == null) {
            if (this.screen_x == 0 && this.screen_y == 0) {
                this.screen_x = 1;
                this.screen_y = 1;
            }
            this.offscreen_image = this.createImage(this.screen_x, this.screen_y);
        }
    }

    public boolean repaint_it(int n) {
        boolean bl = false;
        if (n == 1) {
            ++this.need_to_refresh_w;
        } else {
            int n2 = this.need_to_refresh_w;
            if (this.need_to_refresh_r != n2) {
                this.need_to_refresh_r = n2;
                bl = true;
            }
        }
        return bl;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponents(graphics);
        if (graphics == null) {
            System.out.println("dvcwin.paint() g is null");
            return;
        }
        if (this.first_image != null) {
            graphics.drawImage(this.first_image, 0, 0, this);
            return;
        }
        if (this.clearScreenImage != null) {
            graphics.drawImage(this.clearScreenImage, 0, 0, this);
            return;
        }
        if (this.offscreen_image != null) {
            graphics.drawImage(this.offscreen_image, 0, 0, this);
            return;
        }
    }

    public void update(Graphics graphics) {
        if (this.offscreen_image == null || null == this.offscreen_gc) {
            this.offscreen_image = this.createImage(this.getSize().width, this.getSize().height);
            this.offscreen_gc = this.offscreen_image.getGraphics();
        }
        if (this.first_image != null) {
            if (null == this.offscreen_gc) {
                System.out.println("Message from offscreen_gc null detection");
            }
            this.offscreen_gc.drawImage(this.first_image, 0, 0, this);
        }
        graphics.drawImage(this.offscreen_image, 0, 0, this);
    }

    public void paste_array(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = 8 == n4 ? 8 : (n2 + 16 > this.screen_y ? this.screen_y - n2 : 16);
        int n6 = 0;
        while (n6 < n5) {
            try {
                System.arraycopy(nArray, n6 * 16, this.pixel_buffer, (n2 + n6) * this.screen_x + n, n3);
            }
            catch (Exception exception) {
                return;
            }
            ++n6;
        }
        this.image_source.newPixels(n, n2, n3, 16, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_abs_dimensions(int n, int n2) {
        if (n != this.screen_x || n2 != this.screen_y || !this.abs_dimen_initialized || this.clear_screen) {
            dvcwin dvcwin2 = this;
            synchronized (dvcwin2) {
                this.screen_x = n;
                this.screen_y = n2;
            }
            this.clear_screen = false;
            this.abs_dimen_initialized = true;
            this.offscreen_image = null;
            this.pixel_buffer = new int[this.screen_x * this.screen_y];
            this.image_source = new MemoryImageSource(this.screen_x, this.screen_y, this.cm, this.pixel_buffer, 0, this.screen_x);
            if (this.image_source != null) {
                // empty if block
            }
            this.image_source.setAnimated(true);
            this.image_source.setFullBufferUpdates(false);
            this.first_image = this.createImage(this.image_source);
            this.invalidate();
            this.validate();
            Container container = this.getParent();
            if (container != null) {
                while (container.getParent() != null) {
                    container.invalidate();
                    container = container.getParent();
                }
                container.invalidate();
                container.validate();
            }
            System.gc();
            if (this.firstResize) {
                this.firstResize = false;
                this.remconsObj.ParentApp.dispFrame.pack();
                this.remconsObj.ParentApp.dispFrame.setLocationRelativeTo(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Dimension dimension;
        dvcwin dvcwin2 = this;
        synchronized (dvcwin2) {
            dimension = new Dimension(this.screen_x, this.screen_y);
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void show_text(String string) {
        if (this.screen_updater == null) {
            System.out.println("Screen is no longer updating");
            return;
        }
        System.out.println("dvcwin:show_text " + string);
        if (this.screen_x != 640 || this.screen_y != 100) {
            this.set_abs_dimensions(640, 100);
            this.image_source = null;
            this.first_image = null;
            this.offscreen_image = null;
            this.offscreen_image = this.createImage(this.screen_x, this.screen_y);
        }
        if (this.offscreen_image != null) {
            Graphics graphics = this.offscreen_image.getGraphics();
            new Color(0);
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, this.screen_x, this.screen_y);
            Font font = new Font("Courier", 0, 20);
            new Color(0);
            graphics.setColor(Color.white);
            graphics.setFont(font);
            graphics.drawString(string, 10, 20);
            graphics.drawImage(this.offscreen_image, 0, 0, this);
            graphics.dispose();
            System.gc();
            super.repaint();
        }
    }

    public void set_framerate(int n) {
        this.frametime = n > 0 ? 1000 / n : 66;
    }

    public void run() {
        while (this.updater_running) {
            try {
                Thread.sleep(this.frametime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.repaint_it(0)) continue;
            super.repaint();
        }
        System.out.println("Updater finished running");
    }

    public synchronized void start_updates() {
        this.screen_updater = new Thread((Runnable)this, "dvcwin");
        this.updater_running = true;
        this.screen_updater.start();
        System.out.println("..screen update thread started..");
    }

    public synchronized void stop_updates() {
        System.out.println("dvcwin.stop_update");
        if (this.screen_updater != null && this.screen_updater.isAlive()) {
            this.updater_running = false;
        }
        this.screen_x = 0;
        this.screen_y = 0;
        this.screen_updater = null;
    }

    public void clearScreen() {
        if (this.screen_updater == null) {
            System.out.println("Screen is no longer updating");
            return;
        }
        this.clear_screen = true;
        if (this.screen_x == 0 && this.screen_y == 0) {
            System.out.println("clearScreen() EXCEPTION Screen_x = 0 Screen_y = 0");
            this.screen_x = 1;
            this.screen_y = 1;
        }
        this.set_abs_dimensions(this.screen_x, this.screen_y);
        this.offscreen_image = null;
        this.offscreen_image = this.createImage(this.screen_x, this.screen_y);
        Graphics graphics = this.offscreen_image.getGraphics();
        new Color(0);
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.screen_x, this.screen_y);
        graphics.drawImage(this.offscreen_image, 0, 0, this);
        graphics.dispose();
        System.gc();
        super.repaint();
    }
}

