/*
 * Decompiled with CFR 0.152.
 */
package com.hp.ilo2.remcons;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class ToolTip
extends JPanel
implements MouseListener {
    protected String tip;
    protected Component owner;
    private Container mainContainer;
    private LayoutManager mainLayout;
    private boolean shown;
    private final int VERTICAL_OFFSET = 10;
    private final int HORIZONTAL_ENLARGE = 10;

    public ToolTip(String string, Component component) {
        this.tip = string;
        this.owner = component;
        component.addMouseListener(this);
        this.setBackground(new Color(255, 255, 220));
    }

    public void paint(Graphics graphics) {
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        graphics.drawString(this.tip, 3, this.getSize().height - 3);
    }

    private void addToolTip() {
        this.mainContainer.setLayout(null);
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.owner.getFont());
        this.setSize(fontMetrics.stringWidth(this.tip) + 10, fontMetrics.getHeight());
        this.setLocation(this.owner.getLocationOnScreen().x - this.mainContainer.getLocationOnScreen().x, this.owner.getLocationOnScreen().y - this.mainContainer.getLocationOnScreen().y - 10);
        if (this.mainContainer.getSize().width < this.getLocation().x + this.getSize().width) {
            this.setLocation(this.mainContainer.getSize().width - (this.getSize().width + 10), this.getLocation().y - 10);
        }
        this.mainContainer.add((Component)this, 0);
        this.mainContainer.validate();
        this.repaint();
        this.shown = true;
    }

    private void removeToolTip() {
        if (this.shown) {
            this.mainContainer.remove(0);
            this.mainContainer.setLayout(this.mainLayout);
            this.mainContainer.validate();
        }
        this.shown = false;
    }

    private void findMainContainer() {
        Container container = this.owner.getParent();
        while (true) {
            if (container instanceof Applet || container instanceof Frame) break;
            container = container.getParent();
        }
        this.mainContainer = container;
        this.mainLayout = this.mainContainer.getLayout();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.findMainContainer();
        this.addToolTip();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.removeToolTip();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.removeToolTip();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

