/*
 * Decompiled with CFR 0.152.
 */
package com.hp.ilo2.remcons;

import com.hp.ilo2.remcons.TimerListener;
import java.util.Date;

class Timer
implements Runnable {
    private static final int STATE_INIT = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_PAUSED = 2;
    private static final int STATE_STOPPED = 3;
    private int state = 0;
    private static final int POLL_PERIOD = 50;
    private int timeout_count;
    private int timeout_max;
    private boolean one_shot;
    private long start_time_millis;
    private long stop_time_millis;
    private Date date = new Date();
    private TimerListener callback;
    private Object callback_info;
    private Object mutex;

    public Timer(int n, boolean bl, Object object) {
        this.timeout_max = n;
        this.one_shot = bl;
        this.mutex = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(TimerListener timerListener, Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            this.callback = timerListener;
            this.callback_info = object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.mutex;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    this.timeout_count = 0;
                    new Thread(this).start();
                    break;
                }
                case 1: {
                    this.timeout_count = 0;
                    break;
                }
                case 2: {
                    this.timeout_count = 0;
                    this.state = 1;
                    break;
                }
                case 3: {
                    this.timeout_count = 0;
                    this.state = 1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state != 0) {
                this.state = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == 1) {
                this.state = 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cont() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == 2) {
                this.state = 1;
            }
        }
    }

    public void run() {
        do {
            this.date = new Date();
            this.start_time_millis = this.date.getTime();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.date = new Date();
            this.stop_time_millis = this.date.getTime();
        } while (this.process_state());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean process_state() {
        boolean bl = true;
        Object object = this.mutex;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.timeout_count = this.stop_time_millis > this.start_time_millis ? (int)((long)this.timeout_count + (this.stop_time_millis - this.start_time_millis)) : (this.timeout_count += 50);
                    if (this.timeout_count < this.timeout_max) break;
                    if (this.callback != null) {
                        this.callback.timeout(this.callback_info);
                    }
                    if (this.one_shot) {
                        this.state = 0;
                        bl = false;
                        break;
                    }
                    this.timeout_count = 0;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.state = 0;
                    bl = false;
                }
            }
        }
        return bl;
    }
}

