/*
 * Decompiled with CFR 0.152.
 */
package com.hp.ilo2.remcons;

import com.hp.ilo2.remcons.MouseSyncListener;
import com.hp.ilo2.remcons.Timer;
import com.hp.ilo2.remcons.TimerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class MouseSync
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
TimerListener {
    private static final int CMD_START = 0;
    private static final int CMD_STOP = 1;
    private static final int CMD_SYNC = 2;
    private static final int CMD_SERVER_MOVE = 3;
    private static final int CMD_SERVER_SCREEN = 4;
    private static final int CMD_SERVER_DISABLE = 5;
    private static final int CMD_TIMEOUT = 6;
    private static final int CMD_CLICK = 7;
    private static final int CMD_ENTER = 8;
    private static final int CMD_EXIT = 9;
    private static final int CMD_PRESS = 10;
    private static final int CMD_RELEASE = 11;
    private static final int CMD_DRAG = 12;
    private static final int CMD_MOVE = 13;
    private static final int CMD_ALIGN = 14;
    private static final int STATE_INIT = 0;
    private static final int STATE_SYNC = 1;
    private static final int STATE_ENABLE = 2;
    private static final int STATE_DISABLE = 3;
    private int state;
    private MouseSyncListener listener;
    private int server_w;
    private int server_h;
    private int server_x;
    private int server_y;
    private int client_x;
    private int client_y;
    private int client_dx;
    private int client_dy;
    private int[] send_dx;
    private int[] send_dy;
    private int[] recv_dx;
    private int[] recv_dy;
    private int send_dx_index;
    private int send_dy_index;
    private static final int SYNC_SUCCESS_COUNT = 2;
    private static final int SYNC_FAIL_COUNT = 4;
    private int send_dx_count;
    private int send_dy_count;
    private int send_dx_success;
    private int send_dy_success;
    private boolean sync_successful;
    private static final int TIMEOUT_DELAY = 5;
    private static final int TIMEOUT_MOVE = 200;
    private static final int TIMEOUT_SYNC = 2000;
    private Timer timer;
    public static final int MOUSE_BUTTON_LEFT = 4;
    public static final int MOUSE_BUTTON_CENTER = 2;
    public static final int MOUSE_BUTTON_RIGHT = 1;
    private int pressed_button;
    private boolean dragging;
    private Object mutex;
    private boolean debug_msg = false;

    public MouseSync(Object object) {
        this.mutex = object;
        this.state = 0;
        this.state_machine(0, null, 0, 0);
    }

    public void setListener(MouseSyncListener mouseSyncListener) {
        this.listener = mouseSyncListener;
    }

    public void enableDebug() {
        this.debug_msg = true;
    }

    public void disableDebug() {
        this.debug_msg = false;
    }

    public void restart() {
        this.go_state(0);
    }

    public void align() {
        this.state_machine(14, null, 0, 0);
    }

    public void sync() {
        this.state_machine(2, null, 0, 0);
    }

    public void serverMoved(int n, int n2, int n3, int n4) {
        this.state_machine(3, null, n, n2);
    }

    public void serverScreen(int n, int n2) {
        this.state_machine(4, null, n, n2);
    }

    public void serverDisabled() {
        this.state_machine(5, null, 0, 0);
    }

    public void timeout(Object object) {
        this.state_machine(6, null, 0, 0);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.listener.requestScreenFocus(mouseEvent);
        this.listener.sendMouse(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.listener.installKeyboardHook();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.listener.unInstallKeyboardHook();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.listener.sendMouse(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.listener.sendMouse(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.listener.sendMouse(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.listener.sendMouse(mouseEvent);
    }

    private void move_delay() {
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void sync_default() {
        int[] nArray = new int[]{1, 4, 6, 8, 12, 16, 32, 64};
        this.send_dx = new int[nArray.length];
        this.send_dy = new int[nArray.length];
        this.recv_dx = new int[nArray.length];
        this.recv_dy = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            this.send_dx[n] = nArray[n];
            this.send_dy[n] = nArray[n];
            this.recv_dx[n] = nArray[n];
            this.recv_dy[n] = nArray[n];
            ++n;
        }
        this.send_dx_index = 0;
        this.send_dy_index = 0;
        this.send_dx_count = 0;
        this.send_dy_count = 0;
        this.send_dx_success = 0;
        this.send_dy_success = 0;
        this.sync_successful = false;
    }

    private void sync_continue() {
        int n = 1;
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        if (this.server_x > this.server_w / 2) {
            n = -1;
        }
        if (this.server_y < this.server_h / 2) {
            n2 = -1;
        }
        if (this.send_dx_index >= 0) {
            n3 = n * this.send_dx[this.send_dx_index];
        }
        if (this.send_dy_index >= 0) {
            n4 = n2 * this.send_dy[this.send_dy_index];
        }
        this.listener.serverMove(n3, n4, this.client_x, this.client_y);
        this.timer.start();
    }

    private void sync_update(int n, int n2) {
        this.timer.pause();
        int n3 = n - this.server_x;
        int n4 = this.server_y - n2;
        this.server_x = n;
        this.server_y = n2;
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n4 < 0) {
            n4 = -n4;
        }
        if (this.send_dx_index >= 0) {
            if (this.recv_dx[this.send_dx_index] == n3) {
                ++this.send_dx_success;
            }
            this.recv_dx[this.send_dx_index] = n3;
            ++this.send_dx_count;
            if (this.send_dx_success >= 2) {
                --this.send_dx_index;
                this.send_dx_success = 0;
                this.send_dx_count = 0;
            } else if (this.send_dx_count >= 4) {
                if (this.debug_msg) {
                    System.out.println("no x sync:" + this.send_dx[this.send_dx_index]);
                }
                this.go_state(2);
                return;
            }
        }
        if (this.send_dy_index >= 0) {
            if (this.recv_dy[this.send_dy_index] == n4) {
                ++this.send_dy_success;
            }
            this.recv_dy[this.send_dy_index] = n4;
            ++this.send_dy_count;
            if (this.send_dy_success >= 2) {
                --this.send_dy_index;
                this.send_dy_success = 0;
                this.send_dy_count = 0;
            } else if (this.send_dy_count >= 4) {
                if (this.debug_msg) {
                    System.out.println("no y sync:" + this.send_dy[this.send_dy_index]);
                }
                this.go_state(2);
                return;
            }
        }
        if (this.send_dx_index < 0 && this.send_dy_index < 0) {
            int n5 = this.send_dx.length - 1;
            while (n5 >= 0) {
                if (this.recv_dx[n5] == 0 || this.recv_dy[n5] == 0) {
                    if (this.debug_msg) {
                        // empty if block
                    }
                    this.go_state(2);
                    return;
                }
                if (n5 != 0 && (this.recv_dx[n5] < this.recv_dx[n5 - 1] || this.recv_dy[n5] < this.recv_dy[n5 - 1])) {
                    if (this.debug_msg) {
                        // empty if block
                    }
                    this.go_state(2);
                    return;
                }
                --n5;
            }
            this.sync_successful = true;
            this.send_dx_index = 0;
            this.send_dy_index = 0;
            this.go_state(2);
        } else {
            this.sync_continue();
        }
    }

    private void init_vars() {
        this.server_w = 640;
        this.server_h = 480;
        this.server_x = 0;
        this.server_y = 0;
        this.client_x = 0;
        this.client_y = 0;
        this.client_dx = 0;
        this.client_dy = 0;
        this.pressed_button = 0;
        this.dragging = false;
        this.sync_default();
    }

    private void move_server(boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.timer.pause();
        int n7 = this.client_dx;
        int n8 = this.client_dy;
        if (n7 >= 0) {
            n2 = 1;
        } else {
            n2 = -1;
            n7 = -n7;
        }
        if (n8 >= 0) {
            n = 1;
        } else {
            n = -1;
            n8 = -n8;
        }
        do {
            int n9;
            if (n7 != 0) {
                n9 = this.send_dx.length - 1;
                while (n9 >= this.send_dx_index) {
                    if (this.recv_dx[n9] <= n7) {
                        n3 = n2 * this.send_dx[n9];
                        n5 += this.recv_dx[n9];
                        n7 -= this.recv_dx[n9];
                        break;
                    }
                    --n9;
                }
                if (n9 < this.send_dx_index) {
                    n3 = 0;
                    n5 += n7;
                    n7 = 0;
                }
            } else {
                n3 = 0;
            }
            if (n8 != 0) {
                n9 = this.send_dy.length - 1;
                while (n9 >= this.send_dy_index) {
                    if (this.recv_dy[n9] <= n8) {
                        n4 = n * this.send_dy[n9];
                        n6 += this.recv_dy[n9];
                        n8 -= this.recv_dy[n9];
                        break;
                    }
                    --n9;
                }
                if (n9 < this.send_dy_index) {
                    n4 = 0;
                    n6 += n8;
                    n8 = 0;
                }
            } else {
                n4 = 0;
            }
            if (n3 == 0 && n4 == 0) continue;
            this.listener.serverMove(n3, n4, this.client_x, this.client_y);
        } while (bl && (n7 != 0 || n8 != 0));
        this.client_dx -= n2 * n5;
        this.client_dy -= n * n6;
        if (!bl2) {
            this.server_x += n2 * n5;
            this.server_y -= n * n6;
            if (this.debug_msg) {
                // empty if block
            }
        }
        if (this.client_dx != 0 || this.client_dy != 0) {
            this.timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void go_state(int n) {
        Object object = this.mutex;
        synchronized (object) {
            this.state_machine(1, null, 0, 0);
            this.state = n;
            this.state_machine(0, null, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void state_machine(int n, MouseEvent mouseEvent, int n2, int n3) {
        Object object = this.mutex;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    this.state_init(n, mouseEvent, n2, n3);
                    break;
                }
                case 1: {
                    this.state_sync(n, mouseEvent, n2, n3);
                    break;
                }
                case 2: {
                    this.state_enable(n, mouseEvent, n2, n3);
                    break;
                }
                case 3: {
                    this.state_disable(n, mouseEvent, n2, n3);
                }
            }
        }
    }

    private void state_init(int n, MouseEvent mouseEvent, int n2, int n3) {
        switch (n) {
            case 0: {
                this.init_vars();
                this.go_state(3);
                break;
            }
        }
    }

    private void state_sync(int n, MouseEvent mouseEvent, int n2, int n3) {
        switch (n) {
            case 0: {
                this.timer = new Timer(2000, false, this.mutex);
                this.timer.setListener(this, null);
                this.sync_default();
                this.send_dx_index = this.send_dx.length - 1;
                this.send_dy_index = this.send_dy.length - 1;
                this.sync_continue();
                break;
            }
            case 1: {
                this.timer.stop();
                this.timer = null;
                if (!this.sync_successful) {
                    if (this.debug_msg) {
                        System.out.println("fail");
                    }
                    this.sync_default();
                } else if (this.debug_msg) {
                    // empty if block
                }
                if (!this.debug_msg) break;
                int n4 = 0;
                while (n4 < this.send_dx.length) {
                    ++n4;
                }
                n4 = 0;
                while (n4 < this.send_dx.length) {
                    ++n4;
                }
                break;
            }
            case 2: {
                this.go_state(1);
                break;
            }
            case 3: {
                if (n2 > 2000 || n3 > 2000) {
                    this.go_state(3);
                    break;
                }
                this.sync_update(n2, n3);
                break;
            }
            case 4: {
                this.server_w = n2;
                this.server_h = n3;
                break;
            }
            case 5: {
                this.go_state(3);
                break;
            }
            case 6: {
                this.go_state(2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                this.client_x = mouseEvent.getX();
                this.client_y = mouseEvent.getY();
                break;
            }
        }
    }

    private void state_enable(int n, MouseEvent mouseEvent, int n2, int n3) {
        switch (n) {
            case 0: {
                if (this.debug_msg) {
                    // empty if block
                }
                this.timer = new Timer(200, false, this.mutex);
                this.timer.setListener(this, null);
                break;
            }
            case 1: {
                this.timer.stop();
                this.timer = null;
                break;
            }
            case 2: {
                this.go_state(1);
                break;
            }
            case 3: {
                if (this.debug_msg) {
                    // empty if block
                }
                if (n2 > 2000 || n3 > 2000) {
                    this.go_state(3);
                    break;
                }
                this.server_x = n2;
                this.server_y = n3;
                break;
            }
            case 4: {
                this.server_w = n2;
                this.server_h = n3;
                break;
            }
            case 5: {
                this.go_state(3);
                break;
            }
            case 14: {
                this.client_dx = this.client_x - this.server_x;
                this.client_dy = this.server_y - this.client_y;
                this.move_server(true, true);
                break;
            }
            case 6: {
                this.move_server(true, true);
                break;
            }
            case 8: 
            case 9: {
                this.client_x = mouseEvent.getX();
                this.client_y = mouseEvent.getY();
                if (this.client_x < 0) {
                    this.client_x = 0;
                }
                if (this.client_x > this.server_w) {
                    this.client_x = this.server_w;
                }
                if (this.client_y < 0) {
                    this.client_y = 0;
                }
                if (this.client_y > this.server_h) {
                    this.client_y = this.server_h;
                }
                if (this.debug_msg) {
                    // empty if block
                }
                if (this.pressed_button == 1) break;
                if ((mouseEvent.getModifiers() & 2) != 0) break;
                this.align();
                break;
            }
            case 12: {
                if (this.pressed_button != 1) {
                    if (this.pressed_button > 0) {
                        this.pressed_button = -this.pressed_button;
                        this.listener.serverPress(this.pressed_button);
                    }
                    this.client_dx += mouseEvent.getX() - this.client_x;
                    this.client_dy += this.client_y - mouseEvent.getY();
                    this.move_server(false, true);
                }
                this.client_x = mouseEvent.getX();
                this.client_y = mouseEvent.getY();
                if (this.debug_msg) {
                    // empty if block
                }
                this.dragging = true;
                break;
            }
            case 13: {
                if ((mouseEvent.getModifiers() & 2) == 0) {
                    this.client_dx += mouseEvent.getX() - this.client_x;
                    this.client_dy += this.client_y - mouseEvent.getY();
                    this.move_server(false, true);
                }
                this.client_x = mouseEvent.getX();
                this.client_y = mouseEvent.getY();
                if (!this.debug_msg) break;
                break;
            }
            case 10: {
                if (this.pressed_button != 0) break;
                this.pressed_button = (mouseEvent.getModifiers() & 4) != 0 ? 1 : ((mouseEvent.getModifiers() & 8) != 0 ? 2 : 4);
                this.dragging = false;
                break;
            }
            case 11: {
                if (this.pressed_button == -4) {
                    this.listener.serverRelease(4);
                } else if (this.pressed_button == -2) {
                    this.listener.serverRelease(2);
                } else if (this.pressed_button == -1) {
                    this.listener.serverRelease(1);
                }
                this.pressed_button = 0;
                break;
            }
            case 7: {
                if (this.dragging) break;
                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                    this.listener.serverClick(4, 1);
                    break;
                }
                if ((mouseEvent.getModifiers() & 8) != 0) {
                    this.listener.serverClick(2, 1);
                    break;
                }
                if ((mouseEvent.getModifiers() & 4) == 0) break;
                this.listener.serverClick(1, 1);
            }
        }
    }

    private void state_disable(int n, MouseEvent mouseEvent, int n2, int n3) {
        switch (n) {
            case 0: {
                if (this.debug_msg) {
                    // empty if block
                }
                this.timer = new Timer(200, false, this.mutex);
                this.timer.setListener(this, null);
                break;
            }
            case 1: {
                this.timer.stop();
                this.timer = null;
                break;
            }
            case 2: {
                this.sync_default();
                break;
            }
            case 3: {
                if (this.debug_msg) {
                    // empty if block
                }
                if (n2 >= 2000 || n3 >= 2000) break;
                this.server_x = n2;
                this.server_y = n3;
                this.go_state(2);
                break;
            }
            case 4: {
                this.server_w = n2;
                this.server_h = n3;
                break;
            }
            case 5: {
                break;
            }
            case 14: {
                this.client_dx = this.client_x - this.server_x;
                this.client_dy = this.server_y - this.client_y;
                this.move_server(true, false);
                break;
            }
            case 6: {
                this.move_server(true, false);
                break;
            }
            case 8: 
            case 9: {
                this.client_x = mouseEvent.getX();
                this.client_y = mouseEvent.getY();
                if (this.client_x < 0) {
                    this.client_x = 0;
                }
                if (this.client_x > this.server_w) {
                    this.client_x = this.server_w;
                }
                if (this.client_y < 0) {
                    this.client_y = 0;
                }
                if (this.client_y > this.server_h) {
                    this.client_y = this.server_h;
                }
                if (this.debug_msg) {
                    // empty if block
                }
                if (this.pressed_button == 1) break;
                if ((mouseEvent.getModifiers() & 2) != 0) break;
                this.align();
                break;
            }
            case 12: {
                if (this.pressed_button != 1) {
                    if (this.pressed_button > 0) {
                        this.pressed_button = -this.pressed_button;
                        this.listener.serverPress(this.pressed_button);
                    }
                    this.client_dx += mouseEvent.getX() - this.client_x;
                    this.client_dy += this.client_y - mouseEvent.getY();
                    this.move_server(false, false);
                } else {
                    this.server_x = mouseEvent.getX();
                    this.server_y = mouseEvent.getY();
                }
                this.client_x = mouseEvent.getX();
                this.client_y = mouseEvent.getY();
                if (this.debug_msg) {
                    // empty if block
                }
                this.dragging = true;
                break;
            }
            case 13: {
                if ((mouseEvent.getModifiers() & 2) == 0) {
                    this.client_dx += mouseEvent.getX() - this.client_x;
                    this.client_dy += this.client_y - mouseEvent.getY();
                    this.move_server(false, false);
                } else {
                    this.server_x = mouseEvent.getX();
                    this.server_y = mouseEvent.getY();
                }
                this.client_x = mouseEvent.getX();
                this.client_y = mouseEvent.getY();
                if (!this.debug_msg) break;
                break;
            }
            case 10: {
                if (this.pressed_button != 0) break;
                this.pressed_button = (mouseEvent.getModifiers() & 4) != 0 ? 1 : ((mouseEvent.getModifiers() & 8) != 0 ? 2 : 4);
                this.dragging = false;
                break;
            }
            case 11: {
                if (this.pressed_button == -4) {
                    this.listener.serverRelease(4);
                } else if (this.pressed_button == -2) {
                    this.listener.serverRelease(2);
                } else if (this.pressed_button == -1) {
                    this.listener.serverRelease(1);
                }
                this.pressed_button = 0;
                break;
            }
            case 7: {
                if (this.dragging) break;
                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                    this.listener.serverClick(4, 1);
                    break;
                }
                if ((mouseEvent.getModifiers() & 8) != 0) {
                    this.listener.serverClick(2, 1);
                    break;
                }
                if ((mouseEvent.getModifiers() & 4) == 0) break;
                this.listener.serverClick(1, 1);
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
    }
}

