/*
 * Decompiled with CFR 0.152.
 */
package com.hp.ilo2.remcons;

import com.hp.ilo2.remcons.remcons;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

class LocaleTranslator {
    Hashtable locales = new Hashtable();
    Hashtable aliases = new Hashtable();
    Hashtable selected;
    Hashtable reverse_alias = new Hashtable();
    public boolean showgui = false;
    public boolean windows = true;
    String selected_name;
    String euro1 = " \u20ac\u001b[+4";
    String euro2 = " \u20ac\u001b[+e";
    String belgian = "\u0001\u0011 \u0011\u0001 \u0017\u001a \u001a\u0017 !8 \"3 #\u001b[+3 $] %\" &1 '4 (5 )- *} +? ,m -= .< /> 0) 1! 2@ 3# 4$ 5% 6^ 7& 8* 9( :. ;, <\u00f0 =/ >\u00f1 ?M @\u001b[+2 AQ M: QA WZ ZW [\u001b[+[ \\\u001b[+\u00f0 ]\u001b[+] ^[\u00a0 _+ `\u001b[+\\\u00a0 aq m; qa wz zw {\u001b[+9 |\u001b[+1 }\u001b[+0 ~\u001b[+/\u00a0 \u00a3| \u00a76 \u00a8{\u00a0 \u00b0_ \u00b2` \u00b3~ \u00b4\u001b[+'\u00a0 \u00b5\\ \u00c0\u001b[+\\Q \u00c1\u001b[+'Q \u00c2[Q \u00c3\u001b[+/Q \u00c4{Q \u00c8\u001b[+\\E \u00c9\u001b[+'E \u00ca[E \u00cb{E \u00cc\u001b[+\\I \u00cd\u001b[+'I \u00ce[I \u00cf{I \u00d1\u001b[+/N \u00d2\u001b[+\\O \u00d3\u001b[+'O \u00d4[O \u00d5\u001b[+/O \u00d6{O \u00d9\u001b[+\\U \u00da\u001b[+'U \u00db[U \u00dc{U \u00dd\u001b[+'Y \u00e0\u001b[+\\q \u00e1\u001b[+'q \u00e2[q \u00e3\u001b[+/q \u00e4{q \u00e79 \u00e8\u001b[+\\e \u00e9\u001b[+'e \u00ea[e \u00eb{e \u00ec\u001b[+\\i \u00ed\u001b[+'i \u00ee[i \u00ef{i \u00f1\u001b[+/n \u00f2\u001b[+\\o \u00f3\u001b[+'o \u00f4[o \u00f5\u001b[+/o \u00f6{o \u00f9\u001b[+\\u \u00fa\u001b[+'u \u00fb[u \u00fc{u \u00fd\u001b[+'y \u00ff{y";
    String british = "\"@ #\\ @\" \\\u00f0 |\u00f1 ~| \u00a3# \u00a6\u001b[+` \u00ac~ \u00c1\u001b[+A \u00e1\u001b[+a \u00c9\u001b[+E \u00e9\u001b[+e \u00cd\u001b[+I \u00ed\u001b[+i \u00d3\u001b[+O \u00f3\u001b[+o \u00da\u001b[+U \u00fa\u001b[+u";
    String danish = "\"@ $\u001b[+4 &^ '\\ (* )( *| +- -/ /& :> ;< <\u00f0 =) >\u00f1 ?_ @\u001b[+2 [\u001b[+8 \\\u001b[+\u00f0 ]\u001b[+9 ^}\u00a0 _? `+\u00a0 {\u001b[+7 |\u001b[+= }\u001b[+0 ~\u001b[+]\u00a0 \u00a3\u001b[+3 \u00a4$ \u00a7~ \u00a8]\u00a0 \u00b4=\u00a0 \u00bd` \u00c0+A \u00c1=A \u00c2}A \u00c3\u001b[+]A \u00c4]A \u00c5{ \u00c6: \u00c8+E \u00c9=E \u00ca}E \u00cb]E \u00cc+I \u00cd=I \u00ce}I \u00cf]I \u00d1\u001b[+]N \u00d2+O \u00d3=O \u00d4}O \u00d5\u001b[+]O \u00d6]O \u00d8\" \u00d9+U \u00da=U \u00db}U \u00dc]U \u00dd=Y \u00e0+a \u00e1=a \u00e2}a \u00e3\u001b[+]a \u00e4]a \u00e5[ \u00e6; \u00e8+e \u00e9=e \u00ea}e \u00eb]e \u00ec+i \u00ed=i \u00ee}i \u00ef]i \u00f1\u001b[+]n \u00f2+o \u00f3=o \u00f4}o \u00f5\u001b[+]o \u00f6]o \u00f8' \u00f9+u \u00fa=u \u00fb}u \u00fc]u \u00fd=y \u00ff]y";
    String finnish = "\"@ $\u001b[+4 &^ '\\ (* )( *| +- -/ /& :> ;< <\u00f0 =) >\u00f1 ?_ @\u001b[+2 [\u001b[+8 \\\u001b[+- ]\u001b[+9 ^}\u00a0 _? `+\u00a0 {\u001b[+7 |\u001b[+\u00f0 }\u001b[+0 ~\u001b[+]\u00a0 \u00a3\u001b[+3 \u00a4$ \u00a7` \u00a8]\u00a0 \u00b4=\u00a0 \u00bd~ \u00c0+A \u00c1=A \u00c2}A \u00c3\u001b[+]A \u00c4]A \u00c5{ \u00c8+E \u00c9=E \u00ca}E \u00cb]E \u00cc+I \u00cd=I \u00ce}I \u00cf]I \u00d1\u001b[+]N \u00d2+O \u00d3=O \u00d4}O \u00d5\u001b[+]O \u00d6]O \u00d9+U \u00da=U \u00db}U \u00dc]U \u00dd=Y \u00e0+a \u00e1=a \u00e2}a \u00e3\u001b[+]a \u00e4]a \u00e5[ \u00e8+e \u00e9=e \u00ea}e \u00eb]e \u00ec+i \u00ed=i \u00ee}i \u00ef]i \u00f1\u001b[+]n \u00f2+o \u00f3=o \u00f4}o \u00f5\u001b[+]o \u00f6]o \u00f9+u \u00fa=u \u00fb}u \u00fc]u \u00fd=y \u00ff]y";
    String french = "\u0001\u0011 \u0011\u0001 \u0017\u001a \u001a\u0017 !/ \"3 #\u001b[+3 $] %\" &1 '4 (5 )- *\\ ,m -6 .< /> 0) 1! 2@ 3# 4$ 5% 6^ 7& 8* 9( :. ;, <\u00f0 >\u00f1 ?M @\u001b[+0 AQ M: QA WZ ZW [\u001b[+5 \\\u001b[+8 ]\u001b[+- ^\u001b[+9 _8 `\u001b[+7 aq m; qa wz zw {\u001b[+4 |\u001b[+6 }\u001b[+= ~\u001b[+2 \u00a3} \u00a4\u001b[+] \u00a7? \u00a8{\u00a0 \u00b0_ \u00b2` \u00b5| \u00c2[Q \u00c4{Q \u00ca[E \u00cb{E \u00ce[I \u00cf{I \u00d4[O \u00d6{O \u00db[U \u00dc{U \u00e00 \u00e2[q \u00e4{q \u00e79 \u00e87 \u00e92 \u00ea[e \u00eb{e \u00ee[i \u00ef{i \u00f4[o \u00f6{o \u00f9' \u00fb[u \u00fc{u \u00ff{y";
    String french_canadian = "\"@ #` '< /# <\\ >| ?^ @\u001b[+2 [\u001b[+[ \\\u001b[+` ]\u001b[+] ^[\u00a0 `'\u00a0 {\u001b[+' |~ }\u001b[+\\ ~\u001b[+; \u00a2\u001b[+4 \u00a3\u001b[+3 \u00a4\u001b[+5 \u00a6\u001b[+7 \u00a7\u001b[+o \u00a8}\u00a0 \u00ab\u00f0 \u00ac\u001b[+6 \u00ad\u001b[+. \u00af\u001b[+, \u00b0\u001b[+\u00f0 \u00b1\u001b[+1 \u00b2\u001b[+8 \u00b3\u001b[+9 \u00b4\u001b[+/\u00a0 \u00b5\u001b[+m \u00b6\u001b[+p \u00b8]\u00a0 \u00bb\u00f1 \u00bc\u001b[+0 \u00bd\u001b[+- \u00be\u001b[+= \u00c0'A \u00c1\u001b[+/A \u00c2[A \u00c4}A \u00c7]C \u00c8'E \u00c9? \u00ca[E \u00cb}E \u00cc'I \u00cd\u001b[+/I \u00ce[I \u00cf}I \u00d2'O \u00d3\u001b[+/O \u00d4[O \u00d6}O \u00d9'U \u00da\u001b[+/U \u00db[U \u00dc}U \u00dd\u001b[+/Y \u00e0'a \u00e1\u001b[+/a \u00e2[a \u00e4}a \u00e7]c \u00e8'e \u00e9\u001b[+/e \u00ea[e \u00eb}e \u00ec'i \u00ed\u001b[+/i \u00ee[i \u00ef}i \u00f2'o \u00f3\u001b[+/o \u00f4[o \u00f6}o \u00f9'u \u00fa\u001b[+/u \u00fb[u \u00fc}u \u00fd\u001b[+/y \u00ff}y";
    String german = "\u0019\u001a \u001a\u0019 \"@ #\\ &^ '| (* )( *} +] -/ /& :> ;< <\u00f0 =) >\u00f1 ?_ @\u001b[+q YZ ZY [\u001b[+8 \\\u001b[+- ]\u001b[+9 ^`\u00a0 _? `+\u00a0 yz zy {\u001b[+7 |\u001b[+\u00f0 }\u001b[+0 ~\u001b[+] \u00a7# \u00b0~ \u00b2\u001b[+2 \u00b3\u001b[+3 \u00b4=\u00a0 \u00b5\u001b[+m \u00c0+A \u00c1=A \u00c2`A \u00c4\" \u00c8+E \u00c9=E \u00ca`E \u00cc+I \u00cd=I \u00ce`I \u00d2+O \u00d3=O \u00d4`O \u00d6: \u00d9+U \u00da=U \u00db`U \u00dc{ \u00dd=Z \u00df- \u00e0+a \u00e1=a \u00e2`a \u00e4' \u00e8+e \u00e9=e \u00ea`e \u00ec+i \u00ed=i \u00ee`i \u00f2+o \u00f3=o \u00f4`o \u00f6; \u00f9+u \u00fa=u \u00fb`u \u00fc[ \u00fd=z";
    String italian = "\"@ #\u001b[+' &^ '- (* )( *} +] -/ /& :> ;< <\u00f0 =) >\u00f1 ?_ @\u001b[+; [\u001b[+[ \\` ]\u001b[+] ^+ _? |~ \u00a3# \u00a7| \u00b0\" \u00e0' \u00e7: \u00e8[ \u00e9{ \u00ec= \u00f2; \u00f9\\";
    String japanese = "\"@ &^ '& (* )( *\" +: :' =_ @[ [] \\\u00f2 ]\\ ^= _\u00f3 `{ {} \u00a5\u00f4 |\u00f5 }| ~+";
    String latin_american = "\"@ &^ '- (* )( *} +] -/ /& :> ;< <\u00f0 =) >\u00f1 ?_ @\u001b[+q [\" \\\u001b[+- ]| ^\u001b[+'\u00a0 _? `\u001b[+\\\u00a0 {' |` }\\ ~\u001b[+] \u00a1+ \u00a8{\u00a0 \u00ac\u001b[+` \u00b0~ \u00b4[\u00a0 \u00bf= \u00c0\u001b[+\\A \u00c1[A \u00c2\u001b[+'A \u00c4{A \u00c8\u001b[+\\E \u00c9[E \u00ca\u001b[+'E \u00cb{E \u00cc\u001b[+\\I \u00cd[I \u00ce\u001b[+'I \u00cf{I \u00d1: \u00d2\u001b[+\\O \u00d3[O \u00d4\u001b[+'O \u00d6{O \u00d9\u001b[+\\U \u00da[U \u00db\u001b[+'U \u00dc{U \u00dd[Y \u00e0\u001b[+\\a \u00e1[a \u00e2\u001b[+'a \u00e4{a \u00e8\u001b[+\\e \u00e9[e \u00ea\u001b[+'e \u00eb{e \u00ec\u001b[+\\i \u00ed[i \u00ee\u001b[+'i \u00ef{i \u00f1; \u00f2\u001b[+\\o \u00f3[o \u00f4\u001b[+'o \u00f6{o \u00f9\u001b[+\\u \u00fa[u \u00fb\u001b[+'u \u00fc{u \u00fd[y \u00ff{y";
    String norwegian = "\"@ $\u001b[+4 &^ '\\ (* )( *| +- -/ /& :> ;< <\u00f0 =) >\u00f1 ?_ @\u001b[+2 [\u001b[+8 \\= ]\u001b[+9 ^}\u00a0 _? `+\u00a0 {\u001b[+7 |` }\u001b[+0 ~\u001b[+]\u00a0 \u00a3\u001b[+3 \u00a4$ \u00a7~ \u00a8]\u00a0 \u00b4\u001b[+=\u00a0 \u00c0+A \u00c1\u001b[+=A \u00c2}A \u00c3\u001b[+]A \u00c4]A \u00c5{ \u00c6\" \u00c8+E \u00c9\u001b[+=E \u00ca}E \u00cb]E \u00cc+I \u00cd\u001b[+=I \u00ce}I \u00cf]I \u00d1\u001b[+]N \u00d2+O \u00d3\u001b[+=O \u00d4}O \u00d5\u001b[+]O \u00d6]O \u00d8: \u00d9+U \u00da\u001b[+=U \u00db}U \u00dc]U \u00dd\u001b[+=Y \u00e0+a \u00e1\u001b[+=a \u00e2}a \u00e3\u001b[+]a \u00e4]a \u00e5[ \u00e6' \u00e8+e \u00e9\u001b[+=e \u00ea}e \u00eb]e \u00ec+i \u00ed\u001b[+=i \u00ee}i \u00ef]i \u00f1\u001b[+]n \u00f2+o \u00f3\u001b[+=o \u00f4}o \u00f5\u001b[+]o \u00f6]o \u00f8; \u00f9+u \u00fa\u001b[+=u \u00fb}u \u00fc]u \u00fd\u001b[+=y \u00ff]y";
    String portuguese = "\"@ &^ '- (* )( *{ +[ -/ /& :> ;< <\u00f0 =) >\u00f1 ?_ @\u001b[+2 [\u001b[+8 \\` ]\u001b[+9 ^|\u00a0 _? `}\u00a0 {\u001b[+7 |~ }\u001b[+0 ~\\\u00a0 \u00a3\u001b[+3 \u00a7\u001b[+4 \u00a8\u001b[+[\u00a0 \u00aa\" \u00ab= \u00b4]\u00a0 \u00ba' \u00bb+ \u00c0}A \u00c1]A \u00c2|A \u00c3\\A \u00c4\u001b[+[A \u00c7: \u00c8}E \u00c9]E \u00ca|E \u00cb\u001b[+[E \u00cc}I \u00cd]I \u00ce|I \u00cf\u001b[+[I \u00d1\\N \u00d2}O \u00d3]O \u00d4|O \u00d5\\O \u00d6\u001b[+[O \u00d9}U \u00da]U \u00db|U \u00dc\u001b[+[U \u00dd]Y \u00e0}a \u00e1]a \u00e2|a \u00e3\\a \u00e4\u001b[+[a \u00e7; \u00e8}e \u00e9]e \u00ea|e \u00eb\u001b[+[e \u00ec}i \u00ed]i \u00ee|i \u00ef\u001b[+[i \u00f1\\n \u00f2}o \u00f3]o \u00f4|o \u00f5\\o \u00f6\u001b[+[o \u00f9}u \u00fa]u \u00fb|u \u00fc\u001b[+[u \u00fd]y \u00ff\u001b[+[y";
    String spanish = "\"@ #\u001b[+3 &^ '- (* )( *} +] -/ /& :> ;< <\u00f0 =) >\u00f1 ?_ @\u001b[+2 [\u001b[+[ \\\u001b[+` ]\u001b[+] ^{\u00a0 _? `[\u00a0 {\u001b[+' |\u001b[+1 }\u001b[+\\ \u00a1= \u00a8\"\u00a0 \u00aa~ \u00ac\u001b[+6 \u00b4'\u00a0 \u00b7# \u00ba` \u00bf+ \u00c0[A \u00c1'A \u00c2{A \u00c4\"A \u00c7| \u00c8[E \u00c9'E \u00ca{E \u00cb\"E \u00cc[I \u00cd'I \u00ce{I \u00cf\"I \u00d1: \u00d2[O \u00d3'O \u00d4{O \u00d6\"O \u00d9[U \u00da'U \u00db{U \u00dc\"U \u00dd'Y \u00e0[a \u00e1'a \u00e2{a \u00e4\"a \u00e7\\ \u00e8[e \u00e9'e \u00ea{e \u00eb\"e \u00ec[i \u00ed'i \u00ee{i \u00ef\"i \u00f1; \u00f2[o \u00f3'o \u00f4{o \u00f6\"o \u00f9[u \u00fa'u \u00fb{u \u00fc\"u \u00fd'y \u00ff\"y";
    String swedish = "\"@ $\u001b[+4 &^ '\\ (* )( *| +- -/ /& :> ;< <\u00f0 =) >\u00f1 ?_ @\u001b[+2 [\u001b[+8 \\\u001b[+- ]\u001b[+9 ^}\u00a0 _? `+\u00a0 {\u001b[+7 |\u001b[+\u00f0 }\u001b[+0 ~\u001b[+]\u00a0 \u00a3\u001b[+3 \u00a4$ \u00a7` \u00a8]\u00a0 \u00b4=\u00a0 \u00bd~ \u00c0+A \u00c1=A \u00c2}A \u00c3\u001b[+]A \u00c4]A \u00c5{ \u00c8+E \u00c9=E \u00ca}E \u00cb]E \u00cc+I \u00cd=I \u00ce}I \u00cf]I \u00d1\u001b[+]N \u00d2+O \u00d3=O \u00d4}O \u00d5\u001b[+]O \u00d6]O \u00d9+U \u00da=U \u00db}U \u00dc]U \u00dd=Y \u00e0+a \u00e1=a \u00e2}a \u00e3\u001b[+]a \u00e4]a \u00e5[ \u00e8+e \u00e9=e \u00ea}e \u00eb]e \u00ec+i \u00ed=i \u00ee}i \u00ef]i \u00f1\u001b[+]n \u00f2+o \u00f3=o \u00f4}o \u00f5\u001b[+]o \u00f6]o \u00f9+u \u00fa=u \u00fb}u \u00fc]u \u00fd=y \u00ff]y";
    String swiss_french = "\u0019\u001a \u001a\u0019 !} \"@ #\u001b[+3 $\\ &^ '- (* )( *# +! -/ /& :> ;< <\u00f0 =) >\u00f1 ?_ @\u001b[+2 YZ ZY [\u001b[+[ \\\u001b[+\u00f0 ]\u001b[+] ^=\u00a0 _? `+\u00a0 yz zy {\u001b[+' |\u001b[+7 }\u001b[+\\ ~\u001b[+=\u00a0 \u00a2\u001b[+8 \u00a3| \u00a6\u001b[+1 \u00a7` \u00a8]\u00a0 \u00ac\u001b[+6 \u00b0~ \u00b4\u001b[+-\u00a0 \u00c0+A \u00c1\u001b[+-A \u00c2=A \u00c3\u001b[+=A \u00c4]A \u00c8+E \u00c9\u001b[+-E \u00ca=E \u00cb]E \u00cc+I \u00cd\u001b[+-I \u00ce=I \u00cf]I \u00d1\u001b[+=N \u00d2+O \u00d3\u001b[+-O \u00d4=O \u00d5\u001b[+=O \u00d6]O \u00d9+U \u00da\u001b[+-U \u00db=U \u00dc]U \u00dd\u001b[+-Z \u00e0+a \u00e1\u001b[+-a \u00e2=a \u00e3\u001b[+=a \u00e4]a \u00e7$ \u00e8+e \u00e9\u001b[+-e \u00ea=e \u00eb]e \u00ec+i \u00ed\u001b[+-i \u00ee=i \u00ef]i \u00f1\u001b[+=n \u00f2+o \u00f3\u001b[+-o \u00f4=o \u00f5\u001b[+=o \u00f6]o \u00f9+u \u00fa\u001b[+-u \u00fb=u \u00fc]u \u00fd\u001b[+-z \u00ff]z";
    String swiss_german = "\u0019\u001a \u001a\u0019 !} \"@ #\u001b[+3 $\\ &^ '- (* )( *# +! -/ /& :> ;< <\u00f0 =) >\u00f1 ?_ @\u001b[+2 YZ ZY [\u001b[+[ \\\u001b[+\u00f0 ]\u001b[+] ^=\u00a0 _? `+\u00a0 yz zy {\u001b[+' |\u001b[+7 }\u001b[+\\ ~\u001b[+=\u00a0 \u00a2\u001b[+8 \u00a3| \u00a6\u001b[+1 \u00a7` \u00a8]\u00a0 \u00ac\u001b[+6 \u00b0~ \u00b4\u001b[+-\u00a0 \u00c0+A \u00c1\u001b[+-A \u00c2=A \u00c3\u001b[+=A \u00c4]A \u00c8+E \u00c9\u001b[+-E \u00ca=E \u00cb]E \u00cc+I \u00cd\u001b[+-I \u00ce=I \u00cf]I \u00d1\u001b[+=N \u00d2+O \u00d3\u001b[+-O \u00d4=O \u00d5\u001b[+=O \u00d6]O \u00d9+U \u00da\u001b[+-U \u00db=U \u00dc]U \u00dd\u001b[+-Z \u00e0+a \u00e1\u001b[+-a \u00e2=a \u00e3\u001b[+=a \u00e4]a \u00e7$ \u00e8+e \u00e9\u001b[+-e \u00ea=e \u00eb]e \u00ec+i \u00ed\u001b[+-i \u00ee=i \u00ef]i \u00f1\u001b[+=n \u00f2+o \u00f3\u001b[+-o \u00f4=o \u00f5\u001b[+=o \u00f6]o \u00f9+u \u00fa\u001b[+-u \u00fb=u \u00fc]u \u00fd\u001b[+-z \u00ff]z";

    String create_accents(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '*') {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    void parse_locale_str(String string, Hashtable hashtable) {
        int n = 0;
        char c = '\u0000';
        Character c2 = null;
        StringBuffer stringBuffer = new StringBuffer(16);
        int n2 = 0;
        while (n2 < string.length()) {
            c = string.charAt(n2);
            if (n == 0 && c != ' ') {
                ++n;
                c2 = new Character(c);
            } else {
                if (n == 1 && c != ' ') {
                    if (c == '\u00a0') {
                        c = ' ';
                    }
                    stringBuffer.append(c);
                }
                if (n == 1 && c == ' ') {
                    hashtable.put(c2, stringBuffer.toString());
                    n = 0;
                    stringBuffer = new StringBuffer(16);
                }
            }
            ++n2;
        }
        hashtable.put(c2, stringBuffer.toString());
    }

    void add_locale(String string, String string2, String string3) {
        Hashtable hashtable = new Hashtable();
        this.parse_locale_str(string2, hashtable);
        this.locales.put(string, hashtable);
        this.aliases.put(string3, string);
        this.reverse_alias.put(string, string3);
    }

    void add_iso_alias(String string, String string2) {
        this.locales.put(string2, this.locales.get(string));
        this.reverse_alias.put(string2, this.reverse_alias.get(string));
    }

    void add_alias(String string, String string2) {
        this.aliases.put(string2, string);
        this.reverse_alias.put(string, string2);
    }

    public LocaleTranslator() {
        Object object;
        String string = null;
        this.locales.put("en_US", new Hashtable());
        this.add_alias("en_US", "English (United States)");
        this.add_locale("en_GB", this.british + this.euro1, "English (United Kingdom)");
        this.add_locale("fr_FR", this.french + this.euro2, "French");
        this.add_locale("it_IT", this.italian + this.euro2, "Italian");
        this.add_locale("de_DE", this.german + this.euro2, "German");
        this.add_locale("es_ES", this.spanish + this.euro2, "Spanish (Spain)");
        this.add_locale("ja_JP", this.japanese, "Japanese");
        this.add_locale("es_MX", this.latin_american + this.euro2, "Spanish (Latin America)");
        this.add_iso_alias("es_MX", "es_AR");
        this.add_iso_alias("es_MX", "es_BO");
        this.add_iso_alias("es_MX", "es_CL");
        this.add_iso_alias("es_MX", "es_CO");
        this.add_iso_alias("es_MX", "es_CR");
        this.add_iso_alias("es_MX", "es_DO");
        this.add_iso_alias("es_MX", "es_EC");
        this.add_iso_alias("es_MX", "es_GT");
        this.add_iso_alias("es_MX", "es_HN");
        this.add_iso_alias("es_MX", "es_NI");
        this.add_iso_alias("es_MX", "es_PA");
        this.add_iso_alias("es_MX", "es_PE");
        this.add_iso_alias("es_MX", "es_PR");
        this.add_iso_alias("es_MX", "es_PY");
        this.add_iso_alias("es_MX", "es_SV");
        this.add_iso_alias("es_MX", "es_UY");
        this.add_iso_alias("es_MX", "es_VE");
        this.add_locale("fr_BE", this.belgian + this.euro2, "French Belgium");
        this.add_locale("fr_CA", this.french_canadian + this.euro2, "French Canadian");
        this.add_locale("da_DK", this.danish + this.euro2, "Danish");
        this.add_locale("no_NO", this.norwegian + this.euro2, "Norwegian");
        this.add_locale("pt_PT", this.portuguese + this.euro2, "Portugese");
        this.add_locale("sv_SE", this.swedish + this.euro2, "Swedish");
        this.add_locale("fi_FI", this.finnish + this.euro2, "Finnish");
        this.add_locale("fr_CH", this.swiss_french + this.euro2, "Swiss (French)");
        this.add_locale("de_CH", this.swiss_german + this.euro2, "Swiss (German)");
        Enumeration<?> enumeration = remcons.prop.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("locale.override")) {
                string = remcons.prop.getProperty(string2);
                System.out.println("Locale override: " + string);
                continue;
            }
            if (string2.startsWith("locale.windows")) {
                this.windows = Boolean.valueOf(remcons.prop.getProperty(string2));
                continue;
            }
            if (string2.startsWith("locale.showgui")) {
                this.showgui = Boolean.valueOf(remcons.prop.getProperty(string2));
                continue;
            }
            if (!string2.startsWith("locale.")) continue;
            object = string2.substring(7);
            String string3 = remcons.prop.getProperty(string2);
            System.out.println("Adding user defined local for " + (String)object);
            this.add_locale((String)object, string3, (String)object + " (User Defined)");
        }
        if (string != null) {
            System.out.println("Trying to select locale: " + string);
            if (this.selectLocale(string) != 0) {
                System.out.println("No keyboard definition for " + string);
            }
        } else {
            object = Locale.getDefault();
            System.out.println("Trying to select locale: " + ((Locale)object).toString());
            if (this.selectLocale(((Locale)object).toString()) != 0) {
                System.out.println("No keyboard definition for '" + ((Locale)object).toString() + "'");
            }
        }
    }

    public int selectLocale(String string) {
        String string2 = (String)this.aliases.get(string);
        if (string2 != null) {
            string = string2;
        }
        this.selected = (Hashtable)this.locales.get(string);
        this.selected_name = (String)this.reverse_alias.get(string);
        return this.selected != null ? 0 : -1;
    }

    public String translate(char c) {
        Character c2 = new Character(c);
        String string = null;
        if (this.selected != null) {
            string = (String)this.selected.get(c2);
        }
        return string == null ? c2.toString() : string;
    }

    public String[] getLocales() {
        int n = this.aliases.size();
        String[] stringArray = new String[n];
        Enumeration enumeration = this.aliases.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        n2 = 0;
        while (n2 < n - 1) {
            int n3 = n2 + 1;
            while (n3 < n) {
                if (stringArray[n3].compareTo(stringArray[n2]) < 0) {
                    String string = stringArray[n3];
                    stringArray[n3] = stringArray[n2];
                    stringArray[n2] = string;
                }
                ++n3;
            }
            ++n2;
        }
        return stringArray;
    }

    public String getSelected() {
        return this.selected_name;
    }
}

