/*
 * Decompiled with CFR 0.152.
 */
package com.kvm;

import com.kvm.Base;
import com.kvm.BtnCDMenuMouseAdapter;
import com.kvm.BtnCreateImageMouseAdapter;
import com.kvm.BtnFlpMenuMouseAdapter;
import com.kvm.BtnShowMouseAdapter;
import com.kvm.CreateCDAction;
import com.kvm.CreateDQTSliderAction;
import com.kvm.CreateDQTSliderMouseListener;
import com.kvm.CreateFloatAction;
import com.kvm.CreateFlpAction;
import com.kvm.CreateHelpAction;
import com.kvm.CreateImageAction;
import com.kvm.CreateMouseMenuButton;
import com.kvm.CreatePowerButtonActionListener;
import com.kvm.FloatToolbarUsbResetAction;
import com.kvm.FloatToolbarVideoAction;
import com.kvm.GetBMCHelpDocumentWindowAdapter;
import com.kvm.HelpButtonMouseAdapter;
import com.kvm.HelpDocument;
import com.kvm.ImagePane;
import com.kvm.KVMInterface;
import com.kvm.KVMUtil;
import com.kvm.KvmMenuMouseAdapter;
import com.kvm.MousePopupMenu;
import com.kvm.PowerMenuButtonMouseAdapter;
import com.kvm.PowerPopupMenu;
import com.kvm.SliderUI;
import com.kvm.VirtualMedia;
import com.kvm.VmmMonuseListenerMouseAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;

public class FloatToolbar
extends JPanel {
    private KVMInterface kvmInterface;
    private transient VirtualMedia virtualMedia = null;
    private ImagePane imagePanel = null;
    private FloatToolbar floatToolbar = null;
    private int imgwidth = 0;
    private int imgheight = 0;
    private JButton btnCDMenu;
    private JButton btnFlpMenu;
    private JButton btnCreateImage;
    private JButton btnShow;
    private boolean isShowPanel = true;
    private boolean isShowingCD = false;
    private boolean isShowingFlp = false;
    private boolean isShowingImagep = false;
    public static final int KVMMENU_WIDTH = 655;
    public static final int KVMMENU_WIDTH_OTHER = 235;
    public static final int KVMMENU_HEIGTH = 32;
    private boolean flag = true;
    private JButton powerMenuButton;
    private PowerPopupMenu powerMenu;
    private JButton mouseMenuButton;
    private MousePopupMenu mouseMenu;
    private JButton usbResetButton;
    private JButton videoButton;
    private JButton helpButton;
    private JSlider dqtSlider = null;
    private JFrame helpFrm;
    private transient HelpDocument help;
    private int slider_value = 0;
    private int pre_slider_value = 0;

    public KVMInterface getKvmInterface() {
        return this.kvmInterface;
    }

    public void setKvmInterface(KVMInterface kvmInterface) {
        this.kvmInterface = kvmInterface;
    }

    public ImagePane getImagePanel() {
        return this.imagePanel;
    }

    public int getImgwidth() {
        return this.imgwidth;
    }

    public JButton getBtnCDMenu() {
        return this.btnCDMenu;
    }

    public void setBtnCDMenu(JButton btnCDMenu) {
        this.btnCDMenu = btnCDMenu;
    }

    public JButton getBtnFlpMenu() {
        return this.btnFlpMenu;
    }

    public void setBtnFlpMenu(JButton btnFlpMenu) {
        this.btnFlpMenu = btnFlpMenu;
    }

    public JButton getBtnCreateImage() {
        return this.btnCreateImage;
    }

    public void setBtnCreateImage(JButton btnCreateImage) {
        this.btnCreateImage = btnCreateImage;
    }

    public JButton getBtnShow() {
        return this.btnShow;
    }

    public void setBtnShow(JButton btnShow) {
        this.btnShow = btnShow;
    }

    public boolean isShowPanel() {
        return this.isShowPanel;
    }

    public void setShowPanel(boolean isShowPanel) {
        this.isShowPanel = isShowPanel;
    }

    public boolean isShowingCD() {
        return this.isShowingCD;
    }

    public void setShowingCD(boolean isShowingCD) {
        this.isShowingCD = isShowingCD;
    }

    public boolean isShowingFlp() {
        return this.isShowingFlp;
    }

    public void setShowingFlp(boolean isShowingFlp) {
        this.isShowingFlp = isShowingFlp;
    }

    public boolean isShowingImagep() {
        return this.isShowingImagep;
    }

    public void setShowingImagep(boolean isShowingImagep) {
        this.isShowingImagep = isShowingImagep;
    }

    public PowerPopupMenu getPowerMenu() {
        return this.powerMenu;
    }

    public void setPowerMenu(PowerPopupMenu powerMenu) {
        this.powerMenu = powerMenu;
    }

    public MousePopupMenu getMouseMenu() {
        return this.mouseMenu;
    }

    public void setMouseMenu(MousePopupMenu mouseMenu) {
        this.mouseMenu = mouseMenu;
    }

    public JButton getVideoButton() {
        return this.videoButton;
    }

    public void setVideoButton(JButton videoButton) {
        this.videoButton = videoButton;
    }

    public JSlider getDqtSlider() {
        return this.dqtSlider;
    }

    public void setDqtSlider(JSlider dqtSlider) {
        this.dqtSlider = dqtSlider;
    }

    public JFrame getHelpFrm() {
        return this.helpFrm;
    }

    public void setHelpFrm(JFrame helpFrm) {
        this.helpFrm = helpFrm;
    }

    public FloatToolbar(ImagePane imagePanel, VirtualMedia virtualMedia, KVMInterface kvmInterface2) {
        this.imagePanel = imagePanel;
        this.virtualMedia = virtualMedia;
        this.kvmInterface = kvmInterface2;
        this.floatToolbar = this;
        this.setLayout(null);
        if (null != virtualMedia) {
            this.setSize(655, 32);
        } else {
            this.setSize(235, 32);
        }
        this.createFloatButton();
        if (null != virtualMedia) {
            this.createCDMenuButton();
            this.createFlpMenuButton();
        }
        if (KVMUtil.isAdmin()) {
            this.createPowerButton();
        }
        if ("USB".equals("USB")) {
            this.createMouseMenuButton();
        }
        this.createHelpButton();
        this.createDQTSlider();
        this.createUsbResetButton();
        this.createVideoButton();
        if (kvmInterface2.getBladeSize() == 1) {
            this.createImageButton();
        }
        this.init();
        imagePanel.add(this);
        imagePanel.add(kvmInterface2.getImageFile());
        this.startStateMenu();
        this.floatToolbar.addMouseListener(this.kvmMenuMonuseListener());
        if (null != virtualMedia) {
            imagePanel.add(virtualMedia.getCdp());
            imagePanel.add(virtualMedia.getFlp());
            virtualMedia.getFlp().addMouseListener(this.vmmMonuseListener());
            virtualMedia.getCdp().addMouseListener(this.vmmMonuseListener());
        }
        kvmInterface2.getImageFile().addMouseListener(this.vmmMonuseListener());
        if (KVMUtil.isLinuxOS()) {
            this.btnCreateImage.setEnabled(false);
        }
    }

    public JButton createUsbResetButton() {
        this.usbResetButton = this.createButton("usb_reset", "resource/images/usb_reset.png");
        this.usbResetButton.addActionListener(this.usbResetAction());
        this.usbResetButton.setBackground(new Color(158, 202, 232));
        this.usbResetButton.setBorder(null);
        this.usbResetButton.setFocusable(false);
        return this.usbResetButton;
    }

    public JButton createVideoButton() {
        this.videoButton = this.createButton("localKinescope", "resource/images/video_start.png");
        this.videoButton.addActionListener(this.videoAction());
        this.videoButton.setBackground(new Color(158, 202, 232));
        this.videoButton.setBorder(null);
        this.videoButton.setFocusable(false);
        return this.videoButton;
    }

    public JButton createHelpButton() {
        this.helpButton = this.createButton("help_document", "resource/images/help.gif");
        this.helpButton.addActionListener(this.createHelpAction());
        this.helpButton.setBackground(new Color(158, 202, 232));
        this.helpButton.setBorder(null);
        this.helpButton.setFocusable(false);
        return this.helpButton;
    }

    private Action createHelpAction() {
        CreateHelpAction action = new CreateHelpAction(this);
        return action;
    }

    public JSlider createDQTSlider() {
        this.dqtSlider = new JSlider(0, 40, 90, 40);
        this.dqtSlider.setUI(new SliderUI(this.dqtSlider));
        this.dqtSlider.setPaintTicks(false);
        this.dqtSlider.setMajorTickSpacing(16);
        this.dqtSlider.setMinorTickSpacing(1);
        this.dqtSlider.setValue(70);
        this.dqtSlider.setPaintLabels(true);
        this.dqtSlider.setPaintTrack(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>(10);
        ((Dictionary)labelTable).put(40, this.createDqtLabel("dqt_min"));
        ((Dictionary)labelTable).put(65, this.createDqtLabel("dqt_mid"));
        ((Dictionary)labelTable).put(90, this.createDqtLabel("dqt_max"));
        this.dqtSlider.setLabelTable(labelTable);
        this.dqtSlider.setFocusable(false);
        this.dqtSlider.addChangeListener(this.createDQTSliderAction());
        this.dqtSlider.addMouseListener(new CreateDQTSliderMouseListener(this));
        return this.dqtSlider;
    }

    public ChangeListener createDQTSliderAction() {
        CreateDQTSliderAction listner = new CreateDQTSliderAction(this);
        return listner;
    }

    public Action usbResetAction() {
        FloatToolbarUsbResetAction action = new FloatToolbarUsbResetAction(this);
        return action;
    }

    public Action videoAction() {
        FloatToolbarVideoAction action = new FloatToolbarVideoAction(this);
        return action;
    }

    public JButton createPowerButton() {
        this.powerMenuButton = this.createButton("Power_Management", "resource/images/dev_com_power.gif");
        this.powerMenu = new PowerPopupMenu(this.kvmInterface);
        this.powerMenuButton.setBackground(new Color(158, 202, 232));
        this.powerMenuButton.setFocusable(false);
        this.powerMenuButton.addActionListener(new CreatePowerButtonActionListener(this));
        return this.powerMenuButton;
    }

    public void init() {
        if (null != this.virtualMedia) {
            this.add(this.btnCDMenu);
            this.add(this.btnFlpMenu);
        }
        if (this.powerMenuButton != null) {
            this.add(this.powerMenuButton);
        }
        if (this.mouseMenuButton != null) {
            this.add(this.mouseMenuButton);
        }
        this.btnShow.setBounds(22, 2, 20, 16);
        this.add(this.btnShow);
        this.kvmInterface.getToolbar().getFullButton().setBounds(60, 1, 20, 20);
        this.add(this.kvmInterface.getToolbar().getFullButton());
        if (this.powerMenuButton != null) {
            this.powerMenuButton.setBackground(new Color(158, 202, 232));
            this.powerMenuButton.setBorder(BorderFactory.createEmptyBorder());
            this.powerMenuButton.setBounds(90, 0, 20, 20);
        }
        this.videoButton.setBackground(new Color(158, 202, 232));
        this.videoButton.setBorder(BorderFactory.createEmptyBorder());
        this.videoButton.setBounds(120, 0, 20, 20);
        this.add(this.videoButton);
        if (this.mouseMenuButton != null) {
            this.mouseMenuButton.setBackground(new Color(158, 202, 232));
            this.mouseMenuButton.setBorder(BorderFactory.createEmptyBorder());
            this.mouseMenuButton.setBounds(150, 0, 20, 20);
        }
        if (null != this.virtualMedia) {
            this.btnCDMenu.setBackground(new Color(158, 202, 232));
            this.btnCDMenu.setBounds(180, 0, 23, 23);
            this.btnFlpMenu.setBackground(new Color(158, 202, 232));
            this.btnFlpMenu.setBounds(210, 0, 23, 23);
        }
        this.btnCreateImage.setBackground(new Color(158, 202, 232));
        this.btnCreateImage.setBounds(240, 0, 23, 23);
        this.add(this.btnCreateImage);
        this.kvmInterface.getToolbar().getCombineKey().setBounds(270, 1, 20, 20);
        this.add(this.kvmInterface.getToolbar().getCombineKey());
        JLabel lblcombo = new JLabel(this.kvmInterface.getKvmUtil().getString("DQT_Value"));
        if (Base.getLocal().equalsIgnoreCase("zh")) {
            lblcombo.setFont(new Font("\u9ed1\u4f53", 0, 10));
        } else {
            lblcombo.setFont(new Font("Times new roman", 0, 10));
        }
        lblcombo.setBounds(300, 0, 72, 20);
        this.add(lblcombo);
        this.dqtSlider.setBackground(new Color(158, 202, 232));
        this.dqtSlider.setBorder(BorderFactory.createEmptyBorder());
        this.dqtSlider.setBounds(372, 0, 96, 32);
        this.add(this.dqtSlider);
        JLabel lblnum = new JLabel("num");
        lblnum.setFont(new Font("sansserif", 0, 12));
        lblnum.setBounds(480, 0, 28, 20);
        this.add(lblnum);
        this.kvmInterface.getToolbar().getNumColorButton().setBounds(508, 5, 10, 10);
        this.add(this.kvmInterface.getToolbar().getNumColorButton());
        JLabel lblcaps = new JLabel("caps");
        lblcaps.setFont(new Font("sansserif", 0, 12));
        lblcaps.setBounds(523, 0, 30, 20);
        this.add(lblcaps);
        this.kvmInterface.getToolbar().getCapsColorButton().setBounds(553, 5, 10, 10);
        this.add(this.kvmInterface.getToolbar().getCapsColorButton());
        JLabel lblscroll = new JLabel("scroll");
        lblscroll.setFont(new Font("sansserif", 0, 12));
        lblscroll.setBounds(568, 0, 35, 20);
        this.add(lblscroll);
        this.kvmInterface.getToolbar().getScrollColorButton().setBounds(603, 5, 10, 10);
        this.add(this.kvmInterface.getToolbar().getScrollColorButton());
        this.helpButton.setBackground(new Color(158, 202, 232));
        this.helpButton.setBorder(BorderFactory.createEmptyBorder());
        this.helpButton.setBounds(618, 0, 20, 20);
        this.add(this.helpButton);
        if (this.kvmInterface.getBladeSize() == 1) {
            this.btnCreateImage.setContentAreaFilled(false);
            this.btnCreateImage.addMouseListener(new BtnCreateImageMouseAdapter(this));
        }
        if (null != this.virtualMedia) {
            this.btnCDMenu.setContentAreaFilled(false);
            this.btnCDMenu.addMouseListener(new BtnCDMenuMouseAdapter(this));
            this.btnFlpMenu.setContentAreaFilled(false);
            this.btnFlpMenu.addMouseListener(new BtnFlpMenuMouseAdapter(this));
        }
        if (this.powerMenuButton != null) {
            this.powerMenuButton.setContentAreaFilled(false);
            this.powerMenuButton.addMouseListener(new PowerMenuButtonMouseAdapter(this));
        }
        this.helpButton.setContentAreaFilled(false);
        this.helpButton.addMouseListener(new HelpButtonMouseAdapter(this));
        this.btnShow.setContentAreaFilled(false);
        this.btnShow.addMouseListener(new BtnShowMouseAdapter(this));
    }

    public MouseListener vmmMonuseListener() {
        VmmMonuseListenerMouseAdapter adapter = new VmmMonuseListenerMouseAdapter(this);
        return adapter;
    }

    public MouseListener kvmMenuMonuseListener() {
        KvmMenuMouseAdapter adapter = new KvmMenuMouseAdapter(this);
        return adapter;
    }

    public void startStateMenu() {
        if (this.kvmInterface.isFullScreen()) {
            this.setVisible(false);
            return;
        }
        if (!this.kvmInterface.isFullScreen() && this.imagePanel.getImagePaneWidth() != 0 && this.imagePanel.getImagePaneWidth() == this.imgwidth) {
            if (this.kvmInterface.isReturnToWin()) {
                this.setVisible(true);
                this.setLocationToPanel();
                this.kvmInterface.setReturnToWin(false);
            }
            return;
        }
        if (this.imagePanel.getImagePaneWidth() != 0 && this.imagePanel.getImagePaneWidth() != this.imgwidth) {
            this.imgwidth = this.imagePanel.getImagePaneWidth();
            this.imgheight = this.imagePanel.getImagePaneHeight();
        } else {
            this.imgwidth = 1024;
            this.imgheight = 768;
        }
        this.setLocationToPanel();
    }

    public void setLocationToPanel() {
        if ((double)this.imgwidth > Toolkit.getDefaultToolkit().getScreenSize().getWidth()) {
            this.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - (double)this.getWidth()) / 2 + this.kvmInterface.getH(), -1 + this.kvmInterface.getVv());
            if (null != this.virtualMedia) {
                this.virtualMedia.getFlp().setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - (double)this.virtualMedia.getFlp().getWidth()) / 2 + this.kvmInterface.getH(), this.getHeight() + this.kvmInterface.getVv() - 1);
                this.virtualMedia.getCdp().setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - (double)this.virtualMedia.getCdp().getWidth()) / 2 + this.kvmInterface.getH(), this.getHeight() + this.kvmInterface.getVv() - 1);
            }
            if (this.kvmInterface.getBladeSize() == 1) {
                this.kvmInterface.getImageFile().setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - (double)this.kvmInterface.getImageFile().getWidth()) / 2 + this.kvmInterface.getH(), this.getHeight() + this.kvmInterface.getVv() - 1);
            }
        } else {
            this.setLocation((this.imgwidth - this.getWidth()) / 2 + this.kvmInterface.getH(), -1 + this.kvmInterface.getVv());
            if (null != this.virtualMedia) {
                this.virtualMedia.getFlp().setLocation((this.imgwidth - this.virtualMedia.getFlp().getWidth()) / 2 + this.kvmInterface.getH(), this.getHeight() + this.kvmInterface.getVv() - 1);
                this.virtualMedia.getCdp().setLocation((this.imgwidth - this.virtualMedia.getCdp().getWidth()) / 2 + this.kvmInterface.getH(), this.getHeight() + this.kvmInterface.getVv() - 1);
            }
            if (this.kvmInterface.getBladeSize() == 1) {
                this.kvmInterface.getImageFile().setLocation((this.imgwidth - this.kvmInterface.getImageFile().getWidth()) / 2 + this.kvmInterface.getH(), this.getHeight() + this.kvmInterface.getVv() - 1);
            }
        }
        if (this.isShowPanel) {
            this.setVisible(true);
        }
        if (null != this.virtualMedia) {
            this.virtualMedia.getFlp().setVisible(false);
            this.virtualMedia.getCdp().setVisible(false);
            this.btnCDMenu.setBorder(null);
            this.btnFlpMenu.setBorder(null);
        }
        if (this.kvmInterface.getBladeSize() == 1) {
            this.kvmInterface.getImageFile().setVisible(false);
            this.btnCreateImage.setBorder(null);
        }
        if (null != this.floatToolbar && null != this.floatToolbar.powerMenu) {
            this.floatToolbar.powerMenu.setVisible(false);
        }
    }

    public void fullStateMenu() {
        if (null != this.virtualMedia) {
            this.virtualMedia.getCdp().setVisible(false);
            this.virtualMedia.getFlp().setVisible(false);
        }
        this.setVisible(false);
    }

    private JButton createButton(String resCode, String imageURL) {
        JButton button = new JButton(new ImageIcon(FloatToolbar.class.getResource(imageURL)));
        button.setToolTipText(this.kvmInterface.getKvmUtil().getString(resCode));
        return button;
    }

    public JLabel createDqtLabel(String resCode) {
        JLabel label = new JLabel(this.kvmInterface.getKvmUtil().getString(resCode));
        return label;
    }

    private JButton createFloatButton() {
        this.btnShow = this.createButton("button_float", "resource/images/float.gif");
        this.btnShow.addActionListener(this.createFloatAction());
        this.btnShow.setBackground(new Color(158, 202, 232));
        this.btnShow.setBorder(null);
        this.btnShow.setFocusable(false);
        return this.btnShow;
    }

    private JButton createImageButton() {
        this.btnCreateImage = this.createButton("create_image", "resource/images/virtualne.gif");
        this.btnCreateImage.addActionListener(this.createImageAction());
        this.btnShow.setBackground(new Color(158, 202, 232));
        this.btnCreateImage.setFocusable(false);
        return this.btnCreateImage;
    }

    private JButton createCDMenuButton() {
        this.btnCDMenu = this.createButton("cd_cdroms", "resource/images/cd.gif");
        this.btnCDMenu.setBorder(null);
        this.btnCDMenu.addActionListener(this.createCDAction());
        this.btnCDMenu.setBackground(new Color(158, 202, 232));
        this.btnCDMenu.setFocusable(false);
        return this.btnCDMenu;
    }

    private JButton createFlpMenuButton() {
        this.btnFlpMenu = this.createButton("flp_floppy", "resource/images/flp.gif");
        this.btnFlpMenu.setBorder(null);
        this.btnFlpMenu.addActionListener(this.createFlpAction());
        this.btnFlpMenu.setBackground(new Color(158, 202, 232));
        this.btnFlpMenu.setFocusable(false);
        return this.btnFlpMenu;
    }

    public JButton createMouseMenuButton() {
        this.mouseMenuButton = this.createButton("Mouse_Manager", "resource/images/mouse_manager.png");
        this.mouseMenu = new MousePopupMenu(this.kvmInterface);
        this.mouseMenuButton.setBackground(new Color(158, 202, 232));
        this.mouseMenuButton.setFocusable(false);
        this.mouseMenuButton.addActionListener(new CreateMouseMenuButton(this));
        return this.mouseMenuButton;
    }

    private Action createImageAction() {
        CreateImageAction action = new CreateImageAction(this);
        return action;
    }

    private Action createCDAction() {
        CreateCDAction action = new CreateCDAction(this);
        return action;
    }

    private Action createFlpAction() {
        CreateFlpAction action = new CreateFlpAction(this);
        return action;
    }

    private Action createFloatAction() {
        CreateFloatAction action = new CreateFloatAction(this);
        return action;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(new Color(158, 202, 232));
        int w = this.getWidth();
        int h = this.getHeight();
        int[] x = new int[]{0, w, w - h, h, 0};
        int[] y = new int[]{0, 0, h, h, 0};
        int nPoints = 4;
        Polygon poly = new Polygon(x, y, nPoints);
        g2d.fillPolygon(poly);
        g2d.drawPolygon(poly);
    }

    public void setVirtualMediaVisible(boolean cdflag, boolean flpflag) {
        this.virtualMedia.getCdp().setVisible(cdflag);
        this.virtualMedia.getFlp().setVisible(flpflag);
    }

    public void setCDVisibleAndLocation(boolean cdflag, int x, int y) {
        this.virtualMedia.getCdp().setVisible(cdflag);
        this.virtualMedia.getCdp().setLocation(x, y);
    }

    public void setFlpVisibleAndLocation(boolean flpflag, int x, int y) {
        this.virtualMedia.getFlp().setVisible(flpflag);
        this.virtualMedia.getFlp().setLocation(x, y);
    }

    public void setCDVisible(boolean cdflag) {
        this.virtualMedia.getCdp().setVisible(cdflag);
    }

    public void setFlpVisible(boolean flpflag) {
        this.virtualMedia.getFlp().setVisible(flpflag);
    }

    public void setCDLocation(int x, int y) {
        this.virtualMedia.getCdp().setLocation(x, y);
    }

    public void setFlpLocation(int x, int y) {
        this.virtualMedia.getFlp().setLocation(x, y);
    }

    public boolean isVirtualMedia() {
        return null != this.virtualMedia;
    }

    public int getCDX() {
        return this.virtualMedia.getCdp().getX();
    }

    public int getCDY() {
        return this.virtualMedia.getCdp().getY();
    }

    public int getCDWidth() {
        return this.virtualMedia.getCdp().getWidth();
    }

    public int getCDHeight() {
        return this.virtualMedia.getCdp().getHeight();
    }

    public int getFlpX() {
        return this.virtualMedia.getFlp().getX();
    }

    public int getFlpY() {
        return this.virtualMedia.getFlp().getY();
    }

    public int getFlpWidth() {
        return this.virtualMedia.getFlp().getWidth();
    }

    public int getFlpHeight() {
        return this.virtualMedia.getFlp().getHeight();
    }

    public JPanel getCDPanel() {
        return this.virtualMedia.getCdp();
    }

    public JPanel getFlpPanel() {
        return this.virtualMedia.getFlp();
    }

    public VirtualMedia getVirtualMedia() {
        return this.virtualMedia;
    }

    public void setVirtualMedia(VirtualMedia virtualMedia) {
        this.virtualMedia = virtualMedia;
    }

    public void destroyVmLink() {
        if (null == this.virtualMedia) {
            return;
        }
        this.virtualMedia.destoryVMM();
    }

    public JFrame getBMCHelpDocument() {
        String path = "";
        path = Base.getLocal().equalsIgnoreCase("en") ? "resource/helpdoc/help/kvmvmm_en.html" : "resource/helpdoc/help/kvmvmm_zh.html";
        if (null == this.help) {
            this.help = new HelpDocument(path);
        }
        this.helpFrm = new JFrame();
        this.helpFrm.addWindowListener(new GetBMCHelpDocumentWindowAdapter(this));
        this.helpFrm.setSize(800, 650);
        int x = (int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - (double)this.helpFrm.getWidth()) / 2;
        int y = (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - (double)this.helpFrm.getHeight()) / 2;
        this.helpFrm.setLocation(x, y);
        this.helpFrm.setLayout(new BorderLayout());
        this.helpFrm.getContentPane().add(this.help.getScroller());
        this.helpFrm.setVisible(true);
        return this.helpFrm;
    }

    public JButton getMouseMenuButton() {
        return this.mouseMenuButton;
    }

    public void setMouseMenuButton(JButton mouseMenuButton) {
        this.mouseMenuButton = mouseMenuButton;
    }

    public FloatToolbar getFloatToolbar() {
        return this.floatToolbar;
    }

    public void setFloatToolbar(FloatToolbar floatToolbar) {
        this.floatToolbar = floatToolbar;
    }

    public int getSlider_value() {
        return this.slider_value;
    }

    public void setSlider_value(int sliderValue) {
        this.slider_value = sliderValue;
    }

    public int getPre_slider_value() {
        return this.pre_slider_value;
    }

    public void setPre_slider_value(int preSliderValue) {
        this.pre_slider_value = preSliderValue;
    }

    public JButton getPowerMenuButton() {
        return this.powerMenuButton;
    }

    public void setPowerMenuButton(JButton powerMenuButton) {
        this.powerMenuButton = powerMenuButton;
    }

    public JButton getHelpButton() {
        return this.helpButton;
    }

    public void setHelpButton(JButton helpButton) {
        this.helpButton = helpButton;
    }
}

