/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vm.console.storage.impl;

import com.huawei.vm.console.communication.VMTimerTask;
import com.huawei.vm.console.management.ConsoleControllers;
import com.huawei.vm.console.storage.impl.FloppyDriver;
import com.huawei.vm.console.utils.DeviceIO;
import com.huawei.vm.console.utils.VMException;
import de.tu_darmstadt.informatik.rbg.bstickler.udflib.UDFExtendFile;
import java.util.Map;

public class FloppyDevice
extends FloppyDriver {
    private final DeviceIO device;
    private boolean needReOpen = false;
    private VMTimerTask timerTask = null;

    public FloppyDevice(String path) throws VMException {
        super(path);
        this.mustExist = true;
        this.device = new DeviceIO();
        if (!ConsoleControllers.isSetUp()) {
            throw new VMException(210);
        }
        int result = this.device.open(this.deviceName);
        if (0 != result) {
            if (33 == result || 32 == result) {
                throw new VMException(223);
            }
            throw new VMException(220);
        }
    }

    public FloppyDevice(String path, VMTimerTask timerTask) throws VMException {
        super(path);
        this.mustExist = true;
        this.device = new DeviceIO();
        if (!ConsoleControllers.isSetUp()) {
            throw new VMException(210);
        }
        int result = this.device.open(this.deviceName);
        if (0 != result) {
            if (33 == result || 32 == result) {
                throw new VMException(223);
            }
            throw new VMException(220);
        }
        if (0L > this.device.size()) {
            this.needReOpen = true;
            if (null != timerTask) {
                this.timerTask = timerTask;
                this.timerTask.startFloppyReopen(this);
            }
        }
    }

    @Override
    protected void open(String path) throws VMException {
        int result = this.device.open(path);
        if (0 != result) {
            if (33 == result || 32 == result) {
                throw new VMException(223);
            }
            throw new VMException(220);
        }
    }

    @Override
    public void close() throws VMException {
        int result = this.device.close();
        if (null != this.timerTask) {
            this.timerTask.stopFloppyReopen();
            this.timerTask = null;
        }
        if (0 > result) {
            throw new VMException(221);
        }
    }

    @Override
    public boolean isWriteProtect() {
        return super.isWriteProtect() || !this.device.canWrite();
    }

    @Override
    public void formatUnit(int mediumType, int startCylinderNumber, int endCylinderNumber, int startHeadNumber, int endHeadNumber) throws VMException {
        this.device.setBadTrackNumber(0);
        int result = this.device.format(mediumType, startCylinderNumber, endCylinderNumber, startHeadNumber, endHeadNumber);
        if (0 != result) {
            throw new VMException(this.device.getBadTrackNumber());
        }
    }

    @Override
    public int read(byte[] dataBuffer, long startPosition, int length) throws VMException {
        int result = this.device.read(startPosition, length, dataBuffer);
        if (0 > result) {
            throw new VMException(250);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMediumSize() throws VMException {
        long size = this.device.size();
        if (0L > size) {
            throw new VMException(253);
        }
        if (this.needReOpen) {
            this.needReOpen = false;
            DeviceIO deviceIO = this.device;
            synchronized (deviceIO) {
                this.device.close();
                if (null != this.timerTask) {
                    this.timerTask.stopFloppyReopen();
                    this.timerTask = null;
                }
                this.device.open(this.deviceName);
            }
        }
        return size;
    }

    @Override
    public void write(byte[] dataBuffer, long startPosition, int length) throws VMException {
        int result = -1;
        if (!this.isWriteProtect()) {
            result = this.device.write(startPosition, length, dataBuffer);
        }
        if (0 > result) {
            if (this.isWriteProtect()) {
                throw new VMException(254);
            }
            if (0L > this.getMediumSize()) {
                throw new VMException(253);
            }
            throw new VMException(250);
        }
    }

    @Override
    public void inquiry() {
    }

    @Override
    public boolean isInited() {
        this.device.size();
        return this.device.isActive();
    }

    @Override
    public int getBlockLength() {
        return this.device.getBytesPerSector();
    }

    @Override
    protected void prepareChangeDisk(String localDirName, Map<Long, UDFExtendFile> memoryStructMap, String diskName) throws VMException {
    }

    @Override
    public void eject() {
    }

    @Override
    public void insert() throws VMException {
    }
}

