/*
 * Decompiled with CFR 0.152.
 */
package com.Kinescope;

import com.Kinescope.KinescopeFrame;
import com.kvm.Base;
import com.kvm.Debug;
import com.library.LoggerUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class KinescopeDataCollect
extends Thread {
    private String path = "";
    private Thread dataCollectThread;
    private boolean isCollect = false;
    private List<KinescopeFrame> frameList = null;
    private KinescopeFrame kinescopeFrame = null;
    private RandomAccessFile file;
    private static int indexCount = 20;
    private static byte FILETOP = 1;
    private static byte SEQINDEX = (byte)2;
    private static byte IMAGEDATA = (byte)3;
    private long fileIndexPos = 0L;
    private int indexPos = 0;
    private int frameSeqIndex = 0;

    public List<KinescopeFrame> getFrameList() {
        return this.frameList;
    }

    public void setFrameList(List<KinescopeFrame> frameList) {
        this.frameList = frameList;
    }

    public int getFrameSeqIndex() {
        return this.frameSeqIndex;
    }

    public void setFrameSeqIndex(int frameSeqIndex) {
        this.frameSeqIndex = frameSeqIndex;
    }

    public KinescopeDataCollect(String path) {
        this.path = path;
        try {
            this.file = new RandomAccessFile(path, "rw");
        }
        catch (FileNotFoundException e) {
            LoggerUtil.error(e.getClass().getName());
        }
        this.frameList = new ArrayList<KinescopeFrame>(10);
    }

    public void startCollectThread() {
        this.dataCollectThread = new Thread(this);
        this.dataCollectThread.setName("dataCollectThread");
        this.dataCollectThread.start();
    }

    @Override
    public void run() {
        try {
            this.file.write(this.fileTopData(0, 0L));
            boolean flag = this.isCollect();
            try {
                while (flag) {
                    if (this.frameList.size() == 0) {
                        Thread.sleep(10L);
                        continue;
                    }
                    this.kinescopeFrame = this.frameList.remove(0);
                    if (this.kinescopeFrame.isIFrame()) {
                        if (this.fileIndexPos == 0L) {
                            this.addSeqIndex(this.kinescopeFrame.getSeqFrame());
                        } else if (this.indexPos < indexCount) {
                            this.updateSeqIndex(this.kinescopeFrame.getSeqFrame());
                        } else {
                            this.updateSeqIndexPos(this.file.length());
                            this.addSeqIndex(this.kinescopeFrame.getSeqFrame());
                        }
                    }
                    this.file.write(this.fileImageData(this.kinescopeFrame));
                    this.file.seek(0L);
                    this.file.write(this.fileTopData(this.kinescopeFrame.getSeqFrame(), this.file.length()));
                    this.file.seek(this.file.length());
                    this.kinescopeFrame = null;
                    flag = this.isCollect();
                }
            }
            catch (InterruptedException e) {
                Debug.printExc(e.getClass().getName());
            }
            KinescopeFrame frame = null;
            if (this.frameList != null && this.frameList.size() > 0) {
                int size = this.frameList.size();
                for (int i = 0; i < size; ++i) {
                    frame = this.frameList.remove(i);
                    this.file.write(this.fileImageData(frame));
                    this.file.seek(0L);
                    this.file.write(this.fileTopData(frame.getSeqFrame(), this.file.length()));
                    this.file.seek(this.file.length());
                    frame = null;
                }
                this.frameList = null;
            }
            this.file.close();
        }
        catch (RuntimeException re) {
            LoggerUtil.error(re.getClass().getName());
        }
        catch (Exception e) {
            LoggerUtil.error(e.getClass().getName());
        }
    }

    public void addSeqIndex(int frameNum) {
        try {
            this.fileIndexPos = this.file.length();
            this.file.write(this.seqIndexData());
            this.file.seek(this.file.length() - 1L);
            this.indexPos = 0;
            this.updateSeqIndex(frameNum);
        }
        catch (IOException e) {
            LoggerUtil.error(e.getClass().getName());
        }
    }

    public void updateSeqIndex(int frameNum) {
        try {
            this.file.seek(this.fileIndexPos + (long)this.indexPos * 12L + 7L);
            byte[] iframeIndex = new byte[]{(byte)(frameNum >> 24), (byte)(frameNum >> 16), (byte)(frameNum >> 8), (byte)(frameNum >> 0), (byte)(this.file.length() >> 56), (byte)(this.file.length() >> 48), (byte)(this.file.length() >> 40), (byte)(this.file.length() >> 32), (byte)(this.file.length() >> 24), (byte)(this.file.length() >> 16), (byte)(this.file.length() >> 8), (byte)(this.file.length() >> 0)};
            this.file.write(iframeIndex);
            ++this.indexPos;
            this.file.seek(this.file.length());
        }
        catch (IOException e) {
            LoggerUtil.error(e.getClass().getName());
        }
    }

    public void updateSeqIndexPos(long pos) {
        try {
            this.file.seek(this.fileIndexPos + (long)this.indexPos * 12L + 7L);
            byte[] datas = new byte[]{(byte)(pos >> 56), (byte)(pos >> 48), (byte)(pos >> 40), (byte)(pos >> 32), (byte)(pos >> 24), (byte)(pos >> 16), (byte)(pos >> 8), (byte)(pos >> 0)};
            this.file.write(datas);
            this.file.seek(this.file.length());
        }
        catch (IOException e) {
            LoggerUtil.error(e.getClass().getName());
        }
    }

    public byte[] fileImageData(KinescopeFrame kinescopeFrame) {
        int is_Iframe = 0;
        byte[] imageData = new byte[kinescopeFrame.getSourceData().length + 25];
        imageData[0] = -2;
        imageData[1] = -10;
        imageData[2] = (byte)(imageData.length >> 24);
        imageData[3] = (byte)(imageData.length >> 16);
        imageData[4] = (byte)(imageData.length >> 8);
        imageData[5] = (byte)(imageData.length >> 0);
        imageData[6] = IMAGEDATA;
        is_Iframe = kinescopeFrame.isIFrame() ? 0 : 1;
        imageData[7] = (byte)((kinescopeFrame.getDqt() & 0xF) << 4 | is_Iframe & 0xF);
        imageData[8] = 0;
        imageData[9] = (byte)(kinescopeFrame.getSeqFrame() >> 24);
        imageData[10] = (byte)(kinescopeFrame.getSeqFrame() >> 16);
        imageData[11] = (byte)(kinescopeFrame.getSeqFrame() >> 8);
        imageData[12] = (byte)(kinescopeFrame.getSeqFrame() >> 0);
        imageData[13] = (byte)(kinescopeFrame.getWidth() >> 8);
        imageData[14] = (byte)(kinescopeFrame.getWidth() >> 0);
        imageData[15] = (byte)(kinescopeFrame.getHeight() >> 8);
        imageData[16] = (byte)(kinescopeFrame.getHeight() >> 0);
        long nowTime = System.currentTimeMillis();
        imageData[17] = (byte)(nowTime >> 56);
        imageData[18] = (byte)(nowTime >> 48);
        imageData[19] = (byte)(nowTime >> 40);
        imageData[20] = (byte)(nowTime >> 32);
        imageData[21] = (byte)(nowTime >> 24);
        imageData[22] = (byte)(nowTime >> 16);
        imageData[23] = (byte)(nowTime >> 8);
        imageData[24] = (byte)(nowTime >> 0);
        System.arraycopy(kinescopeFrame.getSourceData(), 0, imageData, 25, imageData.length - 25);
        return imageData;
    }

    public byte[] fileTopData(int totalFrame, long fileLength) {
        byte[] datas = new byte[52];
        datas[0] = -2;
        datas[1] = -10;
        datas[2] = (byte)(datas.length >> 24);
        datas[3] = (byte)(datas.length >> 16);
        datas[4] = (byte)(datas.length >> 8);
        datas[5] = (byte)(datas.length >> 0);
        datas[6] = FILETOP;
        datas[7] = 0;
        datas[8] = (byte)(totalFrame >> 24);
        datas[9] = (byte)(totalFrame >> 16);
        datas[10] = (byte)(totalFrame >> 8);
        datas[11] = (byte)totalFrame;
        datas[12] = 0;
        datas[13] = 0;
        datas[14] = 0;
        datas[15] = 0;
        datas[16] = 0;
        datas[17] = 0;
        datas[18] = 0;
        datas[19] = 0;
        datas[20] = (byte)(fileLength >> 56);
        datas[21] = (byte)(fileLength >> 48);
        datas[22] = (byte)(fileLength >> 40);
        datas[23] = (byte)(fileLength >> 32);
        datas[24] = (byte)(fileLength >> 24);
        datas[25] = (byte)(fileLength >> 16);
        datas[26] = (byte)(fileLength >> 8);
        datas[27] = (byte)(fileLength >> 0);
        datas[28] = Base.getIsNewCompAlgorithm() ? (byte)0 : 1;
        datas[29] = (byte)Base.getDqtzSize();
        return datas;
    }

    public byte[] seqIndexData() {
        byte[] datas = new byte[indexCount * 12 + 7 + 8];
        datas[0] = -2;
        datas[1] = -10;
        datas[2] = (byte)(datas.length >> 24);
        datas[3] = (byte)(datas.length >> 16);
        datas[4] = (byte)(datas.length >> 8);
        datas[5] = (byte)(datas.length >> 0);
        datas[6] = SEQINDEX;
        return datas;
    }

    public static byte[] intToBytes(int intsrc) {
        byte[] temp = new byte[]{(byte)intsrc, (byte)(intsrc >> 8), (byte)(intsrc >> 16), (byte)(intsrc >> 24)};
        return temp;
    }

    public static byte[] longToBytes(long intsrc) {
        byte[] temp = new byte[]{(byte)intsrc, (byte)(intsrc >> 8), (byte)(intsrc >> 16), (byte)(intsrc >> 24), (byte)(intsrc >> 32), (byte)(intsrc >> 40), (byte)(intsrc >> 48), (byte)(intsrc >> 56)};
        return temp;
    }

    public Thread getDataCollectThread() {
        return this.dataCollectThread;
    }

    public boolean isCollect() {
        return this.isCollect;
    }

    public String getPath() {
        return this.path;
    }

    public void setDataCollectThread(Thread dataCollectThread) {
        this.dataCollectThread = dataCollectThread;
    }

    public void setCollect(boolean isCollect) {
        this.isCollect = isCollect;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

